---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 26
  claims_without_evidence: 4
confidence_derived: 0.87
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：26 / 30、根拠なし：4
- 優先レビュー（高）
  1. **RBEクラスタの詳細スペック**：根拠不足（GCP側の設定が非公開）
  2. **バックアップの保持期間**：根拠不足（GCSライフサイクルポリシーがリポジトリ外管理）
  3. **CI基盤（Kokoro）の詳細構成**：根拠不足（内部CIシステムの詳細は非公開）
  4. **PyPIアップロードの詳細手順**：根拠不足（認証情報・手順の詳細はリポジトリ外管理）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ci/official/containers/ml_build/Dockerfile`
- E-02: `tensorflow/tools/tf_sig_build_dockerfiles/Dockerfile`
- E-03: `tensorflow/tools/ci_build/Dockerfile.cpu`
- E-04: `tensorflow/tools/ci_build/Dockerfile.gpu`
- E-05: `tensorflow/tools/ci_build/Dockerfile.rocm`
- E-06: `ci/devinfra/docker/windows2022/Dockerfile`
- E-07: `tensorflow/tools/ci_build/cloudbuild.yaml`
- E-08: `ci/official/utilities/setup.sh`
- E-09: `ci/official/utilities/setup_docker.sh`
- E-10: `ci/official/envs/ci_default`
- E-11: `ci/official/envs/linux_x86`
- E-12: `ci/official/envs/linux_x86_cuda`
- E-13: `ci/official/envs/linux_arm64`
- E-14: `ci/official/envs/macos_arm64`
- E-15: `ci/official/envs/rbe`
- E-16: `ci/official/envs/windows_x86_2022`
- E-17: `.github/workflows/arm-ci.yml`
- E-18: `tensorflow/tools/gcs_test/Dockerfile`
- E-19: `.github/workflows/osv-scanner-scheduled.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ビルド環境はDockerコンテナ上で動作する | E-01, E-02, E-06, E-08, E-09 | ○ |
| C-02 | Google Cloud Buildを使用してDockerイメージをビルドする | E-07 | ○ |
| C-03 | GitHub Actionsを使用してARM CI等を実行する | E-17 | ○ |
| C-04 | Bazel RBEによる分散ビルドをサポートする | E-15 | ○ |
| C-05 | GCSをアーティファクト保管に使用する | E-10 (TFCI_ARTIFACT_*_GCS_URI変数) | ○ |
| C-06 | DockerイメージはArtifact Registryにホストされる | E-11 (us-docker.pkg.dev/ml-oss-artifacts-published) | ○ |
| C-07 | Linux x86_64 CPUビルドはUbuntu 22.04ベースである | E-01, E-02 | ○ |
| C-08 | GPUビルドにCUDA 12.3を使用する | E-02 (nvidia/cuda:12.3.2-base-ubuntu22.04) | ○ |
| C-09 | cuDNN 9.1を使用する | E-01 (cuda12.1_cudnn9.1.packages.txt) | ○ |
| C-10 | ROCm 5.3.0によるAMD GPU対応がある | E-05 | ○ |
| C-11 | Windows環境はWindows Server 2022ベースである | E-06 | ○ |
| C-12 | Windows環境にVisual Studio 2022 (MSVC 14.39)を使用する | E-06 | ○ |
| C-13 | Windows環境にLLVM 18.1.4を使用する | E-06 | ○ |
| C-14 | Python 3.10〜3.14をサポートする | E-01 | ○ |
| C-15 | Bazelisk v1.27.0を使用する（Linux） | E-01 | ○ |
| C-16 | Bazelisk v1.22.1を使用する（Windows） | E-06 | ○ |
| C-17 | patchelf 0.18.0を使用する | E-01, E-02 | ○ |
| C-18 | Docker pullの失敗時に指数バックオフでリトライする | E-09 | ○ |
| C-19 | 既存のtfコンテナが存在する場合は再利用する | E-09 | ○ |
| C-20 | TFCI環境変数でプラットフォーム別設定を切り替える | E-08, E-10, E-11, E-12 | ○ |
| C-21 | wheelサイズ制限が設定されている（CPU: 265M, GPU: 630M） | E-11, E-12 | ○ |
| C-22 | ARM64向けのDockerイメージはml-build-arm64:latest | E-13 | ○ |
| C-23 | macOS ARM64ではネイティブ実行（Docker不使用） | E-14 (TFCI_DOCKER_ENABLEが未設定) | ○ |
| C-24 | GPU環境では--gpus allフラグを使用する | E-12 | ○ |
| C-25 | Windows環境でGCEメタデータへのポートフォワーディングを使用する | E-15 | ○ |
| C-26 | script.logにビルドログを記録する | E-08 | ○ |
| C-27 | RBEクラスタの詳細スペック（CPU/メモリ等） | **根拠なし** | △ |
| C-28 | バックアップの保持期間はGCSライフサイクルポリシーに準拠 | **根拠なし** | △ |
| C-29 | CI基盤（Kokoro）の内部構成・スケーリング詳細 | **根拠なし** | △ |
| C-30 | PyPIアップロードの認証・配布の詳細手順 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- RBEクラスタの詳細構成（マシンタイプ、ノード数等）はリポジトリ内に定義がなく、GCP側で管理されている
  - 候補：GCPコンソール / Terraform定義（別リポジトリ） / インフラチームへの問い合わせ
- GCSバケットのライフサイクルポリシー（保持期間、自動削除ルール）はリポジトリ内に定義がない
  - 候補：GCSバケット設定 / インフラ管理ドキュメント
- Kokoro（Google内部CI）の詳細構成はOSSリポジトリには含まれない
  - 候補：内部CIドキュメント / Google社内Wiki
- PyPIへのアップロード設定の詳細（認証トークン、プロジェクト名管理等）
  - 候補：`TFCI_ARTIFACT_FINAL_PYPI_ARGS` の実際の値 / CI Secretsの管理ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: CIビルド環境の構成（Dockerfile、環境変数）は十分な根拠がある
- 0: ミドルウェアのバージョン情報はDockerfileから正確に抽出されている
- 1: RBEの詳細構成はリポジトリ外にあるため、記述が概要レベルにとどまる
- 1: バックアップ・監視設計はCI環境内で確認可能な範囲に限定される
- 1: レガシーCIスクリプト（tensorflow/tools/ci_build/）と新CIスクリプト（ci/official/）の関係性の正確さ

## 6) レビュアーチェックリスト（最小）
- [ ] 各Dockerfileのベースイメージおよびバージョンが最新の状態と一致しているか
- [ ] CUDA / cuDNNのバージョン記載が実際のビルドパイプラインと整合しているか
- [ ] RBEの構成が実際のGCP環境と一致しているか（インフラチームに確認）
- [ ] GCSバケットの保持ポリシーが組織のポリシーに準拠しているか
- [ ] PyPIアップロードの手順が実際の運用と一致しているか
- [ ] Windowsビルド環境の記載がci/devinfra/docker/windows2022/Dockerfileの最新状態と一致しているか
