# インフラ構成図

## 全体構成図

```mermaid
graph TB
    subgraph "開発者 / トリガー"
        DEV[開発者]
        GH_PUSH[GitHub Push/PR]
    end

    subgraph "GitHub"
        GH_REPO[GitHub リポジトリ<br/>tensorflow/tensorflow]
        GH_ACTIONS[GitHub Actions]
    end

    subgraph "Google Cloud Platform"
        subgraph "Container Registry"
            GAR[Artifact Registry<br/>us-docker.pkg.dev/<br/>ml-oss-artifacts-published]
        end

        subgraph "Cloud Build"
            GCB[Google Cloud Build<br/>Dockerイメージビルド]
        end

        subgraph "Remote Build Execution"
            RBE[Bazel RBE クラスタ<br/>分散ビルド/テスト実行]
        end

        subgraph "Storage"
            GCS_STAGING[GCS<br/>ステージングバケット]
            GCS_FINAL[GCS<br/>ファイナルバケット]
        end
    end

    subgraph "CIビルド環境（Docker コンテナ）"
        subgraph "Linux x86_64"
            CPU_BUILD[CPU ビルド<br/>Ubuntu 22.04<br/>ml-build:latest]
            GPU_BUILD[GPU ビルド<br/>CUDA 12.3 + cuDNN 9.1<br/>ml-build:latest]
        end

        subgraph "Linux ARM64"
            ARM_BUILD[ARM64 ビルド<br/>Ubuntu 22.04<br/>ml-build-arm64:latest]
        end

        subgraph "Windows"
            WIN_BUILD[Windows ビルド<br/>Server 2022<br/>VS 2022 + LLVM 18]
        end

        subgraph "macOS"
            MAC_BUILD[macOS ビルド<br/>ARM64<br/>ネイティブ実行]
        end
    end

    subgraph "配布先"
        PYPI[PyPI<br/>パッケージ公開]
    end

    DEV --> GH_PUSH
    GH_PUSH --> GH_REPO
    GH_REPO --> GH_ACTIONS
    GH_REPO --> GCB

    GCB --> GAR
    GAR --> CPU_BUILD
    GAR --> GPU_BUILD
    GAR --> ARM_BUILD

    GH_ACTIONS --> ARM_BUILD
    GH_ACTIONS --> CPU_BUILD

    CPU_BUILD --> RBE
    GPU_BUILD --> RBE

    CPU_BUILD --> GCS_STAGING
    GPU_BUILD --> GCS_STAGING
    ARM_BUILD --> GCS_STAGING
    WIN_BUILD --> GCS_STAGING
    MAC_BUILD --> GCS_STAGING

    GCS_STAGING --> GCS_FINAL
    GCS_FINAL --> PYPI
```

## CIビルドパイプライン詳細図

```mermaid
flowchart LR
    subgraph "1. セットアップ"
        A1[環境変数読込<br/>ci/official/envs/]
        A2[Docker Pull/Build]
        A3[コンテナ起動]
    end

    subgraph "2. ビルド"
        B1[Bazel ビルド]
        B2[RBE 分散実行<br/>オプション]
        B3[pip パッケージ生成<br/>wheel]
    end

    subgraph "3. テスト"
        C1[Bazel テスト]
        C2[wheel インポートテスト]
        C3[wheel 監査<br/>auditwheel]
        C4[wheel サイズチェック]
    end

    subgraph "4. アーティファクト"
        D1[GCS ステージング<br/>アップロード]
        D2[GCS ファイナル<br/>アップロード]
        D3[PyPI アップロード]
    end

    A1 --> A2 --> A3
    A3 --> B1
    B1 --> B2
    B1 --> B3
    B3 --> C1
    C1 --> C2
    C2 --> C3
    C3 --> C4
    C4 --> D1
    D1 --> D2
    D2 --> D3
```

## プラットフォーム別Dockerイメージ構成図

```mermaid
graph TD
    subgraph "Linux x86_64 CPU/GPU イメージ（ml_build）"
        ML_BASE[Ubuntu 22.04]
        ML_PYTHON[Python 3.10 - 3.14]
        ML_BAZEL[Bazelisk v1.27.0]
        ML_GCLOUD[Google Cloud SDK]
        ML_TOOLS[buildifier / buildozer / patchelf / bats]
        ML_CUDA[CUDA 12.1 + cuDNN 9.1<br/>条件付きインストール]

        ML_BASE --> ML_PYTHON
        ML_PYTHON --> ML_BAZEL
        ML_BAZEL --> ML_GCLOUD
        ML_GCLOUD --> ML_TOOLS
        ML_TOOLS --> ML_CUDA
    end

    subgraph "SIG Build イメージ（tf_sig_build）"
        SIG_BASE[NVIDIA CUDA 12.3.2<br/>Ubuntu 22.04]
        SIG_DEVTOOL[devtoolset-9<br/>manylinux2014互換]
        SIG_CLANG[Clang 18]
        SIG_PYTHON_SIG[Python<br/>バージョン指定]

        SIG_BASE --> SIG_DEVTOOL
        SIG_DEVTOOL --> SIG_CLANG
        SIG_CLANG --> SIG_PYTHON_SIG
    end

    subgraph "Windows イメージ"
        WIN_BASE[Windows Server 2022]
        WIN_VS[Visual Studio 2022<br/>MSVC 14.39]
        WIN_LLVM[LLVM/Clang 18.1.4]
        WIN_MSYS[MSYS2]
        WIN_PY[Python 3.9 - 3.13]
        WIN_JDK[JDK 21 Azul Zulu]

        WIN_BASE --> WIN_VS
        WIN_VS --> WIN_LLVM
        WIN_LLVM --> WIN_MSYS
        WIN_MSYS --> WIN_PY
        WIN_PY --> WIN_JDK
    end
```
