# インフラ設計書

## 概要

本ドキュメントは、TensorFlowプロジェクトのCI/CD（継続的インテグレーション/継続的デリバリー）パイプラインおよびビルドインフラストラクチャの設計を記述する。TensorFlowはOSSライブラリであり、アプリケーションサーバーやデータベースサーバーを持つサービス型のインフラではなく、ビルド・テスト・配布のためのCI/CDインフラストラクチャが中心となる。

## システム構成

### 全体構成

TensorFlowのインフラストラクチャは、以下の主要コンポーネントで構成される。

1. **CIビルド環境**: Docker コンテナ上で動作するビルド・テスト環境（Linux x86_64、Linux ARM64、Windows、macOS）
2. **Google Cloud Build**: Dockerイメージのビルドおよび管理
3. **GitHub Actions**: ARM CI、pylint、セキュリティスキャン等のワークフロー実行
4. **Remote Build Execution (RBE)**: Bazelの分散ビルドキャッシュおよびリモート実行
5. **Google Cloud Storage (GCS)**: ビルドアーティファクトの保管および配布
6. **Google Container Registry (GCR) / Artifact Registry**: Dockerイメージの保管

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| CIビルドサーバー（Linux x86_64） | CPU/GPUビルドおよびテスト実行 | Docker上Ubuntu 22.04ベース、CUDA 12.3対応 | 動的スケーリング（CI基盤依存） |
| CIビルドサーバー（Linux ARM64） | ARM向けビルドおよびテスト実行 | Docker上Ubuntu 22.04ベース（ml-build-arm64） | 動的スケーリング |
| CIビルドサーバー（Windows） | Windows向けビルドおよびテスト | Windows Server 2022、VS 2022、LLVM 18.1.4 | 動的スケーリング |
| CIビルドサーバー（macOS） | macOS ARM64向けビルドおよびテスト | macOS ARM64 | 動的スケーリング |
| GitHub Actions ランナー（ARM64） | ARM CI / ARM CD実行 | self-hosted、Linux ARM64 | オンデマンド |
| RBEクラスタ | Bazelリモートビルド実行 | GCP上の分散ビルドクラスタ | 動的スケーリング |

### ネットワーク構成

- CIビルドコンテナはDockerネットワーク内で動作し、外部へのHTTPS接続によりパッケージダウンロード、GCSアクセス、RBEアクセスを行う
- GitHub ActionsランナーはGitHub APIおよびDockerレジストリとHTTPS通信する
- RBE利用時は、gcloud認証情報をコンテナへボリュームマウント（`$HOME/.config/gcloud:/root/.config/gcloud`）で共有する
- Windows環境ではDockerのhostネットワーキングモードが未対応のため、GCEメタデータサーバー（169.254.169.254:80）へのポートフォワーディングを使用する

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Docker / Docker BuildKit | 最新安定版 | コンテナベースのビルド環境構築・実行 |
| Bazel（Bazelisk経由） | Bazelisk v1.27.0 / v1.22.1（Windows）、Bazelバージョンは`.bazelversion`に準拠 | ビルドシステム |
| Python | 3.10, 3.11, 3.12（デフォルト）, 3.13, 3.14 | ビルド・テスト実行のランタイム |
| NVIDIA CUDA | 12.3（メインビルド環境）、12.1/12.2（RBEイメージ） | GPU対応ビルド |
| NVIDIA cuDNN | 9.1 / 8.9（RBEイメージ） | GPU演算の高速化 |
| NVIDIA TensorRT | 5.0.2（レガシーGPUイメージ） | 推論最適化 |
| ROCm | 5.3.0 | AMD GPU対応ビルド |
| LLVM/Clang | 18（Linux）、18.1.4（Windows） | コンパイラ |
| Visual Studio Build Tools | 2022（MSVC 14.39） | Windowsコンパイラ |
| MSYS2 | 2024-07-27 | Windows上のUnixツール群 |
| JDK (Azul Zulu) | 21 | Bazel実行ランタイム（Windows） |
| Google Cloud SDK | 最新安定版 | GCPリソースへのアクセス（GCS、RBE等） |
| patchelf | 0.18.0 | ELFバイナリの共有ライブラリパス修正 |
| buildifier / buildozer | v8.2.1（Linux）、v3.5.0（SIG Build） | Bazel BUILD ファイルのフォーマット・編集 |
| bats | v1.13.0（ml_build）、v1.7.0（SIG Build） | Bashスクリプトのユニットテスト |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| Google Cloud Storage (GCS) | ビルドアーティファクト（wheelファイル、libtensorflow）の保管・配布 | gcloud CLI / HTTPS API |
| Google Container Registry / Artifact Registry | CIビルド用Dockerイメージの保管 | docker pull/push (HTTPS) |
| Google Cloud Build | Dockerイメージのビルドパイプライン | cloudbuild.yaml経由 |
| Bazel Remote Build Execution (RBE) | 分散ビルド・テスト実行およびビルドキャッシュ | gRPC/HTTPS（gcloud認証） |
| GitHub Actions | CI/CDワークフロー実行（ARM CI、pylint、セキュリティ診断等） | GitHub API (HTTPS) |
| PyPI | Pythonパッケージの公開配布 | twine / HTTPS |
| NVIDIA Container Runtime | GPU対応Dockerコンテナの実行 | `--gpus all` フラグ |

## スケーリング設計

TensorFlowのCI/CDインフラは以下のスケーリング方式を採用している。

- **Docker コンテナベースの水平スケーリング**: CIジョブはDockerコンテナ内で実行され、CI基盤（Kokoro/GitHub Actions）が負荷に応じてワーカーを動的に割り当てる
- **Bazel RBEによる分散ビルド**: `--config rbe_<platform>` 設定により、ビルド・テストをGCP上の分散クラスタにオフロードする。対応プラットフォームは `linux_cpu`、`linux_cuda` 等
- **マルチプラットフォーム並列実行**: Linux x86_64（CPU/GPU）、Linux ARM64、Windows x86_64、macOS ARM64 の各プラットフォーム向けビルドを並列実行する
- **Docker イメージキャッシュ**: `DOCKER_BUILDKIT=1` と `--cache-from` によるレイヤーキャッシュの活用、およびBazelのアクションキャッシュ（`DOCKER_CACHEBUSTER`による制御）

## 可用性設計

- **CIジョブのリトライ機構**: Docker pullの失敗時に指数バックオフ（15秒、30秒、60秒）で自動リトライする。Bazeliskのバージョン取得も最大2回リトライする
- **コンテナの再利用**: 既存の`tf`コンテナが存在する場合は再利用し、不必要な再構築を回避する
- **ビルドアーティファクトの二重保管**: ステージングGCS（`TFCI_ARTIFACT_STAGING_GCS_URI`）とファイナルGCS（`TFCI_ARTIFACT_FINAL_GCS_URI`）の2段階でアーティファクトを保管する
- **マルチPythonバージョン対応**: Python 3.10〜3.14の複数バージョンをプリインストールし、特定バージョンの不具合発生時でも他のバージョンでビルド可能とする

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| Dockerイメージ | Google Artifact Registry / GCRへのpush | イメージ再構築時 | レジストリのライフサイクルポリシーに準拠 |
| ビルドアーティファクト（wheel等） | GCSバケットへのアップロード（ステージング/ファイナル2段階） | ビルド成功時 | GCSバケットのライフサイクルポリシーに準拠 |
| ソースコード | GitHubリポジトリ | pushイベント毎 | GitHubの保持ポリシーに準拠 |
| Bazelビルドキャッシュ | RBEキャッシュサーバー / ディスクキャッシュ | ビルド毎 | キャッシュポリシーに準拠 |

## 監視設計

- **CI実行結果の可視化**: `TFCI_INDEX_HTML_ENABLE=1` 設定により、各ビルドジョブのサマリーページ（`index.html`）を自動生成する
- **NVIDIA GPU監視**: `TFCI_NVIDIA_SMI_ENABLE` フラグにより、GPUビルド環境で`nvidia-smi`による GPU状態の確認を実行する
- **ビルドログ**: 全てのCI実行のスクリプト出力を `$TFCI_OUTPUT_DIR/script.log` に記録する
- **GitHub Actions Status**: GitHub Actionsのワークフロー結果がリポジトリのステータスチェックに反映される
- **Wheelサイズ制限**: `TFCI_WHL_SIZE_LIMIT_ENABLE=1` によりwheelファイルのサイズを監視し、閾値超過時にビルドを失敗させる（CPU: 265M、GPU: 630M、ARM64: 275M、macOS: 245M）
- **セキュリティスキャン**: OSV Scannerによるスケジュール実行（`.github/workflows/osv-scanner-scheduled.yml`）

## 備考

- TensorFlowはOSSライブラリプロジェクトであり、Webサーバーやデータベースサーバーなどのサービス運用インフラは含まない。本設計書はCI/CDパイプラインおよびビルドインフラストラクチャに特化している
- `ci/official/` ディレクトリ配下に公式CIスクリプト群が集約されており、`TFCI` 環境変数によるプラットフォーム別設定の切り替え機構を持つ
- レガシーCIビルドスクリプト（`tensorflow/tools/ci_build/`）も維持されているが、新しい公式CIは `ci/official/` を使用する
- Dockerイメージは `us-docker.pkg.dev/ml-oss-artifacts-published/ml-public-container/` にホストされている
- Windows CI環境では `T:\` ドライブのシンボリックリンクを使用して内部CIとの互換性を維持している
