---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 26
  claims_without_evidence: 4
confidence_derived: 0.87
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：26 / 30、根拠なし：4
- 優先レビュー（高）
  1. **カバレッジ目標の不在**：明示的な数値目標がコードベース内に見つからなかったが、別途社内ドキュメントに存在する可能性がある
  2. **受入テストの担当・プロセス**：コードベースからは推測に基づく記述であり、実際の運用フローの確認が必要
  3. **テストデータの詳細管理方針**：ディレクトリ構成から推測しているが、公式なデータ管理ガイドラインの有無を確認すべき
  4. **Kokoro CI との連携詳細**：Google 内部の CI システムであるため、コードベース上の情報が限定的

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.bazelrc`（テスト設定、タグフィルタ、タイムアウト設定等）
- E-02: `.github/workflows/arm-ci.yml`（ARM64 CI ワークフロー定義）
- E-03: `.github/workflows/pylint-presubmit.yml`（PyLint ワークフロー定義）
- E-04: `ci/official/pycpp.sh`（Python/C++ テスト実行スクリプト）
- E-05: `ci/official/wheel.sh`（ホイールビルドスクリプト）
- E-06: `ci/official/code_check_full.sh`（コード品質チェックスクリプト）
- E-07: `ci/official/utilities/code_check_full.bats`（bats テストスクリプト）
- E-08: `ci/official/envs/ci_default`（CI デフォルト環境変数定義）
- E-09: `ci/official/envs/`（各プラットフォーム・Python バージョン別設定ディレクトリ）
- E-10: `WORKSPACE`（Bazel ワークスペース定義、依存関係管理）
- E-11: `tensorflow/core/kernels/*_test.cc`（C++ 単体テストファイル群）
- E-12: `tensorflow/python/kernel_tests/`（Python カーネルテストディレクトリ）
- E-13: `tensorflow/dtensor/python/tests/`（dtensor テストディレクトリ）
- E-14: `tensorflow/tools/ci_build/`（CI ビルド用 Dockerfile 群）
- E-15: `tensorflow/tools/pip_package/pip_smoke_test.py`（ホイール検証テスト）
- E-16: `.github/workflows/osv-scanner-scheduled.yml`（セキュリティスキャンワークフロー）
- E-17: `.github/workflows/issue-on-pr-rollback.yml`（ロールバック通知ワークフロー）
- E-18: `requirements_lock_3_10.txt` 等（Python 依存ロックファイル）
- E-19: `third_party/xla/.github/workflows/ci.yml`（XLA CI ワークフロー）
- E-20: `ISSUES.md`（Issue 報告ガイドライン）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Bazel をビルドシステムおよびテストランナーとして使用 | E-01, E-04, E-10 | ○ |
| C-02 | C++ テストは `*_test.cc` ファイルで実装される | E-11 | ○ |
| C-03 | Python テストは `*_test.py` ファイルで実装される | E-12, E-13 | ○ |
| C-04 | Google Test (gtest) を C++ テストフレームワークとして使用 | E-01 (`GTEST_INSTALL_FAILURE_SIGNAL_HANDLER=1`) | ○ |
| C-05 | `tf.test.TestCase` を Python テスト基盤として使用 | E-12, E-13 | ○ |
| C-06 | GitHub Actions で ARM CI を実行 | E-02 | ○ |
| C-07 | PyLint を PR 時に実行 | E-03 | ○ |
| C-08 | `pycpp.sh` で Python/C++ テストを実行 | E-04 | ○ |
| C-09 | `wheel.sh` でホイールビルドと検証を実施 | E-05 | ○ |
| C-10 | bats でコード品質チェックを実行 | E-06, E-07 | ○ |
| C-11 | リリースビルドで `--test_size_filters=small,medium` を適用 | E-01 (line 719) | ○ |
| C-12 | GPU テストで `parallel_gpu_execute` ラッパーを使用 | E-01 (line 760) | ○ |
| C-13 | GPU テストで `--local_test_jobs=4` を設定 | E-01 (line 760) | ○ |
| C-14 | ARM64 環境で `--flaky_test_attempts=3` を適用 | E-01 (line 778) | ○ |
| C-15 | macOS テストで `--flaky_test_attempts=3` を適用 | E-01 (line 819) | ○ |
| C-16 | テストタイムアウトが `300,450,1200,3600` 秒に設定 | E-01 (line 760, 817) | ○ |
| C-17 | RBE（Remote Build Execution）を使用 | E-01 (line 613, 640) | ○ |
| C-18 | ResultStore へテスト結果を送信 | E-01 (line 590) | ○ |
| C-19 | Docker コンテナでテスト環境を構築 | E-14 | ○ |
| C-20 | OSV Scanner でセキュリティスキャンを実施 | E-16 | ○ |
| C-21 | PR ロールバック時に自動 Issue 作成 | E-17 | ○ |
| C-22 | Python 3.10-3.13 に対応 | E-18, E-09 | ○ |
| C-23 | Hermetic ビルドに `rules_ml_toolchain` を使用 | E-10 (line 22-38) | ○ |
| C-24 | XLA が独自の CI ワークフローを持つ | E-19 | ○ |
| C-25 | テストタグフィルタで GPU/TPU テストを分離管理 | E-01 (line 864-872) | ○ |
| C-26 | ホイールテストで `--@xla//third_party/py:wheel_dependency=true` を設定 | E-01 (line 867) | ○ |
| C-27 | カバレッジの明示的な数値目標は設定されていない | **根拠なし** | △ |
| C-28 | 受入テストの担当がリリースエンジニアリング・QA である | **根拠なし** | △ |
| C-29 | テストデータは testdata ディレクトリに格納される方針である | **根拠なし**（ディレクトリの存在は確認済みだが方針文書は未確認） | △ |
| C-30 | Kokoro が内部 CI として使用されている | **根拠なし**（`.bazelrc` のコメントに `kokoro:force-run` ラベルの言及あり、間接的根拠のみ） | △ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ目標**: コードベース内に明示的なカバレッジ目標の定義が見つからなかった。Google 内部のプロジェクト管理ツールや別途のドキュメントに定義されている可能性がある。
  - 候補：Google 内部プロジェクト管理ドキュメント / TensorFlow コントリビューターガイド / テスト方針の内部 Wiki
- **受入テストプロセス**: CI スクリプトからリリースフローは推測できるが、受入テストの正式な担当チームやプロセスは確認できなかった。
  - 候補：リリースプロセスドキュメント / RELEASE.md の詳細 / Google 内部リリースチェックリスト
- **テストデータ管理ガイドライン**: testdata ディレクトリの存在は確認したが、公式なデータ管理ガイドラインの有無は不明。
  - 候補：CONTRIBUTING.md / 開発者向けガイドライン / Google 内部コーディング規約
- **Kokoro CI の詳細**: Google の内部 CI システムのため、設定や動作の詳細はコードベースからは限定的にしか把握できない。
  - 候補：Google 内部 CI ドキュメント / Kokoro 設定ファイル（リポジトリ外）

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - カバレッジ目標の記述が「設定されていない」としているが、別途存在する可能性がある。レビュアーは内部ドキュメントとの照合を推奨。
- **0: 低リスク** - テストツールおよびフレームワークの記述は、設定ファイルから直接確認した情報に基づいている。
- **1: 中リスク** - CI/CD の Kokoro 連携部分は間接的な根拠のみであり、実際の運用と差異がある可能性がある。
- **0: 低リスク** - Bazel テスト設定（`.bazelrc`）に基づく記述は高い信頼性を持つ。

## 6) レビュアーチェックリスト（最小）
- [ ] カバレッジ目標について、内部ドキュメントに別途定義がないか確認する
- [ ] 受入テストの担当チーム・プロセスが実際の運用と一致しているか確認する
- [ ] Kokoro CI との連携詳細が正確かどうか、内部システムの情報と照合する
- [ ] テストデータ管理の方針について、CONTRIBUTING.md や内部ガイドラインと整合性を確認する
- [ ] XLA サブプロジェクトのテスト方針が本ドキュメントの記述と矛盾していないか確認する
- [ ] Python バージョンサポート範囲（3.10-3.13）が最新の方針と一致しているか確認する
