# テスト方針書

## 概要

本ドキュメントは、TensorFlow プロジェクトにおけるテスト方針を定義するものである。TensorFlow は Google が開発するオープンソースの機械学習フレームワークであり、C++ と Python を中心とした大規模なコードベースを持つ。テストは Bazel ビルドシステムを基盤とし、単体テストから結合テスト、各種プラットフォーム向けのホイールテストまで多層的に実施される。CI/CD は Google の内部インフラ（Kokoro）および GitHub Actions を併用して運用されている。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々の関数・クラス・カーネルの正確性を検証する。C++ テスト（`*_test.cc`）および Python テスト（`*_test.py`）として実装される | 各コンポーネントの開発者 |
| 結合テスト | 複数のコンポーネント間の連携を検証する。Python API を通じたエンドツーエンドの演算実行、dtensor のマルチクライアントテスト、compiler テストなどが該当する | コンポーネント横断チーム |
| システムテスト | ビルドされたホイール（wheel）パッケージのインストールとインポートの正常性を検証する。`pip_smoke_test.py`、`import_api_packages_test.py` 等で実施される | リリースエンジニアリング |
| 受入テスト | リリース候補のホイールを対象プラットフォーム（Linux x86、Linux ARM64、macOS ARM64、Windows）上で実行し、各環境での動作を最終確認する | リリースエンジニアリング・QA |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | 演算カーネル、Python API、グラフ実行、Eager 実行の機能的正確性を検証する | コミットごと（presubmit/postsubmit） |
| 性能テスト | ベンチマークテスト（`benchmark-test` タグ付き）により演算のパフォーマンスを計測する。通常テストスイートからは除外される | ナイトリー・手動実行 |
| セキュリティテスト | OSV Scanner によるセキュリティ脆弱性スキャンを実施する。`osv-scanner-scheduled.yml` ワークフローで定期実行される | 定期スケジュール |
| コード品質チェック | PyLint による静的解析、ライセンスチェック、buildifier によるBUILDファイルフォーマットチェック、API 互換性テストを実施する | プルリクエスト時・コミットごと |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| Linux x86_64 CPU | CPU のみのテスト実行 | Docker コンテナ（`ci_build.sh` 経由）、Bazel ビルド、Python 3.10-3.13 |
| Linux x86_64 CUDA | GPU 対応テスト実行 | Docker コンテナ、CUDA 12.x、hermetic CUDA UMD、`parallel_gpu_execute` ラッパー使用 |
| Linux ARM64 | ARM アーキテクチャ向けテスト | self-hosted ARM64 ランナー、Docker コンテナ、Python 3.10 |
| macOS ARM64 | macOS 向けテスト | macOS ネイティブ環境、`setup_macos.sh` による環境構築 |
| Windows x86_64 | Windows 向けテスト | MSYS2 環境、Clang ベースビルド |
| RBE（Remote Build Execution） | 高速分散ビルド・テスト | `tensorflow-testing` GCP プロジェクト、リモートキャッシュ対応 |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| Bazel | ビルドシステムおよびテストランナー。`bazel test` コマンドでC++/Python双方のテストを実行する | プロジェクトの `.bazelversion` で管理 |
| Google Test (gtest) | C++ 単体テストフレームワーク。`GTEST_INSTALL_FAILURE_SIGNAL_HANDLER=1` でスタックトレース出力を有効化 | Bazel 依存管理 |
| `tf.test.TestCase` | TensorFlow 独自の Python テスト基盤クラス。`absl.testing` を基盤とし、TensorFlow 固有のアサーション機能を提供する | TensorFlow バンドル |
| PyLint | Python コードの静的解析 | GitHub Actions ワークフローで実行 |
| bats (Bash Automated Testing System) | シェルスクリプトのテスト（ライセンスチェック、コード品質チェック等） | CI 環境にインストール |
| OSV Scanner | セキュリティ脆弱性スキャン | GitHub Actions ワークフローで定期実行 |
| Docker | テスト環境のコンテナ化。各プラットフォーム向けの Dockerfile が `tensorflow/tools/ci_build/` に多数用意されている | CI 環境依存 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 明示的な数値目標は設定されていない（後述の備考参照） |
| 分岐カバレッジ | 明示的な数値目標は設定されていない |

TensorFlow プロジェクトでは、カバレッジの数値目標を明示的にコードベース内で定義していない。代わりに、各テストスイートのサイズフィルタ（`small`, `medium`）やタグフィルタ（`-no_oss`, `-gpu` 等）を通じて、テスト対象の網羅性を管理している。リリースビルドでは `--test_size_filters=small,medium` により、small および medium サイズのテストのみを実行対象としている。

## テストデータ

テストデータは以下の方法で管理されている:

- **testdata ディレクトリ**: `tensorflow/lite/testdata/`、`tensorflow/c/testdata/` 等、各コンポーネント直下の `testdata` ディレクトリに格納される。Bazel の `data` 属性で依存関係として宣言される。
- **テストユーティリティ**: `tensorflow/dtensor/python/tests/test_util.py`、`tensorflow/core/function/testing/` 等のヘルパーモジュールにより、テストデータの生成・セットアップを行う。
- **Bazel ルールによる生成**: 一部のテストデータは Bazel ルールによりビルド時に自動生成される。

## 不具合管理

- **GitHub Issues**: バグ報告および追跡は GitHub Issues で管理される（`ISSUES.md` に報告ガイドラインが記載）。
- **flaky テスト対応**: ARM64 環境等では `--flaky_test_attempts=3` により、不安定なテストを自動リトライする設定が適用されている。
- **テスト結果の保存**: `--bes_instance_name="tensorflow-testing"` により ResultStore へテスト結果が送信され、テスト結果の履歴管理が行われている。
- **PR ロールバック通知**: `issue-on-pr-rollback.yml` ワークフローにより、PR のロールバック時に自動で Issue が作成される。

## CI/CD連携

TensorFlow の CI/CD は複数のシステムで構成されている:

### GitHub Actions ワークフロー

| ワークフロー | トリガー | 内容 |
| --- | --- | --- |
| `arm-ci.yml` | master/r2.** ブランチへの push | ARM64 環境でのビルドと Python テスト実行 |
| `arm-ci-extended.yml` | master/r2.** ブランチへの push | ARM64 拡張テスト |
| `arm-ci-extended-cpp.yml` | master/r2.** ブランチへの push | ARM64 C++ テスト |
| `pylint-presubmit.yml` | `.py` ファイル変更を含む PR | PyLint 静的解析 |
| `osv-scanner-scheduled.yml` | スケジュール | セキュリティ脆弱性スキャン |
| `scorecards-analysis.yml` | スケジュール | OpenSSF Scorecards によるセキュリティ評価 |
| `arm-cd.yml` | リリース時 | ARM64 向け CD パイプライン |

### CI 公式スクリプト (`ci/official/`)

| スクリプト | 用途 |
| --- | --- |
| `pycpp.sh` | Python および C++ テストスイートの実行。`bazel test` でテストを実行し、プロファイル結果を出力する |
| `wheel.sh` | ホイールパッケージのビルドと検証 |
| `code_check_full.sh` | bats を使用したコード品質チェック（ライセンス検証等）の実行 |
| `code_check_changed_files.sh` | 変更ファイルのみを対象としたコード品質チェック |

### Bazel テスト設定（`.bazelrc`）

主要なテスト設定は `.bazelrc` で定義されている:

- **`release_base`**: リリースビルド共通設定。`--test_size_filters=small,medium` でテスト対象を制限。
- **`release_linux_base`**: Linux リリーステスト。`--build_tests_only --keep_going --test_output=errors --test_summary=short`。
- **`release_gpu_linux`**: GPU テスト。`--test_timeout=300,450,1200,3600 --local_test_jobs=4`、`parallel_gpu_execute` ラッパーで並列実行。
- **`release_macos_base`**: macOS テスト。`--flaky_test_attempts=3 --test_timeout=300,450,1200,3600`。
- **`linux_cpu_wheel_test`**: CPU ホイールテスト。Python テストのみ、small/medium サイズ。タグフィルタで GPU/TPU テストを除外。
- **`linux_cuda_wheel_test`**: CUDA ホイールテスト。GPU タグ付きテストのみを対象。

### 環境設定 (`ci/official/envs/`)

CI 環境は以下の設定ファイルで管理される:

- `ci_default`: 全 CI 変数のデフォルト値定義
- `linux_x86`, `linux_x86_cuda`, `linux_arm64`: プラットフォーム別設定
- `macos_arm64`: macOS 向け設定
- `py310`, `py311`, `py312`: Python バージョン別設定
- `disk_cache`, `public_cache`: ビルドキャッシュ設定

## 備考

- TensorFlow はモノレポ構成であり、XLA（`third_party/xla/`）を含む大規模なサブプロジェクトもリポジトリ内に含まれる。XLA は独自の GitHub Actions ワークフロー（`ci.yml`, ベンチマーク関連ワークフロー等）を持つ。
- テストのタグ付けにより、特定環境でのみ実行されるテスト（`gpu`, `tpu`, `requires-gpu`）、除外されるテスト（`no_oss`, `oss_excluded`, `no_aarch64`）が管理されている。
- Python バージョンは 3.10 から 3.13 まで対応しており、`requirements_lock_3_10.txt` 等のロックファイルで依存関係を固定している。
- Hermetic ビルドシステム（`rules_ml_toolchain`）により、C++ ツールチェインの再現性を確保している。
- テストタイムアウトはリリースビルドで `300,450,1200,3600` 秒（small, medium, large, enormous に対応）に設定されている。
