# ER図

## TensorBoard SQLite データベース ER図

以下はTensorBoardのSQLiteデータベースにおけるエンティティ間の関係を示すER図である。

```mermaid
erDiagram
    Ids {
        INTEGER id PK "永続ID [1, 2^47)"
    }

    Descriptions {
        INTEGER id PK "リソースの永続ID"
        TEXT description "Markdownテキスト"
    }

    Users {
        INTEGER rowid PK "エフェメラルB-tree ID"
        INTEGER user_id "ユーザー永続ID (NOT NULL)"
        REAL inserted_time "挿入時刻"
        TEXT user_name "一意なユーザー名"
        TEXT email "一意なメールアドレス"
    }

    Experiments {
        INTEGER rowid PK "エフェメラルB-tree ID"
        INTEGER user_id "関連ユーザーの永続ID"
        INTEGER experiment_id "実験永続ID (NOT NULL)"
        REAL inserted_time "挿入時刻"
        REAL started_time "開始時刻"
        INTEGER is_watching "閲覧中フラグ"
        TEXT experiment_name "実験名"
    }

    Runs {
        INTEGER rowid PK "エフェメラルB-tree ID"
        INTEGER experiment_id "関連実験の永続ID"
        INTEGER run_id "ラン永続ID (NOT NULL)"
        REAL inserted_time "挿入時刻"
        REAL started_time "開始時刻"
        REAL finished_time "終了時刻"
        TEXT run_name "ラン名"
    }

    Tags {
        INTEGER rowid PK "エフェメラルB-tree ID"
        INTEGER run_id "関連ランの永続ID"
        INTEGER tag_id "タグ永続ID (NOT NULL)"
        DOUBLE inserted_time "挿入時刻"
        TEXT tag_name "タグ名"
        TEXT display_name "表示名"
        TEXT plugin_name "プラグイン名"
        BLOB plugin_data "プラグインデータ"
    }

    Tensors {
        INTEGER rowid PK "エフェメラルB-tree ID"
        INTEGER series "系列の永続ID"
        INTEGER step "ステップ番号"
        INTEGER dtype "DataType ID"
        REAL computed_time "計算時刻"
        TEXT shape "次元情報"
        BLOB data "テンソルデータ"
    }

    TensorStrings {
        INTEGER rowid PK "エフェメラルB-tree ID"
        INTEGER tensor_rowid "Tensors.rowid参照 (NOT NULL)"
        INTEGER idx "フラット化インデックス (NOT NULL)"
        BLOB data "文字列値"
    }

    Graphs {
        INTEGER rowid PK "エフェメラルB-tree ID"
        INTEGER run_id "関連ランの永続ID"
        INTEGER graph_id "グラフ永続ID (NOT NULL)"
        REAL inserted_time "挿入時刻"
        BLOB graph_def "GraphDefプロト"
    }

    Nodes {
        INTEGER rowid PK "エフェメラルB-tree ID"
        INTEGER graph_id "関連グラフの永続ID (NOT NULL)"
        INTEGER node_id "ノードID (NOT NULL)"
        TEXT node_name "ノード名"
        TEXT op "オペレーション名"
        TEXT device "デバイス名"
        BLOB node_def "NodeDefプロト"
    }

    NodeInputs {
        INTEGER rowid PK "エフェメラルB-tree ID"
        INTEGER graph_id "関連グラフの永続ID (NOT NULL)"
        INTEGER node_id "入力先ノードID (NOT NULL)"
        INTEGER idx "入力順序インデックス (NOT NULL)"
        INTEGER input_node_id "入力元ノードID (NOT NULL)"
        INTEGER input_node_idx "入力元テンソルインデックス"
        INTEGER is_control "制御依存フラグ"
    }

    Ids ||--o| Descriptions : "id"
    Users ||--o{ Experiments : "user_id"
    Experiments ||--o{ Runs : "experiment_id"
    Runs ||--o{ Tags : "run_id"
    Runs ||--o| Graphs : "run_id"
    Tags ||--o{ Tensors : "tag_id = series"
    Tensors ||--o{ TensorStrings : "rowid = tensor_rowid"
    Graphs ||--o{ Nodes : "graph_id"
    Graphs ||--o{ NodeInputs : "graph_id"
    Nodes ||--o{ NodeInputs : "node_id"
```

## リレーションシップ説明

| 関係 | カーディナリティ | 説明 |
| --- | --- | --- |
| Ids - Descriptions | 1:0..1 | 各永続IDに対して0または1つの説明文が存在し得る |
| Users - Experiments | 1:N | 1人のユーザーが複数の実験を持つことができる |
| Experiments - Runs | 1:N | 1つの実験が複数のランを持つことができる |
| Runs - Tags | 1:N | 1つのランが複数のタグを持つことができる |
| Runs - Graphs | 1:0..1 | 1つのランに対して0または1つのグラフが関連付けられる |
| Tags - Tensors | 1:N | 1つのタグ（series）が複数のテンソルを持つことができる |
| Tensors - TensorStrings | 1:N | 1つのテンソルが複数の文字列値を持つことができる |
| Graphs - Nodes | 1:N | 1つのグラフが複数のノードを持つ |
| Graphs - NodeInputs | 1:N | 1つのグラフが複数のノード入力エッジを持つ |
| Nodes - NodeInputs | 1:N | 1つのノードが複数の入力接続を持つことができる |

## 補足

- 外部キー制約はSQLスキーマ上では明示的に定義されていないが、アプリケーションロジックにより参照整合性が維持される
- 永続ID（user_id, experiment_id, run_id, tag_id, graph_id）はIdsテーブルを通じてシステム全体で一意性が保証される設計
- rowidはSQLiteのエフェメラルなB-tree IDであり、永続IDとは異なる
