---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 21
  claims_with_evidence: 21
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：21 / 21、根拠なし：0
- 優先レビュー（高）
  1. 該当なし：全バッチスクリプトのソースコードを直接確認済み

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ci/official/wheel.sh`
- E-02: `ci/official/pycpp.sh`
- E-03: `ci/official/libtensorflow.sh`
- E-04: `ci/official/installer_wheel.sh`
- E-05: `ci/official/upload.sh`
- E-06: `ci/official/any.sh`
- E-07: `ci/official/code_check_full.sh`
- E-08: `ci/official/code_check_changed_files.sh`
- E-09: `ci/official/bisect.sh`
- E-10: `ci/official/debug_tfci.sh`
- E-11: `ci/official/utilities/setup.sh`
- E-12: `ci/official/utilities/setup_docker.sh`
- E-13: `ci/official/utilities/rename_and_verify_wheels.sh`
- E-14: `ci/official/utilities/repack_libtensorflow.sh`
- E-15: `ci/official/utilities/cleanup_docker.sh`
- E-16: `ci/official/utilities/cleanup_summary.sh`
- E-17: `ci/official/utilities/generate_index_html.sh`
- E-18: `tensorflow/tools/benchmark/run_models.sh`
- E-19: `tensorflow/tools/benchmark/run_onednn_benchmarks.sh`
- E-20: `tensorflow/tools/benchmark/download_models.sh`
- E-21: `tools/tf_env_collect.sh`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | wheel.shはTensorFlowのPython wheelパッケージをBazelでビルドし、auditwheel検証・GCSステージングへのアップロードを行う | E-01 | ○ |
| C-02 | pycpp.shはPython/C++の統合テストまたはビルドをBazelで実行し、パフォーマンスプロファイルを生成・分析する | E-02 | ○ |
| C-03 | libtensorflow.shはlibtensorflowのテスト・ビルドを実行し、tarball/zipにリパックしてGCSへアップロードする | E-03 | ○ |
| C-04 | installer_wheel.shはプラットフォーム固有タグ付きのインストーラーwheelを生成し、PyPIアップロード互換形式で出力する | E-04 | ○ |
| C-05 | upload.shはステージング済みの全ビルド成果物をGCSおよびPyPIにアップロードする | E-05 | ○ |
| C-06 | any.shは任意のBazelターゲットまたはCIスクリプトをTFCI環境内で実行する汎用バッチである | E-06 | ○ |
| C-07 | code_check_full.shは全コードに対するコード品質チェック（batsテスト）を実行する | E-07 | ○ |
| C-08 | code_check_changed_files.shは変更されたファイルのみに対するコード品質チェック（batsテスト）を実行する | E-08 | ○ |
| C-09 | bisect.shはgit bisectを使用してCIテスト失敗の原因コミットを特定する | E-09 | ○ |
| C-10 | debug_tfci.shはTFCI環境変数の状態をダンプしてCI設定のデバッグを行う | E-10 | ○ |
| C-11 | setup.shは全CIスクリプト共通の初期化処理（環境変数読込・Docker設定・クリーンアップトラップ設定等）を行う | E-11 | ○ |
| C-12 | setup_docker.shはDockerイメージのpull/rebuild・コンテナ起動・tfrun関数の再定義を行う | E-12 | ○ |
| C-13 | rename_and_verify_wheels.shは生成されたwheelのauditwheel修復・サイズチェック・インストール検証を行う | E-13 | ○ |
| C-14 | repack_libtensorflow.shはlibtensorflowのビルド成果物をtarball/zipに再パッケージする | E-14 | ○ |
| C-15 | cleanup_docker.shはDocker環境のクリーンアップ情報を表示する | E-15 | ○ |
| C-16 | cleanup_summary.shはBazel ResultStoreリンクの抽出・表示を行うビルド後サマリーバッチである | E-16 | ○ |
| C-17 | generate_index_html.shはKokoroビルドジョブの概要HTMLページを生成する | E-17 | ○ |
| C-18 | run_models.shは複数のMLモデルに対しoneDNNベンチマークを実行する | E-18 | ○ |
| C-19 | run_onednn_benchmarks.shはoneDNNベンチマーク実行・ログ解析・結果CSV出力を一括で行う | E-19 | ○ |
| C-20 | download_models.shはMLPerfベンチマーク用モデルをダウンロード・展開する | E-20 | ○ |
| C-21 | tf_env_collect.shはTensorFlow実行環境の情報を収集しファイルに出力する | E-21 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全バッチスクリプトのソースコードを直接参照しており、各バッチの説明はコード内容に基づいている。
- ただし、third_party/xla配下にも多数のシェルスクリプト（ベンチマーク・ビルド関連）が存在するが、TensorFlowコアプロジェクト固有のバッチとしては対象外としている。
  - 候補：`third_party/xla/build_tools/` 配下のスクリプト / `third_party/xla/.kokoro/` 配下のスクリプト / `tensorflow/tools/ci_build/` 配下の個別インストールスクリプト群

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目がソースコードに直接根拠を持つ
- 1: 中リスク - third_party/xla配下およびtensorflow/tools/ci_build/install配下の個別インストールスクリプト群（約40件）をバッチ一覧に含めていない。これらは依存パッケージのインストール用ユーティリティであり、単独のバッチ処理というよりはCI環境構築の部品であるため除外したが、レビュアーの判断で追加が必要な場合がある。

## 6) レビュアーチェックリスト（最小）
- [ ] 一覧に記載された21件のバッチが、プロジェクトで実際に使用されている主要なバッチ処理を網羅しているか
- [ ] カテゴリ分類（CI/CDビルド・アップロード・コードチェック・デバッグ・ユーティリティ・ベンチマーク・環境情報収集）が適切か
- [ ] third_party/xla配下のスクリプト群を別途バッチ一覧に含めるべきか検討
- [ ] tensorflow/tools/ci_build/install/配下のインストールスクリプト群をバッチ一覧に含めるべきか検討
- [ ] 各バッチの説明内容がソースコードの実際の処理内容と一致しているか
