# バッチ設計書 10-debug_tfci.sh

## 概要

本ドキュメントは、TensorFlowのCI/CDパイプラインにおけるTFCI環境デバッグバッチ `debug_tfci.sh` の設計仕様を記述する。

### 本バッチの処理概要

本バッチは、TFCI（TensorFlow CI）環境変数の状態をダンプして、CI設定のデバッグを行うバッチである。

**業務上の目的・背景**：TFCIスクリプトシステムは複数の環境設定ファイルを組み合わせて動作するため、設定の問題を診断する際に環境変数の実際の状態を把握する必要がある。本バッチは、Docker内外の環境変数の差異を可視化し、環境設定の不整合や意図しない変数値の問題を特定するために使用される。

**バッチの実行タイミング**：CI/CD設定の変更時や問題発生時に、開発者が手動で実行する。

**主要な処理内容**：
1. TFCI環境の初期化（setup.sh の読み込み）
2. tfrun外（ホスト環境）での環境変数のダンプ
3. tfrun内（Docker環境）での環境変数のダンプ

**前後の処理との関連**：前段として `setup.sh` による環境初期化が行われる。本バッチはデバッグ専用であり、他のバッチとの依存関係はない。

**影響範囲**：標準出力への環境変数情報の出力のみ。システムへの変更は行わない。

## バッチ種別

デバッグ / 環境情報収集

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 該当なし |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 開発者による手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| TFCI環境変数の設定 | `$TFCI` 環境変数に適切な env ファイルパスが設定されていること（設定されていなくても動作する旨のメッセージが表示される） |

### 実行可否判定

`setup.sh` による環境初期化が完了すれば実行可能。`$TFCI` が未設定の場合でも、既に環境変数がエクスポートされていれば動作する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| TFCI | string | No | なし | 環境設定ファイルのカンマ区切りパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| TFCI環境設定ファイル | シェルスクリプト | `ci/official/envs/` 配下の環境変数定義ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | ホスト環境およびDocker環境の環境変数一覧 |
| $TFCI_OUTPUT_DIR/script.log | テキスト | スクリプト実行ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | script.log |
| 出力先 | `$TFCI_OUTPUT_DIR` |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 環境初期化
   └─ setup.sh を source し、TFCI環境変数を設定
2. ホスト環境変数ダンプ
   └─ "==TFCI== env outside of tfrun:" ヘッダと共に env コマンドを実行
3. Docker環境変数ダンプ
   └─ "==TFCI== env inside of tfrun:" ヘッダと共に tfrun env コマンドを実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[setup.sh による環境初期化]
    B --> C[ホスト環境の env ダンプ]
    C --> D[Docker環境の tfrun env ダンプ]
    D --> E[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ終了 | 環境初期化エラー | setup.shの実行失敗 | TFCI環境設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

本バッチ自体がデバッグ用であるため、失敗した場合はsetup.shの初期化処理を直接確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 環境変数の数（通常数十〜数百個） |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | 最小限 |

## 排他制御

本バッチは読み取り専用の操作のみ行うため、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | setup.sh 実行時 | TFCI環境変数の一覧 |
| 進捗ログ | envダンプ時 | 全環境変数の値 |
| 終了ログ | バッチ終了時 | cleanup_summary.sh によるResultStoreリンク |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | 該当なし | 該当なし |

## 備考

- 本バッチはTFCIスクリプトシステムの検証用であり、ほとんどのユーザーが直接使用する必要はない（ソースコードのコメントにも記載あり）
- ホスト環境（tfrun外）とDocker環境（tfrun内）の両方の環境変数をダンプすることで、Docker設定による環境変数の差異を確認できる
- Docker未使用時は `tfrun` が `"$@"` として定義されるため、両方のenvダンプは同一の結果となる
- 機密情報を含む環境変数も出力される可能性があるため、出力の取り扱いに注意が必要
