# バッチ設計書 12-setup_docker.sh

## 概要

本ドキュメントは、TensorFlow CI/CDパイプラインにおけるDocker環境のセットアップバッチ `setup_docker.sh` の設計仕様を記述する。本バッチはDockerイメージのpull/rebuild、コンテナ起動、および `tfrun` 関数のDocker exec版への再定義を行う。

### 本バッチの処理概要

本バッチは、CI/CDジョブをDocker環境内で実行するために必要なDockerコンテナの準備を一括で行うユーティリティスクリプトである。イメージのpull、オプショナルなリビルド、コンテナの起動、および以降の処理がDocker内で実行されるよう `tfrun` 関数を再定義する。

**業務上の目的・背景**：TensorFlowのCI/CDパイプラインでは、ビルド・テスト環境の再現性と一貫性を確保するためにDockerコンテナ内で処理を実行する必要がある。本バッチはDocker環境の構築を自動化し、開発者やCIシステムが統一された環境でビルド・テストを実行できるようにする。

**バッチの実行タイミング**：No.11（setup.sh）から `TFCI_DOCKER_ENABLE=1` の場合に `source` で読み込まれる。CIジョブの初期化フェーズで実行される。

**主要な処理内容**：
1. `TFCI_DOCKER_PULL_ENABLE=1` の場合、Dockerイメージをリトライ付きでpull
2. `TFCI_DOCKER_REBUILD_ENABLE=1` の場合、Docker BuildKitでイメージをリビルド
3. `TFCI_DOCKER_REBUILD_UPLOAD_ENABLE=1` の場合、リビルドしたイメージをpush
4. `tf` コンテナが存在しない場合、TFCI_変数を引き渡して新規コンテナを起動
5. Windows環境固有の設定（ファイアウォール、サービス停止）
6. `tfrun` 関数を `docker exec tf` に再定義

**前後の処理との関連**：本バッチはNo.11（setup.sh）から呼び出される。起動したコンテナはNo.15（cleanup_docker.sh）でクリーンアップ情報が表示される。すべてのCIジョブスクリプトの `tfrun` コマンドが本バッチで再定義された関数を使用する。

**影響範囲**：Docker環境の構築、`tfrun` 関数の動作変更、以降のすべてのCI処理の実行環境に影響する。

## バッチ種別

環境構築 / Docker環境セットアップ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIジョブ実行時、Docker有効時） |
| 実行時刻 | CIジョブのトリガーに依存 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | setup.shからの `source` 呼び出し（TFCI_DOCKER_ENABLE=1の場合） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Docker実行環境 | `docker` コマンドが利用可能であること |
| TFCI_DOCKER_IMAGE | 使用するDockerイメージ名が設定されていること |
| TFCI_GIT_DIR | TensorFlowリポジトリのルートディレクトリが設定されていること |
| TFCI_DOCKER_ARGS | docker run に渡す追加引数が設定されていること |

### 実行可否判定

setup.shの中で `TFCI_DOCKER_ENABLE=1` の場合にのみ実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| TFCI_DOCKER_PULL_ENABLE | string | Yes | 環境依存 | イメージpullの有無（"1"で有効） |
| TFCI_DOCKER_IMAGE | string | Yes | 環境依存 | 使用するDockerイメージ名 |
| TFCI_DOCKER_REBUILD_ENABLE | string | Yes | 環境依存 | イメージリビルドの有無（"1"で有効） |
| TFCI_DOCKER_REBUILD_ARGS | string | No | 環境依存 | docker build追加引数 |
| TFCI_DOCKER_REBUILD_UPLOAD_ENABLE | string | Yes | 環境依存 | リビルドイメージのpush有無（"1"で有効） |
| TFCI_DOCKER_ARGS | string | Yes | 環境依存 | docker run追加引数 |
| TFCI_GIT_DIR | string | Yes | 環境依存 | リポジトリルートディレクトリ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Dockerレジストリ | Dockerイメージ | pull対象のDockerイメージ |
| TFCI_環境変数 | 変数 | setup.shで設定されたTFCI_変数群 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Dockerコンテナ `tf` | コンテナ | 起動されたDockerコンテナ |
| tfrun関数 | シェル関数 | docker exec tf を実行する関数 |
| Dockerレジストリ（条件付き） | Dockerイメージ | リビルド・push時のイメージ |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. Dockerイメージpull（条件付き）
   └─ TFCI_DOCKER_PULL_ENABLE=1の場合
   └─ リトライ: 失敗時15秒→30秒→60秒スリープ後に再試行（最大4回）
2. Dockerイメージリビルド（条件付き）
   └─ TFCI_DOCKER_REBUILD_ENABLE=1の場合
   └─ Docker BuildKitを使用、キャッシュ元として既存イメージを指定
3. リビルドイメージのpush（条件付き）
   └─ TFCI_DOCKER_REBUILD_UPLOAD_ENABLE=1の場合
4. コンテナ起動（既存コンテナが無い場合）
   └─ TFCI_変数をenv-fileとして渡す
   └─ TFCI_GIT_DIRをボリュームマウント
   └─ bash をエントリポイントとしてデタッチモードで起動
5. Windows固有設定（条件付き）
   └─ ファイアウォールルール追加
   └─ SysMain, DiagTrackサービス停止
6. tfrun関数の再定義
   └─ docker exec tf に再定義
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{DOCKER_PULL有効?}
    B -->|Yes| C[docker pull（リトライ付き）]
    B -->|No| D{DOCKER_REBUILD有効?}
    C --> D
    D -->|Yes| E[docker build]
    D -->|No| G{tfコンテナ存在?}
    E --> F{REBUILD_UPLOAD有効?}
    F -->|Yes| F2[docker push]
    F -->|No| G
    F2 --> G
    G -->|No| H[TFCI_変数をenv-fileに出力]
    G -->|Yes| L[tfrun関数再定義]
    H --> I[docker run でコンテナ起動]
    I --> J{Windows?}
    J -->|Yes| K[ファイアウォール・サービス設定]
    J -->|No| L
    K --> L
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード非0 | docker pull失敗 | ネットワーク障害またはイメージ不在 | リトライ（15s/30s/60s間隔）後に最終試行 |
| 終了コード非0 | docker build失敗 | Dockerfileのビルドエラー | ビルド引数とDockerfileを確認 |
| 終了コード非0 | docker run失敗 | リソース不足またはDocker設定エラー | Docker設定とリソースを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 3回（docker pull）、合計4回の試行 |
| リトライ間隔 | 15秒、30秒、60秒（段階的増加） |
| リトライ対象エラー | docker pull の失敗 |

### 障害時対応

docker pullの失敗はリトライで対応される。最終試行でも失敗した場合はスクリプトがエラー終了し、setup.shのEXITトラップが発動する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回（CIジョブ開始時に1回実行） |
| 目標処理時間 | Docker pull時にネットワーク速度に依存（数十秒〜数分） |
| メモリ使用量上限 | Dockerイメージサイズに依存 |

## 排他制御

`tf` コンテナ名で一意性を確保している。`docker container inspect tf` で既存コンテナの存在をチェックし、存在する場合はコンテナの再作成をスキップする。コンテナは自動削除されないため、明示的に `docker rm tf` で削除する必要がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | docker pull/build/run時 | Dockerコマンドの標準出力（setup.shのset -xにより） |
| エラーログ | エラー発生時 | Dockerコマンドのエラー出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| docker pull成否 | 4回試行後も失敗 | CIジョブログ |
| コンテナ起動成否 | 終了コード非0 | CIジョブログ |

## 備考

- コンテナは `--rm` フラグ付きで起動されるため、停止時に自動削除される。ただし手動削除が必要な場合は `docker rm -f tf` を使用する。
- Windows（MSYS_NT）環境では追加のファイアウォールルール設定とサービス停止処理が行われる。これはBazelビルド時の "Permission denied" エラー対策（b/461500885）である。
- ソースファイルパス: `ci/official/utilities/setup_docker.sh`
