# バッチ設計書 13-rename_and_verify_wheels.sh

## 概要

本ドキュメントは、TensorFlow CI/CDパイプラインにおけるwheelパッケージの検証バッチ `rename_and_verify_wheels.sh` の設計仕様を記述する。本バッチは生成されたPython wheelファイルに対してauditwheel修復、サイズチェック、インストール検証を行う。

### 本バッチの処理概要

本バッチは、Bazelビルドで生成されたTensorFlowのPython wheelパッケージに対して、品質保証のための複数の検証ステップを実行する。wheelファイルのプラットフォーム互換性修正（auditwheel）、ファイルサイズ制限チェック、仮想環境でのインストール検証およびインポートテストを一括で実施する。

**業務上の目的・背景**：TensorFlowのwheelパッケージは複数のプラットフォーム向けにビルドされるため、正しいプラットフォームタグの付与、適切なファイルサイズの維持、そして実際にインストール・インポートが可能であることの検証が不可欠である。本バッチはこれらの品質検証を自動化し、不正なパッケージがリリースされることを防止する。

**バッチの実行タイミング**：wheelビルドバッチ（No.1 wheel.sh）の後続処理として実行される。CI/CDパイプラインのビルドフェーズ完了後に呼び出される。

**主要な処理内容**：
1. 出力ディレクトリに複数wheelが存在する場合、最新以外を `extra_wheels` に移動
2. auditwheel修復によるプラットフォームタグの修正・共有ライブラリの同梱
3. wheelファイルサイズの上限チェック
4. 一時的なPython仮想環境でのwheelインストール検証
5. TensorFlowのインポートテスト（基本演算とKeras確認）
6. NumPy 1.x互換性テスト（条件付き）

**前後の処理との関連**：No.1（wheel.sh）でビルドされたwheelファイルを入力として受け取る。検証済みのwheelはNo.5（upload.sh）でアップロードされる。

**影響範囲**：ビルドされたwheelファイルの名前変更・修復、検証結果に基づくCI/CDパイプラインの成否判定に影響する。

## バッチ種別

品質検証 / パッケージ検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（wheelビルド後） |
| 実行時刻 | CIジョブのトリガーに依存 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | wheelビルドスクリプトからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| TFCI_OUTPUT_DIR | wheelファイルが格納された出力ディレクトリが設定されていること |
| wheelファイルの存在 | TFCI_OUTPUT_DIR内に1つ以上の .whl ファイルが存在すること |
| Pythonの存在 | 指定バージョンのPythonがインストールされていること |
| auditwheel（条件付き） | TFCI_WHL_AUDIT_ENABLE=1の場合、audithwheelが利用可能であること |

### 実行可否判定

wheelファイルが出力ディレクトリに存在すれば実行される。各検証ステップはTFCI_変数で個別に有効化/無効化が可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| TFCI_OUTPUT_DIR | string | Yes | 環境依存 | wheelファイルが格納されたディレクトリ |
| TFCI_WHL_AUDIT_ENABLE | string | Yes | 環境依存 | auditwheel修復の有無（"1"で有効） |
| TFCI_WHL_AUDIT_PLAT | string | No | 環境依存 | audithwheelのプラットフォーム指定 |
| TFCI_WHL_SIZE_LIMIT_ENABLE | string | Yes | 環境依存 | サイズチェックの有無（"1"で有効） |
| TFCI_WHL_SIZE_LIMIT | string | No | 環境依存 | サイズ上限（findコマンド形式: 例 "220M"） |
| TFCI_FIND_BIN | string | No | 環境依存 | findコマンドのパス |
| TFCI_PYTHON_VERSION | string | Yes | 環境依存 | Pythonバージョン（例: "3.11"） |
| TFCI_WHL_IMPORT_TEST_ENABLE | string | Yes | 環境依存 | インポートテストの有無（"1"で有効） |
| TFCI_WHL_NUMPY_VERSION | string | No | 環境依存 | NumPyバージョン指定（"1"でNumPy1.x互換テスト有効） |
| TFCI_BAZEL_COMMON_ARGS | string | Yes | 環境依存 | Bazel共通引数（GPU判定に使用） |
| TFCI_PYTHON_VERIFY_PIP_INSTALL_ARGS | string | No | 環境依存 | pip install追加引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| $TFCI_OUTPUT_DIR/*.whl | wheelファイル | ビルド済みのTensorFlow wheelパッケージ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $TFCI_OUTPUT_DIR/*.whl | wheelファイル | auditwheel修復後のwheelファイル（元のファイルは削除） |
| $TFCI_OUTPUT_DIR/extra_wheels/ | wheelファイル | 余分なwheelファイルの退避先 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | auditwheel修復後のwheelファイル名（プラットフォームタグ付き） |
| 出力先 | $TFCI_OUTPUT_DIR/ |
| 文字コード | バイナリ |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 出力ディレクトリへ移動
   └─ cd $TFCI_OUTPUT_DIR
2. 余分なwheelの退避
   └─ 複数wheelがある場合、最新以外をextra_wheelsに移動
3. auditwheel修復（条件付き）
   └─ TFCI_WHL_AUDIT_ENABLE=1の場合
   └─ 修復後、古いwheelを削除
4. サイズチェック（条件付き）
   └─ TFCI_WHL_SIZE_LIMIT_ENABLE=1の場合
   └─ 上限超過時はexit 2で終了
5. 仮想環境作成
   └─ mktemp -dで一時ディレクトリ作成
   └─ 指定バージョンのPythonでvenv作成
6. NumPy 1.xインストール（条件付き）
   └─ TFCI_WHL_NUMPY_VERSION=1の場合
7. wheelインストール
   └─ GPU環境ではtensorflow[and-cuda]、それ以外は通常インストール
8. インポートテスト（条件付き）
   └─ TFCI_WHL_IMPORT_TEST_ENABLE=1の場合
   └─ tf.constant演算テストとKeras存在確認
9. NumPy 1.x互換性テスト（条件付き）
   └─ tf-nightly-cpuをNumPy1.x環境にインストールしてテスト
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{複数wheel?}
    B -->|Yes| C[最新以外をextra_wheelsに移動]
    B -->|No| D{auditwheel有効?}
    C --> D
    D -->|Yes| E[auditwheel repair実行]
    D -->|No| F{サイズチェック有効?}
    E --> E2[古いwheel削除]
    E2 --> F
    F -->|Yes| G{サイズ超過?}
    F -->|No| H[venv作成]
    G -->|Yes| G2[exit 2]
    G -->|No| H
    H --> I{NumPy1.x?}
    I -->|Yes| J[NumPy 1.xインストール]
    I -->|No| K{GPU環境?}
    J --> K
    K -->|Yes| L[pip install wheel with and-cuda]
    K -->|No| M[pip install wheel]
    L --> N{インポートテスト有効?}
    M --> N
    N -->|Yes| O[TensorFlowインポート・演算テスト]
    N -->|No| P[バッチ終了]
    O --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード2 | サイズ超過エラー | wheelファイルがTFCI_WHL_SIZE_LIMITを超過 | ビルド構成を見直してサイズを削減 |
| 終了コード1 | auditwheel修復失敗 | 共有ライブラリの依存解決失敗 | ビルド環境の依存関係を確認 |
| 終了コード1 | インストール失敗 | pip installでの依存関係エラー | wheelファイルとPython環境の互換性を確認 |
| 終了コード1 | インポートテスト失敗 | TensorFlowのインポートまたはKeras確認の失敗 | ビルドされたwheelの整合性を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

サイズ超過の場合は終了コード2で即時終了する。それ以外のエラーは `set -exo pipefail` により即時終了し、呼び出し元のCIジョブが失敗となる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル（wheelファイル1つ） |
| 目標処理時間 | 数分（auditwheel修復とインストール検証を含む） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

本バッチ内で排他制御は行わない。ただし、TFCI_OUTPUT_DIR内に1つのwheelファイルのみが存在することを前提としており、複数wheelがある場合は自動的に最新以外を退避する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各コマンド実行時 | `set -x` によるコマンドトレース |
| エラーログ | サイズ超過時 | サイズ上限と実際のサイズの表示 |
| テストログ | インポートテスト時 | TensorFlowの演算結果とKeras確認結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| wheelサイズ | TFCI_WHL_SIZE_LIMIT | CIジョブログ（exit 2） |
| インポートテスト | 失敗時 | CIジョブログ |

## 備考

- auditwheel修復は同名ファイルが生成される場合はリネームされない仕様のため、修正時刻ベースで新旧を判定し古い方を削除する。
- NumPy 1.x互換性テスト（TFCI_WHL_NUMPY_VERSION=1）は2025年までのNumPy 1.x互換性維持のために実装されている（b/361369076）。
- GPU環境の判定は `TFCI_BAZEL_COMMON_ARGS` に "gpu" または "cuda" が含まれるかで行う。
- ソースファイルパス: `ci/official/utilities/rename_and_verify_wheels.sh`
