# バッチ設計書 14-repack_libtensorflow.sh

## 概要

本ドキュメントは、TensorFlow CI/CDパイプラインにおけるlibtensorflowのビルド成果物を再パッケージするバッチ `repack_libtensorflow.sh` の設計仕様を記述する。本バッチはBazelビルドで生成されたlibtensorflowの成果物をtarball（Linux/macOS）またはzip（Windows）形式にリパックする。

### 本バッチの処理概要

本バッチは、BazelでビルドされたlibtensorflowのC言語バインディングライブラリを配布可能なアーカイブ形式（tarball/zip）に再パッケージする。プラットフォームに応じてパッケージ形式と同梱ファイルが異なる。

**業務上の目的・背景**：TensorFlowはPythonだけでなくC言語向けのバインディング（libtensorflow）も提供している。Bazelのビルド成果物はそのままでは配布に適さないため、ヘッダファイル、共有ライブラリ、ライセンスファイルなどを適切な構成で再パッケージする必要がある。本バッチはこの配布パッケージの生成を自動化する。

**バッチの実行タイミング**：libtensorflowビルドバッチ（No.3 libtensorflow.sh）からの呼び出しで実行される。

**主要な処理内容**：
1. 出力ディレクトリの作成
2. Linux/macOS環境：Bazelビルド出力のtarballとproto zipをコピー
3. Windows環境：DLL、LIBファイル、Cヘッダファイル群、ライセンスファイルを収集してzipに同梱

**前後の処理との関連**：No.3（libtensorflow.sh）のビルド完了後に呼び出される。生成されたアーカイブはNo.5（upload.sh）でGCSにアップロードされる。

**影響範囲**：libtensorflowの配布パッケージの内容と形式に影響する。

## バッチ種別

パッケージング / アーカイブ生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（libtensorflowビルド後） |
| 実行時刻 | CIジョブのトリガーに依存 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | libtensorflow.shからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bazelビルド完了 | `bazel-bin/tensorflow/tools/lib_package/` 配下にビルド成果物が存在すること |
| 引数の指定 | 第1引数に出力ディレクトリ、第2引数にtarballサフィックスが指定されていること |

### 実行可否判定

呼び出し元スクリプト（libtensorflow.sh）からの引数が正しく渡されれば実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 (DIR) | string | Yes | なし | 出力先ディレクトリパス |
| $2 (TARBALL_SUFFIX) | string | Yes | なし | tarball/zipファイル名のサフィックス（例: "-cpu-linux-x86_64"） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| bazel-bin/tensorflow/tools/lib_package/libtensorflow.tar.gz | tarball | Linux/macOS用ビルド済みlibtensorflow |
| bazel-bin/tensorflow/tools/lib_package/libtensorflow_proto.zip | zip | Protocol Buffersのproto定義 |
| bazel-bin/tensorflow/tensorflow.dll | DLL | Windows用共有ライブラリ |
| bazel-bin/tensorflow/tensorflow.lib | LIB | Windows用インポートライブラリ |
| tensorflow/c/*.h | ヘッダ | C APIヘッダファイル群 |
| tensorflow/c/eager/*.h | ヘッダ | Eager APIヘッダファイル群 |
| tensorflow/core/platform/*.h | ヘッダ | プラットフォームヘッダファイル |
| third_party/xla/xla/tsl/c/*.h | ヘッダ | TSL Cヘッダファイル |
| third_party/xla/third_party/tsl/tsl/platform/*.h | ヘッダ | TSLプラットフォームヘッダファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $DIR/libtensorflow${TARBALL_SUFFIX}.tar.gz | tarball | Linux/macOS用libtensorflowアーカイブ |
| $DIR/libtensorflow_proto.zip | zip | Protocol Buffers proto定義（Linux/macOS） |
| $DIR/libtensorflow-cpu-windows-{arch}.zip | zip | Windows用libtensorflowアーカイブ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | libtensorflow${TARBALL_SUFFIX}.tar.gz（Linux/macOS）またはlibtensorflow-cpu-windows-{arch}.zip（Windows） |
| 出力先 | $DIR（引数で指定） |
| 文字コード | バイナリ |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 出力ディレクトリ作成
   └─ mkdir -p "$DIR"
2. プラットフォーム判定
   └─ uname -s でWindows（MSYS_NT*）かどうかを判定
3a. Linux/macOS の場合
   └─ libtensorflow.tar.gz をサフィックス付きでコピー
   └─ libtensorflow_proto.zip をコピー
3b. Windows の場合
   └─ 一時パッケージディレクトリ（lib_package）を作成
   └─ ディレクトリ構成（include/tensorflow/c, include/tensorflow/c/eager, 等）を作成
   └─ DLL, LIB, ヘッダファイル群をコピー
   └─ zipコマンドで全ファイルをアーカイブ
   └─ 一時ディレクトリを削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[出力ディレクトリ作成]
    B --> C{Windows?}
    C -->|No| D[libtensorflow.tar.gzをコピー]
    D --> E[libtensorflow_proto.zipをコピー]
    E --> F[バッチ終了]
    C -->|Yes| G[一時パッケージディレクトリ作成]
    G --> H[ディレクトリ構造作成]
    H --> I[DLL/LIB/ヘッダファイルコピー]
    I --> J[zipアーカイブ作成]
    J --> K[一時ディレクトリ削除]
    K --> F
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード非0 | ファイルコピー失敗 | ビルド成果物が存在しない | Bazelビルドが正常完了したか確認 |
| 終了コード非0 | zipコマンド失敗 | 入力ファイルの欠落 | ヘッダファイルやDLLの存在を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

Bazelビルド成果物が存在しない場合、cpコマンドが失敗しスクリプトが終了する。ビルドフェーズの成功を確認してから再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回（ビルド後に1回実行） |
| 目標処理時間 | 数秒（ファイルコピーとアーカイブ作成） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

本バッチ内で排他制御は行わない。出力ディレクトリは引数で指定されるため、同一ディレクトリへの同時書き込みは呼び出し元が制御する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各コマンド実行時 | 呼び出し元のset -xによるコマンドトレース |
| エラーログ | エラー発生時 | cp/zipコマンドのエラー出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| アーカイブ生成成否 | 終了コード非0 | CIジョブログ |

## 備考

- Linux/macOS環境では、Bazelのlib_packageルールが生成するtarballをそのままコピーする簡素な処理となっている。
- Windows環境では手動でディレクトリ構成を構築し、必要なヘッダファイル群を個別にコピーする必要がある。含まれるヘッダファイルはC API、Eager API、TSL関連のヘッダである。
- Windows用zipファイル名は `libtensorflow-cpu-windows-{uname -m}.zip` 形式で、アーキテクチャ情報が含まれる。
- ソースファイルパス: `ci/official/utilities/repack_libtensorflow.sh`
