# バッチ設計書 15-cleanup_docker.sh

## 概要

本ドキュメントは、TensorFlow CI/CDパイプラインにおけるDocker環境のクリーンアップ情報を表示するバッチ `cleanup_docker.sh` の設計仕様を記述する。本バッチはCIジョブ終了時にDockerコンテナの削除方法をユーザーに案内し、現在のDockerコンテナ一覧を表示する。

### 本バッチの処理概要

本バッチは、Docker環境で実行されたCIジョブの終了時に、残存するDockerコンテナのクリーンアップ方法をユーザーに提示する情報表示用スクリプトである。コンテナの自動削除は行わず、手動削除コマンドの案内と現在のコンテナ一覧を表示する。

**業務上の目的・背景**：Docker環境でCI/CDジョブを実行した後、`tf` コンテナが残存する場合がある。コンテナが不要に残り続けるとリソースを消費し、次回のCI実行にも影響を与える可能性がある。本バッチは開発者やCIオペレータに対してクリーンアップの方法を明示的に案内する。

**バッチの実行タイミング**：No.11（setup.sh）のEXITトラップ内のcleanup関数から `TFCI_DOCKER_ENABLE=1` の場合に呼び出される。CIジョブの終了時（正常終了・異常終了の両方）に実行される。

**主要な処理内容**：
1. Dockerコンテナの手動削除コマンド（`docker rm -f tf`）の案内メッセージを表示
2. Docker内での追加コマンド実行方法（`docker exec`）の案内を表示
3. `docker ps` で現在のDockerコンテナ一覧を表示

**前後の処理との関連**：No.11（setup.sh）のcleanup関数から呼び出される。No.12（setup_docker.sh）で起動されたコンテナに関する情報を表示する。

**影響範囲**：標準出力への情報表示のみ。システム状態の変更は行わない。

## バッチ種別

情報表示 / クリーンアップガイダンス

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIジョブ終了時、Docker有効時） |
| 実行時刻 | CIジョブの終了タイミングに依存 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | setup.shのEXITトラップ（cleanup関数）からの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Docker実行環境 | `docker` コマンドが利用可能であること |
| TFCI_DOCKER_ENABLE=1 | Docker環境が有効化されていること |

### 実行可否判定

setup.shのcleanup関数内で `TFCI_DOCKER_ENABLE=1` の場合にのみ呼び出される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Docker環境 | コンテナ情報 | docker ps で取得するコンテナ一覧 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | クリーンアップ案内メッセージとコンテナ一覧 |

### 出力ファイル仕様

本バッチはファイル出力を行わない。標準出力のみ。

## 処理フロー

### 処理シーケンス

```
1. ヒアドキュメントによる案内メッセージ表示
   └─ docker rm -f tf コマンドの案内
   └─ docker exec tf コマンドの使用例
2. docker ps でコンテナ一覧を表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[クリーンアップ案内メッセージ表示]
    B --> C[docker ps 実行]
    C --> D[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード非0 | docker psコマンド失敗 | Docker daemonが停止している | Docker daemonの状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

情報表示のみのスクリプトであるため、失敗しても後続処理（cleanup_summary.sh）に大きな影響はない。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回（CIジョブ終了時に1回実行） |
| 目標処理時間 | 1秒未満 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

本バッチ内で排他制御は行わない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 案内ログ | バッチ実行時 | Dockerコンテナ削除方法のガイダンス |
| 情報ログ | docker ps実行時 | 現在のDockerコンテナ一覧 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- 本バッチはDockerコンテナの自動削除を行わない設計である。これはデバッグ目的でコンテナを残しておきたい場合を考慮したものである。
- setup_docker.shでコンテナが `--rm` フラグ付きで起動されている場合、コンテナ停止時に自動削除される。本バッチの案内は手動でのコンテナ管理が必要な場合のガイダンスとなる。
- ソースファイルパス: `ci/official/utilities/cleanup_docker.sh`
