# バッチ設計書 16-cleanup_summary.sh

## 概要

本ドキュメントは、TensorFlow CI/CDパイプラインにおけるBazel ResultStoreリンクの抽出・表示を行うビルド後サマリーバッチ `cleanup_summary.sh` の設計仕様を記述する。

### 本バッチの処理概要

本バッチは、CIジョブ終了時にBazelビルド・テスト結果のResultStoreリンクをスクリプトログから抽出し、ユーザーが結果を容易に確認できるように表示する。PythonスクリプトによるXML出力とフォールバック用のawk抽出の2段階の抽出ロジックを備える。

**業務上の目的・背景**：TensorFlowのCI/CDパイプラインではBazelのRBE（Remote Build Execution）を使用しており、ビルド・テスト結果はResultStoreに保存される。CIジョブのログは非常に長大になるため、ResultStoreのリンクを自動的に抽出して表示することで、開発者がビルド失敗の原因を迅速に特定できるようにする。

**バッチの実行タイミング**：No.11（setup.sh）のEXITトラップ内のcleanup関数から常に呼び出される。CIジョブの終了時（正常終了・異常終了の両方）に実行される。

**主要な処理内容**：
1. スクリプトログに"Streaming build results to"が含まれるか確認
2. Pythonスクリプト（extract_resultstore_links.py）でResultStoreリンクを抽出・表示・XML出力
3. Python抽出が失敗した場合、awkベースのフォールバック抽出を実行

**前後の処理との関連**：No.11（setup.sh）のcleanup関数から呼び出される。No.15（cleanup_docker.sh）の後に実行される。

**影響範囲**：標準出力への情報表示とXMLファイル（sponge_log.xml）の生成に影響する。

## バッチ種別

情報抽出・表示 / ビルドサマリー

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIジョブ終了時） |
| 実行時刻 | CIジョブの終了タイミングに依存 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | setup.shのEXITトラップ（cleanup関数）からの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| TFCI_OUTPUT_DIR | 出力ディレクトリが設定されていること |
| script.log | $TFCI_OUTPUT_DIR/script.log が存在すること |
| TFCI_GIT_DIR | TensorFlowリポジトリルートが設定されていること |

### 実行可否判定

script.logに"Streaming build results to"が含まれる場合にのみResultStore抽出処理が実行される。含まれない場合は何も出力せずに終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| TFCI_OUTPUT_DIR | string | Yes | 環境依存 | script.logとXML出力先のディレクトリ |
| TFCI_GIT_DIR | string | Yes | 環境依存 | Pythonスクリプトの配置先ルート |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| $TFCI_OUTPUT_DIR/script.log | テキストログ | CIジョブの実行ログ（ResultStoreリンクを含む） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | ResultStoreリンクの一覧 |
| $TFCI_OUTPUT_DIR/Bazel_Test_and_Build_Results/sponge_log.xml | XML | ResultStore結果のXML表現 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | sponge_log.xml |
| 出力先 | $TFCI_OUTPUT_DIR/Bazel_Test_and_Build_Results/ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし（XML形式） |

## 処理フロー

### 処理シーケンス

```
1. ResultStoreリンク存在チェック
   └─ grep -q "Streaming build results to" script.log
2. メイン抽出処理（resultstore_extract関数）
   └─ python3（またはpython）の検出
   └─ extract_resultstore_links.py の実行
   └─ --print オプションで標準出力、--xml-out-path でXMLファイル出力
3. フォールバック抽出処理（resultstore_extract_fallback関数）
   └─ メイン処理失敗時に実行
   └─ awkでscript.logから"Streaming build results to"行を抽出
   └─ 重複除去（uniq）してURLを表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{script.logにResultStoreリンクあり?}
    B -->|No| C[何も出力せず終了]
    B -->|Yes| D[resultstore_extract実行]
    D --> E{Python抽出成功?}
    E -->|Yes| F[バッチ終了]
    E -->|No| G[resultstore_extract_fallback実行]
    G --> H[awkでURL抽出・表示]
    H --> F
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード非0 | Python抽出失敗 | python3/pythonが未インストールまたはスクリプトエラー | フォールバック（awk）に自動的に切り替わる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（フォールバック機構で代替） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

メインのPython抽出処理が失敗した場合、自動的にawkベースのフォールバック処理に切り替わる。フォールバックも失敗した場合はCIジョブ自体の失敗にはならない（EXITトラップ内の処理であるため）。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回（CIジョブ終了時に1回実行） |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

本バッチ内で排他制御は行わない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各コマンド実行時 | `set -x` によるコマンドトレース |
| 情報ログ | ResultStore抽出時 | ResultStoreのURL一覧 |
| フォールバックログ | Python抽出失敗時 | フォールバック処理の案内メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- Python抽出スクリプト（extract_resultstore_links.py）は `ci/official/utilities/` 配下に配置されている。
- フォールバック処理のawkコマンドは "Streaming build results to" 行の最後のフィールド（URL）を抽出し、uniqで重複を除去する。
- XML出力先のディレクトリ名 "Bazel_Test_and_Build_Results" はKokoro CI の Sponge 連携に使用される命名規則に従っている。
- ソースファイルパス: `ci/official/utilities/cleanup_summary.sh`
