# バッチ設計書 17-generate_index_html.sh

## 概要

本ドキュメントは、TensorFlow CI/CDパイプラインにおけるKokoroビルドジョブの概要HTMLページを生成するバッチ `generate_index_html.sh` の設計仕様を記述する。

### 本バッチの処理概要

本バッチは、Kokoro CIで実行されるビルドジョブの概要情報をHTML形式で生成する。ジョブ名、プルリクエスト番号、コミットハッシュ、各種内部リンク（Sponge、Test Fusion、Codesearch、ResultStore）を一覧化したHTMLページを出力する。

**業務上の目的・背景**：TensorFlowのCI/CDはKokoro CIシステム上で動作しており、ビルドジョブの詳細情報は複数のツール（Sponge、Test Fusion、Codesearch等）に分散している。本バッチはこれらの情報へのリンクを一つのHTMLページに集約し、開発者やCIオペレータがジョブ情報に迅速にアクセスできるようにする。

**バッチの実行タイミング**：No.11（setup.sh）から `TFCI_INDEX_HTML_ENABLE=1` の場合に呼び出される。CIジョブの初期化フェーズで実行される。

**主要な処理内容**：
1. Kokoro環境変数からジョブ情報を取得
2. ジョブ詳細（ジョブ名、プール、ID、PR番号、コミット）をHTML化
3. Google社員向けリンク（Sponge2、Test Fusion、Codesearch）を生成
4. 外部公開向けリンク（ResultStore）を生成
5. 指定パスにHTMLファイルを出力

**前後の処理との関連**：No.11（setup.sh）から呼び出される。生成されたHTMLは出力ディレクトリに配置され、ビルド成果物として閲覧可能となる。

**影響範囲**：出力ディレクトリのindex.htmlファイルの生成に影響する。

## バッチ種別

レポート生成 / HTML生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIジョブ実行時、INDEX_HTML有効時） |
| 実行時刻 | CIジョブのトリガーに依存 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | setup.shからの呼び出し（TFCI_INDEX_HTML_ENABLE=1の場合） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Kokoro環境変数 | KOKORO_JOB_NAME, KOKORO_JOB_POOL, KOKORO_BUILD_ID等のKokoro CI環境変数が設定されていること |
| 出力パス引数 | 第1引数にHTMLファイルの出力パスが指定されていること |

### 実行可否判定

setup.shの中で `TFCI_INDEX_HTML_ENABLE=1` の場合にのみ実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 | string | Yes | なし | HTMLファイルの出力パス |
| KOKORO_JOB_NAME | string | Yes | 環境依存 | Kokoroジョブ名 |
| KOKORO_JOB_POOL | string | Yes | 環境依存 | Kokoroジョブプール |
| KOKORO_BUILD_ID | string | Yes | 環境依存 | KokoroビルドID |
| KOKORO_PIPER_CHANGELIST | string | No | 環境依存 | Piperチェンジリスト番号 |
| KOKORO_GITHUB_PULL_REQUEST_NUMBER_tensorflow | string | No | 環境依存 | GitHubプルリクエスト番号 |
| KOKORO_GITHUB_PULL_REQUEST_URL_tensorflow | string | No | 環境依存 | GitHubプルリクエストURL |
| KOKORO_GIT_COMMIT_tensorflow | string | Yes | 環境依存 | Gitコミットハッシュ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Kokoro環境変数 | 変数 | Kokoro CIシステムが自動設定する環境変数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $1（引数指定パス） | HTML | ビルドジョブ概要ページ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | index.html（通常は$TFCI_OUTPUT_DIR/index.html） |
| 出力先 | 第1引数で指定されたパス |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし（HTML形式） |

## 処理フロー

### 処理シーケンス

```
1. HTMLファイルの生成
   └─ cat > "$1" <<EOF でヒアドキュメントを使用
   └─ <head>セクション: ジョブ名をタイトルに設定
   └─ <h1>: "TensorFlow Job Logs and Links"
   └─ <h2>Job Details: ジョブ名、プール、ID、PR情報、コミット
   └─ <h2>Googlers-Only Links: Sponge2、Sponge、Test Fusion、Codesearch
   └─ <h2>Non-Googler Links: ResultStore
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Kokoro環境変数を参照]
    B --> C[HTMLヒアドキュメント生成]
    C --> D[Job Details セクション]
    D --> E[Googlers-Only Links セクション]
    E --> F[Non-Googler Links セクション]
    F --> G[ファイル出力]
    G --> H[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード非0 | ファイル書き込み失敗 | 出力先ディレクトリが存在しない | 出力先ディレクトリの存在を確認 |
| 未定義変数エラー | 環境変数未設定 | Kokoro環境変数が未設定 | Kokoro CI環境内で実行していることを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

HTML生成の失敗はCIジョブ全体の成否に影響しないが、ジョブ情報へのアクセスが不便になる。Kokoro環境変数の設定を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回（CIジョブ開始時に1回実行） |
| 目標処理時間 | 1秒未満 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

本バッチ内で排他制御は行わない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各コマンド実行時 | 呼び出し元のset -xによるコマンドトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- HTMLに含まれるリンクのうち、Googlers-Only Links（Sponge2、Sponge、Test Fusion、Codesearch）はGoogle社内ネットワークからのみアクセス可能である。
- Non-Googler Linksの ResultStore リンクは `source.cloud.google.com/results/invocations/{BUILD_ID}` 形式で一般公開されている。
- ジョブ名にスラッシュが含まれる場合、Test Fusionリンクでは `%2F` にエスケープされる。
- ソースファイルパス: `ci/official/utilities/generate_index_html.sh`
