# バッチ設計書 18-run_models.sh

## 概要

本ドキュメントは、TensorFlowのoneDNNベンチマークにおいて複数のMLモデルを実行するバッチ `run_models.sh` の設計仕様を記述する。本バッチはResNet50、Inception、MobileNet、SSD、BERT等の代表的なMLモデルに対し、oneDNN有効/無効の両条件でベンチマークを実行する。

### 本バッチの処理概要

本バッチは、TensorFlowのBazelベンチマークツール（benchmark_model）を使用して、複数の事前学習済みモデルに対するベンチマーク実行を一括で行う。oneDNN最適化の有効/無効それぞれの条件で、複数のバッチサイズ（1, 16, 64）でベンチマークを実行し、パフォーマンス比較データを生成する。

**業務上の目的・背景**：TensorFlowはIntel oneDNN（旧MKL-DNN）による最適化をサポートしている。oneDNN最適化の効果を定量的に評価するため、MLPerf Inferenceで使用される代表的なモデルに対してベンチマークを実行し、パフォーマンス比較データを収集する。これにより、oneDNN最適化の効果測定やリグレッション検出が可能となる。

**バッチの実行タイミング**：手動実行またはベンチマークパイプラインからの呼び出しで実行される。No.20（download_models.sh）でモデルをダウンロード後に実行する。

**主要な処理内容**：
1. oneDNNベンチマーク設定ファイル（onednn_benchmark_config.sh）の読み込み
2. ワークスペースルートへの移動とBazelビルド設定
3. oneDNN無効（ONEDNN=0）とoneDNN有効（ONEDNN=1）の2条件でループ
4. バッチサイズ1, 16, 64の3条件でネストループ
5. 各条件で6つのモデル（ResNet50, Inception, MobileNet, SSD-MobileNet, SSD-ResNet34, BERT）を順次実行
6. BERTはバッチサイズ1のみで実行

**前後の処理との関連**：No.20（download_models.sh）でダウンロードされたモデルファイルを使用する。出力ログはNo.19（run_onednn_benchmarks.sh）で解析・CSV化される。

**影響範囲**：ベンチマーク結果のログ出力、CPUリソースの大量消費に影響する。

## バッチ種別

ベンチマーク実行 / パフォーマンステスト

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行またはベンチマークパイプライン） |
| 実行時刻 | 手動指定 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 / run_onednn_benchmarks.shからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| モデルファイルのダウンロード | download_models.shで~/tf-graphsにモデルファイルがダウンロード済みであること |
| Bazelインストール | Bazelビルドツールが利用可能であること |
| カレントディレクトリ | tensorflow/tools/benchmark/ ディレクトリから実行する必要がある |
| onednn_benchmark_config.sh | 同一ディレクトリにベンチマーク設定ファイルが存在すること |

### 実行可否判定

モデルファイル（~/tf-graphs/配下の.pbファイル群）が存在し、Bazelが利用可能であれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| TF_GRAPHS | string | Yes | ~/tf-graphs | モデルファイルの格納ディレクトリ（onednn_benchmark_config.shで定義） |
| BUILDER | string | Yes | bazel | ビルドツール名（onednn_benchmark_config.shで定義） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ~/tf-graphs/resnet50_v1-5.pb | Protocol Buffers | ResNet50 v1.5モデル |
| ~/tf-graphs/inception.pb | Protocol Buffers | Inceptionモデル |
| ~/tf-graphs/mobilenet-v1.pb | Protocol Buffers | MobileNet v1モデル |
| ~/tf-graphs/ssd-mobilenet-v1.pb | Protocol Buffers | SSD-MobileNet v1モデル |
| ~/tf-graphs/ssd-resnet34.pb | Protocol Buffers | SSD-ResNet34モデル |
| ~/tf-graphs/bert-large.pb | Protocol Buffers | BERT Largeモデル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力/標準エラー | テキスト | ベンチマーク実行結果（推論時間等） |

### 出力ファイル仕様

本バッチ自体はファイル出力を行わない。標準出力をリダイレクトして使用する（run_onednn_benchmarks.sh側で制御）。

## 処理フロー

### 処理シーケンス

```
1. onednn_benchmark_config.sh の読み込み
   └─ TF_GRAPHS, BUILDER, configure_build, benchmark_command の定義
2. Bazelビルド設定
   └─ configure_build() でワークスペースルートに移動し ./configure を実行
3. oneDNNループ（ONEDNN=0, 1）
   └─ 各条件でTF_ENABLE_ONEDNN_OPTS環境変数を設定
   └─ benchmark_command() でBazel実行コマンドを構成
4. バッチサイズループ（BATCH=1, 16, 64）
   └─ "BATCH={size}, ONEDNN={flag}" を出力（パース用）
5. モデル実行
   └─ ResNet50: input_tensor:0, 224x224x3, float
   └─ Inception: input:0, 224x224x3, float
   └─ MobileNet: input:0, 224x224x3, float
   └─ SSD-MobileNet: image_tensor:0, 300x300x3, uint8
   └─ SSD-ResNet34: image:0, 3x1200x1200, float
   └─ BERT: BATCH=1のみ、input_ids/input_mask/segment_ids, 1x384, int32
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[config読込・ビルド設定]
    B --> C[ONEDNN=0]
    C --> D[BATCH=1,16,64 ループ]
    D --> E[ResNet50実行]
    E --> F[Inception実行]
    F --> G[MobileNet実行]
    G --> H[SSD-MobileNet実行]
    H --> I[SSD-ResNet34実行]
    I --> J{BATCH==1?}
    J -->|Yes| K[BERT実行]
    J -->|No| L[次のBATCH]
    K --> L
    L --> M{全BATCH完了?}
    M -->|No| D
    M -->|Yes| N[ONEDNN=1]
    N --> O[BATCH=1,16,64 ループ（同様）]
    O --> P[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード非0 | Bazelビルド失敗 | ビルド設定エラーまたは依存関係不足 | ./configure を再実行し、ビルド環境を確認 |
| 終了コード非0 | モデルファイル不在 | download_models.sh未実行 | download_models.shを先に実行 |
| 終了コード非0 | ベンチマーク実行エラー | メモリ不足やモデル互換性問題 | システムリソースとモデルファイルの整合性を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

`set -x` は有効だが `set -e` は設定されていないため、個別のベンチマーク実行が失敗しても後続のベンチマークは継続される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 合計34回のベンチマーク実行（2条件 x 3バッチサイズ x 5モデル + 2条件 x 1バッチサイズ x 1モデル(BERT)） |
| 目標処理時間 | 数時間（モデルサイズとハードウェアに依存） |
| メモリ使用量上限 | モデル依存（BERT Largeは1.2GB以上のメモリを消費） |

## 排他制御

本バッチ内で排他制御は行わない。ただし、CPUベンチマークの正確性のため、他のCPU集中処理との同時実行は避けることを推奨する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各コマンド実行時 | `set -x` によるコマンドトレース |
| ベンチマーク結果 | 各モデル実行後 | 推論時間、スループット等の統計情報 |
| タイムスタンプ | 各モデル実行前後 | `date` コマンドによるタイムスタンプ |
| パース情報 | バッチサイズ切替時 | "BATCH={size}, ONEDNN={flag}" 形式の情報行 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- 本スクリプトは `tensorflow/tools/benchmark/` ディレクトリから実行する必要がある（`configure_build()` が `cd ../../..` でワークスペースルートに移動するため）。
- BERTモデルはバッチサイズ1のみで実行される。コード内コメントに "Only run BERT with batch size 1 for now." とある。
- 各モデルの入力テンソル名、入力形状、入力型、出力テンソル名はモデルごとに異なる。
- `benchmark_command()` は `--config=opt --dynamic_mode=off //tensorflow/tools/benchmark:benchmark_model --` を返す。
- ソースファイルパス: `tensorflow/tools/benchmark/run_models.sh`
