# バッチ設計書 19-run_onednn_benchmarks.sh

## 概要

本ドキュメントは、TensorFlowのoneDNNベンチマーク実行・ログ解析・結果CSV出力を一括で行うバッチ `run_onednn_benchmarks.sh` の設計仕様を記述する。

### 本バッチの処理概要

本バッチは、oneDNNベンチマークの完全な実行パイプラインを提供する。No.18（run_models.sh）を呼び出してベンチマークを実行し、その出力ログをフィルタリング・解析して、最終的にCSV形式の結果サマリーを生成する。

**業務上の目的・背景**：oneDNNベンチマークの実行からは大量のログが出力されるが、パフォーマンス比較に必要な情報はその一部に限られる。本バッチはベンチマーク実行から結果のCSV出力までを一括で自動化し、oneDNN最適化の効果分析を効率化する。

**バッチの実行タイミング**：手動実行によりベンチマーク全体を一括で実行する際に使用される。

**主要な処理内容**：
1. 出力ディレクトリ（~/onednn_benchmarks）の作成
2. run_models.shの実行とログのtee出力（verbose.log）
3. profiler_sessionとxplane関連のログ行をフィルタリング（run.log）
4. ベンチマークコマンドと結果行の抽出（to_parse.log）
5. Pythonスクリプト（parse_onednn_benchmarks.py）による結果解析・CSV出力

**前後の処理との関連**：No.18（run_models.sh）を呼び出してベンチマークを実行する。No.20（download_models.sh）で事前にモデルがダウンロードされている必要がある。

**影響範囲**：ベンチマーク結果のログファイルとCSVファイルの生成に影響する。

## バッチ種別

ベンチマーク実行・解析 / パイプライン

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 手動指定 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| モデルファイルのダウンロード | download_models.shで~/tf-graphsにモデルファイルがダウンロード済みであること |
| Bazelインストール | Bazelビルドツールが利用可能であること |
| Python3 | python3とparse_onednn_benchmarks.pyが利用可能であること |
| カレントディレクトリ | tensorflow/tools/benchmark/ ディレクトリから実行する必要がある |

### 実行可否判定

run_models.shの前提条件が満たされ、python3が利用可能であれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 引数なし（設定はonednn_benchmark_config.shから読み込み） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| onednn_benchmark_config.sh | シェルスクリプト | ベンチマーク設定（TF_GRAPHS, BUILDER等） |
| ~/tf-graphs/*.pb | Protocol Buffers | ベンチマーク対象のMLモデルファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ~/onednn_benchmarks/verbose.log | テキストログ | ベンチマーク実行の全ログ |
| ~/onednn_benchmarks/run.log | テキストログ | profiler_session/xplane行を除外したログ |
| ~/onednn_benchmarks/to_parse.log | テキストログ | パース対象の抽出済みログ |
| ~/onednn_benchmarks/results.csv | CSV | ベンチマーク結果のサマリー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | results.csv |
| 出力先 | ~/onednn_benchmarks/ |
| 文字コード | UTF-8 |
| 区切り文字 | カンマ |

## 処理フロー

### 処理シーケンス

```
1. ベンチマーク設定読込
   └─ source onednn_benchmark_config.sh
2. 出力ディレクトリ作成
   └─ mkdir -p ~/onednn_benchmarks
3. ベンチマーク実行
   └─ bash run_models.sh 2>&1 | tee verbose.log
4. ログフィルタリング
   └─ grep -v 'profiler_session\|xplane' verbose.log > run.log
5. パース対象行の抽出
   └─ grep "+ ${BUILDER} run\|no stats:\|'BATCH=" run.log > to_parse.log
6. 結果解析・CSV出力
   └─ python3 parse_onednn_benchmarks.py to_parse.log | tee results.csv
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定読込・出力DIR作成]
    B --> C[run_models.sh実行]
    C --> D[verbose.logに全ログ出力]
    D --> E[profiler/xplane行を除外→run.log]
    E --> F[ベンチマークコマンド・結果行を抽出→to_parse.log]
    F --> G[parse_onednn_benchmarks.pyで解析]
    G --> H[results.csvに出力]
    H --> I[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード非0 | run_models.sh実行失敗 | Bazelビルドエラーまたはモデルファイル不在 | 前提条件を確認しrun_models.shを個別に実行してデバッグ |
| 終了コード非0 | parse_onednn_benchmarks.py失敗 | ログ形式の不整合またはPython依存関係不足 | to_parse.logの内容を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

ベンチマーク実行は長時間かかるため、途中の中間ログ（verbose.log）は保持される。部分的な結果からの解析も可能。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 34回のベンチマーク実行（run_models.sh内） |
| 目標処理時間 | 数時間（モデルサイズとハードウェアに依存） |
| メモリ使用量上限 | モデル依存（最大モデルBERT Largeで1.2GB以上） |

## 排他制御

本バッチ内で排他制御は行わない。CPUベンチマークの正確性のため、他のCPU集中処理との同時実行は避けることを推奨する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 全ログ | ベンチマーク実行中 | verbose.log（標準出力+標準エラー） |
| フィルタ済みログ | ログフィルタリング後 | run.log（profiler/xplane除外） |
| パース対象ログ | 抽出後 | to_parse.log（ベンチマークコマンドと結果） |
| 結果サマリー | 解析後 | results.csv（CSV形式のサマリー） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- ログフィルタリングで `profiler_session` と `xplane` を含む行を除外しているのは、これらのTensorFlowプロファイラ関連のログがベンチマーク結果の解析を妨げるためである。
- パース対象の抽出では、Bazel実行コマンド行（`+ ${BUILDER} run`）、統計なし行（`no stats:`）、バッチ情報行（`'BATCH=`）をフィルタリングしている。
- OUTDIR変数は `~/onednn_benchmarks` にハードコードされている。
- ソースファイルパス: `tensorflow/tools/benchmark/run_onednn_benchmarks.sh`
