# バッチ設計書 2-pycpp.sh

## 概要

本ドキュメントは、TensorFlowのCI/CDパイプラインにおけるPython/C++統合テスト・ビルドバッチ `pycpp.sh` の設計仕様を記述する。

### 本バッチの処理概要

本バッチは、TensorFlowのPythonおよびC++コードに対する統合テストまたはビルドをBazelで実行し、パフォーマンスプロファイルを生成・分析する処理を行う。

**業務上の目的・背景**：TensorFlowはPythonフロントエンドとC++バックエンドで構成されるため、両言語の統合テストは品質保証上不可欠である。本バッチはCI/CDパイプラインにおいて、PythonとC++の結合レベルでのテストを自動実行し、パフォーマンスプロファイルによってビルド・テスト効率の可視化を行う。

**バッチの実行タイミング**：CI/CDパイプラインのトリガーに基づき随時実行される。プルリクエストのマージ時やNightlyビルドで定期的に実行される。

**主要な処理内容**：
1. TFCI環境の初期化（setup.sh の読み込み）
2. プロファイル出力パスの設定（Windows/Linux対応）
3. NumPy 1互換ビルドの場合、対応する要件ロックファイルの配置
4. Bazelによるテストまたはビルドの実行（pycpp_test設定、CUDA UMD対応）
5. パフォーマンスプロファイル（profile.json.gz）の生成
6. bazel analyze-profile によるプロファイル分析

**前後の処理との関連**：本バッチの前段として `setup.sh` による環境初期化が行われる。プロファイルデータは後続の分析や最適化検討に使用される。

**影響範囲**：テスト結果のCI/CDフィードバック、`$TFCI_OUTPUT_DIR` 配下のプロファイルファイル生成。

## バッチ種別

テスト実行 / ビルド検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CDトリガーに依存） |
| 実行時刻 | CI/CDパイプラインによる |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CI/CDパイプライン（Kokoro等）からの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| TFCI環境変数の設定 | `$TFCI` 環境変数に適切な env ファイルパスが設定されていること |
| Bazelの利用可能性 | Bazelビルドツールがインストールされ利用可能であること |
| CUDA環境 | hermetic CUDA UMD 設定が利用可能であること |

### 実行可否判定

`setup.sh` による環境初期化が正常に完了し、必要なTFCI環境変数がすべて設定されていること。`TFCI_PYCPP_SWAP_TO_BUILD_ENABLE` の値によりテスト実行かビルド実行かが切り替わる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| TFCI | string | Yes | なし | 環境設定ファイルのカンマ区切りパス |
| TFCI_PYCPP_SWAP_TO_BUILD_ENABLE | string | No | 0 | 1の場合テストの代わりにビルドを実行 |
| TFCI_WHL_NUMPY_VERSION | string | No | なし | NumPyバージョン（1の場合NumPy1互換） |
| TFCI_BAZEL_BAZELRC_ARGS | string | Yes | なし | Bazel設定ファイル引数 |
| TFCI_BAZEL_COMMON_ARGS | string | Yes | なし | Bazel共通引数 |
| TFCI_BAZEL_TARGET_SELECTING_CONFIG_PREFIX | string | Yes | なし | Bazelターゲット選択設定プレフィックス |
| TFCI_OUTPUT_DIR | string | Yes | なし | 出力ディレクトリパス |
| TFCI_OUTPUT_WIN_DOCKER_DIR | string | No | なし | Windows Docker環境での出力パス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| TensorFlowソースコード | ソースファイル | テスト/ビルド対象のPython・C++ソースコード |
| TFCI環境設定ファイル | シェルスクリプト | `ci/official/envs/` 配下の環境変数定義ファイル |
| NumPy1要件ファイル | テキスト | `ci/official/requirements_updater/numpy1_requirements/*.txt` |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $TFCI_OUTPUT_DIR/profile.json.gz | gzip圧縮JSON | Bazelパフォーマンスプロファイル |
| $TFCI_OUTPUT_DIR/script.log | テキスト | スクリプト実行ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | `profile.json.gz` |
| 出力先 | `$TFCI_OUTPUT_DIR` |
| 文字コード | バイナリ（gzip圧縮） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 環境初期化
   └─ setup.sh を source し、TFCI環境変数を設定
2. プロファイルパス設定
   └─ Windows(MSYS_NT)の場合はドライブレター変換、それ以外は $TFCI_OUTPUT_DIR/profile.json.gz
3. NumPy1要件ファイル配置（条件付き）
   └─ TFCI_WHL_NUMPY_VERSION=1 の場合、numpy1用要件ファイルをルートにコピー
4. Bazelテスト/ビルド実行
   └─ TFCI_PYCPP_SWAP_TO_BUILD_ENABLE=1 の場合は build、それ以外は test を実行
   └─ --profile オプションでプロファイル生成、hermetic_cuda_umd 設定を使用
5. プロファイル分析
   └─ bazel analyze-profile でプロファイルを分析し結果を出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[setup.sh による環境初期化]
    B --> C[プロファイル出力パス設定]
    C --> D{NumPy1?}
    D -->|Yes| E[NumPy1要件ファイル配置]
    D -->|No| F{SWAP_TO_BUILD有効?}
    E --> F
    F -->|Yes| G[bazel build 実行]
    F -->|No| H[bazel test 実行]
    G --> I[bazel analyze-profile 実行]
    H --> I
    I --> J[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ終了 | Bazelテスト失敗 | テストケースの失敗 | テストログを確認し、該当テストを修正 |
| 非ゼロ終了 | Bazelビルドエラー | コンパイルエラー等 | ビルドログを確認し、ソースコードを修正 |
| 非ゼロ終了 | プロファイル分析エラー | プロファイルファイルの破損等 | プロファイルファイルの生成を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | スクリプト自体にリトライ機能なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

`set -exo pipefail` により、いずれかのコマンドが失敗した時点でスクリプトが終了する。EXITトラップによりDockerクリーンアップとビルドサマリーが出力される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | pycpp_test設定で定義されたテストターゲット群 |
| 目標処理時間 | ビルド/テスト規模に依存（通常数十分〜数時間） |
| メモリ使用量上限 | Bazelビルドに依存 |

## 排他制御

CI/CDパイプラインの1ジョブとして実行される。同一出力ディレクトリに対する並行実行は想定されていない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | setup.sh 実行時 | TFCI環境変数の一覧 |
| 進捗ログ | 各コマンド実行時 | `set -x` による全コマンドのトレースログ |
| 終了ログ | バッチ終了時 | cleanup_summary.sh によるResultStoreリンク |
| エラーログ | エラー発生時 | Bazelテスト/ビルド失敗の詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ実行結果 | 非ゼロ終了コード | CI/CDシステムの通知機能 |

## 備考

- プロファイル（profile.json.gz）は Chrome ブラウザの `chrome://tracing` で可視化可能
- `--config=hermetic_cuda_umd` により、hermetic CUDA ユーザーモードドライバ設定が使用される
- `--@local_config_cuda//cuda:override_include_cuda_libs=true` により、CUDA ライブラリのインクルードが強制される
