# バッチ設計書 20-download_models.sh

## 概要

本ドキュメントは、TensorFlowのoneDNNベンチマーク用MLモデルをダウンロード・展開するバッチ `download_models.sh` の設計仕様を記述する。

### 本バッチの処理概要

本バッチは、MLPerf Inference v2.0で使用される代表的なMLモデル（ResNet50、Inception、MobileNet、SSD-MobileNet、SSD-ResNet34、BERT Large）をインターネットからダウンロードし、ベンチマーク実行可能な形式（Protocol Buffers .pbファイル）に展開する。

**業務上の目的・背景**：oneDNNベンチマーク（No.18, No.19）の実行には、MLPerfで定義された標準的なモデルファイルが必要である。これらのモデルは外部リポジトリ（Zenodo、GCS、tensorflow.org）で公開されているため、事前にダウンロードしてローカルに配置する必要がある。本バッチはこのモデル取得プロセスを自動化する。

**バッチの実行タイミング**：ベンチマーク実行前に手動で1回実行する。モデルファイルが既にダウンロード済みの場合は `wget -c`（続きからダウンロード）により再ダウンロードをスキップする。

**主要な処理内容**：
1. モデル格納ディレクトリ（~/tf-graphs）の作成
2. 6つのモデルファイルのダウンロード（wget -c）
3. 圧縮ファイル（zip/tgz/tar.gz）の展開とリネーム
4. 展開後の一時ファイル・ディレクトリの削除

**前後の処理との関連**：本バッチの実行後にNo.18（run_models.sh）またはNo.19（run_onednn_benchmarks.sh）を実行する。

**影響範囲**：~/tf-graphsディレクトリへのモデルファイルの配置に影響する。ネットワーク帯域を消費する（特にBERT Largeは1.2GB）。

## バッチ種別

データ取得 / モデルダウンロード

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（初回1回、以降は必要時のみ） |
| 実行時刻 | 手動指定 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ネットワーク接続 | Zenodo、GCS、tensorflow.orgへのHTTP/HTTPS接続が可能であること |
| wget | wgetコマンドが利用可能であること |
| unzip/tar | unzipおよびtarコマンドが利用可能であること |
| ディスク容量 | 約3GB以上の空き容量（BERT Largeだけで1.2GB） |

### 実行可否判定

ネットワーク接続とコマンドラインツール（wget, unzip, tar）が利用可能であれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| TF_GRAPHS | string | Yes | ~/tf-graphs | モデルファイルの格納先（onednn_benchmark_config.shで定義） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| https://zenodo.org/record/2535873/files/resnet50_v1.pb | HTTP | ResNet50 v1.5モデル |
| https://storage.googleapis.com/download.tensorflow.org/models/inception5h.zip | HTTP | Inceptionモデル（zip） |
| https://zenodo.org/record/2269307/files/mobilenet_v1_1.0_224.tgz | HTTP | MobileNet v1モデル（tgz） |
| http://download.tensorflow.org/models/object_detection/ssd_mobilenet_v1_coco_2018_01_28.tar.gz | HTTP | SSD-MobileNet v1モデル（tar.gz） |
| https://zenodo.org/record/3345892/files/tf_ssd_resnet34_22.1.zip | HTTP | SSD-ResNet34モデル（zip） |
| https://zenodo.org/record/3939747/files/model.pb | HTTP | BERT Largeモデル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ~/tf-graphs/resnet50_v1-5.pb | Protocol Buffers | ResNet50 v1.5モデル |
| ~/tf-graphs/inception.pb | Protocol Buffers | Inceptionモデル |
| ~/tf-graphs/mobilenet-v1.pb | Protocol Buffers | MobileNet v1モデル |
| ~/tf-graphs/ssd-mobilenet-v1.pb | Protocol Buffers | SSD-MobileNet v1モデル |
| ~/tf-graphs/ssd-resnet34.pb | Protocol Buffers | SSD-ResNet34モデル |
| ~/tf-graphs/bert-large.pb | Protocol Buffers | BERT Largeモデル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各モデル名.pb |
| 出力先 | ~/tf-graphs/ |
| 文字コード | バイナリ（Protocol Buffers） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. ベンチマーク設定読込
   └─ source onednn_benchmark_config.sh
2. モデル格納ディレクトリ作成
   └─ mkdir -p ~/tf-graphs && cd ~/tf-graphs
3. モデルダウンロード（wget -c）
   └─ ResNet50: resnet50_v1.pb → resnet50_v1-5.pb
   └─ Inception: inception5h.zip
   └─ MobileNet: mobilenet_v1_1.0_224.tgz → mobilenet-v1.tgz
   └─ SSD-MobileNet: ssd_mobilenet_v1_coco_2018_01_28.tar.gz → ssd-mobilenet-v1.tar.gz
   └─ SSD-ResNet34: tf_ssd_resnet34_22.1.zip → ssd-resnet34.zip
   └─ BERT Large: model.pb → bert-large.pb
4. アーカイブ展開・リネーム
   └─ Inception: unzip → inception/ → inception.pb
   └─ MobileNet: tar -xzf → mobilenet_v1_1.0_224_frozen.pb → mobilenet-v1.pb
   └─ SSD-MobileNet: tar -xzf → frozen_inference_graph.pb → ssd-mobilenet-v1.pb
   └─ SSD-ResNet34: unzip → resnet34_tf.22.1.pb → ssd-resnet34.pb
5. 一時ファイル・ディレクトリ削除
   └─ 各展開後の不要なディレクトリを rm -rf
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定読込・ディレクトリ作成]
    B --> C[ResNet50ダウンロード]
    C --> D[Inceptionダウンロード・展開]
    D --> E[MobileNetダウンロード・展開]
    E --> F[SSD-MobileNetダウンロード・展開]
    F --> G[SSD-ResNet34ダウンロード・展開]
    G --> H[BERT Largeダウンロード]
    H --> I[一時ファイル削除]
    I --> J[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード非0 | ダウンロード失敗 | ネットワーク障害またはURLの無効化 | ネットワーク接続を確認し、URLの有効性を確認。wget -cにより部分ダウンロードからの再開が可能 |
| 終了コード非0 | 展開失敗 | ダウンロードファイルの破損 | ファイルを削除して再ダウンロード |
| 終了コード非0 | ディスク容量不足 | 空き容量不足 | ディスク容量を確保してから再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（wget -c による続きからダウンロードで代替） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

`wget -c` オプションにより、ダウンロードが中断しても再実行時に続きからダウンロードされる。破損したファイルの場合は該当ファイルを削除してから再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 6ファイルのダウンロード |
| 目標処理時間 | ネットワーク速度に依存（BERT Largeは1.2GBで10分以上の可能性あり） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

本バッチ内で排他制御は行わない。同一ディレクトリへの同時書き込みは避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ダウンロードログ | wget実行時 | ダウンロード進捗（wgetの標準出力） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- ダウンロードURLはMLPerf Inference v2.0（2022年2月25日提出版）のリファレンスに基づいている（https://github.com/mlcommons/inference#mlperf-inference-v20-submission-02252022）。
- BERT Largeモデルは約1.2GBと大きく、ダウンロードに10分以上かかる可能性がある（コード内コメントに記載）。
- `wget -c` オプションにより、既にダウンロード済みのファイルは再ダウンロードされない（レジューム機能）。
- 最終的に ~/tf-graphs/ に配置されるモデルファイルは以下の6つ: bert-large.pb, inception.pb, mobilenet-v1.pb, resnet50_v1-5.pb, ssd-mobilenet-v1.pb, ssd-resnet34.pb
- ソースファイルパス: `tensorflow/tools/benchmark/download_models.sh`
