# バッチ設計書 3-libtensorflow.sh

## 概要

本ドキュメントは、TensorFlowのCI/CDパイプラインにおけるlibtensorflow（C言語バインディング）のテスト・ビルド・パッケージングバッチ `libtensorflow.sh` の設計仕様を記述する。

### 本バッチの処理概要

本バッチは、libtensorflow（TensorFlowのC言語API）のテストとビルドを実行し、ビルド成果物をtarball（Linux）またはzip（Windows）にリパックしてGCSへアップロードする処理を行う。

**業務上の目的・背景**：TensorFlowはC言語バインディング（libtensorflow）を提供しており、Go・Java・Rust等の他言語から利用される。本バッチは、libtensorflowの品質検証とリリース用パッケージの生成を自動化し、マルチ言語エコシステムの基盤を支える。

**バッチの実行タイミング**：CI/CDパイプラインのトリガーに基づき随時実行される。リリースビルドおよびNightlyビルドで実行される。

**主要な処理内容**：
1. TFCI環境の初期化（setup.sh の読み込み）
2. GPU環境の場合、nvidia-smi による GPU 情報の記録
3. Nightlyビルドの場合、バージョン番号の更新
4. プラットフォーム別のBazelテスト・ビルド実行（Linux: test + build、Windows: buildのみ）
5. `repack_libtensorflow.sh` によるtarball/zipへのリパック
6. GCSステージングが有効な場合、gsutil による成果物のアップロード

**前後の処理との関連**：前段として `setup.sh` による環境初期化が行われる。`repack_libtensorflow.sh` をサブプロセスとして呼び出す。後続処理として `upload.sh` による最終アップロードが想定される。

**影響範囲**：libtensorflowビルド成果物（.tar.gz/.zip）の生成、`$TFCI_OUTPUT_DIR` 配下のファイル、GCSステージング領域。

## バッチ種別

ビルド・パッケージング / テスト実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CDトリガーに依存） |
| 実行時刻 | CI/CDパイプラインによる |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CI/CDパイプライン（Kokoro等）からの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| TFCI環境変数の設定 | `$TFCI` 環境変数に適切な env ファイルパスが設定されていること |
| Bazelの利用可能性 | Bazelビルドツールがインストールされ利用可能であること |
| GCS認証情報 | GCSアップロード有効時、適切な認証情報が設定されていること |

### 実行可否判定

`setup.sh` による環境初期化が正常に完了し、必要なTFCI環境変数がすべて設定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| TFCI | string | Yes | なし | 環境設定ファイルのカンマ区切りパス |
| TFCI_NVIDIA_SMI_ENABLE | string | No | 0 | nvidia-smi実行の有効/無効 |
| TFCI_NIGHTLY_UPDATE_VERSION_ENABLE | string | No | 0 | Nightlyバージョン更新の有効/無効 |
| TFCI_BAZEL_BAZELRC_ARGS | string | Yes | なし | Bazel設定ファイル引数 |
| TFCI_BAZEL_COMMON_ARGS | string | Yes | なし | Bazel共通引数 |
| TFCI_OUTPUT_DIR | string | Yes | なし | 出力ディレクトリパス |
| TFCI_LIB_SUFFIX | string | Yes | なし | tarball/zipのサフィックス |
| TFCI_ARTIFACT_STAGING_GCS_ENABLE | string | No | 0 | GCSステージングの有効/無効 |
| TFCI_ARTIFACT_STAGING_GCS_URI | string | No | なし | GCSステージングURI |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| TensorFlowソースコード | ソースファイル | libtensorflowビルド対象のC/C++ソースコード |
| TFCI環境設定ファイル | シェルスクリプト | `ci/official/envs/` 配下の環境変数定義ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $TFCI_OUTPUT_DIR/libtensorflow{suffix}.tar.gz | tar.gz | Linux向けlibtensorflowパッケージ |
| $TFCI_OUTPUT_DIR/libtensorflow_proto.zip | zip | Protocol Buffers定義ファイル（Linux） |
| $TFCI_OUTPUT_DIR/libtensorflow{suffix}.zip | zip | Windows向けlibtensorflowパッケージ |
| $TFCI_ARTIFACT_STAGING_GCS_URI | GCS | GCSステージング領域への成果物アップロード |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | `libtensorflow{TFCI_LIB_SUFFIX}.tar.gz`（Linux）/ `libtensorflow{TFCI_LIB_SUFFIX}.zip`（Windows） |
| 出力先 | `$TFCI_OUTPUT_DIR` |
| 文字コード | バイナリ |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 環境初期化
   └─ setup.sh を source し、TFCI環境変数を設定
2. GPU情報記録（条件付き）
   └─ TFCI_NVIDIA_SMI_ENABLE=1 の場合、nvidia-smi を実行
3. Nightlyバージョン更新（条件付き）
   └─ TFCI_NIGHTLY_UPDATE_VERSION_ENABLE=1 の場合、update_version.py --nightly を実行
4. プラットフォーム別ビルド/テスト実行
   └─ Linux: bazel test (linux_libtensorflow_test) → bazel build (linux_libtensorflow_build)
   └─ Windows: bazel build (windows_libtensorflow_build) のみ
5. 成果物リパック
   └─ repack_libtensorflow.sh を実行し、tarball/zipを生成
6. GCSアップロード（条件付き）
   └─ TFCI_ARTIFACT_STAGING_GCS_ENABLE=1 の場合、gsutilでGCSにアップロード
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[setup.sh による環境初期化]
    B --> C{NVIDIA SMI有効?}
    C -->|Yes| D[nvidia-smi 実行]
    C -->|No| E{Nightly更新有効?}
    D --> E
    E -->|Yes| F[バージョン番号更新]
    E -->|No| G{プラットフォーム判定}
    F --> G
    G -->|Linux| H[bazel test + bazel build]
    G -->|Windows| I[bazel build のみ]
    H --> J[repack_libtensorflow.sh 実行]
    I --> J
    J --> K{GCSステージング有効?}
    K -->|Yes| L[gsutil cp でGCSにアップロード]
    K -->|No| M[バッチ終了]
    L --> M
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ終了 | Bazelテスト失敗 | libtensorflowテストの失敗 | テストログを確認 |
| 非ゼロ終了 | Bazelビルドエラー | コンパイルエラー | ビルドログを確認 |
| 非ゼロ終了 | リパックエラー | 成果物ファイルの不在等 | ビルド出力を確認 |
| 非ゼロ終了 | GCSアップロードエラー | 認証/ネットワークエラー | 認証情報・接続を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | スクリプト自体にリトライ機能なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

`set -exo pipefail` により障害発生時にスクリプトが終了し、EXITトラップによりクリーンアップが実行される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1セットのlibtensorflowパッケージを生成 |
| 目標処理時間 | ビルド環境に依存（通常数十分） |
| メモリ使用量上限 | Bazelビルドに依存 |

## 排他制御

CI/CDパイプラインの1ジョブとして実行される。同一出力ディレクトリに対する並行実行は想定されていない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | setup.sh 実行時 | TFCI環境変数の一覧 |
| 進捗ログ | 各コマンド実行時 | `set -x` による全コマンドのトレースログ |
| 終了ログ | バッチ終了時 | cleanup_summary.sh によるResultStoreリンク |
| エラーログ | エラー発生時 | Bazelテスト/ビルド失敗の詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ実行結果 | 非ゼロ終了コード | CI/CDシステムの通知機能 |

## 備考

- Linux環境ではテスト（`linux_libtensorflow_test`）とビルド（`linux_libtensorflow_build`）の両方が実行されるが、Windows環境ではビルド（`windows_libtensorflow_build`）のみが実行される
- Windows環境ではtar.gzではなくzipが使用され、gsutilの実行にpowershellが使用される（b/389744576）
- `repack_libtensorflow.sh` はWindows環境でC APIヘッダファイルを個別にコピーし、zipパッケージを構成する
