# バッチ設計書 6-any.sh

## 概要

本ドキュメントは、TensorFlowのCI/CDパイプラインにおける汎用バッチ実行スクリプト `any.sh` の設計仕様を記述する。

### 本バッチの処理概要

本バッチは、任意のBazelターゲットまたは任意のCIスクリプトをTFCI環境内で実行するための汎用バッチである。開発者やCIシステムが柔軟にビルド・テスト・実行を行えるエントリーポイントを提供する。

**業務上の目的・背景**：TensorFlowのCI/CDパイプラインでは、特定のテストターゲットのみの実行やカスタムスクリプトの実行が必要になる場面がある。本バッチは、既存のCIスクリプト群を再利用しつつ、任意のBazelターゲットや外部スクリプトをTFCI環境下で実行できる汎用的な仕組みを提供する。特にデバッグ時や特定テストの再実行時に有用である。

**バッチの実行タイミング**：開発者による手動実行、またはCI/CDパイプラインからの呼び出し時に随時実行される。

**主要な処理内容**：
1. TensorFlowルートディレクトリへの移動
2. `nightly_upload` 環境設定のローカルキャッシュへの置換（安全対策）
3. 追加環境設定ファイルの適用（TF_ANY_EXTRA_ENV）
4. モード判定と実行：
   - スクリプトモード：`TF_ANY_SCRIPT` で指定されたスクリプトを実行
   - ターゲットモード：`TF_ANY_TARGETS` で指定されたBazelターゲットをtest/build/runで実行
   - エラーモード：両方未設定の場合はエラー終了

**前後の処理との関連**：スクリプトモードでは他のCIスクリプト（wheel.sh等）を呼び出す。ターゲットモードでは `setup.sh` を読み込んでTFCI環境を初期化する。`bisect.sh` と組み合わせて特定テストの bisect も可能。

**影響範囲**：実行内容に依存する。Bazelターゲットの場合はテスト結果やビルド成果物、スクリプトモードの場合は呼び出し先スクリプトの影響範囲に準ずる。

## バッチ種別

汎用実行 / CI/CDユーティリティ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動またはCI/CDトリガー） |
| 実行時刻 | 該当なし |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| TFCI環境変数の設定 | `$TFCI` 環境変数に適切な env ファイルパスが設定されていること |
| 実行モードの指定 | `$TF_ANY_SCRIPT` または `$TF_ANY_TARGETS` のいずれかが設定されていること |
| Bazelの利用可能性 | ターゲットモードの場合、Bazelが利用可能であること |

### 実行可否判定

`$TF_ANY_SCRIPT` と `$TF_ANY_TARGETS` の両方が空の場合はエラー終了（終了コード1）となる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| TFCI | string | Yes | なし | 環境設定ファイルのカンマ区切りパス |
| TF_ANY_SCRIPT | string | No | なし | 実行するスクリプトのパス |
| TF_ANY_TARGETS | string | No | なし | Bazelターゲット（スペース区切り） |
| TF_ANY_MODE | string | No | test | Bazelモード（test/build/run） |
| TF_ANY_EXTRA_ENV | string | No | なし | 追加環境設定ファイルのカンマ区切りパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| TFCI環境設定ファイル | シェルスクリプト | `ci/official/envs/` 配下の環境変数定義ファイル |
| 実行対象スクリプト | シェルスクリプト | TF_ANY_SCRIPT で指定されたスクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力/エラー | テキスト | 実行結果のログ出力 |
| 実行内容に依存 | 各種 | Bazelビルド成果物やテスト結果等 |

### 出力ファイル仕様

実行内容に依存する。

## 処理フロー

### 処理シーケンス

```
1. TensorFlowルートディレクトリへ移動
   └─ $(dirname "$0")/../../ に cd
2. TFCI環境変数の前処理
   └─ nightly_upload を public_cache,disk_cache に置換（アップロード防止）
3. 追加環境設定の適用（条件付き）
   └─ TF_ANY_EXTRA_ENV が設定されている場合、TFCI にカンマ区切りで追加
4. 実行モード判定と実行
   └─ TF_ANY_SCRIPT が設定されている場合: 指定スクリプトを実行
   └─ TF_ANY_TARGETS が設定されている場合: setup.sh を読み込み、bazel {mode} を実行
   └─ 両方未設定の場合: エラーメッセージを出力して終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[TFルートディレクトリへ移動]
    B --> C[nightly_uploadをローカルキャッシュに置換]
    C --> D{TF_ANY_EXTRA_ENV設定?}
    D -->|Yes| E[追加環境設定をTFCIに追加]
    D -->|No| F{TF_ANY_SCRIPT設定?}
    E --> F
    F -->|Yes| G[指定スクリプトを実行]
    F -->|No| H{TF_ANY_TARGETS設定?}
    H -->|Yes| I[setup.sh 読み込み]
    I --> J[bazel TF_ANY_MODE TF_ANY_TARGETS 実行]
    H -->|No| K[エラー: 両方未設定]
    G --> L[バッチ終了]
    J --> L
    K --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチ自体はデータベース操作を行わない。実行内容に依存する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | パラメータ不備 | TF_ANY_TARGETSとTF_ANY_SCRIPTが両方空 | いずれかの変数を設定 |
| 非ゼロ終了 | 実行エラー | Bazelまたはスクリプトの失敗 | 実行ログを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | スクリプト自体にリトライ機能なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

`set -exo pipefail` により障害発生時にスクリプトが終了する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 実行内容に依存 |
| 目標処理時間 | 実行内容に依存 |
| メモリ使用量上限 | 実行内容に依存 |

## 排他制御

実行内容に依存する。本バッチ自体に排他制御は実装されていない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | setup.sh 実行時（ターゲットモード） | TFCI環境変数の一覧 |
| 進捗ログ | 各コマンド実行時 | `set -x` による全コマンドのトレースログ |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ実行結果 | 非ゼロ終了コード | CI/CDシステムの通知機能 |

## 備考

- `nightly_upload` 環境設定は安全のため自動的に `public_cache,disk_cache` に置換される。これにより、any.sh 経由でのNightlyアップロードが防止される
- ローカルキャッシュまたはRBE（Remote Build Execution）と組み合わせて使用可能（`TF_ANY_EXTRA_ENV` で設定）
- `bisect.sh` と組み合わせることで、特定テストの失敗原因コミットの特定（git bisect）が可能
