# バッチ設計書 8-code_check_changed_files.sh

## 概要

本ドキュメントは、TensorFlowのCI/CDパイプラインにおける変更ファイル限定コード品質チェックバッチ `code_check_changed_files.sh` の設計仕様を記述する。

### 本バッチの処理概要

本バッチは、変更されたファイルのみに対してコード品質チェック（batsテスト）を実行するバッチである。

**業務上の目的・背景**：プルリクエスト時に全コードのチェックを行うと実行時間が長くなるため、変更されたファイルのみを対象とした高速なコード品質チェックが必要である。本バッチは、開発者のフィードバックループを短縮し、プルリクエストレビューの効率化に貢献する。

**バッチの実行タイミング**：CI/CDパイプラインのプルリクエストトリガーに基づき実行される。コード変更があった場合に高速にフィードバックを返すために使用される。

**主要な処理内容**：
1. TFCI環境の初期化（setup.sh の読み込み）
2. batsテストフレームワークによる `code_check_changed_files.bats` の実行
3. テスト結果のタイミング情報の出力
4. テスト結果の `$TFCI_OUTPUT_DIR` への出力

**前後の処理との関連**：前段として `setup.sh` による環境初期化が行われる。全コードチェックを行う `code_check_full.sh`（No.7）と補完関係にある。

**影響範囲**：CI/CDパイプラインのコード品質ゲート結果。テスト結果ファイルが `$TFCI_OUTPUT_DIR` に出力される。

## バッチ種別

コード品質チェック / テスト実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（プルリクエスト時） |
| 実行時刻 | CI/CDパイプラインによる |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | プルリクエスト / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| TFCI環境変数の設定 | `$TFCI` 環境変数に適切な env ファイルパスが設定されていること |
| batsの利用可能性 | bats（Bash Automated Testing System）がインストールされていること |
| TFCI_OUTPUT_DIR | 出力ディレクトリが設定されていること |
| Git差分情報 | 変更ファイルの特定のためにgitリポジトリ内で実行されること |

### 実行可否判定

`setup.sh` による環境初期化が正常に完了し、batsコマンドが利用可能であること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| TFCI | string | Yes | なし | 環境設定ファイルのカンマ区切りパス |
| TFCI_OUTPUT_DIR | string | Yes | なし | テスト結果の出力ディレクトリ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| code_check_changed_files.bats | batsテストファイル | `ci/official/utilities/code_check_changed_files.bats` |
| Git差分情報 | git diff | 変更されたファイルの一覧 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | batsテスト結果とタイミング情報 |
| $TFCI_OUTPUT_DIR | bats出力 | テスト結果ファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | batsの `--output` オプションにより決定 |
| 出力先 | `$TFCI_OUTPUT_DIR` |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 環境初期化
   └─ setup.sh を source し、TFCI環境変数を設定
2. batsテスト実行
   └─ tfrun bats ./ci/official/utilities/code_check_changed_files.bats --timing --output "$TFCI_OUTPUT_DIR"
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[setup.sh による環境初期化]
    B --> C[bats code_check_changed_files.bats 実行]
    C --> D[テスト結果出力]
    D --> E[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ終了 | コード品質チェック失敗 | batsテストのアサーション失敗 | テスト結果を確認し、変更ファイルの品質問題を修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | スクリプト自体にリトライ機能なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

batsテスト失敗時は、テスト結果レポートを確認し、変更ファイルに対する品質問題を修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 変更されたファイルのみ（プルリクエストの差分） |
| 目標処理時間 | 全コードチェックより大幅に短時間（通常数分以内） |
| メモリ使用量上限 | 通常のシェルプロセス程度 |

## 排他制御

CI/CDパイプラインの1ジョブとして実行される。リポジトリのソースコードを読み取り専用で参照するため、並行実行は問題ない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | setup.sh 実行時 | TFCI環境変数の一覧 |
| 進捗ログ | batsテスト実行中 | 各テストケースの結果とタイミング（`--timing`） |
| 終了ログ | バッチ終了時 | cleanup_summary.sh によるResultStoreリンク |
| エラーログ | テスト失敗時 | 失敗したテストケースの詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ実行結果 | 非ゼロ終了コード | CI/CDシステムの通知機能 |

## 備考

- 全コードチェック（code_check_full.sh）と異なり、変更ファイルのみを対象とするため実行時間が短い
- プルリクエストのCI/CDゲートとして使用されることが多い
- チェック内容の詳細は `code_check_changed_files.bats` に定義されている
