---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-setup.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間の記述**：具体的な計測根拠がなく推定値
  2. **Bazelリトライ回数**：MAX_RETRIESの実際の挙動（set +eとの相互作用）の確認が必要
  3. **Windows環境パス変換の詳細**：convert_msys_paths_to_win_paths.pyの挙動は別ファイルに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `ci/official/utilities/setup.sh`（ソースコード全体、156行）
- E-02: `ci/official/utilities/setup_docker.sh`（Docker設定スクリプト）
- E-03: `ci/official/utilities/cleanup_docker.sh`（Dockerクリーンアップスクリプト）
- E-04: `ci/official/utilities/cleanup_summary.sh`（サマリー出力スクリプト）
- E-05: `ci/official/utilities/generate_index_html.sh`（HTML生成スクリプト）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | シェルオプション set -exo pipefail -o history -o allexport を設定 | E-01 (L32) | ○ |
| C-02 | TFCI_GIT_DIRをsetup.shの2階層上として算出 | E-01 (L38) | ○ |
| C-03 | TFCI変数で指定されたenvファイル群をカンマ区切りで順次source | E-01 (L68-70) | ○ |
| C-04 | 既存TFCI_変数をFROM_ENVとして退避・復元 | E-01 (L56-83) | ○ |
| C-05 | ci_defaultを最初に読み込む | E-01 (L62) | ○ |
| C-06 | TFCI_INSTALLER_WHL_ENABLE=1でインストーラーwheel変数を設定 | E-01 (L89-97) | ○ |
| C-07 | macOS環境でsetup_macos.shをsource | E-01 (L100-102) | ○ |
| C-08 | TFCI_OUTPUT_DIRを作成しscript.logへのtee出力を設定 | E-01 (L105-110) | ○ |
| C-09 | tfrun関数をパススルー関数として定義 | E-01 (L120) | ○ |
| C-10 | MSYS_NT環境でwindows.shとパス変換を実行 | E-01 (L122-126) | ○ |
| C-11 | TFCI_DOCKER_ENABLE=1でsetup_docker.shをsource | E-01 (L129-131) | ○ |
| C-12 | TFCI_INDEX_HTML_ENABLE=1でgenerate_index_html.shを実行 | E-01 (L134-136) | ○ |
| C-13 | Bazelバージョン確認を最大2回リトライ | E-01 (L141-145) | ○ |
| C-14 | EXITトラップでcleanup関数（Docker停止+サマリー出力）を登録 | E-01 (L149-155) | ○ |
| C-15 | cleanup関数内でcleanup_docker.shとcleanup_summary.shを呼び出す | E-01 (L150-154), E-03, E-04 | ○ |
| C-16 | tfrun関数はパイプを含むコマンドに使用不可 | E-01 (L115-118) コメント | ○ |
| C-17 | 変更を最小限にすべきという方針 | E-01 (L19-23) コメント | ○ |
| C-18 | 目標処理時間は数秒〜数十秒（Docker pull時は数分） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18（目標処理時間）：コード上にパフォーマンス要件の記述はなく、処理内容からの推定値である
  - 候補：CI実行ログの分析 / パフォーマンステスト結果 / 運用ドキュメント

## 5) リスクフラグ（レビュー観点）
- C-18: 0（低リスク）- パフォーマンス要件は参考値であり、正確でなくても運用に影響しない
- 全体的にソースコードから直接読み取れる内容が多く、高リスクの項目はない

## 6) レビュアーチェックリスト（最小）
- [ ] setup.shのシェルオプション設定（set -exo pipefail等）が正確に記述されているか
- [ ] TFCI環境変数の読込順序（ci_default → TFCI指定ファイル → FROM_ENV復元）が正しいか
- [ ] EXITトラップのcleanup関数の呼び出し先が正確か
- [ ] 各条件分岐（Docker、installer wheel、macOS、Windows）の条件が正しいか
