---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：12-setup_docker.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間の記述**：具体的な計測根拠がない推定値
  2. **Windows固有設定の詳細**：ファイアウォール・サービス停止の影響範囲の確認
  3. **コンテナの--rmフラグ**：docker runのTFCI_DOCKER_ARGSの内容次第

## 2) 参照した情報（Evidence一覧）

- E-01: `ci/official/utilities/setup_docker.sh`（ソースコード全体、75行）
- E-02: `ci/official/utilities/setup.sh`（呼び出し元、L129-131）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TFCI_DOCKER_PULL_ENABLE=1でdocker pullを実行 | E-01 (L16-24) | ○ |
| C-02 | docker pullのリトライは15s/30s/60s間隔で段階的に増加 | E-01 (L20-23) | ○ |
| C-03 | TFCI_DOCKER_REBUILD_ENABLE=1でDocker BuildKitでリビルド | E-01 (L26-27) | ○ |
| C-04 | TFCI_DOCKER_REBUILD_UPLOAD_ENABLE=1でdocker push | E-01 (L28-30) | ○ |
| C-05 | tfコンテナが存在しない場合に新規作成 | E-01 (L36) | ○ |
| C-06 | TFCI_変数をenv-fileとしてコンテナに渡す | E-01 (L38-39, L56) | ○ |
| C-07 | TFCI_GIT_DIRをボリュームマウント | E-01 (L55) | ○ |
| C-08 | bashをエントリポイントとしてデタッチモードで起動 | E-01 (L54-58) | ○ |
| C-09 | Windows環境でファイアウォールルール追加 | E-01 (L64) | ○ |
| C-10 | Windows環境でSysMain, DiagTrackサービス停止 | E-01 (L70) | ○ |
| C-11 | tfrun関数をdocker exec tfに再定義 | E-01 (L74) | ○ |
| C-12 | Windows設定はb/461500885対策 | E-01 (L69) コメント | ○ |
| C-13 | コンテナは--rmフラグ付きで起動 | E-01 (L54) | ○ |
| C-14 | Docker pull時の目標処理時間は数十秒〜数分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14（目標処理時間）：コード上にパフォーマンス要件の記述はなく、一般的なDocker pull時間からの推定
  - 候補：CI実行ログの分析 / ネットワーク帯域情報 / Dockerイメージサイズ情報

## 5) リスクフラグ（レビュー観点）
- C-14: 0（低リスク）- パフォーマンス要件は参考値
- C-09, C-10: 1（中リスク）- Windows固有処理の影響範囲はプラットフォーム依存

## 6) レビュアーチェックリスト（最小）
- [ ] docker pullのリトライロジック（スリープ間隔: 15s, 30s, 60s）が正確か
- [ ] TFCI_変数のenv-file渡しの仕組みが正しく記述されているか
- [ ] tfrun関数の再定義が正確か
- [ ] Windows固有設定（ファイアウォール、サービス停止）の記述が正確か
