---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-cleanup_docker.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  1. 特になし。シンプルなスクリプトでありすべて根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `ci/official/utilities/cleanup_docker.sh`（ソースコード全体、29行）
- E-02: `ci/official/utilities/setup.sh`（呼び出し元、L149-155）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | catヒアドキュメントでクリーンアップ案内メッセージを表示 | E-01 (L16-26) | ○ |
| C-02 | docker rm -f tf コマンドの案内を含む | E-01 (L21) | ○ |
| C-03 | docker exec tf の使用例を含む | E-01 (L24-25) | ○ |
| C-04 | docker ps でコンテナ一覧を表示 | E-01 (L28) | ○ |
| C-05 | setup.shのcleanup関数から呼び出される | E-02 (L150-151) | ○ |
| C-06 | TFCI_DOCKER_ENABLE=1の場合に呼び出される | E-02 (L150) | ○ |
| C-07 | コンテナの自動削除は行わない | E-01 全体 | ○ |
| C-08 | 引数なしで実行される | E-01 全体 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 全体的に低リスク。情報表示のみのシンプルなスクリプト。

## 6) レビュアーチェックリスト（最小）
- [ ] 案内メッセージの内容が適切か
- [ ] docker ps コマンドの実行が正しく記述されているか
