---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-run_models.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. **ベンチマーク実行回数の算出**：34回の算出ロジックの確認
  2. **BERTのバッチサイズ制限**：将来的に変更される可能性
  3. **各モデルの入力仕様**：モデルファイルの互換性確認

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/tools/benchmark/run_models.sh`（ソースコード全体、86行）
- E-02: `tensorflow/tools/benchmark/onednn_benchmark_config.sh`（ベンチマーク設定、31行）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | onednn_benchmark_config.shを読み込む | E-01 (L20) | ○ |
| C-02 | configure_build()でワークスペースルートに移動し./configureを実行 | E-01 (L24), E-02 (L23-26) | ○ |
| C-03 | ONEDNN=0とONEDNN=1の2条件でループ | E-01 (L28) | ○ |
| C-04 | TF_ENABLE_ONEDNN_OPTSを設定 | E-01 (L31) | ○ |
| C-05 | BATCH=1, 16, 64の3条件でループ | E-01 (L34) | ○ |
| C-06 | ResNet50を224x224x3、float入力で実行 | E-01 (L40-45) | ○ |
| C-07 | Inceptionを224x224x3、float入力で実行 | E-01 (L47-52) | ○ |
| C-08 | MobileNetを224x224x3、float入力で実行 | E-01 (L54-59) | ○ |
| C-09 | SSD-MobileNetを300x300x3、uint8入力で実行 | E-01 (L61-66) | ○ |
| C-10 | SSD-ResNet34を3x1200x1200、float入力で実行 | E-01 (L68-73) | ○ |
| C-11 | BERTはBATCH=1のみで実行 | E-01 (L76-83) | ○ |
| C-12 | BERTの入力はinput_ids, input_mask, segment_ids（int32, 1x384） | E-01 (L78-82) | ○ |
| C-13 | benchmark_commandは--config=opt --dynamic_mode=offを返す | E-02 (L28-30) | ○ |
| C-14 | TF_GRAPHSは~/tf-graphsに設定 | E-02 (L20) | ○ |
| C-15 | BUILDERはbazelに設定 | E-02 (L21) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張がソースコードから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- 全体的に低リスク。モデル固有の入力仕様はソースコードに明示されている。
- C-11: 0（低リスク）- BERTのバッチサイズ制限は "for now" と記載されており将来変更の可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] 各モデルの入力テンソル名・形状・型が正確か
- [ ] ベンチマーク実行回数の算出（34回）が正しいか
- [ ] onednn_benchmark_config.shの設定値が正確に反映されているか
- [ ] BERTのバッチサイズ制限が正しく記述されているか
