---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-run_onednn_benchmarks.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  1. **parse_onednn_benchmarks.pyの出力形式**：Pythonスクリプトの内容は未読
  2. **grepフィルタパターン**：正規表現のエッジケース確認

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/tools/benchmark/run_onednn_benchmarks.sh`（ソースコード全体、28行）
- E-02: `tensorflow/tools/benchmark/onednn_benchmark_config.sh`（ベンチマーク設定）
- E-03: `tensorflow/tools/benchmark/run_models.sh`（ベンチマーク実行スクリプト）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | onednn_benchmark_config.shを読み込む | E-01 (L20) | ○ |
| C-02 | 出力ディレクトリを~/onednn_benchmarksに設定 | E-01 (L22) | ○ |
| C-03 | mkdir -pで出力ディレクトリを作成 | E-01 (L23) | ○ |
| C-04 | run_models.shを実行し標準出力+標準エラーをteeでverbose.logに出力 | E-01 (L24) | ○ |
| C-05 | profiler_sessionとxplane行を除外してrun.logを生成 | E-01 (L25) | ○ |
| C-06 | ベンチマークコマンド行と結果行を抽出してto_parse.logを生成 | E-01 (L26) | ○ |
| C-07 | parse_onednn_benchmarks.pyでto_parse.logを解析しresults.csvに出力 | E-01 (L27) | ○ |
| C-08 | results.csvはteeで標準出力にも表示される | E-01 (L27) | ○ |
| C-09 | set -xでコマンドトレースが有効 | E-01 (L19) | ○ |
| C-10 | grepパターンで"+ ${BUILDER} run"を抽出 | E-01 (L26), E-02 (L21) | ○ |
| C-11 | grepパターンで"no stats:"と"'BATCH="を抽出 | E-01 (L26) | ○ |

## 4) 不足情報（Unknown / Missing）
- parse_onednn_benchmarks.pyの出力形式の詳細はPythonスクリプトの内容を確認する必要がある。ただし、本設計書の範囲はシェルスクリプトであり、Python側の詳細は別途確認が望ましい。

## 5) リスクフラグ（レビュー観点）
- parse_onednn_benchmarks.pyの動作: 1（中リスク）- Pythonスクリプトの出力形式は未確認
- 全体的に低リスク。シンプルなパイプライン構成。

## 6) レビュアーチェックリスト（最小）
- [ ] ログフィルタリングのgrepパターンが正確か
- [ ] パース対象抽出のgrepパターンが正確か
- [ ] 出力ファイルのパス（~/onednn_benchmarks/）が正しいか
