---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-download_models.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  1. **ダウンロードURLの有効性**：外部URLは時間経過で無効化される可能性がある
  2. **BERT Largeのダウンロード時間**：ネットワーク環境依存

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/tools/benchmark/download_models.sh`（ソースコード全体、53行）
- E-02: `tensorflow/tools/benchmark/onednn_benchmark_config.sh`（ベンチマーク設定）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | onednn_benchmark_config.shを読み込む | E-01 (L17) | ○ |
| C-02 | TF_GRAPHSディレクトリ（~/tf-graphs）を作成 | E-01 (L20), E-02 (L20) | ○ |
| C-03 | ResNet50をZenodoからダウンロード | E-01 (L25) | ○ |
| C-04 | Inceptionをstorage.googleapis.comからダウンロード | E-01 (L26) | ○ |
| C-05 | MobileNetをZenodoからダウンロード | E-01 (L27) | ○ |
| C-06 | SSD-MobileNetをdownload.tensorflow.orgからダウンロード | E-01 (L28) | ○ |
| C-07 | SSD-ResNet34をZenodoからダウンロード | E-01 (L29) | ○ |
| C-08 | BERT Largeは約1.2GBでダウンロードに10分以上かかる可能性 | E-01 (L30) コメント | ○ |
| C-09 | Inceptionはunzipで展開しinception.pbにリネーム | E-01 (L33-35) | ○ |
| C-10 | MobileNetはtar展開しmobilenet-v1.pbにリネーム | E-01 (L36-37) | ○ |
| C-11 | SSD-MobileNetはtar展開しssd-mobilenet-v1.pbにリネーム | E-01 (L38-40) | ○ |
| C-12 | SSD-ResNet34はunzip展開しssd-resnet34.pbにリネーム | E-01 (L41-43) | ○ |
| C-13 | 最終的に6つの.pbファイルが~/tf-graphsに配置される | E-01 (L45-52) コメント | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張がソースコードとそのコメントから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- ダウンロードURL: 1（中リスク）- 外部ホスティングのURLは将来的に変更・無効化される可能性がある
- 全体的に低リスク。ダウンロードと展開のシンプルな処理。

## 6) レビュアーチェックリスト（最小）
- [ ] 各モデルのダウンロードURLが有効であるか
- [ ] 展開後のファイル名が正しいか（run_models.shで参照されるファイル名と一致するか）
- [ ] wget -cオプションによるレジューム機能の記述が正確か
