---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 8
  claims_with_evidence: 7
  claims_without_evidence: 1
confidence_derived: 0.88
---

# 根拠レポート：7-code_check_full.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：7 / 8、根拠なし：1
- 優先レビュー（高）
  1. **チェック内容の詳細**：code_check_full.batsの内容は未参照
  2. **ライセンスヘッダー・API一貫性等のチェック項目の具体的記述**：batsファイルの中身に依存
  3. **想定処理時間**：実績データが不足

## 2) 参照した情報（Evidence一覧）

- E-01: `ci/official/code_check_full.sh`（メインスクリプト、18行）
- E-02: `ci/official/utilities/setup.sh`（共通初期化スクリプト、156行）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | setup.shをsourceして環境初期化を行う | E-01 (L16), E-02 | ○ |
| C-02 | batsでcode_check_full.batsを実行 | E-01 (L18) | ○ |
| C-03 | --timingフラグでタイミング情報を出力 | E-01 (L18) | ○ |
| C-04 | --outputで$TFCI_OUTPUT_DIRに結果を出力 | E-01 (L18) | ○ |
| C-05 | tfrunを経由してbatsを実行 | E-01 (L18) | ○ |
| C-06 | EXITトラップでクリーンアップが実行される | E-02 (L149-155) | ○ |
| C-07 | ライセンスヘッダー・API一貫性等のチェックを行う | **根拠なし** | △ |
| C-08 | code_check_changed_files.shと補完関係にある | E-03 (行8-9) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-07のチェック内容の具体的な項目は `ci/official/utilities/code_check_full.bats` の中身に依存するが、当該batsファイルの内容は未参照
  - 候補：`ci/official/utilities/code_check_full.bats` の読み込み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メインスクリプトが2行（初期化+実行）のみで処理が明確
- 1: 中リスク - batsテストの具体的チェック内容が設計書に反映されていない可能性
- 0: 低リスク - コマンドラインオプションの記述は正確

## 6) レビュアーチェックリスト（最小）
- [ ] code_check_full.batsの具体的なテストケース内容を確認したか
- [ ] batsコマンドのオプション（--timing, --output）が正確か
- [ ] チェック対象が「全コード」であることの裏付けがあるか
