---
generated_at: 2026-02-03 15:30:00
metrics:
  claims_total: 181
  claims_with_evidence: 181
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：compiler-jit.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードのヘッダーファイル・実装ファイルに対応するクラス・関数・メソッドが存在するか
2. **根拠との整合性**：テストケースの内容が実際のAPI仕様と矛盾していないか
3. **網羅性**：主要なパブリックAPIを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：181 / 181、根拠なし：0
- 優先レビュー（高）
  1. **特になし**：全テストケースがソースコードの根拠に基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/compiler/jit/xla_device.h` - XlaDevice クラス定義
- E-02: `tensorflow/compiler/jit/xla_cluster_util.h` - クラスタリングユーティリティ関数
- E-03: `tensorflow/compiler/jit/xla_compile_util.h` - コンパイルユーティリティ関数
- E-04: `tensorflow/compiler/jit/xla_launch_util.h` - 起動ユーティリティ関数・クラス
- E-05: `tensorflow/compiler/jit/compilability_check_util.h` - コンパイル可能性チェッカークラス
- E-06: `tensorflow/compiler/jit/mark_for_compilation_pass.h` - コンパイルマーキングパス
- E-07: `tensorflow/compiler/jit/deadness_analysis.h` - デッドネス分析クラス
- E-08: `tensorflow/compiler/jit/device_compiler.h` - デバイスコンパイラテンプレートクラス
- E-09: `tensorflow/compiler/jit/device_util.h` - デバイスユーティリティクラス
- E-10: `tensorflow/compiler/jit/flags.h` - JITフラグ構造体・関数
- E-11: `tensorflow/compiler/jit/encapsulate_subgraphs_pass.h` - サブグラフカプセル化パス
- E-12: `tensorflow/compiler/jit/variable_info.h` - 変数情報クラス
- E-13: `tensorflow/compiler/jit/xla_tensor.h` - XlaTensorクラス
- E-14: `tensorflow/compiler/jit/shape_inference.h` - 形状推論関数
- E-15: `tensorflow/compiler/jit/resource_operation_safety_analysis.h` - リソース操作安全性分析
- E-16: `tensorflow/compiler/jit/xla_platform_info.h` - プラットフォーム情報クラス
- E-17: `tensorflow/compiler/jit/pjrt_device_context.h` - PjRtデバイスコンテキストクラス
- E-18: `tensorflow/compiler/jit/kernels/xla_ops.h` - XLAオペレータカーネルクラス
- E-19: `tensorflow/compiler/jit/build_xla_ops_pass.h` - XLA Opsビルドパス
- E-20: `tensorflow/compiler/jit/partially_decluster_pass.h` - 部分デクラスタリングパス
- E-21: `tensorflow/compiler/jit/cluster_scoping_pass.h` - クラスタスコーピングパス

## 3) Claims と根拠の対応（レビューの主戦場）

### XlaDevice関連 (UT-JIT-001 - UT-JIT-015)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XlaDeviceコンストラクタ | E-01 L153 | ○ |
| C-02 | XlaDevice::GetAllocator正常系 | E-01 L156-157 | ○ |
| C-03 | XlaDevice::GetAllocator異常系 | E-01 L156-157 | ○ |
| C-04 | XlaDevice::Compute正常系 | E-01 L158 | ○ |
| C-05 | XlaDevice::Compute異常系 | E-01 L158 | ○ |
| C-06 | XlaDevice::ComputeAsync | E-01 L159-160 | ○ |
| C-07 | XlaDevice::Sync | E-01 L161 | ○ |
| C-08 | XlaDevice::TryGetDeviceContext | E-01 L163-164 | ○ |
| C-09 | XlaDevice::MakeTensorFromProto正常系 | E-01 L166-169 | ○ |
| C-10 | XlaDevice::MakeTensorFromProto異常系 | E-01 L166-169 | ○ |
| C-11 | XlaDevice::Metadata::device_ordinal | E-01 L69 | ○ |
| C-12 | XlaDevice::Metadata::platform | E-01 L71 | ○ |
| C-13 | XlaDevice::GetMetadata(OpKernelContext) | E-01 L96-97 | ○ |
| C-14 | XlaDevice::GetMetadataFromDevice | E-01 L105-106 | ○ |
| C-15 | XlaDevice::EnsureDeviceContextOk | E-01 L184 | ○ |

### クラスタリングユーティリティ (UT-JIT-016 - UT-JIT-032)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | HasForwardedRefInput(ref有) | E-02 L50 | ○ |
| C-17 | HasForwardedRefInput(ref無) | E-02 L50 | ○ |
| C-18 | CreateCycleDetectionGraph正常系 | E-02 L58-59 | ○ |
| C-19 | CreateCycleDetectionGraph境界値 | E-02 L58-59 | ○ |
| C-20 | GetXlaClusterForNode(クラスタ有) | E-02 L63 | ○ |
| C-21 | GetXlaClusterForNode(クラスタ無) | E-02 L63 | ○ |
| C-22 | RemoveFromXlaCluster | E-02 L66-69 | ○ |
| C-23 | HasResourceInputOrOutput(有) | E-02 L72 | ○ |
| C-24 | HasResourceInputOrOutput(無) | E-02 L72 | ○ |
| C-25 | GetGlobalJitLevelForGraph | E-02 L76-77 | ○ |
| C-26 | IsSingleGpuGraph(true) | E-02 L81 | ○ |
| C-27 | IsSingleGpuGraph(false) | E-02 L81 | ○ |
| C-28 | MayCallFunction | E-02 L85 | ○ |
| C-29 | IsShapeConsumerOp | E-02 L89 | ○ |
| C-30 | GetXlaAutoClusteringSummary | E-02 L93 | ○ |
| C-31 | SerializeGraphDeterministic | E-02 L104 | ○ |
| C-32 | FingerprintGraph | E-02 L109 | ○ |

### コンパイルユーティリティ (UT-JIT-033 - UT-JIT-038)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | CreateSingleOpGraph正常系 | E-03 L44-46 | ○ |
| C-34 | CreateSingleOpGraph異常系 | E-03 L44-46 | ○ |
| C-35 | UsePjRtForSingleDeviceCompilation(true) | E-03 L50 | ○ |
| C-36 | UsePjRtForSingleDeviceCompilation(false) | E-03 L50 | ○ |
| C-37 | GetPjRtDeviceCompilerResourceName | E-03 L53 | ○ |
| C-38 | GetResourceMgrForDeviceCompiler | E-03 L62-63 | ○ |

### 起動ユーティリティ (UT-JIT-039 - UT-JIT-058)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | GatherVariableInfo正常系 | E-04 L43-46 | ○ |
| C-40 | GatherVariableInfo境界値 | E-04 L43-46 | ○ |
| C-41 | InputsFromContext正常系 | E-04 L49 | ○ |
| C-42 | InputsFromContext境界値 | E-04 L49 | ○ |
| C-43 | GetConstantInputIndicesFromContext | E-04 L51-52 | ○ |
| C-44 | SetOutputForConstant | E-04 L54-56 | ○ |
| C-45 | PreparePjRtExecutableArguments正常系 | E-04 L83-90 | ○ |
| C-46 | PreparePjRtExecutableArguments異常系 | E-04 L83-90 | ○ |
| C-47 | PopulateCtxOutputsFromPjRtExecutableOutputs | E-04 L100-106 | ○ |
| C-48 | GetPjRtExecuteOptions | E-04 L109-111 | ○ |
| C-49 | GetDeviceOrdinal | E-04 L114 | ○ |
| C-50 | GetDeviceType | E-04 L117 | ○ |
| C-51 | RunPjRtExecutable正常系 | E-04 L123-128 | ○ |
| C-52 | RunPjRtExecutable異常系 | E-04 L123-128 | ○ |
| C-53 | XlaComputationLaunchContextコンストラクタ | E-04 L169-172 | ○ |
| C-54 | BuildXlaCompilerArguments | E-04 L177-181 | ○ |
| C-55 | PopulateInputs | E-04 L190-195 | ○ |
| C-56 | PopulateOutputs | E-04 L207-213 | ○ |
| C-57 | XlaTensorBufferコンストラクタ | E-04 L227-232 | ○ |
| C-58 | XlaTensorBuffer::size | E-04 L240 | ○ |

### コンパイル可能性チェック (UT-JIT-059 - UT-JIT-072)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | RecursiveCompilabilityCheckerコンストラクタ | E-05 L156-159 | ○ |
| C-60 | FindUncompilableNodes正常系 | E-05 L175-177 | ○ |
| C-61 | FindUncompilableNodes境界値 | E-05 L175-177 | ○ |
| C-62 | IsCompilableNode(true) | E-05 L180-184 | ○ |
| C-63 | IsCompilableNode(false) | E-05 L180-184 | ○ |
| C-64 | OpIsInaccurate | E-05 L189 | ○ |
| C-65 | OpIsSlow | E-05 L190 | ○ |
| C-66 | GetBodyAndConstantsAndResources | E-05 L288-291 | ○ |
| C-67 | CanCreateXlaKernel(true) | E-05 L295 | ○ |
| C-68 | CanCreateXlaKernel(false) | E-05 L295 | ○ |
| C-69 | GetInputMemoryTypes | E-05 L320-323 | ○ |
| C-70 | GetOutputMemoryTypes | E-05 L329-330 | ○ |
| C-71 | CanTriggerXlaCompilation | E-05 L333 | ○ |
| C-72 | NodeCanTriggerXlaCompilation | E-05 L336 | ○ |

### MarkForCompilationPass (UT-JIT-073 - UT-JIT-076)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | MarkForCompilationPassコンストラクタ | E-06 L38 | ○ |
| C-74 | MarkForCompilationPass::Run正常系 | E-06 L40 | ○ |
| C-75 | MarkForCompilationPass::Run異常系 | E-06 L40 | ○ |
| C-76 | GetAllowlistTable | E-06 L50 | ○ |

### DeadnessAnalysis (UT-JIT-077 - UT-JIT-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | DeadnessAnalysis::Run正常系 | E-07 L88-89 | ○ |
| C-78 | DeadnessAnalysis::Run境界値 | E-07 L88-89 | ○ |
| C-79 | DeadnessAnalysis::GetPredicateFor | E-07 L76-77 | ○ |
| C-80 | DeadnessAnalysis::Print | E-07 L81 | ○ |
| C-81 | DeadnessAnalysis::DebugString | E-07 L84 | ○ |
| C-82 | DeadnessPredicate::operator== | E-07 L57-59 | ○ |
| C-83 | DeadnessPredicate::operator!= | E-07 L61-63 | ○ |

### DeviceCompiler (UT-JIT-084 - UT-JIT-091)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | DeviceCompilerコンストラクタ | E-08 L71-75 | ○ |
| C-85 | CompileIfNeeded正常系 | E-08 L103-109 | ○ |
| C-86 | CompileIfNeeded(キャッシュヒット) | E-08 L103-109 | ○ |
| C-87 | CompileSingleOpIfNeeded | E-08 L112-118 | ○ |
| C-88 | DeviceCompiler::client | E-08 L130 | ○ |
| C-89 | DeviceCompiler::device_type | E-08 L131 | ○ |
| C-90 | DeviceCompiler::cache | E-08 L132 | ○ |
| C-91 | DeviceCompiler::Finalize | E-08 L181 | ○ |

### DeviceUtil (UT-JIT-092 - UT-JIT-108)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | DeviceId::operator== | E-09 L46 | ○ |
| C-93 | DeviceId::operator!= | E-09 L47 | ○ |
| C-94 | DeviceSet::Insert | E-09 L63 | ○ |
| C-95 | DeviceSet::UnionWith | E-09 L64 | ○ |
| C-96 | DeviceSet::IsEmpty(true) | E-09 L65 | ○ |
| C-97 | DeviceSet::IsEmpty(false) | E-09 L65 | ○ |
| C-98 | DeviceSet::ForEach | E-09 L72-90 | ○ |
| C-99 | DeviceInfoCache::IsGpu | E-09 L101 | ○ |
| C-100 | DeviceInfoCache::IsCpu | E-09 L102 | ○ |
| C-101 | DeviceInfoCache::GetNameFor | E-09 L104-106 | ○ |
| C-102 | DeviceInfoCache::GetIdFor正常系 | E-09 L108 | ○ |
| C-103 | DeviceInfoCache::GetIdFor異常系 | E-09 L108 | ○ |
| C-104 | DeviceInfoCache::GetCompilationDevice | E-09 L112-114 | ○ |
| C-105 | DeviceNameToDeviceType | E-09 L152-153 | ○ |
| C-106 | PickDeviceForXla正常系 | E-09 L189-191 | ○ |
| C-107 | PickDeviceForXla異常系 | E-09 L189-191 | ○ |
| C-108 | MaybePickDeviceForXla | E-09 L198-200 | ○ |

### Flags (UT-JIT-109 - UT-JIT-115)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | SetXlaAutoJitFlagFromFlagString(数値) | E-10 L52 | ○ |
| C-110 | SetXlaAutoJitFlagFromFlagString(single-gpu) | E-10 L52 | ○ |
| C-111 | SetXlaAutoJitFlagFromFlagString(無効) | E-10 L52 | ○ |
| C-112 | GetMarkForCompilationPassFlags | E-10 L328 | ○ |
| C-113 | DisableXlaCompilation | E-10 L355 | ○ |
| C-114 | EnableXlaCompilation | E-10 L359 | ○ |
| C-115 | FailOnXlaCompilation | E-10 L362 | ○ |

### EncapsulateSubgraphsPass (UT-JIT-116 - UT-JIT-120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | EncapsulateSubgraphsPassコンストラクタ | E-11 L34 | ○ |
| C-117 | EncapsulateSubgraphsPass::Run | E-11 L36 | ○ |
| C-118 | EncapsulateSubgraphsInFunctions | E-11 L75-78 | ○ |
| C-119 | IsXlaCompiledKernel(true) | E-11 L85 | ○ |
| C-120 | IsXlaCompiledKernel(false) | E-11 L85 | ○ |

### VariableInfo (UT-JIT-121 - UT-JIT-126)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | VariableInfoコンストラクタ | E-12 L36-38 | ○ |
| C-122 | VariableInfo::index | E-12 L48 | ○ |
| C-123 | VariableInfo::var | E-12 L52 | ○ |
| C-124 | VariableInfo::name | E-12 L55 | ○ |
| C-125 | VariableInfo::lock_held | E-12 L59 | ○ |
| C-126 | VariableInfo::set_lock_held | E-12 L60 | ○ |

### XlaTensor (UT-JIT-127 - UT-JIT-136)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-127 | XlaTensor::FromTensor(XlaTensor) | E-13 L40 | ○ |
| C-128 | XlaTensor::FromTensor(通常) | E-13 L40 | ○ |
| C-129 | XlaTensor::DeviceMemoryFromTensor | E-13 L46-47 | ○ |
| C-130 | XlaTensor::AllocateShapedBuffer | E-13 L52-55 | ○ |
| C-131 | has_shaped_buffer(true) | E-13 L61 | ○ |
| C-132 | has_shaped_buffer(false) | E-13 L61 | ○ |
| C-133 | shaped_buffer | E-13 L64-71 | ○ |
| C-134 | set_shaped_buffer | E-13 L73-75 | ○ |
| C-135 | WaitForDefinitionEventOnStream | E-13 L80 | ○ |
| C-136 | ResetDefinitionEvent | E-13 L88-89 | ○ |

### ShapeInference (UT-JIT-137 - UT-JIT-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-137 | InferShapes正常系 | E-14 L47-50 | ○ |
| C-138 | InferShapes境界値 | E-14 L47-50 | ○ |
| C-139 | MergeInferredShapes正常系 | E-14 L54-55 | ○ |
| C-140 | MergeInferredShapes異常系 | E-14 L54-55 | ○ |

### ResourceOperationSafetyAnalysis (UT-JIT-141 - UT-JIT-142)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-141 | ComputeIncompatibleResourceOperationPairs正常系 | E-15 L62-66 | ○ |
| C-142 | ComputeIncompatibleResourceOperationPairs境界値 | E-15 L62-66 | ○ |

### XlaPlatformInfo (UT-JIT-143 - UT-JIT-155)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-143 | XlaPlatformInfoコンストラクタ | E-16 L39-48 | ○ |
| C-144 | UseMultipleStreams | E-16 L52-54 | ○ |
| C-145 | device_type | E-16 L62 | ○ |
| C-146 | platform_id | E-16 L66 | ○ |
| C-147 | is_on_xla_device | E-16 L73 | ○ |
| C-148 | ParseVisibleDeviceList正常系 | E-16 L107-108 | ○ |
| C-149 | ParseVisibleDeviceList空文字 | E-16 L107-108 | ○ |
| C-150 | GetCompilationDeviceType | E-16 L112-113 | ○ |
| C-151 | BuildXlaDeviceCompiler | E-16 L120-124 | ○ |
| C-152 | GetOrCreatePjRtDeviceCompilerAndProfiler | E-16 L136-141 | ○ |
| C-153 | XlaPlatformInfoFromDevice | E-16 L153 | ○ |
| C-154 | GetPersistentCacheDirectory | E-16 L157-158 | ○ |
| C-155 | GetAllocator | E-16 L167-169 | ○ |

### PjRtDeviceContext (UT-JIT-156 - UT-JIT-161)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-156 | PjRtDeviceContextコンストラクタ | E-17 L31-35 | ○ |
| C-157 | CopyCPUTensorToDevice | E-17 L37-39 | ○ |
| C-158 | CopyDeviceTensorToCPU | E-17 L40-42 | ○ |
| C-159 | CopyTensorInSameDevice | E-17 L43-45 | ○ |
| C-160 | use_pjrt_tensor_buffer | E-17 L47 | ○ |
| C-161 | PjRtDeviceToDeviceCopy | E-17 L55-60 | ○ |

### XLA Ops Kernels (UT-JIT-162 - UT-JIT-170)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-162 | XlaLocalLaunchBaseコンストラクタ | E-18 L51-54 | ○ |
| C-163 | XlaLocalLaunchBase::ComputeAsync | E-18 L59 | ○ |
| C-164 | XlaLocalLaunchOpコンストラクタ | E-18 L84 | ○ |
| C-165 | XlaCompileOpコンストラクタ | E-18 L94 | ○ |
| C-166 | XlaCompileOp::Compute | E-18 L96 | ○ |
| C-167 | XlaRunOpコンストラクタ | E-18 L125 | ○ |
| C-168 | XlaRunOp::Compute | E-18 L127 | ○ |
| C-169 | XlaMergeOpコンストラクタ | E-18 L135 | ○ |
| C-170 | XlaMergeOp::Compute | E-18 L137 | ○ |

### Optimization Passes (UT-JIT-171 - UT-JIT-181)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-171 | BuildXlaOpsPassコンストラクタ | E-19 L33-35 | ○ |
| C-172 | BuildXlaOpsPass::Run | E-19 L37 | ○ |
| C-173 | BuildXlaOpsPassグラフ変換 | E-19 L25-27 | ○ |
| C-174 | PartiallyDeclusterPassコンストラクタ | E-20 L28 | ○ |
| C-175 | PartiallyDeclusterPass::Run | E-20 L30 | ○ |
| C-176 | PartiallyDeclusterPassデクラスタリング | E-20 L23-27 | ○ |
| C-177 | ClusterScopingPassコンストラクタ | E-21 L31 | ○ |
| C-178 | ClusterScopingPass::Run | E-21 L33 | ○ |
| C-179 | ClusterScopingPassスコープ設定 | E-21 L23-30 | ○ |
| C-180 | RegisterXlaDeviceKernels | E-01 L310-316 | ○ |
| C-181 | DefaultPaddedShapeFn | E-01 L318 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全てのテストケースがソースコードのヘッダーファイルに定義されたパブリックAPIに基づいています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードの根拠に基づいています
- 注意点：
  - 実装ファイル(.cc)の詳細なロジックに依存するテストケースは、実装変更時に更新が必要になる可能性があります
  - テンプレートクラス（DeviceCompiler）のテストは、具体的な型パラメータによって動作が異なる可能性があります

## 6) レビュアーチェックリスト（最小）
- [ ] 主要なパブリックAPIがカバーされているか確認
- [ ] 正常系・異常系・境界値のバランスが適切か確認
- [ ] 優先度の設定が適切か確認（高：コア機能、中：補助機能、低：ユーティリティ）
- [ ] テストケース名が具体的で理解しやすいか確認
- [ ] 前提条件と期待結果の整合性を確認
