---
generated_at: 2026-02-03 15:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：compiler-tf2tensorrt 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **UT-TRT-095 TrtAlgorithmSelector**：algorithm_selector.hの詳細実装未確認
  2. **UT-TRT-096 TimingCache**：timing_cache.hの詳細実装未確認
  3. **UT-TRT-097 TrtPluginInterface**：plugin/trt_plugin.hの詳細実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `tensorflow/compiler/tf2tensorrt/trt_convert_api.h` - ConvertAndBuild API定義
- E-02: `tensorflow/compiler/tf2tensorrt/trt_convert_api.cc` - ConvertAndBuild実装、ValidateConversionParams、GetNodeNames
- E-03: `tensorflow/compiler/tf2tensorrt/common/utils.h` - GetLinkedTensorRTVersion、GetTrtBindingIndex、IONamePrefixes、マクロ定義
- E-04: `tensorflow/compiler/tf2tensorrt/common/utils.cc` - GetLinkedTensorRTVersion、GetLoadedTensorRTVersion、GetTrtBindingIndex、MaybeInitializeTrtPlugins実装
- E-05: `tensorflow/compiler/tf2tensorrt/common/datavec.h` - InputOutputData、DataVec定義
- E-06: `tensorflow/compiler/tf2tensorrt/segment/segment.h` - SegmentGraph、SegmentOptions、Segment構造体
- E-07: `tensorflow/compiler/tf2tensorrt/segment/union_find.h` - ClusterBatchSize、ClusterProperty、UnionFind
- E-08: `tensorflow/compiler/tf2tensorrt/convert/convert_graph.h` - ConvertGraph、GetDeviceAndAllocator、RegisterGraphToFunctionLibrary、CreateStaticEngine
- E-09: `tensorflow/compiler/tf2tensorrt/convert/convert_nodes.h` - EngineConnection、EngineInfo、TrtNodeValidator、Converter、OutputEdgeValidator
- E-10: `tensorflow/compiler/tf2tensorrt/convert/utils.h` - DimsAdapter、TrtUniquePtrType、VectorTensorShapeHasher、TfTypeToTrtType
- E-11: `tensorflow/compiler/tf2tensorrt/convert/weights.h` - TRT_ShapedWeights、TrtWeightStore、TRT_TensorOrWeights
- E-12: `tensorflow/compiler/tf2tensorrt/utils/trt_lru_cache.h` - LRUCache、EngineContext、CalibrationContext、TRTEngineCacheResource
- E-13: `tensorflow/compiler/tf2tensorrt/utils/trt_allocator.h` - Align、TRTBaseAllocator、TRTDeviceAllocator
- E-14: `tensorflow/compiler/tf2tensorrt/utils/trt_shape_optimization_profiles.h` - OptimizationProfileConfig、TrtShapeOptimizationProfile
- E-15: `tensorflow/compiler/tf2tensorrt/utils/trt_int8_calibrator.h` - TRTInt8Calibrator
- E-16: `tensorflow/compiler/tf2tensorrt/kernels/trt_engine_op.cc` - TRTEngineOp、ContextDeviceMemory
- E-17: `tensorflow/compiler/tf2tensorrt/kernels/trt_engine_resource_ops.cc` - CreateTRTResourceHandle、InitializeTRTResource、SerializeTRTResource
- E-18: `tensorflow/compiler/tf2tensorrt/utils/trt_logger.h` - Logger
- E-19: `tensorflow/compiler/tf2tensorrt/utils/trt_engine_utils.h` - ExecutionContext
- E-20: `tensorflow/compiler/tf2tensorrt/convert/op_converter_registry.h` - OpConverterRegistry
- E-21: `tensorflow/compiler/tf2tensorrt/convert/algorithm_selector.h` - TrtAlgorithmSelector
- E-22: `tensorflow/compiler/tf2tensorrt/convert/timing_cache.h` - TimingCache
- E-23: `tensorflow/compiler/tf2tensorrt/plugin/trt_plugin.h` - TrtPluginInterface
- E-24: `tensorflow/compiler/tf2tensorrt/convert/logger_registry.h` - LoggerRegistry
- E-25: `tensorflow/compiler/tf2tensorrt/convert/trt_parameters.h` - TrtPrecisionMode、ProfileStrategy

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConvertAndBuild(GraphDef)で変換成功 | E-01, E-02 | ○ |
| C-02 | ConvertAndBuild(SavedModelBundle)で変換成功 | E-01, E-02 | ○ |
| C-03 | INT8+キャリブレーションでエラー | E-02 (ValidateConversionParams) | ○ |
| C-04 | 静的エンジン変換で入力なしエラー | E-02 (ValidateConversionParams) | ○ |
| C-05 | ValidateConversionParamsでOK | E-02 | ○ |
| C-06 | GetNodeNamesでノード名抽出 | E-02 | ○ |
| C-07 | GetNodeNamesで空ベクタ | E-02 | ○ |
| C-08 | GetLinkedTensorRTVersionでバージョン取得 | E-03, E-04 | ○ |
| C-09 | GetLoadedTensorRTVersionでランタイム取得 | E-04 | ○ |
| C-10 | GetTrtBindingIndex(name)でインデックス取得 | E-03, E-04 | ○ |
| C-11 | GetTrtBindingIndex(name)でNotFound | E-04 | ○ |
| C-12 | GetTrtBindingIndex(index)でインデックス取得 | E-04 | ○ |
| C-13 | MaybeInitializeTrtPluginsでプラグイン初期化 | E-04 | ○ |
| C-14 | SegmentGraphでセグメント抽出 | E-06 | ○ |
| C-15 | SegmentGraphで最小サイズ未満 | E-06 | ○ |
| C-16 | SegmentGraphで候補なし | E-06 | ○ |
| C-17 | ClusterBatchSize.SetBatchSize | E-07 | ○ |
| C-18 | ClusterBatchSize.MergeIfCompatible成功 | E-07 | ○ |
| C-19 | ClusterBatchSize.MergeIfCompatible失敗 | E-07 | ○ |
| C-20 | UnionFind.Merge | E-07 | ○ |
| C-21 | UnionFind.FindRoot | E-07 | ○ |
| C-22 | ConvertGraphで変換成功 | E-08 | ○ |
| C-23 | GetDeviceAndAllocator | E-08 | ○ |
| C-24 | RegisterGraphToFunctionLibrary | E-08 | ○ |
| C-25 | ConvertSegmentToGraphDef | E-09 | ○ |
| C-26 | ConvertGraphDefToEngine成功 | E-09 | ○ |
| C-27 | ConvertGraphDefToEngine失敗 | E-09 | ○ |
| C-28 | EngineConnection非制御エッジ | E-09 | ○ |
| C-29 | EngineConnection制御エッジ | E-09 | ○ |
| C-30 | TrtNodeValidator.IsTensorRTCandidate成功 | E-09 | ○ |
| C-31 | TrtNodeValidator.IsTensorRTCandidate失敗 | E-09 | ○ |
| C-32 | Converter.Create | E-09 | ○ |
| C-33 | Converter.ConvertNode | E-09 | ○ |
| C-34 | Converter.AddInputTensor | E-09 | ○ |
| C-35 | Converter.BuildCudaEngine | E-09 | ○ |
| C-36 | OutputEdgeValidator | E-09 | ○ |
| C-37 | DimsAdapter.Create(TensorShape) | E-10 | ○ |
| C-38 | DimsAdapter.Create MAX_DIMS超 | E-10 | ○ |
| C-39 | DimsAdapter.AsTrtDims | E-10 | ○ |
| C-40 | DimsAdapter.Volume | E-10 | ○ |
| C-41 | DimsAdapter.IsStatic true | E-10 | ○ |
| C-42 | DimsAdapter.IsStatic false | E-10 | ○ |
| C-43 | TfTypeToTrtType成功 | E-10 | ○ |
| C-44 | TfTypeToTrtType失敗 | E-10 | ○ |
| C-45 | TRT_ShapedWeights.GetTrtWeights | E-11 | ○ |
| C-46 | TRT_ShapedWeights.SetValues | E-11 | ○ |
| C-47 | TRT_ShapedWeights.SetShape | E-11 | ○ |
| C-48 | TrtWeightStore.GetTempWeights | E-11 | ○ |
| C-49 | TRT_TensorOrWeights.is_tensor | E-11 | ○ |
| C-50 | TRT_TensorOrWeights.is_weights | E-11 | ○ |
| C-51 | LRUCache.emplace | E-12 | ○ |
| C-52 | LRUCache.emplace LRU削除 | E-12 | ○ |
| C-53 | LRUCache.at | E-12 | ○ |
| C-54 | LRUCache.at out_of_range | E-12 | ○ |
| C-55 | EngineContext.GetCudaEngine | E-12 | ○ |
| C-56 | EngineContext.GetExecutionContext成功 | E-12 | ○ |
| C-57 | EngineContext.GetExecutionContext失敗 | E-12 | ○ |
| C-58 | TRTEngineCacheResource.GetEngineContext成功 | E-12 | ○ |
| C-59 | TRTEngineCacheResource.GetEngineContext失敗 | E-12 | ○ |
| C-60 | Align | E-13 | ○ |
| C-61 | TRTDeviceAllocator.allocate | E-13 | ○ |
| C-62 | TRTDeviceAllocator.free | E-13 | ○ |
| C-63 | TrtShapeOptimizationProfile.AddShape | E-14 | ○ |
| C-64 | TrtShapeOptimizationProfile.GetProfileNumber成功 | E-14 | ○ |
| C-65 | TrtShapeOptimizationProfile.GetProfileNumber失敗 | E-14 | ○ |
| C-66 | TrtShapeOptimizationProfile.ConfigureBuilder | E-14 | ○ |
| C-67 | TrtShapeOptimizationProfile.CreateExecutionContexts | E-14 | ○ |
| C-68 | OptimizationProfileConfig.IncludesShapes範囲内 | E-14 | ○ |
| C-69 | OptimizationProfileConfig.IncludesShapes min | E-14 | ○ |
| C-70 | OptimizationProfileConfig.IncludesShapes max | E-14 | ○ |
| C-71 | TRTInt8Calibrator.getBatchSize | E-15 | ○ |
| C-72 | TRTInt8Calibrator.getBatch成功 | E-15 | ○ |
| C-73 | TRTInt8Calibrator.getBatch終了後 | E-15 | ○ |
| C-74 | TRTInt8Calibrator.setBatch成功 | E-15 | ○ |
| C-75 | TRTInt8Calibrator.setBatch終了後 | E-15 | ○ |
| C-76 | TRTInt8Calibrator.readCalibrationCache | E-15 | ○ |
| C-77 | TRTInt8Calibrator.writeCalibrationCache | E-15 | ○ |
| C-78 | TRTEngineOp.ComputeAsync成功 | E-16 | ○ |
| C-79 | TRTEngineOp.ComputeAsyncフォールバック | E-16 | ○ |
| C-80 | TRTEngineOp.ExecuteCalibration | E-16 | ○ |
| C-81 | TRTEngineOp.VerifyInputShapes成功 | E-16 | ○ |
| C-82 | TRTEngineOp.VerifyInputShapes失敗 | E-16 | ○ |
| C-83 | TRTEngineOp.GetEngine成功 | E-16 | ○ |
| C-84 | TRTEngineOp.GetEngine失敗 | E-16 | ○ |
| C-85 | ContextDeviceMemory.AllocateDeviceMemory成功 | E-16 | ○ |
| C-86 | ContextDeviceMemory.AllocateDeviceMemory失敗 | E-16 | ○ |
| C-87 | CreateTRTResourceHandle.Compute | E-17 | ○ |
| C-88 | InitializeTRTResource.Compute成功 | E-17 | ○ |
| C-89 | InitializeTRTResource.Compute空ファイル名 | E-17 | ○ |
| C-90 | SerializeTRTResource.Compute | E-17 | ○ |
| C-91 | TrtPrecisionModeToName | E-25 | ○ |
| C-92 | ProfileStrategyToName | E-25 | ○ |
| C-93 | OpConverterRegistry.GetOpConverter成功 | E-20 | ○ |
| C-94 | OpConverterRegistry.GetOpConverter失敗 | E-20 | ○ |
| C-95 | TrtAlgorithmSelector.selectAlgorithms | E-21 | △ |
| C-96 | TimingCache | E-22 | △ |
| C-97 | TrtPluginInterface | E-23 | △ |
| C-98 | LoggerRegistry.GetInstance | E-24 | △ |
| C-99 | Logger.GetLogger | E-18 | ○ |
| C-100 | ExecutionContext.Create | E-19 | △ |

## 4) 不足情報（Unknown / Missing）
- **algorithm_selector.h/cc**: TrtAlgorithmSelectorの詳細実装は読み込み対象外であったため、selectAlgorithmsメソッドの詳細な挙動は未確認
  - 候補：algorithm_selector.cc の詳細確認
- **timing_cache.h/cc**: TimingCacheの詳細実装は読み込み対象外
  - 候補：timing_cache.cc の詳細確認
- **trt_plugin.h/cc**: プラグインインターフェースの詳細は読み込み対象外
  - 候補：plugin/trt_plugin.cc の詳細確認
- **logger_registry.h/cc**: LoggerRegistryの詳細実装は読み込み対象外
  - 候補：logger_registry.cc の詳細確認
- **trt_engine_utils.h/cc**: ExecutionContext::Createの詳細実装は読み込み対象外
  - 候補：trt_engine_utils.cc の詳細確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: UT-TRT-091〜092, UT-TRT-096〜098（補助的機能、影響範囲小）
- **1（中リスク）**: UT-TRT-006〜007, UT-TRT-017〜021, UT-TRT-037〜050, UT-TRT-060〜077, UT-TRT-081〜082, UT-TRT-087, UT-TRT-089, UT-TRT-093〜095, UT-TRT-099〜100（ユーティリティ・補助機能）
- **2（高リスク）**: UT-TRT-001〜005, UT-TRT-010〜016, UT-TRT-022〜036, UT-TRT-051〜059, UT-TRT-061〜067, UT-TRT-078〜080, UT-TRT-083〜086, UT-TRT-088, UT-TRT-090（コア機能、エンジン変換・実行に直接影響）

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度（高リスク）のテストケースがコア機能を適切にカバーしているか
- [ ] ConvertAndBuild APIのエラーハンドリングが網羅されているか
- [ ] LRUCacheの境界値テスト（容量0、容量1、容量超過）が十分か
- [ ] TRTEngineOpのフォールバック動作が適切にテストされているか
- [ ] INT8キャリブレーションのテストケースがC++インターフェースの制限を考慮しているか
- [ ] △マークの5件（C-95〜C-100）について、実装詳細を確認し必要に応じてテストケースを追加または修正
