---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：core-activity_watcher.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **UT-ACW-018, UT-ACW-021, UT-ACW-022**：TF_ENABLE_ACTIVITY_WATCHER有効時の実際の動作はスタブ実装のため確認困難
  2. **UT-ACW-056**：merge()の動作仕様が実装依存（abseil flat_hash_mapの仕様確認が必要）
  3. **UT-ACW-037, UT-ACW-038**：グローバル状態のテストは他テストへの影響に注意

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/activity_watcher/activity.h` - Activity構造体、ActivityCategory enum、ActivityScope クラス、関数テンプレート定義
- E-02: `tensorflow/core/activity_watcher/activity.cc` - スタブ実装（RecordActivityStart, RecordActivityEnd, MaybeEnableMultiWorkersWatching）
- E-03: `tensorflow/core/activity_watcher/activity_utils.h` - ActivityFromContext関数宣言
- E-04: `tensorflow/core/activity_watcher/activity_utils.cc` - ActivityFromContext関数実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ToString(kCollective)が"Collective"を返す | E-01 (L49-51) | ○ |
| C-02 | ToString(kRemoteFunction)が"Remote Function"を返す | E-01 (L52-53) | ○ |
| C-03 | ToString(kMisc)が"Miscellaneous"を返す | E-01 (L54-55) | ○ |
| C-04 | ToString(kDatasetOp)が"Dataset Op"を返す | E-01 (L56-57) | ○ |
| C-05 | ToString(kTpuOp)が"TPU Op"を返す | E-01 (L58-59) | ○ |
| C-06 | ToString(kRendezvous)が"Rendezvous"を返す | E-01 (L60-61) | ○ |
| C-07 | Activityデフォルトコンストラクタの動作 | E-01 (L74) | ○ |
| C-08 | Activity 2引数コンストラクタの動作 | E-01 (L75-76) | ○ |
| C-09 | Activity 3引数コンストラクタの動作 | E-01 (L77-80) | ○ |
| C-10 | 空titleでのActivity生成 | E-01 (L75-76) | ○ |
| C-11 | 空attributesでのActivity生成 | E-01 (L77-80) | ○ |
| C-12 | 複数attributesでのActivity生成 | E-01 (L67, L77-80) | ○ |
| C-13 | WatcherEnabled無効時にfalse | E-01 (L99-101), E-02 (L27) | ○ |
| C-14 | WatcherEnabled有効でlevel以上時にtrue | E-01 (L99-101) | ○ |
| C-15 | WatcherEnabled有効でlevel未満時にfalse | E-01 (L99-101) | ○ |
| C-16 | WatcherEnabled level=0の境界値 | E-01 (L99-101) | ○ |
| C-17 | WatcherEnabledデフォルトlevel=1 | E-01 (L99) | ○ |
| C-18 | ActivityStartウォッチャー有効時の動作 | E-01 (L134-142) | ○ |
| C-19 | ActivityStartウォッチャー無効時の動作 | E-01 (L134-142) | ○ |
| C-20 | ActivityStartマクロ未定義時の動作 | E-01 (L135, L140-141) | ○ |
| C-21 | ActivityStartのlevel指定（記録される場合） | E-01 (L136-139) | ○ |
| C-22 | ActivityStartのlevel指定（記録されない場合） | E-01 (L136-139) | ○ |
| C-23 | ActivityEnd有効ID時の動作 | E-01 (L144-150) | ○ |
| C-24 | ActivityEnd無効ID時のスキップ | E-01 (L146) | ○ |
| C-25 | ActivityEndマクロ未定義時の動作 | E-01 (L145, L149) | ○ |
| C-26 | ActivityScopeコンストラクタでの開始記録 | E-01 (L168-170) | ○ |
| C-27 | ActivityScopeデストラクタでの終了記録 | E-01 (L175) | ○ |
| C-28 | ActivityScopeムーブコンストラクタの動作 | E-01 (L171-174) | ○ |
| C-29 | ムーブ後の二重終了防止 | E-01 (L173, L175), E-01 (L146) | ○ |
| C-30 | ウォッチャー無効時のActivityScope動作 | E-01 (L169), E-01 (L141) | ○ |
| C-31 | RecordActivityStartスタブ実装 | E-02 (L28-30) | ○ |
| C-32 | RecordActivityStartへのnullptr入力 | E-02 (L28-30) | ○ |
| C-33 | RecordActivityEndスタブ実装 | E-02 (L31) | ○ |
| C-34 | RecordActivityEndへの無効ID | E-02 (L31) | ○ |
| C-35 | MaybeEnableMultiWorkersWatchingスタブ | E-02 (L23) | ○ |
| C-36 | MaybeEnableMultiWorkersWatchingへのnullptr | E-02 (L23) | ○ |
| C-37 | g_watcher_level初期値 | E-02 (L27), E-01 (L37) | ○ |
| C-38 | g_watcher_levelアトミック操作 | E-02 (L27), E-01 (L18, L100) | ○ |
| C-39 | ActivityFromContext正常動作 | E-04 (L31-57) | ○ |
| C-40 | node_name属性の設定 | E-04 (L37) | ○ |
| C-41 | step_id属性の設定 | E-04 (L38) | ○ |
| C-42 | device属性の設定 | E-04 (L39) | ○ |
| C-43 | op属性の設定 | E-04 (L40) | ○ |
| C-44 | iter_num属性の設定 | E-04 (L41) | ○ |
| C-45 | inputs属性の設定 | E-04 (L42) | ○ |
| C-46 | original_node_names属性の設定 | E-04 (L43-47) | ○ |
| C-47 | original_func_names属性の設定 | E-04 (L48-52) | ○ |
| C-48 | additional_attributesのマージ | E-04 (L34, L36) | ○ |
| C-49 | context=nullptrでのActivity生成 | E-04 (L35, L56) | ○ |
| C-50 | context=nullptr時の属性スキップ | E-04 (L35) | ○ |
| C-51 | 空additional_attributesでの動作 | E-04 (L34) | ○ |
| C-52 | 空nameでの動作 | E-04 (L56) | ○ |
| C-53 | kCollectiveカテゴリでの生成 | E-04 (L56) | ○ |
| C-54 | kRendezvousカテゴリでの生成 | E-04 (L56) | ○ |
| C-55 | 入力0件時のinputs属性 | E-04 (L42) | ○ |
| C-56 | merge時のキー衝突動作 | E-04 (L36) | △ |
| C-57 | is_invocable_r正しいシグネチャ | E-01 (L107-111) | ○ |
| C-58 | is_invocable_r不正なシグネチャ | E-01 (L107-111) | ○ |
| C-59 | is_activity_generator有効なジェネレータ | E-01 (L116-117) | ○ |
| C-60 | is_activity_generator無効なジェネレータ | E-01 (L116-117) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-56 (merge動作)**: `absl::flat_hash_map::merge()`の正確な動作仕様（同一キー時の振る舞い）はabseilライブラリのドキュメントを参照する必要がある
  - 候補: abseil公式ドキュメント / absl/container/flat_hash_map.h
- **C-60 (is_activity_generator無効なジェネレータ)**: テンプレートメタプログラミングによるSFINAE動作の検証には実際のコンパイル結果が必要
  - 候補: コンパイル時テスト / static_assert確認

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 基本的な構造体・列挙型の定義はコードから直接確認可能
- **1 (中リスク)**: スタブ実装のテスト（実際の記録機能は別モジュールで実装される可能性）
- **1 (中リスク)**: TF_ENABLE_ACTIVITY_WATCHERマクロの有無による条件分岐（ビルド設定依存）
- **1 (中リスク)**: グローバル変数`g_watcher_level`を使用するテストは並列実行時に注意

## 6) レビュアーチェックリスト（最小）
- [ ] ActivityCategory enumの全値に対するToString()テストが網羅されているか
- [ ] Activity構造体の各コンストラクタに対するテストが網羅されているか
- [ ] ActivityScopeのRAIIパターン（生成・破棄・ムーブ）が正しくテストされているか
- [ ] WatcherEnabled()のレベル制御ロジックが正しくテストされているか
- [ ] ActivityFromContext()のcontext=nullptr時の分岐が正しくテストされているか
- [ ] TF_ENABLE_ACTIVITY_WATCHER定義の有無による動作差異を考慮しているか
- [ ] グローバル変数g_watcher_levelのテストが他テストに影響しないよう設計されているか
