---
generated_at: 2026-02-03 16:30:00
metrics:
  claims_total: 114
  claims_with_evidence: 108
  claims_without_evidence: 6
confidence_derived: 0.95
---

# 根拠レポート：core-common_runtime 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内のクラス・メソッド定義、条件分岐、エラーハンドリングなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が実際のコードロジックと矛盾していないか
3. **網羅性**：主要なクラス・メソッド・境界条件を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：108 / 114、根拠なし：6
- 優先レビュー（高）
  1. **GPUデバイス関連テスト（UT-CRT-097〜100）**：環境依存の動作検証が必要
  2. **Executor非同期実行テスト（UT-CRT-075）**：実行フローの詳細確認が必要
  3. **RingAlg待機動作テスト（UT-CRT-092）**：スレッド同期の動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/common_runtime/session_factory.cc` - SessionFactory::Register, SessionFactory::GetFactory
- E-02: `tensorflow/core/common_runtime/device_set.cc` - DeviceSet::AddDevice, FindMatchingDevices, FindDeviceByName, PrioritizedDeviceTypeList, SortPrioritizedDeviceTypeVector, SortPrioritizedDeviceVector
- E-03: `tensorflow/core/common_runtime/graph_optimizer.cc` - GraphOptimizer constructor, Optimize method
- E-04: `tensorflow/core/common_runtime/pool_allocator.cc` - PoolAllocator constructor, AllocateRaw, DeallocateRaw, Clear, BasicCPUAllocator::Alloc, Free
- E-05: `tensorflow/core/common_runtime/rendezvous_mgr.cc` - RefCountedIntraProcessRendezvous, PrivateIntraProcessRendezvous
- E-06: `tensorflow/core/common_runtime/request_cost.cc` - RequestCost::RecordCost, ScaleCosts, GetCosts, RecordMetrics, GetMetrics, RecordBatchMetrics, ScaleBatchCosts, GetBatchMetrics
- E-07: `tensorflow/core/common_runtime/graph_runner.cc` - GraphRunner constructor, Run, SimpleRendezvous
- E-08: `tensorflow/core/common_runtime/local_device.cc` - LocalDevice constructor, EigenThreadPoolInfo
- E-09: `tensorflow/core/common_runtime/dynamic_device_mgr.cc` - DynamicDeviceMgr constructor, ListDevices, LookupDevice, AddDevices, RemoveDevices, ContainsDevice, NumDevices, NumDeviceType, HostCPU
- E-10: `tensorflow/core/common_runtime/executor.cc` - ExecutorImpl::Initialize, RunAsyncInternal, KernelStats
- E-11: `tensorflow/core/common_runtime/optimization_registry.cc` - OptimizationPassRegistry::Global, Register, RunGrouping
- E-12: `tensorflow/core/common_runtime/single_threaded_executor.cc` - ValidateOpIsSafeForSyncExecution, SingleThreadedExecutorImpl::Initialize, Run
- E-13: `tensorflow/core/common_runtime/ring_alg.cc` - RingAlg::PCQueue, RingAlg constructor, GenerateSubdivsInCollectiveParams
- E-14: `tensorflow/core/common_runtime/gpu/gpu_bfc_allocator.cc` - GPUBFCAllocator constructor, GetAllowGrowthValue, GetGarbageCollectionValue
- E-15: `tensorflow/core/common_runtime/collective_param_resolver_local.cc` - CollectiveParamResolverLocal constructor, CompleteGroupAsync, GetCollectiveName, CheckUserSpecifiedRanks
- E-16: `tensorflow/core/common_runtime/function.cc` - FunctionLibraryRuntimeOverlay, AddArg, AddRet, Endpoint

## 3) Claims と根拠の対応（レビューの主戦場）

### SessionFactory（UT-CRT-001〜005）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SessionFactory::Registerが正常に登録を行う | E-01 L44-51 | ○ |
| C-02 | 重複登録時にエラーログ出力 | E-01 L48-50 | ○ |
| C-03 | GetFactoryが正しいファクトリを返す | E-01 L68-86 | ○ |
| C-04 | 対応ファクトリなしでNotFoundエラー | E-01 L107-111 | ○ |
| C-05 | 複数候補でInternalエラー | E-01 L87-106 | ○ |

### DeviceSet（UT-CRT-006〜015）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | AddDeviceでデバイスがリストに追加される | E-02 L33-43 | ○ |
| C-07 | AddDevice後にキャッシュがクリアされる | E-02 L36-42 | ○ |
| C-08 | FindMatchingDevicesで一致デバイスが検索される | E-02 L45-63 | ○ |
| C-09 | 一致デバイスなしで空リスト | E-02 L55-60 | ○ |
| C-10 | FindDeviceByNameでデバイス検索 | E-02 L65-67 | ○ |
| C-11 | 存在しないデバイス名でnullptr | E-02 L66 (gtl::FindPtrOrNull) | ○ |
| C-12 | DeviceTypeOrderで優先度が返される | E-02 L69-72 | ○ |
| C-13 | PrioritizedDeviceTypeListで優先度順リスト | E-02 L86-97 | ○ |
| C-14 | nullポインタで何もしない | E-02 L100-101 | ○ |
| C-15 | SortPrioritizedDeviceVectorでソート | E-02 L116-141 | ○ |

### GraphOptimizer（UT-CRT-016〜020）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | L1以上でCSEと定数畳み込みが有効 | E-03 L29-34 | ○ |
| C-17 | Optimizeでグラフ最適化実行 | E-03 L38-158 | ○ |
| C-18 | 定数畳み込みが実行される | E-03 L70-90 | ○ |
| C-19 | CSEが実行される | E-03 L101-109 | ○ |
| C-20 | 最大10ラウンドで終了 | E-03 L47-48 (kMaxRounds = 10) | ○ |

### PoolAllocator（UT-CRT-021〜032）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | pool_size_limit付きで初期化 | E-04 L38-51 | ○ |
| C-22 | auto_resize=trueでlimit=0でアサート | E-04 L47-50 | ○ |
| C-23 | AllocateRawでメモリ割り当て | E-04 L97-136 | ○ |
| C-24 | 0バイトでnullptr | E-04 L98 | ○ |
| C-25 | プールから再利用 | E-04 L112-125 | ○ |
| C-26 | DeallocateRawでプールに戻す | E-04 L138-156 | ○ |
| C-27 | nullptrの解放で何もしない | E-04 L139 | ○ |
| C-28 | プール満杯でevict | E-04 L147-149 | ○ |
| C-29 | Clearで全メモリ解放 | E-04 L158-174 | ○ |
| C-30 | BasicCPUAllocator::Allocでメモリ割り当て | E-04 L262-280 | ○ |
| C-31 | 0バイトでnullptr | E-04 L268 | ○ |
| C-32 | Freeでメモリ解放 | E-04 L282-293 | ○ |

### RendezvousMgr（UT-CRT-033〜037）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | RefCountedIntraProcessRendezvous::Send | E-05 L178-183 | ○ |
| C-34 | RecvAsync | E-05 L185-190 | ○ |
| C-35 | StartAbort | E-05 L192-195 | ○ |
| C-36 | PrivateIntraProcessRendezvous::Send | E-05 L208-214 | ○ |
| C-37 | RecvAsync | E-05 L216-222 | ○ |

### RequestCost（UT-CRT-038〜046）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | RecordCostでコスト記録 | E-06 L29-35 | ○ |
| C-39 | コスト累積 | E-06 L33 (+=演算子) | ○ |
| C-40 | ScaleCostsでスケール | E-06 L37-42 | ○ |
| C-41 | GetCostsでマップ返却 | E-06 L44-47 | ○ |
| C-42 | RecordMetricsでメトリクス記録 | E-06 L49-55 | ○ |
| C-43 | GetMetricsでマップ返却 | E-06 L57-60 | ○ |
| C-44 | RecordBatchMetrics | E-06 L62-65 | ○ |
| C-45 | ScaleBatchCosts | E-06 L67-74 | ○ |
| C-46 | GetBatchMetrics | E-06 L76-79 | ○ |

### GraphRunner（UT-CRT-047〜056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | Envからデバイス作成 | E-07 L96-98 | ○ |
| C-48 | Device指定初期化 | E-07 L99 | ○ |
| C-49 | Runでグラフ実行 | E-07 L103-213 | ○ |
| C-50 | device_=nullでNotFound | E-07 L108-110 | ○ |
| C-51 | 入力テンソル処理 | E-07 L133-143 | ○ |
| C-52 | SimpleRendezvous::Send | E-07 L54-67 | ○ |
| C-53 | deadテンソルでエラー | E-07 L56-58 | ○ |
| C-54 | 重複送信でエラー | E-07 L62-64 | ○ |
| C-55 | RecvAsyncでテンソル受信 | E-07 L69-83 | ○ |
| C-56 | 存在しないキーでエラー | E-07 L76-77 | ○ |

### LocalDevice（UT-CRT-057〜059）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | LocalDevice初期化 | E-08 L111-168 | ○ |
| C-58 | グローバルスレッドプール共有 | E-08 L123-152 | ○ |
| C-59 | NUMA対応設定 | E-08 L132-145 | ○ |

### DynamicDeviceMgr（UT-CRT-060〜073）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | デフォルトコンストラクタ | E-09 L31 | ○ |
| C-61 | デバイスリスト初期化 | E-09 L33-47 | ○ |
| C-62 | ListDevices | E-09 L78-86 | ○ |
| C-63 | LookupDevice成功 | E-09 L110-126 | ○ |
| C-64 | LookupDevice失敗 | E-09 L114-122 | ○ |
| C-65 | AddDevices成功 | E-09 L165-189 | ○ |
| C-66 | AddDevices重複エラー | E-09 L169-173 | ○ |
| C-67 | RemoveDevices成功 | E-09 L191-230 | ○ |
| C-68 | CPUデバイス保護 | E-09 L196-199 | ○ |
| C-69 | 未登録デバイス削除エラー | E-09 L200-203 | ○ |
| C-70 | ContainsDevice | E-09 L128-131 | ○ |
| C-71 | NumDevices | E-09 L160-163 | ○ |
| C-72 | NumDeviceType | E-09 L153-158 | ○ |
| C-73 | HostCPU | E-09 L243-260 | ○ |

### Executor（UT-CRT-074〜078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | ExecutorImpl::Initialize | E-10 L152-156 | ○ |
| C-75 | RunAsyncInternal | E-10 L159 | △ |
| C-76 | KernelStats::Initialize | E-10 L169-180 | ○ |
| C-77 | KernelStats::IsExpensive | E-10 L185-189 | ○ |
| C-78 | UpdateCostEstimate | E-10 L200 | ○ |

### OptimizationRegistry（UT-CRT-079〜082）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | Global | E-11 L27-31 | ○ |
| C-80 | Register | E-11 L33-36 | ○ |
| C-81 | RunGrouping成功 | E-11 L38-106 | ○ |
| C-82 | RunGroupingエラー伝播 | E-11 L80-82 | ○ |

### SingleThreadedExecutor（UT-CRT-083〜089）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | ValidateOpIsSafeForSyncExecution成功 | E-12 L33-61 | ○ |
| C-84 | 参照型出力でエラー | E-12 L36-42 | ○ |
| C-85 | Switchノードでエラー | E-12 L45-51 | ○ |
| C-86 | Initialize成功 | E-12 L85-255 | ○ |
| C-87 | ノード数不一致エラー | E-12 L91-95 | ○ |
| C-88 | Run成功 | E-12 L257-486 | ○ |
| C-89 | 引数数不一致エラー | E-12 L349-353 | ○ |

### RingAlg（UT-CRT-090〜096）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | PCQueue::Enqueue | E-13 L78-84 | ○ |
| C-91 | PCQueue::Dequeue | E-13 L86-98 | ○ |
| C-92 | Dequeue待機動作 | E-13 L88-93 | △ |
| C-93 | RingAlgコンストラクタ | E-13 L100-107 | ○ |
| C-94 | GenerateSubdivsInCollectiveParams | E-13 L110-150 | ○ |
| C-95 | max_subdivs=-1で制限 | E-13 L115-118 | ○ |
| C-96 | 空shapeでエラー | E-13 L121-123 | ○ |

### GPUBFCAllocator（UT-CRT-097〜100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | GPUBFCAllocator初期化 | E-14 L85-99 | ○ |
| C-98 | GetAllowGrowthValueデフォルト | E-14 L33-35 | ○ |
| C-99 | 環境変数オーバーライド | E-14 L37-53 | △ |
| C-100 | GetGarbageCollectionValueデフォルト | E-14 L63-82 | △ |

### CollectiveParamResolverLocal（UT-CRT-101〜107）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | コンストラクタ初期化 | E-15 L46-56 | ○ |
| C-102 | CompleteGroupAsync | E-15 L58-62 | ○ |
| C-103 | GetCollectiveName（NCCL無効） | E-15 L65-88 | ○ |
| C-104 | GetCollectiveName（NCCL有効） | E-15 L65-88 | ○ |
| C-105 | CheckUserSpecifiedRanks成功 | E-15 L104-132 | ○ |
| C-106 | 部分ランク指定エラー | E-15 L119-123 | ○ |
| C-107 | 重複ランクエラー | E-15 L125-129 | ○ |

### Function（UT-CRT-108〜114）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | Instantiate | E-16 L169-172 | ○ |
| C-109 | ReleaseHandle | E-16 L173 | ○ |
| C-110 | Run | E-16 L179-190 | △ |
| C-111 | AddArg | E-16 L117-129 | ○ |
| C-112 | AddRet | E-16 L131-145 | ○ |
| C-113 | Endpoint::name（index=0） | E-16 L91-93 | ○ |
| C-114 | Endpoint::name（index>0） | E-16 L91-96 | ○ |

## 4) 不足情報（Unknown / Missing）
- **GPU関連テスト（UT-CRT-097〜100）**：環境変数による動作変更のテストは、実際のGPU環境での検証が必要
  - 候補：GPU環境でのE2Eテスト / 環境変数モックテスト / インテグレーションテスト
- **非同期実行テスト（UT-CRT-075, UT-CRT-092）**：スレッド同期やコールバックの動作は実行時検証が必要
  - 候補：マルチスレッドテスト環境 / タイミング検証テスト
- **関数実行テスト（UT-CRT-110）**：FunctionLibraryRuntimeの完全な動作フローは追加のコンテキストが必要
  - 候補：FunctionLibraryRuntimeImplの実装確認

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：SessionFactory, DeviceSet, RequestCost, GraphRunner - 単純なCRUD操作が中心
- 1（中リスク）：GraphOptimizer, PoolAllocator, Executor - メモリ管理や最適化ロジックを含む
- 2（高リスク）：GPU関連、Collective操作 - 環境依存性が高く、並列処理を含む

## 6) レビュアーチェックリスト（最小）
- [ ] GPU関連テスト（UT-CRT-097〜100）の環境依存性を確認
- [ ] 非同期処理テスト（UT-CRT-075, UT-CRT-092）のスレッド安全性を確認
- [ ] メモリ管理テスト（UT-CRT-021〜032）のリーク検証を確認
- [ ] エラーハンドリングテストの例外メッセージを確認
- [ ] 境界値テストのエッジケースカバレッジを確認
