---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 162
  claims_with_evidence: 162
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：core-data.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：162 / 162、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースはソースコードのヘッダーファイルから直接抽出されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/data/dataset_utils.h` - データセットユーティリティのヘッダー
- E-02: `tensorflow/core/data/name_utils.h` - 名前ユーティリティのヘッダー
- E-03: `tensorflow/core/data/hash_utils.h` - ハッシュユーティリティのヘッダー
- E-04: `tensorflow/core/data/serialization_utils.h` - シリアライゼーションユーティリティのヘッダー
- E-05: `tensorflow/core/data/compression_utils.h` - 圧縮ユーティリティのヘッダー
- E-06: `tensorflow/core/data/split_utils.h` - スプリットユーティリティのヘッダー
- E-07: `tensorflow/core/data/standalone.h` - スタンドアロン実行のヘッダー
- E-08: `tensorflow/core/data/metric_utils.h` - メトリクスユーティリティのヘッダー
- E-09: `tensorflow/core/data/unbounded_thread_pool.h` - スレッドプールのヘッダー
- E-10: `tensorflow/core/data/root_dataset.h` - ルートデータセットのヘッダー
- E-11: `tensorflow/core/data/utils.h` - 汎用ユーティリティのヘッダー
- E-12: `tensorflow/core/data/stats_utils.h` - 統計ユーティリティのヘッダー
- E-13: `tensorflow/core/data/service/common.h` - データサービス共通定義のヘッダー
- E-14: `tensorflow/core/data/service/url.h` - URL処理のヘッダー
- E-15: `tensorflow/core/data/service/byte_size.h` - バイトサイズクラスのヘッダー
- E-16: `tensorflow/core/data/service/auto_scaler.h` - オートスケーラーのヘッダー
- E-17: `tensorflow/core/data/service/snapshot/path_utils.h` - スナップショットパスユーティリティのヘッダー
- E-18: `tensorflow/core/data/service/snapshot/file_utils.h` - スナップショットファイルユーティリティのヘッダー
- E-19: `tensorflow/core/data/service/data_transfer.h` - データ転送のヘッダー
- E-20: `tensorflow/core/data/rewrite_utils.h` - 書き換えユーティリティのヘッダー
- E-21: `tensorflow/core/data/finalization_utils.h` - ファイナライゼーションユーティリティのヘッダー

## 3) Claims と根拠の対応（レビューの主戦場）

### dataset_utils.h 関連（UT-DAT-001〜029）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateWeakHandle正常系テスト | E-01（51-63行目） | ○ |
| C-02 | CreateWeakHandle異常系テスト | E-01（51-63行目） | ○ |
| C-03 | CreateHandle正常系テスト | E-01（67-76行目） | ○ |
| C-04 | VerifyTypesMatch正常系テスト（一致） | E-01（144-145行目） | ○ |
| C-05 | VerifyTypesMatch異常系テスト（不一致） | E-01（144-145行目） | ○ |
| C-06 | VerifyTypesMatch境界値テスト（空配列） | E-01（144-148行目） | ○ |
| C-07 | VerifyShapesCompatible正常系テスト | E-01（152-158行目） | ○ |
| C-08 | VerifyShapesCompatible異常系テスト | E-01（152-158行目） | ○ |
| C-09 | DeterminismPolicy::FromString正常系 | E-01（183行目） | ○ |
| C-10 | DeterminismPolicy::FromString異常系 | E-01（183行目） | ○ |
| C-11 | DeterminismPolicy::IsDeterministic | E-01（190行目） | ○ |
| C-12 | DeterminismPolicy::IsNondeterministic | E-01（191-193行目） | ○ |
| C-13 | MaybeOverrideSeeds（ゼロシード） | E-01（205-206行目） | ○ |
| C-14 | MaybeOverrideSeeds（非ゼロシード） | E-01（205-206行目） | ○ |
| C-15 | AddToFunctionLibrary | E-01（211-214行目） | ○ |
| C-16 | IsFunctionStateful | E-01（217-218行目） | ○ |
| C-17 | IsNodeStateful | E-01（221-222行目） | ○ |
| C-18 | MatchesAnyVersion（一致） | E-01（256-257行目） | ○ |
| C-19 | MatchesAnyVersion（不一致） | E-01（256-257行目） | ○ |
| C-20 | MaybeCopySubSlice | E-01（261行目） | ○ |
| C-21 | MaybeCopySubSlice境界値 | E-01（261行目） | ○ |
| C-22 | CopyPartialBatch | E-01（267-268行目） | ○ |
| C-23 | ReadBatch | E-01（271-273行目） | ○ |
| C-24 | WriteBatch | E-01（276-279行目） | ○ |
| C-25 | GetExperiments | E-01（312-315行目） | ○ |
| C-26 | GetOptimizations | E-01（323-326行目） | ○ |
| C-27 | ShouldConfigureMaxIntraOpParallelism | E-01（336行目） | ○ |
| C-28 | ShouldUsePrivateThreadPool | E-01（339行目） | ○ |
| C-29 | ShouldUseAutotuning | E-01（342行目） | ○ |

### name_utils.h 関連（UT-DAT-030〜034）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | ArgsToString正常系 | E-02（53行目） | ○ |
| C-31 | ArgsToString境界値（空） | E-02（53行目） | ○ |
| C-32 | OpName | E-02（58-69行目） | ○ |
| C-33 | DatasetDebugString | E-02（75-86行目） | ○ |
| C-34 | IteratorPrefix | E-02（92-103行目） | ○ |

### hash_utils.h 関連（UT-DAT-035〜040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | HashNode | E-03（33-35行目） | ○ |
| C-36 | HashTensor | E-03（41行目） | ○ |
| C-37 | HashGraph | E-03（47行目） | ○ |
| C-38 | CheckGraphsEqual（同一） | E-03（53行目） | ○ |
| C-39 | CheckGraphsEqual（異なる） | E-03（53行目） | ○ |
| C-40 | CheckSubgraphsEqual | E-03（59-60行目） | ○ |

### serialization_utils.h 関連（UT-DAT-041〜055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | ReadElementsFromCheckpoint | E-04（45-47行目） | ○ |
| C-42 | WriteElementsToCheckpoint | E-04（53-55行目） | ○ |
| C-43 | UpdateCheckpointElements | E-04（61-64行目） | ○ |
| C-44 | VariantTensorDataReader::Contains（存在） | E-04（72-73行目） | ○ |
| C-45 | VariantTensorDataReader::Contains（不在） | E-04（72-73行目） | ○ |
| C-46 | VariantTensorDataReader::ReadScalar | E-04（75-80行目） | ○ |
| C-47 | VariantTensorDataReader::ReadTensor | E-04（81-87行目） | ○ |
| C-48 | VariantTensorDataWriter::WriteScalar | E-04（122-128行目） | ○ |
| C-49 | VariantTensorDataWriter::WriteTensor | E-04（130-132行目） | ○ |
| C-50 | VariantTensorDataWriter::ReleaseData | E-04（136行目） | ○ |
| C-51 | IteratorStateVariant::InitializeFromVariantData | E-04（193-194行目） | ○ |
| C-52 | IteratorStateVariant::Encode | E-04（202行目） | ○ |
| C-53 | IteratorStateVariant::Decode | E-04（207行目） | ○ |
| C-54 | AsGraphDef | E-04（221-223行目） | ○ |
| C-55 | CheckpointStats | E-04（238-239行目） | ○ |

### compression_utils.h 関連（UT-DAT-056〜060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | CompressElement正常系 | E-05（34-35行目） | ○ |
| C-57 | CompressElement異常系（4GB超過） | E-05（33行目コメント） | ○ |
| C-58 | CompressElement境界値（空） | E-05（34-35行目） | ○ |
| C-59 | UncompressElement正常系 | E-05（38-39行目） | ○ |
| C-60 | UncompressElement異常系 | E-05（38-39行目） | ○ |

### split_utils.h 関連（UT-DAT-061〜071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | IndexSplitProvider::GetNext正常系 | E-06（39行目） | ○ |
| C-62 | IndexSplitProvider::GetNext終端 | E-06（39行目） | ○ |
| C-63 | IndexSplitProvider::Reset | E-06（40行目） | ○ |
| C-64 | IndexSplitProvider::Save | E-06（41-42行目） | ○ |
| C-65 | IndexSplitProvider::Restore | E-06（43-44行目） | ○ |
| C-66 | IndexSplitProvider::Cardinality | E-06（45行目） | ○ |
| C-67 | ShardingSplitProvider::GetNext | E-06（60行目） | ○ |
| C-68 | ShardingSplitProvider::Reset | E-06（61行目） | ○ |
| C-69 | GetSplitProviders | E-06（76-77行目） | ○ |
| C-70 | GetSingleSplitProvider正常系 | E-06（82-83行目） | ○ |
| C-71 | GetSingleSplitProvider異常系 | E-06（82-83行目） | ○ |

### standalone.h 関連（UT-DAT-072〜080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | Iterator::GetNext正常系 | E-07（88行目） | ○ |
| C-73 | Iterator::GetNext終端 | E-07（88行目） | ○ |
| C-74 | Iterator::Save | E-07（92行目） | ○ |
| C-75 | Iterator::Restore | E-07（96行目） | ○ |
| C-76 | Dataset::FromGraph正常系 | E-07（129-130行目） | ○ |
| C-77 | Dataset::FromGraph異常系 | E-07（129-130行目） | ○ |
| C-78 | Dataset::MakeIterator | E-07（135行目） | ○ |
| C-79 | Dataset::MakeSplitProviders | E-07（142-143行目） | ○ |
| C-80 | Dataset::Get | E-07（145行目） | ○ |

### metric_utils.h 関連（UT-DAT-081〜082）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | IteratorMetricsCollector::RecordStart | E-08（54行目） | ○ |
| C-82 | IteratorMetricsCollector::RecordStop | E-08（59行目） | ○ |

### unbounded_thread_pool.h 関連（UT-DAT-083〜085）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | UnboundedThreadPool::Schedule | E-09（49行目） | ○ |
| C-84 | UnboundedThreadPool::get_thread_factory | E-09（47行目） | ○ |
| C-85 | UnboundedThreadPool::NumThreads | E-09（50行目） | ○ |

### root_dataset.h 関連（UT-DAT-086〜090）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | RootDataset::FromOptions | E-10（55-58行目） | ○ |
| C-87 | RootDataset::CardinalityInternal | E-10（65行目） | ○ |
| C-88 | RootDataset::Get | E-10（66-67行目） | ○ |
| C-89 | RootDataset::CheckExternalState | E-10（68行目） | ○ |
| C-90 | FinalizeDataset | E-10（102-103行目） | ○ |

### utils.h 関連（UT-DAT-091〜095）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | AddLatencySample | E-11（32行目） | ○ |
| C-92 | IncrementThroughput | E-11（35行目） | ○ |
| C-93 | TranslateFileName | E-11（39行目） | ○ |
| C-94 | LocalityOptimizedPath | E-11（47行目） | ○ |
| C-95 | DisableCompressionAtRuntime | E-11（51-53行目） | ○ |

### service/common.h 関連（UT-DAT-096〜106）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | IsNoShard | E-13（61行目） | ○ |
| C-97 | IsDynamicShard | E-13（64行目） | ○ |
| C-98 | IsStaticShard | E-13（67行目） | ○ |
| C-99 | ValidateProcessingMode正常系 | E-13（70行目） | ○ |
| C-100 | ValidateProcessingMode異常系 | E-13（70行目） | ○ |
| C-101 | ToAutoShardPolicy | E-13（74-75行目） | ○ |
| C-102 | ParseTargetWorkers正常系 | E-13（79行目） | ○ |
| C-103 | ParseTargetWorkers異常系 | E-13（79行目） | ○ |
| C-104 | TargetWorkersToString | E-13（82行目） | ○ |
| C-105 | ParseDeploymentMode | E-13（86行目） | ○ |
| C-106 | IsPreemptedError | E-13（89行目） | ○ |

### service/url.h 関連（UT-DAT-107〜109）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | URL正常系 | E-14（36行目） | ○ |
| C-108 | URL::has_port（あり） | E-14（39行目） | ○ |
| C-109 | URL::has_port（なし） | E-14（39行目） | ○ |

### service/byte_size.h 関連（UT-DAT-110〜118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | ByteSize::Bytes | E-15（48行目） | ○ |
| C-111 | ByteSize::KB | E-15（53行目） | ○ |
| C-112 | ByteSize::MB | E-15（56行目） | ○ |
| C-113 | ByteSize::GB | E-15（59行目） | ○ |
| C-114 | ByteSize::operator+= | E-15（65行目） | ○ |
| C-115 | ByteSize::operator-=正常系 | E-15（68行目） | ○ |
| C-116 | ByteSize::operator-=境界値 | E-15（68行目、122-128行目） | ○ |
| C-117 | ByteSize::ToUnsignedBytes | E-15（77行目） | ○ |
| C-118 | ByteSize::DebugString | E-15（86行目） | ○ |

### service/auto_scaler.h 関連（UT-DAT-119〜129）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | AutoScaler::GetOptimalNumberOfWorkers正常系 | E-16（75-76行目） | ○ |
| C-120 | AutoScaler::GetOptimalNumberOfWorkers異常系 | E-16（75-76行目） | ○ |
| C-121 | AutoScaler::ReportProcessingTime正常系 | E-16（80-82行目） | ○ |
| C-122 | AutoScaler::ReportProcessingTime異常系（ゼロ） | E-16（78-79行目コメント） | ○ |
| C-123 | AutoScaler::ReportProcessingTime異常系（負） | E-16（78-79行目コメント） | ○ |
| C-124 | AutoScaler::ReportTargetProcessingTime | E-16（86-88行目） | ○ |
| C-125 | AutoScaler::RemoveWorker正常系 | E-16（92-93行目） | ○ |
| C-126 | AutoScaler::RemoveWorker異常系 | E-16（92行目コメント） | ○ |
| C-127 | AutoScaler::RemoveConsumer | E-16（97行目） | ○ |
| C-128 | MultipleIterationsAutoScaler::UnregisterIteration | E-16（122行目） | ○ |
| C-129 | MultipleIterationsAutoScaler::UpdateOptimalNumberOfWorkersMetric | E-16（128-129行目） | ○ |

### service/snapshot/path_utils.h 関連（UT-DAT-130〜137）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-130 | StreamsDirectory | E-17（30行目） | ○ |
| C-131 | StreamDirectory | E-17（33-34行目） | ○ |
| C-132 | SplitsDirectory | E-17（38-39行目） | ○ |
| C-133 | ParseStreamDirectoryName正常系 | E-17（60-61行目） | ○ |
| C-134 | ParseStreamDirectoryName異常系 | E-17（60-61行目） | ○ |
| C-135 | ParseSplitFilename | E-17（78-79行目） | ○ |
| C-136 | ParseCheckpointFilename | E-17（84-85行目） | ○ |
| C-137 | ParseChunkFilename | E-17（90-91行目） | ○ |

### service/snapshot/file_utils.h 関連（UT-DAT-138〜145）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138 | AtomicallyWriteStringToFile | E-18（34-35行目） | ○ |
| C-139 | AtomicallyWriteBinaryProto | E-18（39-41行目） | ○ |
| C-140 | AtomicallyWriteTextProto | E-18（45-47行目） | ○ |
| C-141 | AtomicallyWriteTFRecords | E-18（51-54行目） | ○ |
| C-142 | GetChildren正常系 | E-18（58-59行目） | ○ |
| C-143 | GetChildren境界値（空） | E-18（58-59行目） | ○ |
| C-144 | IsTemporaryFile（一時ファイル） | E-18（63行目） | ○ |
| C-145 | IsTemporaryFile（通常ファイル） | E-18（63行目） | ○ |

### service/data_transfer.h 関連（UT-DAT-146〜151）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-146 | GetElementResult::Copy | E-19（50行目） | ○ |
| C-147 | GetElementResult::EstimatedMemoryUsageBytes | E-19（53行目） | ○ |
| C-148 | DataTransferClient::Register | E-19（89行目） | ○ |
| C-149 | DataTransferClient::Build | E-19（92-93行目） | ○ |
| C-150 | DataTransferServer::Register | E-19（128行目） | ○ |
| C-151 | DataTransferServer::Build | E-19（131-132行目） | ○ |

### rewrite_utils.h 関連（UT-DAT-152〜157）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-152 | CreateRewriterConfig | E-20（46-48行目） | ○ |
| C-153 | RewriteDataset | E-20（52-55行目） | ○ |
| C-154 | GetGrapplerItem | E-20（66-68行目） | ○ |
| C-155 | GetDatasetNode | E-20（72行目） | ○ |
| C-156 | GetDatasetNodeDef | E-20（75行目） | ○ |
| C-157 | SelectOptimizations | E-20（83-87行目） | ○ |

### finalization_utils.h 関連（UT-DAT-158）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-158 | GetFinalizedDataset | E-21（30-31行目） | ○ |

### stats_utils.h 関連（UT-DAT-159〜162）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-159 | ExecutionTimeHistogramName | E-12（36行目） | ○ |
| C-160 | ThreadUtilizationScalarName | E-12（40行目） | ○ |
| C-161 | BufferSizeScalarName | E-12（43行目） | ○ |
| C-162 | BufferUtilizationHistogramName | E-12（50行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
- 全てのテストケースはヘッダーファイルの関数・クラス定義から直接抽出されています

## 5) リスクフラグ（レビュー観点）
- **リスクレベル: 0（低リスク）**
- 全てのテストケースはTensorFlowのcore/dataモジュールのパブリックAPIに基づいています
- 各関数のシグネチャ、パラメータ、戻り値の型がヘッダーファイルで明確に定義されています

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度のテストケース（チェックポイント、圧縮、シリアライゼーション関連）が網羅されているか
- [ ] 異常系テストケースが適切に定義されているか（nullポインタ、不正な入力、境界値）
- [ ] テストケース間の依存関係や前提条件が明確に記載されているか
- [ ] 実際のテスト実装時に必要なモック/スタブの特定が可能か
- [ ] service/ディレクトリ配下の分散処理関連テストが十分にカバーされているか
