---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 98
  claims_with_evidence: 98
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：core-debug.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：98 / 98、根拠なし：0
- 優先レビュー（高）
  1. **UT-DBG-001〜006**: InsertNodes関数の入力検証・早期リターン - ソースコード行51-129から直接導出
  2. **UT-DBG-042〜047**: DebugGrpcChannel接続関連 - gRPC通信の信頼性テスト
  3. **UT-DBG-061〜067**: DebugCallbackRegistry - シングルトン・スレッドセーフ動作の検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/debug/debug_graph_utils.h` - DebugNodeInserterクラス定義
- E-02: `tensorflow/core/debug/debug_graph_utils.cc` - DebugNodeInserterクラス実装
- E-03: `tensorflow/core/debug/debug_io_utils.h` - DebugIO, DebugFileIO, DebugGrpcChannel, DebugGrpcIOクラス定義
- E-04: `tensorflow/core/debug/debug_io_utils.cc` - DebugIO, DebugFileIO, DebugGrpcChannel, DebugGrpcIO実装
- E-05: `tensorflow/core/debug/debug_callback_registry.h` - DebugCallbackRegistryクラス定義
- E-06: `tensorflow/core/debug/debug_callback_registry.cc` - DebugCallbackRegistry実装
- E-07: `tensorflow/core/debug/debug_node_key.h` - DebugNodeKey構造体定義
- E-08: `tensorflow/core/debug/debug_node_key.cc` - DebugNodeKey実装
- E-09: `tensorflow/core/debug/debugger_state_impl.h` - DebuggerState, DebugGraphDecoratorクラス定義
- E-10: `tensorflow/core/debug/debugger_state_impl.cc` - DebuggerState, DebugGraphDecorator実装
- E-11: `tensorflow/core/debug/debug.cc` - DebuggerStateRegistration実装
- E-12: `tensorflow/core/debug/bfc_dump_reader.cc` - BFCメモリダンプリーダー関数群

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DebugNodeInserter::InsertNodesは空watchesでOkStatusを返す | E-02 (行57-60) | ○ |
| C-02 | ワイルドカードノード名でデフォルトデバッグオペレーションが設定される | E-02 (行83-97) | ○ |
| C-03 | ワイルドカードでoutput_slot!=-1はFailedPreconditionエラー | E-02 (行92-96) | ○ |
| C-04 | 非ワイルドカードで負のoutput_slotはエラー | E-02 (行99-106) | ○ |
| C-05 | debug_opsが空の場合スキップ | E-02 (行75-77) | ○ |
| C-06 | debug_urlsが空の場合スキップ | E-02 (行79-81) | ○ |
| C-07 | DeparallelizeWhileLoopsでparallel_iterationsが1に設定 | E-02 (行259-280) | ○ |
| C-08 | GetCopyNodeNameで__copy_接頭辞付き名前生成 | E-02 (行283-288) | ○ |
| C-09 | GetDebugNodeNameで__dbg_接頭辞付き名前生成 | E-02 (行291-299) | ○ |
| C-10 | ParseDebugOpNameで属性なし/ありのパース | E-02 (行366-416) | ○ |
| C-11 | ParseDebugOpNameで不正括弧形式エラー | E-02 (行374-378) | ○ |
| C-12 | ParseDebugOpNameで重複属性キーエラー | E-02 (行406-412) | ○ |
| C-13 | ReadEventFromFileでファイル読み込み | E-04 (行302-330) | ○ |
| C-14 | DebugIO::PublishDebugMetadataでメタデータ発行 | E-04 (行337-423) | ○ |
| C-15 | DebugIO::PublishDebugTensorでテンソルダンプ | E-04 (行425-503) | ○ |
| C-16 | 無効URLスキームでUnavailableエラー | E-04 (行477-480) | ○ |
| C-17 | ディスク容量制限超過でResourceExhaustedエラー | E-04 (行437-446) | ○ |
| C-18 | DebugIO::PublishGraphでグラフ発行 | E-04 (行505-543) | ○ |
| C-19 | IsCopyNodeGateOpenのゲート制御ロジック | E-04 (行545-562) | ○ |
| C-20 | IsDebugNodeGateOpenのゲート制御ロジック | E-04 (行564-581) | ○ |
| C-21 | IsDebugURLGateOpenのゲート制御ロジック | E-04 (行583-594) | ○ |
| C-22 | CloseDebugURLでgRPCストリームクローズ | E-04 (行596-607) | ○ |
| C-23 | DebugFileIO::DumpTensorToDirでテンソルダンプ | E-04 (行609-635) | ○ |
| C-24 | DebugFileIO::GetDumpFilePathでパス生成 | E-04 (行637-659) | ○ |
| C-25 | DebugFileIO::DumpEventProtoToFileでイベント保存 | E-04 (行661-684) | ○ |
| C-26 | requestDiskByteUsageでディスク使用量管理 | E-04 (行738-760) | ○ |
| C-27 | resetDiskByteUsageでディスク使用量リセット | E-04 (行762-765) | ○ |
| C-28 | DebugGrpcChannel::Connectで接続確立 | E-04 (行772-790) | ○ |
| C-29 | DebugGrpcChannel::WriteEventでイベント書き込み | E-04 (行792-795) | ○ |
| C-30 | DebugGrpcChannel::ReadEventReplyで応答読み込み | E-04 (行797-800) | ○ |
| C-31 | DebugGrpcIO::SendTensorThroughGrpcStreamでテンソル送信 | E-04 (行849-874) | ○ |
| C-32 | DebugGrpcIO::IsReadGateOpenでゲート確認 | E-04 (行933-938) | ○ |
| C-33 | DebugGrpcIO::IsWriteGateOpenでゲート確認 | E-04 (行940-950) | ○ |
| C-34 | DebugGrpcIO::CloseGrpcStreamでストリームクローズ | E-04 (行952-968) | ○ |
| C-35 | SetDebugNodeKeyGrpcStateで状態設定 | E-04 (行992-1006) | ○ |
| C-36 | DebugCallbackRegistry::singletonでシングルトン取得 | E-06 (行24-29) | ○ |
| C-37 | RegisterCallbackでコールバック登録 | E-06 (行31-35) | ○ |
| C-38 | GetCallbackでコールバック取得 | E-06 (行37-42) | ○ |
| C-39 | UnregisterCallbackでコールバック解除 | E-06 (行44-47) | ○ |
| C-40 | DebugNodeKeyコンストラクタで初期化 | E-08 (行29-44) | ○ |
| C-41 | DebugNodeKey::operator==で等価比較 | E-08 (行46-51) | ○ |
| C-42 | DebugNodeKey::operator!=で非等価比較 | E-08 (行53-55) | ○ |
| C-43 | DeviceNameToDevicePathでデバイスパス変換 | E-08 (行57-63) | ○ |
| C-44 | DebuggerStateコンストラクタで初期化 | E-10 (行23-33) | ○ |
| C-45 | DebuggerStateデストラクタでURL解放 | E-10 (行35-39) | ○ |
| C-46 | DebuggerState::PublishDebugMetadataでメタデータ発行 | E-10 (行41-50) | ○ |
| C-47 | DebugGraphDecorator::DecorateGraphでグラフ装飾 | E-10 (行52-56) | ○ |
| C-48 | DebugGraphDecorator::PublishGraphでグラフ発行 | E-10 (行58-69) | ○ |
| C-49 | ReadDumpFileでダンプファイル読み込み | E-12 (行26-49) | ○ |
| C-50 | FilterByChunkTypeでチャンクフィルタリング | E-12 (行51-67) | ○ |
| C-51 | PrintChunkでチャンク情報出力 | E-12 (行69-90) | ○ |
| C-52 | PrintSummaryでサマリー出力 | E-12 (行92-113) | ○ |
| C-53 | PrintChunksByAddressでアドレス順ソート出力 | E-12 (行146-154) | ○ |
| C-54 | PrintChunksByActionCountでアクションカウント順ソート出力 | E-12 (行156-165) | ○ |
| C-55 | PrintChunksBySizeでサイズ順ソート出力 | E-12 (行167-175) | ○ |
| C-56 | PrintChunksByOpNameでオペレーション名フィルタ出力 | E-12 (行177-201) | ○ |
| C-57 | PrintSizeHistoryでサイズ履歴出力 | E-12 (行203-225) | ○ |
| C-58 | ParseBoolStringでブール値パース | E-02 (行33-46) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全テストケースはソースコードから直接導出されており、根拠なしの項目はありません
- プロトコルバッファ定義（.proto）は参照していますが、テストケース生成には使用していません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードから直接導出
- gRPC関連テスト（UT-DBG-042〜060）は実際のネットワーク環境でのテストが必要
- ファイルI/O関連テスト（UT-DBG-016〜037）は実際のファイルシステムでのテストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがソースコードの全publicメソッドをカバーしているか確認
- [ ] 異常系テストケースが適切な例外/エラーを期待しているか確認
- [ ] 境界値テストケースが適切な値を使用しているか確認
- [ ] gRPC関連テストのモック戦略が適切か確認
- [ ] ファイルI/O関連テストの一時ファイル管理が適切か確認
- [ ] スレッドセーフティ関連テスト（DebugCallbackRegistry）の並行実行シナリオが十分か確認
