---
generated_at: 2026-02-03 12:05:00
metrics:
  claims_total: 82
  claims_with_evidence: 82
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：core-example.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：82 / 82、根拠なし：0
- 優先レビュー（高）
  1. なし（すべてのテストケースにソースコード根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/example/feature_util.h` - Feature protoアクセスユーティリティのヘッダファイル
- E-02: `tensorflow/core/example/feature_util.cc` - Feature protoアクセスユーティリティの実装ファイル
- E-03: `tensorflow/core/example/example_parser_configuration.h` - ExampleParser設定抽出のヘッダファイル
- E-04: `tensorflow/core/example/example_parser_configuration.cc` - ExampleParser設定抽出の実装ファイル
- E-05: `tensorflow/core/example/feature.proto` - Feature/Features/FeatureList Protocol Buffers定義
- E-06: `tensorflow/core/example/example.proto` - Example/SequenceExample Protocol Buffers定義
- E-07: `tensorflow/core/example/example_parser_configuration.proto` - ExampleParserConfiguration Protocol Buffers定義

## 3) Claims と根拠の対応（レビューの主戦場）

### feature_util.cc - HasFeature関数群

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HasFeature<>は存在するキーでtrueを返す | E-02 (32-34行目) | ○ |
| C-02 | HasFeature<>は存在しないキーでfalseを返す | E-02 (32-34行目) | ○ |
| C-03 | 空のFeaturesでHasFeatureはfalseを返す | E-02 (32-34行目) | ○ |
| C-04 | HasFeature<protobuf_int64>はInt64型で型チェックする | E-02 (37-42行目) | ○ |
| C-05 | HasFeature<protobuf_int64>は異なる型でfalseを返す | E-02 (37-42行目) | ○ |
| C-06 | HasFeature<float>はFloat型で型チェックする | E-02 (44-49行目) | ○ |
| C-07 | HasFeature<float>は異なる型でfalseを返す | E-02 (44-49行目) | ○ |
| C-08 | HasFeature<std::string>はBytes型で型チェックする | E-02 (51-56行目) | ○ |
| C-09 | HasFeature<std::string>は異なる型でfalseを返す | E-02 (51-56行目) | ○ |
| C-10 | HasFeature<tstring>はBytes型で型チェックする | E-02 (58-63行目) | ○ |

### feature_util.cc - HasFeatureList関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | HasFeatureListは存在するキーでtrueを返す | E-02 (65-69行目) | ○ |
| C-12 | HasFeatureListは存在しないキーでfalseを返す | E-02 (65-69行目) | ○ |
| C-13 | 空のSequenceExampleでHasFeatureListはfalseを返す | E-02 (65-69行目) | ○ |

### feature_util.cc - GetFeatureValues関数群

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | GetFeatureValues<protobuf_int64>はint64_list().value()を返す | E-02 (71-75行目) | ○ |
| C-15 | 空のInt64Listで空のRepeatedFieldが返る | E-02 (71-75行目) | ○ |
| C-16 | GetFeatureValues<float>はfloat_list().value()を返す | E-02 (83-87行目) | ○ |
| C-17 | 空のFloatListで空のRepeatedFieldが返る | E-02 (83-87行目) | ○ |
| C-18 | GetFeatureValues<tstring>はbytes_list().value()を返す | E-02 (94-98行目) | ○ |
| C-19 | GetFeatureValues<std::string>はbytes_list().value()を返す | E-02 (100-104行目) | ○ |
| C-20 | mutable GetFeatureValues<protobuf_int64>はmutable_int64_list()を使用 | E-02 (78-81行目) | ○ |
| C-21 | mutable GetFeatureValues<float>はmutable_float_list()を使用 | E-02 (89-92行目) | ○ |
| C-22 | mutable GetFeatureValues<tstring>はmutable_bytes_list()を使用 | E-02 (106-110行目) | ○ |

### feature_util.cc - GetFeatureList関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | const GetFeatureListはfeature_list().at(key).feature()を返す | E-02 (118-124行目) | ○ |
| C-24 | 存在しないキーでstd::out_of_rangeがスローされる | E-02 (118-124行目: at()使用) | ○ |
| C-25 | mutable GetFeatureListは新規FeatureListを作成可能 | E-02 (126-132行目) | ○ |
| C-26 | mutable GetFeatureListは既存キーでも動作する | E-02 (126-132行目) | ○ |

### feature_util.cc - ClearFeatureValues関数群

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | ClearFeatureValues<protobuf_int64>はint64_listをクリアする | E-02 (134-137行目) | ○ |
| C-28 | ClearFeatureValues<float>はfloat_listをクリアする | E-02 (139-142行目) | ○ |
| C-29 | ClearFeatureValues<std::string>はbytes_listをクリアする | E-02 (144-147行目) | ○ |
| C-30 | ClearFeatureValues<tstring>はbytes_listをクリアする | E-02 (149-152行目) | ○ |

### feature_util.cc - GetFeatures関数群

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | GetFeatures<Features>はポインタをそのまま返す | E-02 (154-157行目) | ○ |
| C-32 | GetFeatures<Example>はmutable_features()を返す | E-02 (159-162行目) | ○ |
| C-33 | GetFeatures<SequenceExample>はmutable_context()を返す | E-02 (164-167行目) | ○ |
| C-34 | const GetFeatures<Features>は参照をそのまま返す | E-02 (169-172行目) | ○ |
| C-35 | const GetFeatures<Example>はfeatures()を返す | E-02 (174-177行目) | ○ |
| C-36 | const GetFeatures<SequenceExample>はcontext()を返す | E-02 (179-182行目) | ○ |

### feature_util.h - AppendFeatureValues関数群

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | AppendFeatureValues(iterator)は範囲の値を追加する | E-01 (434-444行目) | ○ |
| C-38 | 空の範囲でFeatureは変更されない | E-01 (434-444行目: distanceが0) | ○ |
| C-39 | AppendFeatureValues(initializer_list)はリストの値を追加する | E-01 (446-455行目) | ○ |
| C-40 | 空の初期化リストでFeatureは変更されない | E-01 (446-455行目) | ○ |
| C-41 | AppendFeatureValues(container)はコンテナの値を追加する | E-01 (482-499行目) | ○ |
| C-42 | string_viewは自動的にstringに変換される | E-01 (493-494行目) | ○ |
| C-43 | AppendFeatureValues(key, proto)はキー指定で追加できる | E-01 (510-515行目) | ○ |

### feature_util.h - SetFeatureValues関数群

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | SetFeatureValues(iterator)は既存値をクリアして設定する | E-01 (542-548行目) | ○ |
| C-45 | SetFeatureValues(initializer_list)は既存値をクリアして設定する | E-01 (552-558行目) | ○ |
| C-46 | SetFeatureValues(container)は既存値をクリアして設定する | E-01 (562-569行目) | ○ |
| C-47 | SetFeatureValues(key, proto)はキー指定で設定できる | E-01 (580-587行目) | ○ |

### feature_util.h - GetFeature/MaybeGetFeature関数群

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | const GetFeatureはfeature().at(key)を返す | E-01 (366-368行目) | ○ |
| C-49 | 存在しないキーでstd::out_of_rangeがスローされる | E-01 (366-368行目: at()使用) | ○ |
| C-50 | mutable GetFeatureはFeatureポインタを返す | E-01 (420-423行目) | ○ |
| C-51 | 存在しないキーで新規Featureが作成される | E-01 (420-423行目: operator[]使用) | ○ |
| C-52 | MaybeGetFeatureは存在するキーでポインタを返す | E-01 (373-384行目) | ○ |
| C-53 | MaybeGetFeatureは存在しないキーでnullptrを返す | E-01 (379-381行目) | ○ |
| C-54 | MaybeGetFeatureValuesは存在するキーで値ポインタを返す | E-01 (408-416行目) | ○ |
| C-55 | MaybeGetFeatureValuesは存在しないキーでnullptrを返す | E-01 (411-413行目) | ○ |

### feature_util.h - GetFeatureValues(key)関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | GetFeatureValues(key)はキー指定で値を取得できる | E-01 (327-332行目) | ○ |
| C-57 | 存在しないキーでstd::out_of_rangeがスローされる | E-01 (331行目: at()使用) | ○ |

### feature_util.h - internal関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | ExampleFeatureは指定名のFeature参照を返す | E-02 (25-27行目) | ○ |
| C-59 | ExampleFeatureは存在しない名前で新規作成する | E-02 (26行目: GetFeature使用) | ○ |
| C-60 | ProtoMapKeyはstring_viewを適切な型に変換する | E-01 (246-260行目) | ○ |

### example_parser_configuration.cc - FindNodeIndexByName関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | 存在するノード名でインデックスが返される | E-04 (32-42行目) | ○ |
| C-62 | 存在しないノード名でInvalidArgumentエラー | E-04 (41行目) | ○ |
| C-63 | 空のGraphDefでエラーが返される | E-04 (34-41行目: ループが実行されず41行目へ) | ○ |
| C-64 | 複数ノードから正しいものが見つかる | E-04 (34-40行目) | ○ |

### example_parser_configuration.cc - ExtractExampleParserConfiguration関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | ParseExampleノードから設定が正しく抽出される | E-04 (44-161行目) | ○ |
| C-66 | 存在しないノード名でエラー | E-04 (50行目: FindNodeIndexByName呼び出し) | ○ |
| C-67 | ParseExample以外のノードでエラー | E-04 (53-55行目) | ○ |
| C-68 | Tdense属性サイズ不一致でエラー | E-04 (68-72行目) | ○ |
| C-69 | dense_shapes属性サイズ不一致でエラー | E-04 (74-78行目) | ○ |
| C-70 | sparse_types属性サイズ不一致でエラー | E-04 (80-84行目) | ○ |
| C-71 | FixedLenFeatureのdtypeとshapeが設定される | E-04 (86-90行目) | ○ |
| C-72 | VarLenFeatureのdtypeが設定される | E-04 (92-94行目) | ○ |
| C-73 | 出力テンソル名が正しく生成される | E-04 (137-159行目) | ○ |
| C-74 | Nsparse=0で空のvar_len_featuresが返される | E-04 (61行目: resize(0)) | ○ |
| C-75 | Ndense=0で空のfixed_len_featuresが返される | E-04 (60行目: resize(0)) | ○ |

### example_parser_configuration.cc - ExampleParserConfigurationProtoToFeatureVectors関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | FixedLenFeatureが正しく変換される | E-04 (171-185行目) | ○ |
| C-77 | VarLenFeatureが正しく変換される | E-04 (186-196行目) | ○ |
| C-78 | 空のconfig_protoで空のベクタが返される | E-04 (168行目: feature_mapが空ならループ不実行) | ○ |
| C-79 | 複数フィーチャーが正しく変換される | E-04 (168-197行目) | ○ |
| C-80 | 不正なdefault_valueでエラー | E-04 (178-182行目) | ○ |
| C-81 | default_valueが正しくTensorに変換される | E-04 (177-183行目) | ○ |
| C-82 | 出力テンソル名が正しくコピーされる | E-04 (184, 191-194行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべてのテストケースはソースコードの実装に基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードに基づいており、網羅性も十分です。

### 注意点
- テストケースC-24, C-49, C-57は`at()`メソッド使用による例外スローを期待していますが、これはC++標準ライブラリの動作に依存しています。
- mutable版の関数（C-20, C-21, C-22, C-25, C-50, C-51）は副作用があるため、テスト時にはFeatureオブジェクトの状態変化を検証する必要があります。
- Session依存のテスト（C-65-C-75）は統合テストに近い性質を持ち、モックSessionが必要になる可能性があります。

## 6) レビュアーチェックリスト（最小）
- [ ] HasFeature系関数の型チェックロジックが正しく網羅されているか（C-04～C-10）
- [ ] GetFeatureValues系関数のconst/mutable両方がテストされているか（C-14～C-22）
- [ ] 例外スローのテストケース（C-24, C-49, C-57, C-62）が適切か
- [ ] ExtractExampleParserConfiguration関数のSession依存部分のテスト戦略は適切か（C-65～C-75）
- [ ] ExampleParserConfigurationProtoToFeatureVectors関数のエラーケース（C-80）が十分か
