---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 160
  claims_with_evidence: 156
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：core-framework 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：156 / 160、根拠なし：4
- 優先レビュー（高）
  1. **InferenceContext構築パラメータ**：具体的なコンストラクタ引数の詳細確認が必要
  2. **OpKernelConstruction詳細**：構築時の各パラメータの型と要件確認が必要
  3. **一部のエラーメッセージ**：CHECK/DCHECKによる実際のメッセージ内容の確認が必要
  4. **FunctionDefHelper::Create引数**：引数の組み合わせパターンの網羅性確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/framework/tensor.h` - Tensorクラス定義
- E-02: `tensorflow/core/framework/tensor.cc` - Tensor実装
- E-03: `tensorflow/core/framework/tensor_shape.h` - TensorShape/PartialTensorShape/TensorShapeUtils定義
- E-04: `tensorflow/core/framework/tensor_shape.cc` - TensorShape実装
- E-05: `tensorflow/core/framework/types.h` - DataType関連の型定義と関数
- E-06: `tensorflow/core/framework/allocator.h` - Allocator定義（tslからのusing宣言）
- E-07: `tensorflow/core/framework/op_kernel.h` - OpKernel/AsyncOpKernel/OpKernelConstruction定義
- E-08: `tensorflow/core/framework/attr_value_util.h` - AttrValue操作関数
- E-09: `tensorflow/core/framework/shape_inference.h` - InferenceContext/DimensionHandle/ShapeHandle定義
- E-10: `tensorflow/core/framework/node_def_util.h` - NodeDef操作関数/AttrSlice
- E-11: `tensorflow/core/framework/function.h` - FunctionDefHelper定義

## 3) Claims と根拠の対応（レビューの主戦場）

### Tensor クラス関連（UT-CFW-001 〜 UT-CFW-056）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Tensor()でデフォルト1次元0要素floatテンソル作成 | E-01 L118-132, E-02 L867 | ○ |
| C-02 | Tensor(DataType, TensorShape)で指定形状作成 | E-01 L134-142, E-02 L1061 | ○ |
| C-03 | 無効DataTypeでエラー発生 | E-02 L1037-1045 BuildTensor | ○ |
| C-04 | カスタムアロケータでテンソル作成 | E-01 L144-152, E-02 L1009 | ○ |
| C-05 | nullptrアロケータでCHECK失敗 | E-02 L1012 CHECK_NOTNULL | ○ |
| C-06 | スカラーfloatコンストラクタ | E-01 L214-215 | ○ |
| C-07 | スカラーint32コンストラクタ | E-01 L218-219 | ○ |
| C-08 | スカラーboolコンストラクタ | E-01 L240-241 | ○ |
| C-09 | コピーコンストラクタでバッファ共有 | E-01 L1024-1027 | ○ |
| C-10 | ムーブコンストラクタで所有権移動 | E-01 L1029-1032 | ○ |
| C-11 | dtype()でデータ型取得 | E-01 L286 | ○ |
| C-12 | shape()で形状取得 | E-01 L289 | ○ |
| C-13 | dims()で次元数取得 | E-01 L295 | ○ |
| C-14 | dim_size(int)で次元サイズ取得 | E-01 L298 | ○ |
| C-15 | 最後の次元サイズ取得 | E-01 L298 | ○ |
| C-16 | NumElements()で要素数取得 | E-01 L301 | ○ |
| C-17 | 空テンソルの要素数0 | E-01 L301 | ○ |
| C-18 | IsInitialized()でtrue | E-02 L884-887 | ○ |
| C-19 | 0要素テンソルでIsInitialized()true | E-02 L886 num_elements()==0 | ○ |
| C-20 | TotalBytes()でメモリ使用量計算 | E-02 L1228-1233 | ○ |
| C-21 | 0要素テンソルでTotalBytes()=0 | E-02 L1229 | ○ |
| C-22 | IsSameSize()で同一サイズtrue | E-01 L303-305 | ○ |
| C-23 | IsSameSize()で異なるサイズfalse | E-01 L303-305 | ○ |
| C-24 | SharesBufferWith()でバッファ共有true | E-02 L1602-1605 | ○ |
| C-25 | SharesBufferWith()で独立バッファfalse | E-02 L1602-1605 | ○ |
| C-26 | IsAligned()でtrue | E-01 L326-334 | ○ |
| C-27 | CopyFrom()で形状変更コピー | E-01 L350-355 | ○ |
| C-28 | CopyFrom()で要素数不一致false | E-01 L352 | ○ |
| C-29 | Slice()でスライス取得 | E-02 L1115-1140 | ○ |
| C-30 | Slice()で全範囲スライス | E-02 L1121-1123 | ○ |
| C-31 | Slice()で空スライス | E-02 L1128 dim0_size=limit-start | ○ |
| C-32 | SubSlice()でサブスライス取得 | E-02 L1142-1162 | ○ |
| C-33 | SubSlice()で最初のインデックス | E-02 L1142-1162 | ○ |
| C-34 | SubSlice()で最後のインデックス | E-02 L1142-1162 | ○ |
| C-35 | FromProto()で復元 | E-02 L1168-1207 | ○ |
| C-36 | FromProto()で無効shape false | E-02 L1171 | ○ |
| C-37 | FromProto()でDT_INVALID false | E-02 L1172 | ○ |
| C-38 | AsProtoField()でシリアライズ | E-02 L1209-1216 | ○ |
| C-39 | AsProtoTensorContent()でシリアライズ | E-02 L1218-1226 | ○ |
| C-40 | flat<T>()でフラット化 | E-01 L899-905 | ○ |
| C-41 | flat<T>()で型不一致CHECK | E-01 L901 CheckTypeAndIsAligned | ○ |
| C-42 | tensor<T, NDIMS>()で取得 | E-01 L798-803 | ○ |
| C-43 | tensor<T, NDIMS>()で次元数不一致CHECK | E-01 L800 CheckTypeAndIsAligned | ○ |
| C-44 | scalar<T>()でスカラーアクセス | E-01 L971-978 | ○ |
| C-45 | scalar<T>()で非スカラーCHECK | E-01 L976 CheckIsAlignedAndSingleElement | ○ |
| C-46 | vec<T>()でベクトルアクセス | E-01 L429-431 | ○ |
| C-47 | matrix<T>()でマトリクスアクセス | E-01 L434-436 | ○ |
| C-48 | SummarizeValue()で要約取得 | E-02 L1471-1585 | ○ |
| C-49 | DebugString()でデバッグ文字列 | E-02 L1607-1611 | ○ |
| C-50 | BitcastFrom()で成功 | E-02 L916-951 | ○ |
| C-51 | BitcastFrom()でサイズ不一致エラー | E-02 L926-929 | ○ |
| C-52 | RefCountIsOne()で単一参照true | E-01 L680-686 | ○ |
| C-53 | RefCountIsOne()で共有参照false | E-01 L680-686 | ○ |
| C-54 | TensorBuffer::data()でポインタ取得 | E-01 L82 | ○ |
| C-55 | TensorBuffer::size()でサイズ取得 | E-01 L85 | ○ |
| C-56 | TensorBuffer::root_buffer()でルート取得 | E-01 L89 | ○ |

### TensorShape クラス関連（UT-CFW-057 〜 UT-CFW-104）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | TensorShape()でスカラー作成 | E-03 L773-783 | ○ |
| C-58 | 初期化リストから形状作成 | E-03 L172-173, E-04 L201 | ○ |
| C-59 | protoから形状作成 | E-04 L142-158 | ○ |
| C-60 | dims()で次元数取得 | E-03 L294-297 | ○ |
| C-61 | スカラーでdims()=0 | E-03 L294-297 | ○ |
| C-62 | dim_size(int)でサイズ取得 | E-04 L359-374 | ○ |
| C-63 | num_elements()で要素数計算 | E-03 L70 | ○ |
| C-64 | スカラーでnum_elements()=1 | E-03 L70 | ○ |
| C-65 | 0次元含むと要素数0 | E-03 L70 | ○ |
| C-66 | AddDim()で次元追加 | E-04 L415-427 | ○ |
| C-67 | AddDim()で負の値CHECK | E-04 L416 CHECK_GE | ○ |
| C-68 | AddDimWithStatus()でOkStatus | E-04 L430-460 | ○ |
| C-69 | AddDimWithStatus()で負値エラー | E-04 L432-436 | ○ |
| C-70 | InsertDim()で挿入 | E-04 L527-539 | ○ |
| C-71 | InsertDim()で先頭挿入 | E-04 L527-539 | ○ |
| C-72 | InsertDim()で末尾挿入 | E-04 L527-539 | ○ |
| C-73 | set_dim()で変更 | E-04 L588-613 | ○ |
| C-74 | RemoveDim()で削除 | E-03 L243-246 | ○ |
| C-75 | RemoveLastDims()で末尾削除 | E-03 L260-263 | ○ |
| C-76 | RemoveDimRange()で範囲削除 | E-04 L656-673 | ○ |
| C-77 | IsSameSize()で同一true | E-04 L722-728 | ○ |
| C-78 | IsSameSize()で異なるfalse | E-04 L722-728 | ○ |
| C-79 | AsProto()でシリアライズ | E-04 L731-740 | ○ |
| C-80 | DebugString()で文字列取得 | E-04 L760-775 | ○ |
| C-81 | IsValid()で有効proto true | E-04 L79-96 | ○ |
| C-82 | IsValid()で負次元false | E-04 L87 | ○ |
| C-83 | IsValid()でオーバーフローfalse | E-04 L91-93 | ○ |
| C-84 | MaxDimensions()=254 | E-03 L63 | ○ |
| C-85 | IsScalar()でスカラーtrue | E-03 L492 | ○ |
| C-86 | IsScalar()で非スカラーfalse | E-03 L492 | ○ |
| C-87 | IsVector()で1次元true | E-03 L494 | ○ |
| C-88 | IsMatrix()で2次元true | E-03 L500 | ○ |
| C-89 | IsSquareMatrix()で正方true | E-03 L502-504 | ○ |
| C-90 | IsSquareMatrix()で非正方false | E-03 L502-504 | ○ |
| C-91 | StartsWith()でプレフィックス一致 | E-04 L798-805 | ○ |
| C-92 | EndsWith()でサフィックス一致 | E-04 L807-817 | ○ |
| C-93 | MakeShape()で形状作成 | E-04 L859-870 | ○ |
| C-94 | MakeShape()で負次元エラー | E-04 L831-834 | ○ |
| C-95 | PartialTensorShape()で未知ランク | E-04 L317-328 | ○ |
| C-96 | unknown_rank()でtrue | E-03 L288-290 | ○ |
| C-97 | IsFullyDefined()で完全定義true | E-03 L311 | ○ |
| C-98 | IsFullyDefined()で未知次元false | E-03 L311 | ○ |
| C-99 | Concatenate()で連結 | E-04 L884-888 | ○ |
| C-100 | MergeWith()でマージ | E-04 L921-959 | ○ |
| C-101 | MergeWith()で非互換エラー | E-04 L932-936 | ○ |
| C-102 | IsCompatibleWith()で互換true | E-04 L981-991 | ○ |
| C-103 | AsTensorShape()で変換 | E-04 L961-968 | ○ |
| C-104 | AsTensorShape()で未知次元false | E-04 L962 IsFullyDefined | ○ |

### Types 関連（UT-CFW-105 〜 UT-CFW-125）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | DataTypeString()で文字列変換 | E-05 L89 | ○ |
| C-106 | DataTypeFromString()で変換 | E-05 L171 | ○ |
| C-107 | DataTypeFromString()で無効false | E-05 L171 | ○ |
| C-108 | DataTypeSize(DT_FLOAT)=4 | E-05 L491 | ○ |
| C-109 | DataTypeSize(DT_DOUBLE)=8 | E-05 L491 | ○ |
| C-110 | IsRefType()で参照型true | E-05 L179-181 | ○ |
| C-111 | IsRefType()で非参照型false | E-05 L179-181 | ○ |
| C-112 | MakeRefType()で参照型変換 | E-05 L182-185 | ○ |
| C-113 | RemoveRefType()で基本型変換 | E-05 L186-189 | ○ |
| C-114 | BaseType()で参照から基本型 | E-05 L190-192 | ○ |
| C-115 | BaseType()で基本型そのまま | E-05 L190-192 | ○ |
| C-116 | TypesCompatible()で同一true | E-05 L195-197 | ○ |
| C-117 | TypesCompatible()で参照/基本true | E-05 L195-197 | ○ |
| C-118 | DataTypeCanUseMemcpy(DT_FLOAT)true | E-05 L437-439 | ○ |
| C-119 | DataTypeCanUseMemcpy(DT_STRING)false | E-05 L425-436 kDataTypesCanUseMemcpy | ○ |
| C-120 | DataTypeIsFloating(DT_FLOAT)true | E-05 L447-449 | ○ |
| C-121 | DataTypeIsFloating(DT_INT32)false | E-05 L447-449 | ○ |
| C-122 | DataTypeIsInteger(DT_INT32)true | E-05 L470-472 | ○ |
| C-123 | DataTypeIsQuantized(DT_QINT8)true | E-05 L461-463 | ○ |
| C-124 | DataTypeSet::Contains()でtrue | E-05 L109-112 | ○ |
| C-125 | DataTypeSet::size()でサイズ | E-05 L162 | ○ |

### OpKernel 関連（UT-CFW-126 〜 UT-CFW-134）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | OpKernel構築 | E-07 L107-111 | ○ |
| C-127 | name()で名前取得 | E-07 L172 | ○ |
| C-128 | type_string()でop型取得 | E-07 L174 | ○ |
| C-129 | num_inputs()で入力数取得 | E-07 L183 | ○ |
| C-130 | num_outputs()で出力数取得 | E-07 L190 | ○ |
| C-131 | input_type(int)で入力型取得 | E-07 L184 | ○ |
| C-132 | output_type(int)で出力型取得 | E-07 L191 | ○ |
| C-133 | IsExpensive()でtrue | E-07 L165 | ○ |
| C-134 | is_deferred()でtrue | E-07 L203 | ○ |

### AttrValueUtil 関連（UT-CFW-135 〜 UT-CFW-149）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | SetAttrValue(string)設定 | E-08 L62 | ○ |
| C-136 | SetAttrValue(int64_t)設定 | E-08 L66 | ○ |
| C-137 | SetAttrValue(float)設定 | E-08 L68 | ○ |
| C-138 | SetAttrValue(bool)設定 | E-08 L70 | ○ |
| C-139 | SetAttrValue(DataType)設定 | E-08 L71 | ○ |
| C-140 | SetAttrValue(TensorShape)設定 | E-08 L72 | ○ |
| C-141 | SetAttrValue(Tensor)設定 | E-08 L75 | ○ |
| C-142 | SummarizeAttrValue()で要約 | E-08 L45 | ○ |
| C-143 | AttrValueHasType()で正しい型Ok | E-08 L48-49 | ○ |
| C-144 | AttrValueHasType()で不正な型エラー | E-08 L48-49 | ○ |
| C-145 | ParseAttrValue()でパース | E-08 L58-59 | ○ |
| C-146 | ParseAttrValue()で不正入力false | E-08 L58-59 | ○ |
| C-147 | AreAttrValuesEqual()で同一true | E-08 L124-125 | ○ |
| C-148 | AreAttrValuesEqual()で異なるfalse | E-08 L124-125 | ○ |
| C-149 | AttrValueHash()で同一ハッシュ | E-08 L108 | ○ |

### ShapeInference/NodeDefUtil/Function 関連（UT-CFW-150 〜 UT-CFW-160）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-150 | InferenceContext構築 | E-09 L38-45 | △ |
| C-151 | MakeShape()でShapeHandle作成 | E-09 L52-54 | △ |
| C-152 | UnknownDim()で未知次元作成 | E-09 L53 | ○ |
| C-153 | DimensionHandle::SameHandle()で同一true | E-09 L133 | ○ |
| C-154 | ShapeHandle::SameHandle()で同一true | E-09 L174 | ○ |
| C-155 | AddNodeAttr(AttrValue)で追加 | E-10 L88-89 | ○ |
| C-156 | AddNodeAttr(int64_t)で追加 | E-10 L95 | ○ |
| C-157 | AttrSlice::Find()で存在取得 | E-10 L160 | ○ |
| C-158 | AttrSlice::Find()で非存在nullptr | E-10 L160 | ○ |
| C-159 | SummarizeNodeDef()で要約 | E-10 L71-72 | ○ |
| C-160 | FunctionDefHelper::Create()で作成 | E-11 L172-177 | △ |

## 4) 不足情報（Unknown / Missing）
- **C-150（InferenceContext構築）**: InferenceContextのコンストラクタ詳細パラメータの完全な定義確認が必要
  - 候補：shape_inference.ccの実装確認 / InferenceContext利用例の調査 / 既存テストコードの参照
- **C-151（MakeShape）**: InferenceContext::MakeShapeメソッドの詳細シグネチャの確認が必要
  - 候補：shape_inference.hの完全な読み込み / メソッドオーバーロードの確認
- **C-160（FunctionDefHelper::Create）**: 引数パターンの網羅性確認が必要
  - 候補：function.hの完全な読み込み / function_testlib.ccの参照

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - Tensor, TensorShape, Types関連（UT-CFW-001〜UT-CFW-125）: ソースコードから直接確認可能
- **0: 低リスク** - OpKernel, AttrValueUtil関連（UT-CFW-126〜UT-CFW-149）: ヘッダファイルから確認可能
- **1: 中リスク** - ShapeInference関連（UT-CFW-150〜UT-CFW-154）: 一部実装詳細の確認が必要
- **1: 中リスク** - Function関連（UT-CFW-160）: 複雑なAPIの網羅性確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Tensorクラスのコンストラクタバリエーションが網羅されているか
- [ ] TensorShapeの境界値テスト（MaxDimensions、オーバーフロー）が適切か
- [ ] DataType関連のすべての型が考慮されているか
- [ ] CHECK/DCHECKによるクラッシュ動作のテストケースが現実的か
- [ ] OpKernelの同期/非同期動作の違いが考慮されているか
- [ ] InferenceContextの各種メソッド（未読部分）の追加テストケースが必要か確認
- [ ] FunctionDefHelperの各種Create/Defineオーバーロードが網羅されているか確認
