---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 242
  claims_with_evidence: 242
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：core-function 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内の対応する関数・メソッド・クラスが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要な関数・メソッドに対するテストケースが網羅されているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：242 / 242、根拠なし：0
- 優先レビュー（高）
  1. **runtime_client.cc のC++テストケース**：複雑なMLIR変換ロジック含む
  2. **FunctionType関連のテストケース**：多数の型システム関連メソッド
  3. **transform.py のテストケース**：関数変換の複雑なロジック

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

### capture サブモジュール
- E-01: `tensorflow/core/function/capture/capture_container.py` - MutationAwareDict, FunctionCaptures クラス
- E-02: `tensorflow/core/function/capture/free_vars_detect.py` - 自由変数検出関連関数
- E-03: `tensorflow/core/function/capture/restore_captures.py` - キャプチャ復元関数

### runtime_client サブモジュール
- E-04: `tensorflow/core/function/runtime_client/runtime_client.py` - Python Runtime クラス
- E-05: `tensorflow/core/function/runtime_client/runtime_client.h` - C++ Runtime クラスヘッダ
- E-06: `tensorflow/core/function/runtime_client/runtime_client.cc` - C++ Runtime クラス実装

### trace_type サブモジュール
- E-07: `tensorflow/core/function/trace_type/default_types.py` - Literal, Tuple, List, Dict等のTraceType実装
- E-08: `tensorflow/core/function/trace_type/trace_type_builder.py` - TraceType生成コンテキスト、from_value関数
- E-09: `tensorflow/core/function/trace_type/serialization.py` - シリアライズ/デシリアライズ機能
- E-10: `tensorflow/core/function/trace_type/util.py` - ユーティリティ関数
- E-11: `tensorflow/core/function/trace_type/custom_nest_trace_type.py` - CustomNestTraceType クラス

### polymorphism サブモジュール
- E-12: `tensorflow/core/function/polymorphism/function_type.py` - Parameter, FunctionType クラス、関連関数
- E-13: `tensorflow/core/function/polymorphism/function_cache.py` - FunctionCache クラス
- E-14: `tensorflow/core/function/polymorphism/type_dispatch.py` - TypeDispatchTable クラス

### transform サブモジュール
- E-15: `tensorflow/core/function/transform/transform.py` - 関数変換API

### testing サブモジュール
- E-16: `tensorflow/core/function/testing/test_pass.py` - テストパス登録

## 3) Claims と根拠の対応（レビューの主戦場）

### capture_container.py 関連テストケース（C-01〜C-27）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MutationAwareDict.__init__初期化テスト | E-01 (行31-36) | ○ |
| C-02 | MutationAwareDict.pop正常系テスト | E-01 (行38-40) | ○ |
| C-03 | MutationAwareDict.pop境界値テスト | E-01 (行38-40) | ○ |
| C-04 | MutationAwareDict.__setitem__テスト | E-01 (行42-44) | ○ |
| C-05 | MutationAwareDict.__delitem__テスト | E-01 (行46-48) | ○ |
| C-06 | MutationAwareDict.clearテスト | E-01 (行50-52) | ○ |
| C-07 | FunctionCaptures.__init__テスト | E-01 (行66-79) | ○ |
| C-08 | FunctionCaptures.clearテスト | E-01 (行81-87) | ○ |
| C-09 | FunctionCaptures.capture_by_value正常系テスト | E-01 (行88-155) | ○ |
| C-10 | FunctionCaptures.capture_by_value小さいテンソルテスト | E-01 (行117-138) | ○ |
| C-11 | FunctionCaptures.capture_by_value大きいテンソルテスト | E-01 (行140-141) | ○ |
| C-12 | FunctionCaptures.capture_by_value異なるグラフテスト | E-01 (行143-155) | ○ |
| C-13 | FunctionCaptures.add_or_replace by_refテスト | E-01 (行157-176) | ○ |
| C-14 | FunctionCaptures.add_or_replace by_valテスト | E-01 (行170-176) | ○ |
| C-15 | FunctionCaptures.add_or_replace tracetype自動生成テスト | E-01 (行173-176) | ○ |
| C-16 | FunctionCaptures.pop by_refテスト | E-01 (行178-184) | ○ |
| C-17 | FunctionCaptures.pop by_valテスト | E-01 (行185-190) | ○ |
| C-18 | FunctionCaptures.reset_capturesテスト | E-01 (行192-201) | ○ |
| C-19 | FunctionCaptures._capture_by_ref作成テスト | E-01 (行207-242) | ○ |
| C-20 | FunctionCaptures._capture_by_ref既存テスト | E-01 (行220-222) | ○ |
| C-21 | FunctionCaptures.merge_by_ref_with正常系テスト | E-01 (行244-250) | ○ |
| C-22 | FunctionCaptures.merge_by_ref_with異常系テスト | E-01 (行246) | ○ |
| C-23 | FunctionCaptures.get_by_ref_snapshot正常系テスト | E-01 (行253-265) | ○ |
| C-24 | FunctionCaptures.get_by_ref_snapshotフォールバックテスト | E-01 (行260-264) | ○ |
| C-25 | FunctionCaptures.capture_typesテスト | E-01 (行310-314) | ○ |
| C-26 | FunctionCaptures.capture_typesキャッシュ更新テスト | E-01 (行312-313) | ○ |
| C-27 | FunctionCaptures.by_val_capture_tuplesテスト | E-01 (行316-320) | ○ |

### free_vars_detect.py 関連テストケース（C-28〜C-43）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | _parse_and_analyzeテスト | E-02 (行36-49) | ○ |
| C-29 | _handle_wrap_partial_func wrappedテスト | E-02 (行52-64) | ○ |
| C-30 | _handle_wrap_partial_func partialテスト | E-02 (行60-63) | ○ |
| C-31 | _get_self_obj_from_closure正常系テスト | E-02 (行67-122) | ○ |
| C-32 | _get_self_obj_from_closure境界値テスト | E-02 (行109) | ○ |
| C-33 | _search_callable_free_vars正常系テスト | E-02 (行125-196) | ○ |
| C-34 | _search_callable_free_varsソースなしテスト | E-02 (行130-137) | ○ |
| C-35 | _make_callable_signature関数テスト | E-02 (行205-220) | ○ |
| C-36 | _make_callable_signatureメソッドテスト | E-02 (行211-217) | ○ |
| C-37 | _make_callable_signatureラムダテスト | E-02 (行208-210) | ○ |
| C-38 | _make_callable_signature異常系テスト | E-02 (行218-220) | ○ |
| C-39 | _detect_function_free_vars正常系テスト | E-02 (行223-249) | ○ |
| C-40 | _detect_function_free_vars異常系テスト | E-02 (行225-227) | ○ |
| C-41 | generate_free_var_logging正常系テスト | E-02 (行252-329) | ○ |
| C-42 | generate_free_var_loggingキャッシュテスト | E-02 (行265-266) | ○ |
| C-43 | generate_free_var_logging自由変数なしテスト | E-02 (行274-277) | ○ |

### restore_captures.py 関連テストケース（C-44〜C-53）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | get_tensor_from_node分散変数テスト | E-03 (行48-49) | ○ |
| C-45 | get_tensor_from_nodeリソース変数テスト | E-03 (行54-55) | ○ |
| C-46 | get_tensor_from_node Assetテスト | E-03 (行56-57) | ○ |
| C-47 | get_tensor_from_node Tensorテスト | E-03 (行58-59) | ○ |
| C-48 | get_tensor_from_node CapturableResourceテスト | E-03 (行60-62) | ○ |
| C-49 | get_tensor_from_node異常系テスト | E-03 (行63) | ○ |
| C-50 | restore_captures正常系テスト | E-03 (行66-142) | ○ |
| C-51 | restore_captures変数設定テスト | E-03 (行94) | ○ |
| C-52 | restore_capturesカスタム復元テスト | E-03 (行101-106) | ○ |
| C-53 | restore_captures FunctionType更新テスト | E-03 (行137-142) | ○ |

### runtime_client関連テストケース（C-54〜C-70）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | Runtime.GetFunctionProto Pythonテスト | E-04 (行30-32) | ○ |
| C-55 | Runtime.CreateFunction Pythonテスト | E-04 (行34-35) | ○ |
| C-56 | GlobalEagerContextテスト | E-06 (行69-88) | ○ |
| C-57 | GlobalPythonEagerContext正常系テスト | E-06 (行90-94) | ○ |
| C-58 | GlobalPythonEagerContext異常系テスト | E-06 (行92) | ○ |
| C-59 | Runtime::GetFunctionProto正常系テスト | E-06 (行96-107) | ○ |
| C-60 | Runtime::GetFunctionProto異常系テスト | E-06 (行100-104) | ○ |
| C-61 | Runtime::CreateFunction FunctionDefテスト | E-06 (行109-116) | ○ |
| C-62 | Runtime::CreateFunction置換テスト | E-06 (行111-114) | ○ |
| C-63 | Runtime::CreateFunction TFGテスト | E-06 (行118-123) | ○ |
| C-64 | Runtime::CreateFunction TFテスト | E-06 (行125-135) | ○ |
| C-65 | Runtime::TransformFunction TFGテスト | E-06 (行137-181) | ○ |
| C-66 | Runtime::TransformFunction TFテスト | E-06 (行183-215) | ○ |
| C-67 | Runtime::TransformFunction無効パイプラインテスト | E-06 (行147-152) | ○ |
| C-68 | Runtime::TransformFunction無効方言テスト | E-06 (行217-220) | ○ |
| C-69 | Runtime::CallFunction正常系テスト | E-06 (行223-252) | ○ |
| C-70 | Runtime::CallFunction異常系テスト | E-06 (行228-229) | ○ |

### default_types.py 関連テストケース（C-71〜C-116）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71〜C-74 | is_nanテスト | E-07 (行42-50) | ○ |
| C-75〜C-88 | Literalクラステスト | E-07 (行53-145) | ○ |
| C-89〜C-91 | Weakrefクラステスト | E-07 (行148-200) | ○ |
| C-92〜C-100 | Tupleクラステスト | E-07 (行203-299) | ○ |
| C-101〜C-104 | Listクラステスト | E-07 (行302-385) | ○ |
| C-105〜C-109 | NamedTupleクラステスト | E-07 (行388-528) | ○ |
| C-110〜C-111 | Attrsクラステスト | E-07 (行531-668) | ○ |
| C-112〜C-116 | Dictクラステスト | E-07 (行671-818) | ○ |

### trace_type_builder.py 関連テストケース（C-117〜C-141）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117〜C-120 | InternalTracingContextテスト | E-08 (行28-55) | ○ |
| C-121〜C-126 | InternalPlaceholderContextテスト | E-08 (行58-110) | ○ |
| C-127 | InternalCastContextテスト | E-08 (行113-124) | ○ |
| C-128〜C-141 | from_valueテスト | E-08 (行127-209) | ○ |

### serialization.py 関連テストケース（C-142〜C-148）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-142〜C-143 | register_serializableテスト | E-09 (行49-65) | ○ |
| C-144〜C-146 | serializeテスト | E-09 (行68-85) | ○ |
| C-147〜C-148 | deserializeテスト | E-09 (行88-100) | ○ |

### util.py 関連テストケース（C-149〜C-156）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-149〜C-150 | is_namedtupleテスト | E-10 (行23-25) | ○ |
| C-151〜C-152 | is_attrsテスト | E-10 (行29-30) | ○ |
| C-153〜C-154 | is_np_ndarrayテスト | E-10 (行34-39) | ○ |
| C-155〜C-156 | cast_and_return_whether_castedテスト | E-10 (行42-52) | ○ |

### custom_nest_trace_type.py 関連テストケース（C-157〜C-166）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-157〜C-166 | CustomNestTraceTypeテスト | E-11 (行24-143) | ○ |

### function_type.py 関連テストケース（C-167〜C-202）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-167〜C-174 | Parameterクラステスト | E-12 (行57-164) | ○ |
| C-175〜C-193 | FunctionTypeクラステスト | E-12 (行167-483) | ○ |
| C-194〜C-196 | sanitize_arg_nameテスト | E-12 (行492-518) | ○ |
| C-197 | canonicalize_to_monomorphicテスト | E-12 (行535-591) | ○ |
| C-198〜C-199 | add_type_constraintsテスト | E-12 (行596-653) | ○ |
| C-200 | from_structured_signatureテスト | E-12 (行656-707) | ○ |
| C-201〜C-202 | to_structured_signatureテスト | E-12 (行710-733) | ○ |

### function_cache.py 関連テストケース（C-203〜C-214）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-203 | FunctionContextテスト | E-13 (行24-28) | ○ |
| C-204〜C-214 | FunctionCacheクラステスト | E-13 (行30-103) | ○ |

### type_dispatch.py 関連テストケース（C-215〜C-229）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-215〜C-229 | TypeDispatchTableクラステスト | E-14 (行26-131) | ○ |

### transform.py 関連テストケース（C-230〜C-241）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-230〜C-234 | transform_functionテスト | E-15 (行39-274) | ○ |
| C-235〜C-236 | transform_atomic_functionテスト | E-15 (行277-325) | ○ |
| C-237〜C-238 | _replicate_gradient_functionsテスト | E-15 (行328-391) | ○ |
| C-239 | _gen_gradient_funcテスト | E-15 (行394-404) | ○ |
| C-240 | _get_outer_most_captureテスト | E-15 (行407-425) | ○ |
| C-241 | _ops_with_custom_gradientsテスト | E-15 (行428-437) | ○ |

### test_pass.py 関連テストケース（C-242）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-242 | RegisterTestPassテスト | E-16 (行21) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのテストケースにソースコードの根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全テストケースがソースコードに基づいて生成されている

潜在的なリスク：
1. C++コード（runtime_client.cc）のテストケースはMLIRやTensorFlow内部APIに依存しており、環境構築が複雑
2. 一部のテストケースはモック/スタブが必要（例：EagerContext、FuncGraph）
3. transform.py関連のテストはtf.function全体の統合テストに近い性質を持つ

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（runtime_client関連、FunctionType関連）の入力値・期待結果が妥当か確認
- [ ] C++テストケースの実行可能性を確認（ビルド環境、依存関係）
- [ ] 異常系テストケースで適切な例外型が指定されているか確認
- [ ] 境界値テストケースのしきい値（_EAGER_CONST_THRESHOLD=128など）が正しいか確認
- [ ] テストケースIDの命名規則（UT-CFN-XXX）が一貫しているか確認
