---
generated_at: 2026-02-03 12:30:00
metrics:
  claims_total: 132
  claims_with_evidence: 132
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：core-graph.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・ヘッダファイルなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠となるコードと矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：132 / 132、根拠なし：0
- 優先レビュー（高）
  1. **UT-GRP-001〜005**：Graph初期化とAddNodeはコア機能のため重点レビュー推奨
  2. **UT-GRP-118〜121**：Partition機能は複雑なため詳細確認推奨
  3. **UT-GRP-088〜090**：サイクル検出ロジックは重要なグラフ検証機能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/graph/graph.h` - Graphクラス、Nodeクラス、Edgeクラス定義
- E-02: `tensorflow/core/graph/graph.cc` - Graphクラスの実装
- E-03: `tensorflow/core/graph/algorithm.h` - グラフ探索アルゴリズム宣言
- E-04: `tensorflow/core/graph/algorithm.cc` - DFS/BFS/GetPostOrder等の実装
- E-05: `tensorflow/core/graph/node_builder.h` - NodeBuilderクラス定義
- E-06: `tensorflow/core/graph/node_builder.cc` - NodeBuilderの実装
- E-07: `tensorflow/core/graph/validate.h` - グラフ検証関数宣言
- E-08: `tensorflow/core/graph/validate.cc` - ValidateGraphDef等の実装
- E-09: `tensorflow/core/graph/edgeset.h` - EdgeSetクラス定義（インライン実装含む）
- E-10: `tensorflow/core/graph/edgeset.cc` - EdgeSet::insert/erase実装
- E-11: `tensorflow/core/graph/costmodel.h` - CostModelクラス定義
- E-12: `tensorflow/core/graph/costmodel.cc` - CostModelの実装
- E-13: `tensorflow/core/graph/optimizer_cse.h` - CSE最適化関数宣言
- E-14: `tensorflow/core/graph/optimizer_cse.cc` - OptimizeCSE実装
- E-15: `tensorflow/core/graph/control_flow.h` - 制御フロー情報構造体定義
- E-16: `tensorflow/core/graph/control_flow.cc` - BuildControlFlowInfo実装
- E-17: `tensorflow/core/graph/graph_partition.h` - パーティション関数宣言
- E-18: `tensorflow/core/graph/graph_partition.cc` - Partition実装
- E-19: `tensorflow/core/graph/subgraph.h` - サブグラフ書き換えクラス定義
- E-20: `tensorflow/core/graph/subgraph.cc` - RewriteGraphForExecution実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-GRP-001) | Graph(OpRegistryInterface*)でSOURCE/SINKノードが作成される | E-01, E-02 (437-463行) | ○ |
| C-02 (UT-GRP-002) | Graph(FunctionLibraryDefinition&)で関数ライブラリがコピーされる | E-01, E-02 (465-473行) | ○ |
| C-03 (UT-GRP-003) | AddNodeで有効なNodeDefからノードが追加される | E-01, E-02 (546-589行) | ○ |
| C-04 (UT-GRP-004) | AddNodeで無効なOp名の場合エラーが返る | E-02 (547-549行) LookUp失敗時 | ○ |
| C-05 (UT-GRP-005) | AddNodeで型不一致の場合エラーが返る | E-02 (553-558行) InOutTypesForNode失敗時 | ○ |
| C-06 (UT-GRP-006) | CopyNodeでノードがコピーされる | E-02 (591-609行) | ○ |
| C-07 (UT-GRP-007) | CopyNodeでSOURCE/SINKのコピーでDCHECK失敗 | E-02 (592-593行) DCHECK | ○ |
| C-08 (UT-GRP-008) | RemoveNodeでノードと関連エッジが削除される | E-02 (611-632行) | ○ |
| C-09 (UT-GRP-009) | RemoveNodeでSOURCE/SINKにDCHECK失敗 | E-02 (613-614行) DCHECK | ○ |
| C-10 (UT-GRP-010) | AddEdgeでデータエッジが追加される | E-02 (634-664行) | ○ |
| C-11 (UT-GRP-011) | AddEdgeでkControlSlotでコントロールエッジが作成 | E-02 (640-644行) | ○ |
| C-12 (UT-GRP-012) | AddControlEdgeでコントロールエッジが追加される | E-02 (683-710行) | ○ |
| C-13 (UT-GRP-013) | AddControlEdgeで重複時nullptrが返る | E-02 (685-691行) | ○ |
| C-14 (UT-GRP-014) | AddControlEdge allow_duplicates=trueで重複許可 | E-02 (694行) | ○ |
| C-15 (UT-GRP-015) | RemoveEdgeでエッジが削除される | E-02 (666-677行) | ○ |
| C-16 (UT-GRP-016) | RemoveControlEdgeでNodeDefも更新される | E-02 (712-725行) | ○ |
| C-17 (UT-GRP-017) | UpdateEdgeでエッジが更新される | E-02 (736-751行) | ○ |
| C-18 (UT-GRP-018) | UpdateEdgeで存在しないエッジでInvalidArgument | E-02 (741-743行) | ○ |
| C-19 (UT-GRP-019) | IsValidNodeで有効ノードにOKが返る | E-02 (918-936行) | ○ |
| C-20 (UT-GRP-020) | IsValidNodeでnullptrにInvalidArgument | E-02 (919-921行) | ○ |
| C-21 (UT-GRP-021) | IsValidNodeで他Graphノードにエラー | E-02 (930-934行) | ○ |
| C-22 (UT-GRP-022) | IsValidOutputTensorで有効インデックスにOK | E-02 (938-947行) | ○ |
| C-23 (UT-GRP-023) | IsValidOutputTensorで範囲外にOutOfRange | E-02 (940-945行) | ○ |
| C-24 (UT-GRP-024) | IsValidInputTensorで有効インデックスにOK | E-02 (949-958行) | ○ |
| C-25 (UT-GRP-025) | IsValidInputTensorで範囲外にOutOfRange | E-02 (951-956行) | ○ |
| C-26 (UT-GRP-026) | ToGraphDefでGraphDefが生成される | E-02 (827-912行) | ○ |
| C-27 (UT-GRP-027) | ToGraphDefでinclude_flib_defで関数含む | E-02 (845-847行) | ○ |
| C-28 (UT-GRP-028) | ToGraphDefでinclude_debug_infoでデバッグ情報含む | E-02 (848-850行) | ○ |
| C-29 (UT-GRP-029) | Cloneでグラフがクローンされる | E-02 (490-494行) | ○ |
| C-30 (UT-GRP-030) | Clearで全ノードが削除される | E-02 (496-503行) | ○ |
| C-31 (UT-GRP-031) | NewNameでユニーク名が生成される | E-02 (914-916行) | ○ |
| C-32 (UT-GRP-032) | AddWhileContextでWhileContextが追加される | E-02 (1008-1027行) | ○ |
| C-33 (UT-GRP-033) | AddWhileContextで重複frame_nameにエラー | E-02 (1020-1023行) | ○ |
| C-34 (UT-GRP-034) | InternDeviceNameでデバイス名がインターン化 | E-02 (989-1006行) | ○ |
| C-35 (UT-GRP-035) | InternDeviceNameで空文字に0が返る | E-02 (993-995行) | ○ |
| C-36 (UT-GRP-036) | Node::idでIDが返却される | E-01 (88行) inline実装 | ○ |
| C-37 (UT-GRP-037) | Node::nameで名前が返却される | E-02 (235行) | ○ |
| C-38 (UT-GRP-038) | Node::input_edgeで入力エッジが返る | E-02 (319-343行) | ○ |
| C-39 (UT-GRP-039) | Node::input_edgeで範囲外にInvalidArgument | E-02 (320-324行) | ○ |
| C-40 (UT-GRP-040) | Node::input_edgeで見つからない場合NotFound | E-02 (342行) | ○ |
| C-41 (UT-GRP-041) | Node::input_edgesで全入力エッジが返る | E-02 (346-368行) | ○ |
| C-42 (UT-GRP-042) | Node::input_edgesで重複入力にInternal | E-02 (355-358行) | ○ |
| C-43 (UT-GRP-043) | Node::input_edgesで欠損入力にInvalidArgument | E-02 (362-366行) | ○ |
| C-44 (UT-GRP-044) | Node::AddAttrで属性が追加される | E-01 (217-221行) | ○ |
| C-45 (UT-GRP-045) | Node::ClearAttrで属性が削除される | E-02 (284-287行) | ○ |
| C-46 (UT-GRP-046) | Node::IsSourceでソースノード判定 | E-01 (159行) | ○ |
| C-47 (UT-GRP-047) | Node::IsSinkでシンクノード判定 | E-01 (160行) | ○ |
| C-48 (UT-GRP-048) | Node::IsOpで通常ノード判定 | E-01 (162行) | ○ |
| C-49 (UT-GRP-049) | GetNodeClassForOpでNodeClassが返る | E-02 (51-115行) | ○ |
| C-50 (UT-GRP-050) | GetNodeClassForOpで不明OpにNC_OTHER | E-02 (112-114行) | ○ |
| C-51 (UT-GRP-051) | Edge::IsControlEdgeでコントロールエッジ判定true | E-01 (1071-1075行) | ○ |
| C-52 (UT-GRP-052) | Edge::IsControlEdgeでデータエッジ判定false | E-01 (1071-1075行) | ○ |
| C-53 (UT-GRP-053) | EdgeSet::insertでエッジが挿入される | E-10 (20-50行) | ○ |
| C-54 (UT-GRP-054) | EdgeSet::insertで重複時既存が返る | E-10 (26-30行) | ○ |
| C-55 (UT-GRP-055) | EdgeSet::insertでkInline超過時FlatSetに変換 | E-10 (39-46行) | ○ |
| C-56 (UT-GRP-056) | EdgeSet::eraseでエッジが削除される | E-10 (52-68行) | ○ |
| C-57 (UT-GRP-057) | EdgeSet::eraseで存在しないエッジに0が返る | E-10 (63-64行) | ○ |
| C-58 (UT-GRP-058) | EdgeSet::sizeでエッジ数が返る | E-09 (144-155行) | ○ |
| C-59 (UT-GRP-059) | EdgeSet::emptyで空判定 | E-09 (142行) | ○ |
| C-60 (UT-GRP-060) | DFSで深さ優先探索が実行される | E-04 (89-95行) | ○ |
| C-61 (UT-GRP-061) | DFSでstable_comparatorで順序が安定 | E-04 (67-77行) | ○ |
| C-62 (UT-GRP-062) | DFSでedge_filterでエッジがフィルタ | E-04 (70, 80行) | ○ |
| C-63 (UT-GRP-063) | DFSFromで指定ノードから開始 | E-04 (97-103行) | ○ |
| C-64 (UT-GRP-064) | ReverseDFSで逆方向DFSが実行される | E-04 (113-119行) | ○ |
| C-65 (UT-GRP-065) | ReverseDFSFromで指定ノードから逆DFS | E-04 (187-201行) | ○ |
| C-66 (UT-GRP-066) | GetPostOrderで後順序が取得される | E-04 (203-210行) | ○ |
| C-67 (UT-GRP-067) | GetPostOrderで空グラフでも動作 | E-04 (206-209行) | ○ |
| C-68 (UT-GRP-068) | GetReversePostOrderで逆後順序が取得される | E-04 (212-217行) | ○ |
| C-69 (UT-GRP-069) | PruneForReverseReachabilityで不要ノード削除 | E-04 (219-253行) | ○ |
| C-70 (UT-GRP-070) | PruneForReverseReachabilityで変更なしにfalse | E-04 (251-252行) | ○ |
| C-71 (UT-GRP-071) | FixupSourceAndSinkEdgesで孤立ノード接続 | E-04 (255-271行) | ○ |
| C-72 (UT-GRP-072) | FixupSourceAndSinkEdgesで変更なしにfalse | E-04 (270行) | ○ |
| C-73 (UT-GRP-073) | BreadthFirstTraversalでBFSが実行される | E-04 (310-321行) | ○ |
| C-74 (UT-GRP-074) | NodeBuilderで有効引数でビルダー作成 | E-06 (45-48行) | ○ |
| C-75 (UT-GRP-075) | NodeBuilder::Input(Node*)で入力追加 | E-06 (56-63行) | ○ |
| C-76 (UT-GRP-076) | NodeBuilder::Input(Node*)でnullptrにエラー | E-06 (160-165行) AddIndexError | ○ |
| C-77 (UT-GRP-077) | NodeBuilder::Input(Node*)で範囲外にエラー | E-06 (166-170行) AddIndexError | ○ |
| C-78 (UT-GRP-078) | NodeBuilder::Input(NodeOut)で入力追加 | E-06 (65-73行) | ○ |
| C-79 (UT-GRP-079) | NodeBuilder::Input(Span)で複数入力追加 | E-06 (75-88行) | ○ |
| C-80 (UT-GRP-080) | NodeBuilder::ControlInputでコントロール入力追加 | E-06 (90-94行) | ○ |
| C-81 (UT-GRP-081) | NodeBuilder::Attrで属性設定 | E-05 (166-170行) | ○ |
| C-82 (UT-GRP-082) | NodeBuilder::FinalizeでノードがGraphに追加 | E-06 (126-158行) | ○ |
| C-83 (UT-GRP-083) | NodeBuilder::Finalizeでエラー時InvalidArgument | E-06 (132-134行) | ○ |
| C-84 (UT-GRP-084) | NodeBuilder::Finalizeでエッジが追加される | E-06 (146-153行) | ○ |
| C-85 (UT-GRP-085) | ValidateGraphDefで有効GraphDefにOK | E-08 (31-44行) | ○ |
| C-86 (UT-GRP-086) | ValidateGraphDefで未登録Opにエラー | E-08 (38行) LookUpOpDef | ○ |
| C-87 (UT-GRP-087) | ValidateGraphDefで非推奨Opにエラー | E-08 (40行) CheckOpDeprecation | ○ |
| C-88 (UT-GRP-088) | ValidateGraphHasNoCycleでサイクルなしにOK | E-08 (64-116行) | ○ |
| C-89 (UT-GRP-089) | ValidateGraphHasNoCycleでサイクルありにエラー | E-08 (102-114行) | ○ |
| C-90 (UT-GRP-090) | ValidateGraphHasNoCycleでWhileループは許可 | E-08 (73-81行) Merge/NextIteration調整 | ○ |
| C-91 (UT-GRP-091) | VerifyNoDuplicateNodeNamesで重複なしにOK | E-08 (118-127行) | ○ |
| C-92 (UT-GRP-092) | VerifyNoDuplicateNodeNamesで重複ありにエラー | E-08 (121-123行) | ○ |
| C-93 (UT-GRP-093) | CostModel::InitFromGraphで初期化 | E-12 (480-493行) | ○ |
| C-94 (UT-GRP-094) | CostModel::RecordCountで実行回数記録 | E-12 (188-193行) | ○ |
| C-95 (UT-GRP-095) | CostModel::TotalCountで総実行回数取得 | E-12 (195-199行) | ○ |
| C-96 (UT-GRP-096) | CostModel::RecordTimeで実行時間記録 | E-12 (230-236行) | ○ |
| C-97 (UT-GRP-097) | CostModel::TotalTimeで総実行時間取得 | E-12 (238-246行) | ○ |
| C-98 (UT-GRP-098) | CostModel::TimeEstimateで時間見積もり | E-12 (248-252行) | ○ |
| C-99 (UT-GRP-099) | CostModel::TimeEstimateでmin_count未満に最小値 | E-12 (250行) | ○ |
| C-100 (UT-GRP-100) | CostModel::RecordSizeでサイズ記録 | E-12 (201-213行) | ○ |
| C-101 (UT-GRP-101) | CostModel::TotalBytesで総バイト数取得 | E-12 (215-222行) | ○ |
| C-102 (UT-GRP-102) | CostModel::SizeEstimateでサイズ見積もり | E-12 (224-228行) | ○ |
| C-103 (UT-GRP-103) | CostModel::MergeFromLocalでローカルマージ | E-12 (55-83行) | ○ |
| C-104 (UT-GRP-104) | CostModel::MergeFromGlobalでグローバルマージ | E-12 (85-111行) | ○ |
| C-105 (UT-GRP-105) | CostModel::RecordMaxMemorySizeで最大メモリ記録 | E-12 (270-294行) | ○ |
| C-106 (UT-GRP-106) | CostModel::CopyTimeEstimateでコピー時間推定 | E-12 (395-408行) | ○ |
| C-107 (UT-GRP-107) | OptimizeCSEで共通部分式が削除される | E-14 (270-330行) | ○ |
| C-108 (UT-GRP-108) | OptimizeCSEで変更なしにfalse | E-14 (294, 329行) | ○ |
| C-109 (UT-GRP-109) | OptimizeCSEでconsider_fnでスキップ | E-14 (307行) | ○ |
| C-110 (UT-GRP-110) | OptimizerCSE::NodeHashで同一ハッシュ | E-14 (199-230行) | ○ |
| C-111 (UT-GRP-111) | OptimizerCSE::Equivalentで同値判定true | E-14 (239-268行) | ○ |
| C-112 (UT-GRP-112) | OptimizerCSE::Equivalentで異なるOp名にfalse | E-14 (242行) | ○ |
| C-113 (UT-GRP-113) | OptimizerCSE::Equivalentでstateful Opにfalse | E-14 (245行) | ○ |
| C-114 (UT-GRP-114) | BuildControlFlowInfoで制御フロー情報構築 | E-16 (86-186行) | ○ |
| C-115 (UT-GRP-115) | BuildControlFlowInfoで異なるフレームにエラー | E-16 (140-147, 161-168行) | ○ |
| C-116 (UT-GRP-116) | BuildControlFlowInfoで到達不能ノードレポート | E-16 (177-183行) | ○ |
| C-117 (UT-GRP-117) | BuildControlFlowInfoで複数LoopCondにエラー | E-16 (69-78行) ValidateControlFlowInfo内 | ○ |
| C-118 (UT-GRP-118) | Partitionでグラフがデバイス別に分割 | E-18 (978-1313行) | ○ |
| C-119 (UT-GRP-119) | PartitionでSend/Recvノードが挿入 | E-18 (185-325行) AddSend/AddRecv | ○ |
| C-120 (UT-GRP-120) | Partitionで不完全グラフにエラー | E-18 (1084-1088行) | ○ |
| C-121 (UT-GRP-121) | AddControlEdgesでスケジューリングエッジ追加 | E-18 (882-941行) | ○ |
| C-122 (UT-GRP-122) | RewriteGraphForExecutionでグラフ書き換え | E-20 (298-334行) | ○ |
| C-123 (UT-GRP-123) | RewriteGraphForExecutionで空入力にエラー | E-20 (348-351行) | ○ |
| C-124 (UT-GRP-124) | RewriteGraphForExecutionでfeed/fetch同名にエラー | E-20 (363-368行) | ○ |
| C-125 (UT-GRP-125) | RewriteGraphForExecutionで重複feedにエラー | E-20 (354-361行) | ○ |
| C-126 (UT-GRP-126) | ArgFeedRewrite::AddNodeで_Arg追加 | E-20 (221-236行) | ○ |
| C-127 (UT-GRP-127) | RecvFeedRewrite::AddNodeで_Recv追加 | E-20 (238-257行) | ○ |
| C-128 (UT-GRP-128) | RetvalFetchRewrite::AddNodeで_Retval追加 | E-20 (259-277行) | ○ |
| C-129 (UT-GRP-129) | SendFetchRewrite::AddNodeで_Send追加 | E-20 (279-296行) | ○ |
| C-130 (UT-GRP-130) | FeedInputsで存在しないfeedにNotFound | E-20 (68-70行) | ○ |
| C-131 (UT-GRP-131) | FetchOutputsで存在しないfetchにNotFound | E-20 (137-139行) | ○ |
| C-132 (UT-GRP-132) | FetchOutputsで出力なしノードにエラー | E-20 (145-152行) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- すべてのテストケースはソースコードを直接参照して作成されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいて作成されており、信頼性は高い
- ただし以下の点は追加確認を推奨：
  - C++のテンプレートメソッドに関するテストケース（NodeBuilder::Attr等）
  - マルチスレッド環境での動作（Graphクラスはスレッドセーフではないと明記されている）
  - パフォーマンスに関するテスト（CostModel関連）

## 6) レビュアーチェックリスト（最小）
- [ ] Graph初期化関連テスト（UT-GRP-001〜005）の網羅性確認
- [ ] エッジ操作関連テスト（UT-GRP-010〜018）の整合性確認
- [ ] 検証関数テスト（UT-GRP-085〜092）のエラー条件網羅性確認
- [ ] パーティション機能テスト（UT-GRP-118〜121）の境界条件確認
- [ ] サブグラフ書き換えテスト（UT-GRP-122〜132）のエラーハンドリング確認
