---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 140
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：core-grappler 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：140 / 140、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースに根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/grappler/utils.h` - NodeMap、SetVector、ユーティリティ関数の定義
- E-02: `tensorflow/core/grappler/graph_view.h` - GraphViewInternal、GraphViewクラスの定義
- E-03: `tensorflow/core/grappler/mutable_graph_view.h` - MutableGraphViewクラスの定義
- E-04: `tensorflow/core/grappler/costs/cost_estimator.h` - Costs構造体、CostEstimatorインターフェースの定義
- E-05: `tensorflow/core/grappler/costs/op_level_cost_estimator.h` - OpLevelCostEstimatorクラスの定義
- E-06: `tensorflow/core/grappler/optimizers/graph_optimizer.h` - GraphOptimizerインターフェースの定義
- E-07: `tensorflow/core/grappler/optimizers/constant_folding.h` - ConstantFoldingクラスの定義
- E-08: `tensorflow/core/grappler/optimizers/meta_optimizer.h` - MetaOptimizerクラスの定義
- E-09: `tensorflow/core/grappler/clusters/cluster.h` - Clusterクラスの定義
- E-10: `tensorflow/core/grappler/grappler_item.h` - GrapplerItem構造体の定義
- E-11: `tensorflow/core/grappler/utils/topological_sort.h` - トポロジカルソート関数の定義
- E-12: `tensorflow/core/grappler/utils/symbolic_shapes.h` - シンボリック形状ユーティリティの定義
- E-13: `tensorflow/core/grappler/costs/graph_properties.h` - GraphPropertiesクラスの定義
- E-14: `tensorflow/core/grappler/costs/virtual_scheduler.h` - VirtualScheduler、ReadyNodeManager、SchedulerStateクラスの定義

## 3) Claims と根拠の対応（レビューの主戦場）

### NodeMap / NodeMapInternal (UT-GRP-001 - UT-GRP-010)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NodeMapInternal正常系テスト | E-01 (utils.h:104-234) | ○ |
| C-02 | NodeMapInternal nullptrテスト | E-01 (utils.h:109-112) | ○ |
| C-03 | GetOutputs正常系テスト | E-01 (utils.h:133-140) | ○ |
| C-04 | GetOutputs境界値テスト | E-01 (utils.h:133-140) | ○ |
| C-05 | GetNode正常系テスト | E-01 (utils.h:174-182) | ○ |
| C-06 | GetNode異常系テスト | E-01 (utils.h:177-179) | ○ |
| C-07 | AddNode正常系テスト | E-01 (utils.h:161-167) | ○ |
| C-08 | AddNode異常系テスト | E-01 (utils.h:164-166) | ○ |
| C-09 | RemoveNode正常系テスト | E-01 (utils.h:169-172) | ○ |
| C-10 | UpdateInput正常系テスト | E-01 (utils.h:201-206) | ○ |

### SetVector (UT-GRP-011 - UT-GRP-014)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | SetVector PushBack正常系テスト | E-01 (utils.h:271-277) | ○ |
| C-12 | SetVector PushBack重複テスト | E-01 (utils.h:272) | ○ |
| C-13 | SetVector PopBack正常系テスト | E-01 (utils.h:279-284) | ○ |
| C-14 | SetVector Exists正常系テスト | E-01 (utils.h:286) | ○ |

### ユーティリティ関数 (UT-GRP-015 - UT-GRP-020)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | IsControlInput制御入力判定 | E-01 (utils.h:307) | ○ |
| C-16 | IsControlInput通常入力判定 | E-01 (utils.h:307) | ○ |
| C-17 | NodeName正常系テスト | E-01 (utils.h:91-93) | ○ |
| C-18 | NodeName空文字列テスト | E-01 (utils.h:91-93) | ○ |
| C-19 | NodePosition正常系テスト | E-01 (utils.h:95-99) | ○ |
| C-20 | NodePosition制御入力テスト | E-01 (utils.h:67-71) | ○ |

### GraphView (UT-GRP-021 - UT-GRP-033)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | GraphView構築テスト | E-02 (graph_view.h:403-409) | ○ |
| C-22 | GetNode正常系テスト | E-02 (graph_view.h:117-119) | ○ |
| C-23 | GetNode異常系テスト | E-02 (graph_view.h:118) | ○ |
| C-24 | HasNode正常系テスト | E-02 (graph_view.h:122-124) | ○ |
| C-25 | GetInputPort正常系テスト | E-02 (graph_view.h:129-131) | ○ |
| C-26 | GetOutputPort正常系テスト | E-02 (graph_view.h:136-138) | ○ |
| C-27 | GetFanout正常系テスト | E-02 (graph_view.h:141-144) | ○ |
| C-28 | GetFanin正常系テスト | E-02 (graph_view.h:147-167) | ○ |
| C-29 | GetRegularFanin正常系テスト | E-02 (graph_view.h:172-181) | ○ |
| C-30 | GetRegularFanin境界値テスト | E-02 (graph_view.h:173-177) | ○ |
| C-31 | HasFanin正常系テスト | E-02 (graph_view.h:184-204) | ○ |
| C-32 | NumFanins正常系テスト | E-02 (graph_view.h:248-253) | ○ |
| C-33 | NumFanouts正常系テスト | E-02 (graph_view.h:257-273) | ○ |

### MutableGraphView (UT-GRP-034 - UT-GRP-049)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | MutableGraphView構築テスト | E-03 (mutable_graph_view.h:45-48) | ○ |
| C-35 | AddNode正常系テスト | E-03 (mutable_graph_view.h:64) | ○ |
| C-36 | AddSubgraph正常系テスト | E-03 (mutable_graph_view.h:77) | ○ |
| C-37 | UpdateNode正常系テスト | E-03 (mutable_graph_view.h:83-86) | ○ |
| C-38 | UpdateNode異常系テスト | E-03 (mutable_graph_view.h:83-86) | ○ |
| C-39 | UpdateNodeName正常系テスト | E-03 (mutable_graph_view.h:92-94) | ○ |
| C-40 | UpdateNodeName異常系テスト | E-03 (mutable_graph_view.h:92-94) | ○ |
| C-41 | SwapNodeNames正常系テスト | E-03 (mutable_graph_view.h:120-122) | ○ |
| C-42 | UpdateFanouts正常系テスト | E-03 (mutable_graph_view.h:136-137) | ○ |
| C-43 | AddRegularFanin正常系テスト | E-03 (mutable_graph_view.h:144-145) | ○ |
| C-44 | AddControllingFanin正常系テスト | E-03 (mutable_graph_view.h:179-180) | ○ |
| C-45 | RemoveRegularFanin正常系テスト | E-03 (mutable_graph_view.h:189-190) | ○ |
| C-46 | RemoveControllingFanin正常系テスト | E-03 (mutable_graph_view.h:207-208) | ○ |
| C-47 | UpdateFanin正常系テスト | E-03 (mutable_graph_view.h:224-226) | ○ |
| C-48 | DeleteNodes正常系テスト | E-03 (mutable_graph_view.h:255-256) | ○ |
| C-49 | DeleteNodes異常系テスト | E-03 (mutable_graph_view.h:253-256) | ○ |

### Costs / CostEstimator (UT-GRP-050 - UT-GRP-055)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | Costsコンストラクタテスト | E-04 (cost_estimator.h:209-220) | ○ |
| C-51 | ZeroCosts正常系テスト | E-04 (cost_estimator.h:222-236) | ○ |
| C-52 | CombineCosts正常系テスト | E-04 (cost_estimator.h:238) | ○ |
| C-53 | MultiplyCosts正常系テスト | E-04 (cost_estimator.h:242) | ○ |
| C-54 | CostEstimator Initialize正常系テスト | E-04 (cost_estimator.h:254) | ○ |
| C-55 | CostEstimator PredictCosts正常系テスト | E-04 (cost_estimator.h:264-266) | ○ |

### OpLevelCostEstimator (UT-GRP-056 - UT-GRP-066)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | PredictCosts正常系テスト | E-05 (op_level_cost_estimator.h:104) | ○ |
| C-57 | GetDeviceInfo正常系テスト | E-05 (op_level_cost_estimator.h:107) | ○ |
| C-58 | PredictConv2D正常系テスト | E-05 (op_level_cost_estimator.h:144-145) | ○ |
| C-59 | PredictMatMul正常系テスト | E-05 (op_level_cost_estimator.h:154-155) | ○ |
| C-60 | CountConv2DOperations正常系テスト | E-05 (op_level_cost_estimator.h:241-245) | ○ |
| C-61 | CountMatMulOperations正常系テスト | E-05 (op_level_cost_estimator.h:246-254) | ○ |
| C-62 | CalculateTensorSize正常系テスト | E-05 (op_level_cost_estimator.h:275-276) | ○ |
| C-63 | CalculateInputSize正常系テスト | E-05 (op_level_cost_estimator.h:285-286) | ○ |
| C-64 | CalculateOutputSize正常系テスト | E-05 (op_level_cost_estimator.h:294-295) | ○ |
| C-65 | SafeDiv正常系テスト | E-05 (op_level_cost_estimator.h:206-211) | ○ |
| C-66 | SafeDiv境界値テスト | E-05 (op_level_cost_estimator.h:207-211) | ○ |

### GraphOptimizer (UT-GRP-067 - UT-GRP-069)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | Optimize正常系テスト | E-06 (graph_optimizer.h:59-60) | ○ |
| C-68 | DeadlineExceeded正常系テスト（未超過） | E-06 (graph_optimizer.h:74-76) | ○ |
| C-69 | DeadlineExceeded正常系テスト（超過） | E-06 (graph_optimizer.h:74-76) | ○ |

### ConstantFolding (UT-GRP-070 - UT-GRP-077)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | ConstantFolding Optimize正常系テスト | E-07 (constant_folding.h:62-63) | ○ |
| C-71 | CreateNodeDef正常系テスト | E-07 (constant_folding.h:43-45) | ○ |
| C-72 | AddControlDependency正常系テスト | E-07 (constant_folding.h:46-47) | ○ |
| C-73 | IsFoldable正常系テスト | E-07 (constant_folding.h:86-90) | ○ |
| C-74 | FoldNode正常系テスト | E-07 (constant_folding.h:101-102) | ○ |
| C-75 | SimplifyArithmeticOperations正常系テスト | E-07 (constant_folding.h:217-220) | ○ |
| C-76 | SimplifyReshape正常系テスト | E-07 (constant_folding.h:223-224) | ○ |
| C-77 | SimplifyReduction正常系テスト | E-07 (constant_folding.h:248-249) | ○ |

### MetaOptimizer (UT-GRP-078 - UT-GRP-081)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | MetaOptimizer Optimize正常系テスト | E-08 (meta_optimizer.h:44-48) | ○ |
| C-79 | OptimizeConsumeItem正常系テスト | E-08 (meta_optimizer.h:50-51) | ○ |
| C-80 | MetaOptimizerEnabled正常系テスト | E-08 (meta_optimizer.h:125) | ○ |
| C-81 | RunMetaOptimizer正常系テスト | E-08 (meta_optimizer.h:133-135) | ○ |

### Cluster (UT-GRP-082 - UT-GRP-087)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | Provision正常系テスト | E-09 (cluster.h:57) | ○ |
| C-83 | Shutdown正常系テスト | E-09 (cluster.h:63) | ○ |
| C-84 | Initialize正常系テスト | E-09 (cluster.h:126) | ○ |
| C-85 | Run正常系テスト | E-09 (cluster.h:129-132) | ○ |
| C-86 | GetDevices正常系テスト | E-09 (cluster.h:97-99) | ○ |
| C-87 | AllowSoftPlacement正常系テスト | E-09 (cluster.h:69) | ○ |

### GrapplerItem (UT-GRP-088 - UT-GRP-092)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | WithGraph正常系テスト | E-10 (grappler_item.h:47) | ○ |
| C-89 | MainOpsFanin正常系テスト | E-10 (grappler_item.h:75) | ○ |
| C-90 | NodesToPreserve正常系テスト | E-10 (grappler_item.h:84) | ○ |
| C-91 | AddDevice正常系テスト | E-10 (grappler_item.h:115) | ○ |
| C-92 | AddDevice異常系テスト | E-10 (grappler_item.h:115) | ○ |

### TopologicalSort (UT-GRP-093 - UT-GRP-096)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | TopologicalSort正常系テスト | E-11 (topological_sort.h:50) | ○ |
| C-94 | TopologicalSort異常系テスト | E-11 (topological_sort.h:50) | ○ |
| C-95 | ComputeTopologicalOrder正常系テスト | E-11 (topological_sort.h:42-47) | ○ |
| C-96 | ReversedTopologicalSort正常系テスト | E-11 (topological_sort.h:53) | ○ |

### SymbolicShapes (UT-GRP-097 - UT-GRP-103)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | IsKnown正常系テスト | E-12 (symbolic_shapes.h:26) | ○ |
| C-98 | IsUnknown正常系テスト | E-12 (symbolic_shapes.h:28) | ○ |
| C-99 | ShapeIsSymbolicallyDefined正常系テスト | E-12 (symbolic_shapes.h:32-33) | ○ |
| C-100 | ShapesSymbolicallyEqual正常系テスト | E-12 (symbolic_shapes.h:45-48) | ○ |
| C-101 | ShapesBroadcastable正常系テスト | E-12 (symbolic_shapes.h:52-55) | ○ |
| C-102 | NumCoefficients正常系テスト | E-12 (symbolic_shapes.h:41) | ○ |
| C-103 | NumCoefficients境界値テスト | E-12 (symbolic_shapes.h:41) | ○ |

### GraphProperties (UT-GRP-104 - UT-GRP-110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-104 | InferStatically正常系テスト | E-13 (graph_properties.h:99-116) | ○ |
| C-105 | InferDynamically正常系テスト | E-13 (graph_properties.h:119) | ○ |
| C-106 | GetInputProperties正常系テスト | E-13 (graph_properties.h:135-136) | ○ |
| C-107 | GetOutputProperties正常系テスト | E-13 (graph_properties.h:137-138) | ○ |
| C-108 | HasInputProperties正常系テスト | E-13 (graph_properties.h:133) | ○ |
| C-109 | ClearInputProperties正常系テスト | E-13 (graph_properties.h:143) | ○ |
| C-110 | AnnotateOutputShapes正常系テスト | E-13 (graph_properties.h:125) | ○ |

### VirtualScheduler (UT-GRP-111 - UT-GRP-125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | VirtualScheduler Init正常系テスト | E-14 (virtual_scheduler.h:492) | ○ |
| C-112 | GetCurrNode正常系テスト | E-14 (virtual_scheduler.h:496) | ○ |
| C-113 | MarkCurrNodeExecuted正常系テスト | E-14 (virtual_scheduler.h:501) | ○ |
| C-114 | Summary正常系テスト | E-14 (virtual_scheduler.h:504-509) | ○ |
| C-115 | GetPeakMemoryUsage正常系テスト | E-14 (virtual_scheduler.h:516-518) | ○ |
| C-116 | SchedulerState Init正常系テスト | E-14 (virtual_scheduler.h:356-358) | ○ |
| C-117 | CreateOpContext正常系テスト | E-14 (virtual_scheduler.h:384) | ○ |
| C-118 | MarkNodeExecuted正常系テスト | E-14 (virtual_scheduler.h:385-388) | ○ |
| C-119 | FIFOManager AddNode正常系テスト | E-14 (virtual_scheduler.h:189) | ○ |
| C-120 | FIFOManager GetCurrNode正常系テスト | E-14 (virtual_scheduler.h:190-193) | ○ |
| C-121 | FIFOManager Empty境界値テスト | E-14 (virtual_scheduler.h:195) | ○ |
| C-122 | LIFOManager AddNode正常系テスト | E-14 (virtual_scheduler.h:209) | ○ |
| C-123 | LIFOManager GetCurrNode正常系テスト | E-14 (virtual_scheduler.h:210) | ○ |
| C-124 | FirstReadyManager Greater正常系テスト | E-14 (virtual_scheduler.h:265) | ○ |
| C-125 | CompositeNodeManager AddNode正常系テスト | E-14 (virtual_scheduler.h:302) | ○ |

### 追加ユーティリティ関数 (UT-GRP-126 - UT-GRP-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | AddPrefixToNodeName正常系テスト | E-01 (utils.h:316-322) | ○ |
| C-127 | AsControlDependency正常系テスト | E-01 (utils.h:335-339) | ○ |
| C-128 | NodeIsOnCpu正常系テスト | E-01 (utils.h:342) | ○ |
| C-129 | NodeIsOnGpu正常系テスト | E-01 (utils.h:345) | ○ |
| C-130 | NumOutputs正常系テスト | E-01 (utils.h:349) | ○ |
| C-131 | HasControlInputs正常系テスト | E-01 (utils.h:352) | ○ |
| C-132 | NumControlInputs正常系テスト | E-01 (utils.h:364) | ○ |
| C-133 | DedupControlInputs正常系テスト | E-01 (utils.h:380) | ○ |
| C-134 | CheckAttrExists正常系テスト | E-01 (utils.h:383) | ○ |
| C-135 | CheckAttrExists異常系テスト | E-01 (utils.h:383) | ○ |
| C-136 | GetDataTypeFromAttr正常系テスト | E-01 (utils.h:391) | ○ |
| C-137 | GetDataTypeFromAttr異常系テスト | E-01 (utils.h:391) | ○ |
| C-138 | GetTailOfChain正常系テスト | E-01 (utils.h:402-404) | ○ |
| C-139 | EraseNodesFromGraph正常系テスト | E-01 (utils.h:421-426) | ○ |
| C-140 | IsKernelRegisteredForNode正常系テスト | E-01 (utils.h:412-417) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースはヘッダーファイルのクラス定義、関数シグネチャ、コメントに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースにソースコード根拠があります
- 1: 中リスク - 一部のテストケースは実装の詳細（.ccファイル）を確認する必要があるかもしれません
  - 特にConstantFolding、MetaOptimizerなどの複雑な最適化ロジック
  - VirtualSchedulerの状態管理ロジック

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースのテスト観点（正常系/異常系/境界値）が適切に分類されているか確認
- [ ] 期待結果が具体的かつ検証可能であるか確認
- [ ] 優先度の設定が適切であるか確認（金額計算やセキュリティ関連は高優先度など）
- [ ] モジュール略称（GRP）がプロジェクト内で重複していないか確認
- [ ] 実際の.ccファイルの実装詳細と整合性があるか確認
- [ ] 既存のテストコード（*_test.cc）との重複や不足がないか確認
