---
generated_at: 2026-02-03 15:30:00
metrics:
  claims_total: 153
  claims_with_evidence: 153
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：core-ir 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：153 / 153、根拠なし：0
- 優先レビュー（高）
  1. テストケースの網羅性：各クラス/関数の全メソッドがカバーされているか確認推奨
  2. 境界値テストの追加検討：一部の関数で境界値テストを追加する余地あり
  3. 異常系テストの拡充：外部依存（OpRegistry等）のエラー処理の検証を追加検討

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `tensorflow/core/ir/ops.h` - TFG ops ヘッダファイル（FunctionTable, GraphOp等の定義）
- E-02: `tensorflow/core/ir/ops.cc` - TFG ops 実装ファイル（TFGraphDialect, GraphOp, GraphFuncOp, ReturnOp等）
- E-03: `tensorflow/core/ir/interfaces.h` - インターフェース定義（TensorFlowRegistryInterfaceBase, StatefulMemoryEffectInterface等）
- E-04: `tensorflow/core/ir/interfaces.cc` - インターフェース実装（ControlArgumentInterface::verifyRegion, StatefulMemoryEffectInterface::getEffects）
- E-05: `tensorflow/core/ir/tf_op_wrapper.h` - TFOp wrapperクラス定義
- E-06: `tensorflow/core/ir/tf_op_wrapper.cc` - TFOp wrapperクラス実装
- E-07: `tensorflow/core/ir/utility.h` - ユーティリティ関数定義（SplitDataAndControlValues等）
- E-08: `tensorflow/core/ir/utility.cc` - ユーティリティ関数実装（GetLoopRegionDataArgs, LookupControlDependency等）
- E-09: `tensorflow/core/ir/tf_op_registry.h` - TensorFlow Op Registryインターフェース定義
- E-10: `tensorflow/core/ir/tf_op_registry.cc` - TensorFlow Op Registryインターフェース実装
- E-11: `tensorflow/core/ir/types/dialect.h` - TFType dialect定義（TensorFlowType, TensorFlowRefType, ResourceType等）
- E-12: `tensorflow/core/ir/types/dialect.cc` - TFType dialect実装（型パース/プリント、属性、型変換関数等）
- E-13: `tensorflow/core/ir/importexport/convert_types.h` - 型変換関数定義
- E-14: `tensorflow/core/ir/importexport/convert_types.cc` - 型変換関数実装
- E-15: `tensorflow/core/ir/importexport/graphdef_import.h` - GraphDefインポート関数定義
- E-16: `tensorflow/core/ir/importexport/graphdef_export.h` - GraphDefエクスポート関数定義
- E-17: `tensorflow/core/ir/importexport/convert_attributes.h` - 属性変換関数定義
- E-18: `tensorflow/core/ir/importexport/convert_tensor.h` - テンソル変換関数定義
- E-19: `tensorflow/core/ir/importexport/mangling.h` - マングリング関数定義
- E-20: `tensorflow/core/ir/utils/shape_inference_utils.h` - シェイプ推論ユーティリティ定義

## 3) Claims と根拠の対応（レビューの主戦場）

### TFGraphDialect関連 (UT-CIR-001 〜 UT-CIR-008)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TFGraphDialect::initializeの正常動作 | E-02 (ops.cc L101-143) | ○ |
| C-02 | getRegisteredInterfaceForOp(OpAsmOpInterface) | E-02 (ops.cc L146-172) | ○ |
| C-03 | getRegisteredInterfaceForOp(MemoryEffectOpInterface) | E-02 (ops.cc L164-168) | ○ |
| C-04 | IntrinsicOperationトレイト処理 | E-02 (ops.cc L153-155) | ○ |
| C-05 | printCustomTfOp正常系 | E-02 (ops.cc L202-257) | ○ |
| C-06 | printCustomTfOp異常系（不正順序） | E-02 (ops.cc L210-232) | ○ |
| C-07 | ParseCustomTfOp正常系 | E-02 (ops.cc L294-336) | ○ |
| C-08 | ParseCustomTfOp異常系 | E-02 (ops.cc L299-307) | ○ |

### GraphOp関連 (UT-CIR-009 〜 UT-CIR-010)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | GraphOp::verify正常系 | E-02 (ops.cc L388-394) | ○ |
| C-10 | GraphOp::verify異常系 | E-02 (ops.cc L391) | ○ |

### GraphFuncOp関連 (UT-CIR-011 〜 UT-CIR-025)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | isMarkedForCompilation(_xla_compile_id) | E-02 (ops.cc L399-411) | ○ |
| C-12 | isMarkedForCompilation(_tpu_replicate) | E-02 (ops.cc L409) | ○ |
| C-13 | isMarkedForCompilation(_XlaMustCompile) | E-02 (ops.cc L410) | ○ |
| C-14 | isMarkedForCompilation(属性なし) | E-02 (ops.cc L399-411) | ○ |
| C-15 | verifyBody正常系 | E-02 (ops.cc L420-480) | ○ |
| C-16 | verifyBody空ボディ | E-02 (ops.cc L424-425) | ○ |
| C-17 | verifyBody不正終端 | E-02 (ops.cc L441-444) | ○ |
| C-18 | verifyBody型不一致 | E-02 (ops.cc L431-439) | ○ |
| C-19 | verify偶数引数 | E-02 (ops.cc L504-519) | ○ |
| C-20 | verify奇数引数 | E-02 (ops.cc L506-507) | ○ |
| C-21 | canonicalize | E-02 (ops.cc L482-502) | ○ |
| C-22 | getCalledFunction(PartitionedCall) | E-02 (ops.cc L721-735) | ○ |
| C-23 | getCalledFunction(StatefulPartitionedCall) | E-02 (ops.cc L726) | ○ |
| C-24 | getDataValueOf | E-02 (ops.cc L737-739) | ○ |
| C-25 | getControlTokenOf | E-02 (ops.cc L741-743) | ○ |

### ReturnOp関連 (UT-CIR-026 〜 UT-CIR-028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | ReturnOp::verify正常系 | E-02 (ops.cc L782-792) | ○ |
| C-27 | ReturnOp::verify異常系 | E-02 (ops.cc L786-789) | ○ |
| C-28 | ReturnOp::build | E-02 (ops.cc L854-863) | ○ |

### ForOp関連 (UT-CIR-029 〜 UT-CIR-030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | ForOp::verifySymbolUses正常系 | E-02 (ops.cc L1104-1121) | ○ |
| C-30 | ForOp::verifySymbolUses異常系 | E-02 (ops.cc L1116-1118) | ○ |

### Region Op関連 (UT-CIR-031 〜 UT-CIR-036)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | YieldOp::getMutableSuccessorOperands | E-02 (ops.cc L1173-1178) | ○ |
| C-32 | ConditionOp::getMutableSuccessorOperands | E-02 (ops.cc L1318-1323) | ○ |
| C-33 | ForRegionOp::verify正常系 | E-02 (ops.cc L1404-1423) | ○ |
| C-34 | ForRegionOp::verify不正終端 | E-02 (ops.cc L1405-1407) | ○ |
| C-35 | ForRegionOp::verify引数なし | E-02 (ops.cc L1410-1413) | ○ |
| C-36 | ForRegionOp::verify引数型不正 | E-02 (ops.cc L1415-1419) | ○ |

### FunctionTable関連 (UT-CIR-037 〜 UT-CIR-042)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | FunctionTableコンストラクタ | E-02 (ops.cc L1463-1469), E-01 (ops.h L46-62) | ○ |
| C-38 | FunctionTable::empty | E-01 (ops.h L50) | ○ |
| C-39 | FunctionTable::MayBeCall(レガシー) | E-02 (ops.cc L1471-1479), E-01 (ops.h L53) | ○ |
| C-40 | FunctionTable::MayBeCall(シンボル参照) | E-02 (ops.cc L1474-1478) | ○ |
| C-41 | FunctionTable::IsLegacyCall(一致) | E-02 (ops.cc L1481-1485), E-01 (ops.h L57) | ○ |
| C-42 | FunctionTable::IsLegacyCall(不一致) | E-02 (ops.cc L1484) | ○ |

### TFOp関連 (UT-CIR-043 〜 UT-CIR-059)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | TFOpコンストラクタ正常系 | E-06 (tf_op_wrapper.cc L27-29), E-05 (tf_op_wrapper.h L61) | ○ |
| C-44 | TFOpコンストラクタnullptr | E-05 (tf_op_wrapper.h L61) | ○ |
| C-45 | TFOp::nameAttr | E-06 (tf_op_wrapper.cc L31-33), E-05 (tf_op_wrapper.h L100-101) | ○ |
| C-46 | TFOp::setName | E-06 (tf_op_wrapper.cc L37-43), E-05 (tf_op_wrapper.h L103-104) | ○ |
| C-47 | TFOp::requestedDeviceAttr | E-06 (tf_op_wrapper.cc L45-48), E-05 (tf_op_wrapper.h L108-109) | ○ |
| C-48 | TFOp::setRequestedDevice | E-06 (tf_op_wrapper.cc L52-58), E-05 (tf_op_wrapper.h L111-112) | ○ |
| C-49 | TFOp::assignedDeviceAttr | E-06 (tf_op_wrapper.cc L60-63), E-05 (tf_op_wrapper.h L115-116) | ○ |
| C-50 | TFOp::setAssignedDevice | E-06 (tf_op_wrapper.cc L67-73), E-05 (tf_op_wrapper.h L118-119) | ○ |
| C-51 | TFOp::tpuReplicate | E-06 (tf_op_wrapper.cc L75-77), E-05 (tf_op_wrapper.h L122) | ○ |
| C-52 | TFOp::setTpuReplicate | E-06 (tf_op_wrapper.cc L79-81), E-05 (tf_op_wrapper.h L124) | ○ |
| C-53 | TFOp::deviceAttr優先度 | E-05 (tf_op_wrapper.h L128-135) | ○ |
| C-54 | TFOp::deviceAttrフォールバック | E-05 (tf_op_wrapper.h L134) | ○ |
| C-55 | TFOp::splitOperands | E-05 (tf_op_wrapper.h L80-83) | ○ |
| C-56 | TFOp::getNonControlOperands | E-05 (tf_op_wrapper.h L86) | ○ |
| C-57 | TFOp::getControlOperands | E-05 (tf_op_wrapper.h L89) | ○ |
| C-58 | TFOp::controlRet | E-05 (tf_op_wrapper.h L92) | ○ |
| C-59 | TFOp::getNonControlResults | E-05 (tf_op_wrapper.h L95-97) | ○ |

### utility関連 (UT-CIR-060 〜 UT-CIR-071)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | GetLoopRegionDataArgs | E-08 (utility.cc L35-38), E-07 (utility.h L41) | ○ |
| C-61 | GetLoopRegionControlTokens | E-08 (utility.cc L39-42), E-07 (utility.h L44) | ○ |
| C-62 | GetLoopRegionControlOf | E-08 (utility.cc L43-46), E-07 (utility.h L48) | ○ |
| C-63 | GetLoopRegionDataOf | E-08 (utility.cc L47-50), E-07 (utility.h L52) | ○ |
| C-64 | LookupControlDependency(OpResult) | E-08 (utility.cc L52-67), E-07 (utility.h L58) | ○ |
| C-65 | LookupControlDependency(BlockArgument) | E-08 (utility.cc L60-62) | ○ |
| C-66 | LookupDataValue(OpResult) | E-08 (utility.cc L69-84), E-07 (utility.h L64) | ○ |
| C-67 | LookupDataValue単一コントロール | E-08 (utility.cc L75) | ○ |
| C-68 | LookupDataValue(BlockArgument) | E-08 (utility.cc L78-80) | ○ |
| C-69 | SplitDataAndControlValues正常系 | E-07 (utility.h L70-82) | ○ |
| C-70 | SplitDataAndControlValues空リスト | E-07 (utility.h L70-82) | ○ |
| C-71 | SplitDataAndControlValues全コントロール | E-07 (utility.h L72-78) | ○ |

### interfaces関連 (UT-CIR-072 〜 UT-CIR-076)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | ControlArgumentInterface::verifyRegion正常系 | E-04 (interfaces.cc L30-45) | ○ |
| C-73 | ControlArgumentInterface::verifyRegion異常系 | E-04 (interfaces.cc L38-43) | ○ |
| C-74 | StatefulMemoryEffectInterface::getEffectsステートフル | E-04 (interfaces.cc L47-59), E-03 (interfaces.h L47-62) | ○ |
| C-75 | StatefulMemoryEffectInterface::getEffectsステートレス | E-04 (interfaces.cc L51-56) | ○ |
| C-76 | StatefulMemoryEffectInterface::getEffects(GraphOp内) | E-04 (interfaces.cc L56) | ○ |

### tf_op_registry関連 (UT-CIR-077 〜 UT-CIR-081)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | isStateful(IntrinsicOperation) | E-10 (tf_op_registry.cc L42-44), E-09 (tf_op_registry.h L40) | ○ |
| C-78 | isStateful(GraphFuncOp) | E-10 (tf_op_registry.cc L45) | ○ |
| C-79 | isStateful(Region op) | E-10 (tf_op_registry.cc L48-51) | ○ |
| C-80 | IsStatefulImpl登録済み | E-10 (tf_op_registry.cc L33-40) | ○ |
| C-81 | IsStatefulImpl未登録 | E-10 (tf_op_registry.cc L37-38) | ○ |

### types/dialect関連 (UT-CIR-082 〜 UT-CIR-112)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | TFTypeDialect::initialize | E-12 (dialect.cc L65-75), E-11 (dialect.h) | ○ |
| C-83 | parseType(resource) | E-12 (dialect.cc L148-152) | ○ |
| C-84 | parseType(variant) | E-12 (dialect.cc L153-157) | ○ |
| C-85 | parseType不明型 | E-12 (dialect.cc L159-161) | ○ |
| C-86 | printType | E-12 (dialect.cc L166-182) | ○ |
| C-87 | VersionAttr::parse | E-12 (dialect.cc L188-215) | ○ |
| C-88 | VersionAttr::parse(bad_consumers) | E-12 (dialect.cc L199-209) | ○ |
| C-89 | ShapeAttr::parse(ranked) | E-12 (dialect.cc L387-421) | ○ |
| C-90 | ShapeAttr::parse(unranked) | E-12 (dialect.cc L390-398) | ○ |
| C-91 | ShapeAttr::parse(動的次元) | E-12 (dialect.cc L405-406) | ○ |
| C-92 | ShapeAttr::hasRank(true) | E-12 (dialect.cc L444) | ○ |
| C-93 | ShapeAttr::hasRank(false) | E-12 (dialect.cc L444) | ○ |
| C-94 | ShapeAttr::hasStaticShape(true) | E-12 (dialect.cc L451-459) | ○ |
| C-95 | ShapeAttr::hasStaticShape(false) | E-12 (dialect.cc L453-456) | ○ |
| C-96 | FuncAttr::parse | E-12 (dialect.cc L322-353) | ○ |
| C-97 | FuncAttr::parse(空シンボル) | E-12 (dialect.cc L330-338) | ○ |
| C-98 | TensorFlowRefType::get(float32) | E-12 (dialect.cc L535-540) | ○ |
| C-99 | TensorFlowRefType::get(int32) | E-12 (dialect.cc L564-580) | ○ |
| C-100 | TensorFlowRefType::RemoveRef(float) | E-12 (dialect.cc L597-601) | ○ |
| C-101 | TensorFlowRefType::RemoveRef(int32) | E-12 (dialect.cc L616-617) | ○ |
| C-102 | GetCastCompatibleType(同一型) | E-12 (dialect.cc L743-745) | ○ |
| C-103 | GetCastCompatibleType(ranked/unranked) | E-12 (dialect.cc L805-813) | ○ |
| C-104 | GetCastCompatibleType(動的次元) | E-12 (dialect.cc L815-817) | ○ |
| C-105 | GetCastCompatibleType非互換 | E-12 (dialect.cc L816-817) | ○ |
| C-106 | BroadcastCompatible(true) | E-12 (dialect.cc L675-723) | ○ |
| C-107 | BroadcastCompatible(false) | E-12 (dialect.cc L676, 688, 701) | ○ |
| C-108 | AreCastCompatible(true) | E-12 (dialect.cc L827-836) | ○ |
| C-109 | AreCastCompatible(false) | E-12 (dialect.cc L832) | ○ |
| C-110 | DropSubTypes | E-12 (dialect.cc L872-874) | ○ |
| C-111 | DropRefType | E-12 (dialect.cc L876) | ○ |
| C-112 | DropRefAndSubTypes | E-12 (dialect.cc L878) | ○ |

### importexport/convert_types関連 (UT-CIR-113 〜 UT-CIR-125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | ConvertDataType(DT_FLOAT) | E-14 (convert_types.cc L48-50) | ○ |
| C-114 | ConvertDataType(DT_INT32) | E-14 (convert_types.cc L62-64) | ○ |
| C-115 | ConvertDataType(DT_BOOL) | E-14 (convert_types.cc L52-54) | ○ |
| C-116 | ConvertDataType未サポート | E-14 (convert_types.cc L106-109) | ○ |
| C-117 | ConvertScalarTypeToDataType(f32) | E-14 (convert_types.cc L116-119) | ○ |
| C-118 | ConvertScalarTypeToDataType(i32) | E-14 (convert_types.cc L149-152) | ○ |
| C-119 | ConvertScalarTypeToDataType未サポート | E-14 (convert_types.cc L181-182) | ○ |
| C-120 | ConvertToDataType(ShapedType) | E-14 (convert_types.cc L185-193) | ○ |
| C-121 | ConvertToMlirShape(TensorShape) | E-14 (convert_types.cc L195-201) | ○ |
| C-122 | ConvertToMlirShape(TensorShapeProto) | E-14 (convert_types.cc L203-219) | ○ |
| C-123 | ConvertToMlirShape(動的次元) | E-14 (convert_types.cc L213-216) | ○ |
| C-124 | ConvertToMlirTensorType(ranked) | E-14 (convert_types.cc L221-231), E-13 (convert_types.h L49-51) | ○ |
| C-125 | ConvertToMlirTensorType(unranked) | E-14 (convert_types.cc L225-226) | ○ |

### importexport関連 (UT-CIR-126 〜 UT-CIR-153)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | ImportGraphDef | E-15 (graphdef_import.h L32-34) | ○ |
| C-127 | ImportGraphAndFunctionsToMlir | E-15 (graphdef_import.h L37-40) | ○ |
| C-128 | GetValueName | E-16 (graphdef_export.h L36) | ○ |
| C-129 | ConvertToGraphDef | E-16 (graphdef_export.h L40) | ○ |
| C-130 | ConvertToNodeDef | E-16 (graphdef_export.h L44-46) | ○ |
| C-131 | ConvertToFunctionDef | E-16 (graphdef_export.h L50-51) | ○ |
| C-132 | ConvertAttributes | E-17 (convert_attributes.h L36-39) | ○ |
| C-133 | ConvertAttribute(単一) | E-17 (convert_attributes.h L42) | ○ |
| C-134 | ConvertNonFuncAttributeValue | E-17 (convert_attributes.h L55-56) | ○ |
| C-135 | ConvertAttributeValue | E-17 (convert_attributes.h L59-60) | ○ |
| C-136 | ConvertTensorProto | E-18 (convert_tensor.h L34-35) | ○ |
| C-137 | ConvertTensor | E-18 (convert_tensor.h L38-39) | ○ |
| C-138 | ConvertToTensorProto | E-18 (convert_tensor.h L72-73) | ○ |
| C-139 | ConvertToTensor | E-18 (convert_tensor.h L76-77) | ○ |
| C-140 | ConvertTFShapeToMlir | E-18 (convert_tensor.h L80) | ○ |
| C-141 | ConvertMlirShapeToTF | E-18 (convert_tensor.h L83) | ○ |
| C-142 | MangleAttributeName | E-19 (mangling.h L42) | ○ |
| C-143 | IsMangledAttributeName(true) | E-19 (mangling.h L45) | ○ |
| C-144 | IsMangledAttributeName(false) | E-19 (mangling.h L45) | ○ |
| C-145 | DemangleAttributeName | E-19 (mangling.h L49) | ○ |
| C-146 | MangleShape | E-19 (mangling.h L55) | ○ |
| C-147 | DemangleShape | E-19 (mangling.h L57-58) | ○ |
| C-148 | MangleTensor | E-19 (mangling.h L61) | ○ |
| C-149 | DemangleTensor | E-19 (mangling.h L63-64) | ○ |
| C-150 | MangleDataType | E-19 (mangling.h L67) | ○ |
| C-151 | DemangleDataType | E-19 (mangling.h L69-70) | ○ |
| C-152 | InferReturnTypeComponentsForTFOp正常系 | E-20 (shape_inference_utils.h L74-80) | ○ |
| C-153 | InferReturnTypeComponentsForTFOp異常系 | E-20 (shape_inference_utils.h L74-80) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースはソースコードから直接導出されています

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 全テストケースがソースコードに基づいて生成されています
- 注意点:
  - importexport関連の一部関数（graphdef_import.cc, graphdef_export.cc等）の実装詳細は別ファイルにあるため、実装に基づく詳細なテストケースは実装ファイルの追加解析が必要
  - 既存のテストファイル（*_test.cc）との整合性確認を推奨

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの対象クラス/関数がソースコードに存在するか確認
- [ ] 正常系/異常系/境界値のバランスが適切か確認
- [ ] 優先度の設定が適切か確認（金額計算、認証認可、データ整合性は高優先度）
- [ ] 前提条件と入力値が具体的で実行可能か確認
- [ ] 期待結果が検証可能な形式で記述されているか確認
- [ ] importexport関連のテストケースについて、実装ファイルを参照して詳細を追加する必要があるか検討
