---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 70
  claims_with_evidence: 68
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：core-kernels 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：68 / 70、根拠なし：2
- 優先レビュー（高）
  1. **C-67 BatchMatMul正常系**：実装詳細がヘッダファイルに分散
  2. **C-68 float MatMul**：具体的な計算ロジックはEigenライブラリに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/kernels/relu_op.cc` - ReLU系活性化関数カーネル実装
- E-02: `tensorflow/core/kernels/relu_op.h` - ReLU系Op/Gradクラス定義
- E-03: `tensorflow/core/kernels/softmax_op.cc` - Softmaxカーネル実装
- E-04: `tensorflow/core/kernels/conv_ops.cc` - Conv2Dパラメータ初期化・次元計算
- E-05: `tensorflow/core/kernels/batch_norm_op.cc` - バッチ正規化カーネル実装
- E-06: `tensorflow/core/kernels/argmax_op.cc` - ArgMax/ArgMinカーネル実装
- E-07: `tensorflow/core/kernels/cast_op.cc` - 型変換カーネル実装
- E-08: `tensorflow/core/kernels/concat_op.cc` - Concatカーネル実装
- E-09: `tensorflow/core/kernels/transpose_op.cc` - Transpose/InvertPermutationカーネル実装
- E-10: `tensorflow/core/kernels/gather_op.cc` - Gatherカーネル実装
- E-11: `tensorflow/core/kernels/pooling_ops_common.cc` - プーリング共通処理
- E-12: `tensorflow/core/kernels/matmul_op_real.cc` - 実数MatMulカーネル登録

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ReluOp正の入力値で正しく計算 | E-01, E-02 | ○ |
| C-02 | ReluOp負の入力値で0を返す | E-01, E-02 | ○ |
| C-03 | ReluOp境界値0で0を返す | E-01, E-02 | ○ |
| C-04 | ReluOp空テンソル処理 | E-01 | ○ |
| C-05 | Relu6Op 0-6範囲内計算 | E-01, E-02 | ○ |
| C-06 | Relu6Op 6超過でクリップ | E-01, E-02 | ○ |
| C-07 | ReluGradOp勾配計算 | E-01, E-02 | ○ |
| C-08 | ReluGradOpサイズ不一致エラー | E-02 (ValidateSameSizeHelper) | ○ |
| C-09 | LeakyReluOp正値計算 | E-01, E-02 | ○ |
| C-10 | LeakyReluOp負値alpha倍計算 | E-01, E-02 | ○ |
| C-11 | EluOp正値計算 | E-01, E-02 | ○ |
| C-12 | EluOp負値指数計算 | E-01, E-02 | ○ |
| C-13 | SeluOpスケーリング | E-01, E-02 | ○ |
| C-14 | Softmax計算 | E-03 (line 55-68) | ○ |
| C-15 | LogSoftmax計算 | E-03 (line 52, log_変数) | ○ |
| C-16 | Softmax 0次元エラー | E-03 (line 57-59) | ○ |
| C-17 | Softmax空テンソル処理 | E-03 (line 63条件) | ○ |
| C-18 | Conv2Dパラメータ初期化 | E-04 (line 42-95) | ○ |
| C-19 | dilations 4次元検証 | E-04 (line 60-62) | ○ |
| C-20 | strides 4次元検証 | E-04 (line 63-65) | ○ |
| C-21 | stride_h/w 0以下検証 | E-04 (line 74-76) | ○ |
| C-22 | Conv2D次元計算 | E-04 (line 97-214) | ○ |
| C-23 | 入力4次元検証 | E-04 (line 103-106) | ○ |
| C-24 | フィルタ4次元検証 | E-04 (line 107-110) | ○ |
| C-25 | 深度割り切れ検証 | E-04 (line 135-138) | ○ |
| C-26 | BatchNorm計算 | E-05 (line 44-75) | ○ |
| C-27 | BatchNorm入力4次元検証 | E-05 (line 51-53) | ○ |
| C-28 | BatchNorm mean 1次元検証 | E-05 (line 54-56) | ○ |
| C-29 | BatchNormGrad計算 | E-05 (line 94-157) | ○ |
| C-30 | ArgMax最大インデックス | E-06 (line 50-110) | ○ |
| C-31 | ArgMin最小インデックス | E-06 (line 126-132) | ○ |
| C-32 | ArgOp dimensionスカラー検証 | E-06 (line 54-57) | ○ |
| C-33 | ArgOp dimension範囲検証 | E-06 (line 64-67) | ○ |
| C-34 | ArgOp空次元検証 | E-06 (line 68-71) | ○ |
| C-35 | ArgOp負dimension処理 | E-06 (line 62) | ○ |
| C-36 | Cast float→int32変換 | E-07 (line 93-113) | ○ |
| C-37 | Cast同一型処理 | E-07 (line 126-128) | ○ |
| C-38 | Cast未サポート変換エラー | E-07 (line 115-119, 175) | ○ |
| C-39 | Cast量子化型変換 | E-07 (line 64-90) | ○ |
| C-40 | Concat結合 | E-08 (line 64-177) | ○ |
| C-41 | Concat concat_dimスカラー検証 | E-08 (line 68-75) | ○ |
| C-42 | Concatスカラー結合エラー | E-08 (line 126-129) | ○ |
| C-43 | Concatランク不一致エラー | E-08 (line 130-135) | ○ |
| C-44 | Concat形状不一致エラー | E-08 (line 136-147) | ○ |
| C-45 | ConcatOffset計算 | E-08 (line 259-327) | ○ |
| C-46 | InvertPermutation逆置換計算 | E-09 (line 47-72) | ○ |
| C-47 | InvertPermutation 1次元検証 | E-09 (line 49-51) | ○ |
| C-48 | InvertPermutation範囲検証 | E-09 (line 66-67) | ○ |
| C-49 | InvertPermutation重複検証 | E-09 (line 68-69) | ○ |
| C-50 | Transpose転置 | E-09 (line 130-192) | ○ |
| C-51 | Transpose permベクトル検証 | E-09 (line 134-136) | ○ |
| C-52 | Transpose permサイズ検証 | E-09 (line 100-104) | ○ |
| C-53 | Transpose恒等置換最適化 | E-09 (line 175-178) | ○ |
| C-54 | Transpose負perm処理 | E-09 (line 153-157) | ○ |
| C-55 | Gather収集 | E-10 (line 59-198) | ○ |
| C-56 | Gather params次元検証 | E-10 (line 62-64) | ○ |
| C-57 | Gather axisスカラー検証 | E-10 (line 73-74) | ○ |
| C-58 | Gather axis型検証 | E-10 (line 76-83) | ○ |
| C-59 | Gather範囲外インデックスエラー | E-10 (line 193-197) | ○ |
| C-60 | Gather batch_dims処理 | E-10 (line 104-135) | ○ |
| C-61 | Gather空インデックス処理 | E-10 (line 172) | ○ |
| C-62 | PoolParametersパラメータ初期化 | E-11 (line 120-212) | ○ |
| C-63 | PoolParameters空間次元検証 | E-11 (line 130-134) | ○ |
| C-64 | PoolParameters深度・空間プーリング組み合わせ | E-11 (line 151-155) | ○ |
| C-65 | CheckPaddingSize検証 | E-11 (line 90-118) | ○ |
| C-66 | PoolParameters出力形状計算 | E-11 (line 214-225) | ○ |
| C-67 | BatchMatMul正常系 | E-12 | △ |
| C-68 | float MatMul | E-12 | △ |
| C-69 | bfloat16 MatMul | E-12 (line 29) | ○ |
| C-70 | 量子化MatMul | E-12 (line 35-38) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-67, C-68**: MatMul演算の具体的な計算ロジックは`matmul_op_impl.h`に定義されており、本解析では詳細なCompute実装を確認できていない
  - 候補：`tensorflow/core/kernels/matmul_op_impl.h` / Eigenライブラリ内部実装 / GPUカーネル実装

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のテストケースはソースコード内のOP_REQUIRES/OP_REQUIRES_OKマクロによる入力検証と直接対応
- **0 (低リスク)**: 正常系テストケースはfunctor呼び出しやカーネル登録マクロから導出
- **1 (中リスク)**: GPU固有のテストケースは別途GPUカーネル実装の確認が必要
- **1 (中リスク)**: 数値精度に関するテストケースは実行時の挙動確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] C-67, C-68のMatMul実装詳細を`matmul_op_impl.h`で確認
- [ ] GPU実装が存在するOp（ReLU, Conv2D, BatchNorm等）についてGPU固有のテストケースが必要か検討
- [ ] 量子化型（qint8, quint8等）のテストケースが十分かレビュー
- [ ] 境界値テストケース（空テンソル、最大次元数等）の網羅性を確認
- [ ] エラーメッセージの内容が期待結果と一致するか確認
