---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 105
  claims_with_evidence: 98
  claims_without_evidence: 7
confidence_derived: 0.93
---

# 根拠レポート: core-lib 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim: 主張）を検証しています:

1. **根拠の有無確認**: 各テストケースに対して、ソースコード内の関数/メソッド定義が存在するか
2. **根拠との整合性**: テストケースの入力値・期待結果がコードの実装と矛盾していないか
3. **網羅性**: 参照すべきソースファイルを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 98 / 105 = 0.93

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で根拠不足の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）: **0.93**
  - 根拠あり: 98 / 105、根拠なし: 7
- 優先レビュー（高）
  1. **UT-LIB-071〜078 (JPEG関連)**: jpeg_mem.ccの実装詳細が一部ラッパー経由のため内部実装確認が必要
  2. **UT-LIB-087〜089 (GIF関連)**: gif_io.ccの実装詳細がライブラリ依存のため動作確認が推奨
  3. **UT-LIB-102〜105 (CRC32C関連)**: tsl::crc32cへの委譲のため実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに実在するソースファイルを列挙

- E-01: `tensorflow/core/lib/core/arena.h` - Arenaクラス定義
- E-02: `tensorflow/core/lib/core/arena.cc` - Arenaクラス実装
- E-03: `tensorflow/core/lib/wav/wav_io.h` - WAV I/O関数宣言
- E-04: `tensorflow/core/lib/wav/wav_io.cc` - WAV I/O関数実装
- E-05: `tensorflow/core/lib/strings/ordered_code.h` - OrderedCodeクラス宣言
- E-06: `tensorflow/core/lib/strings/ordered_code.cc` - OrderedCodeクラス実装
- E-07: `tensorflow/core/lib/db/sqlite.h` - SQLite関連クラス定義
- E-08: `tensorflow/core/lib/jpeg/jpeg_mem.h` - JPEG関連関数宣言
- E-09: `tensorflow/core/lib/png/png_io.h` - PNG関連関数宣言
- E-10: `tensorflow/core/lib/gif/gif_io.h` - GIF関連関数宣言
- E-11: `tensorflow/core/lib/gtl/edit_distance.h` - LevenshteinDistance関数実装
- E-12: `tensorflow/core/lib/gtl/top_n.h` - TopNクラス実装
- E-13: `tensorflow/core/lib/hash/crc32c.h` - CRC32C関数宣言

## 3) Claims と根拠の対応（レビューの主戦場）

### Arena (UT-LIB-001〜015)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Arena構築テスト | E-01, E-02 (L45-58) | ○ |
| C-02 | block_size検証テスト | E-02 (L51: assert) | ○ |
| C-03 | デストラクタテスト | E-02 (L61-68) | ○ |
| C-04 | Allocテスト | E-01 (L41-43), E-02 | ○ |
| C-05 | サイズ0テスト | E-02 (L195-197) | ○ |
| C-06 | 大きなサイズテスト | E-02 (L204-206) | ○ |
| C-07 | AllocAlignedテスト | E-01 (L45-47) | ○ |
| C-08 | 不正アライメントテスト | E-02 (L200) | ○ |
| C-09 | Resetテスト | E-02 (L91-101) | ○ |
| C-10 | GetMemoryFallbackテスト | E-02 (L194-220) | ○ |
| C-11 | SatisfyAlignmentテスト | E-02 (L72-84) | ○ |
| C-12 | MakeNewBlockテスト | E-02 (L110-115) | ○ |
| C-13 | AllocNewBlock(first_blocks)テスト | E-02 (L139-141) | ○ |
| C-14 | AllocNewBlock(overflow)テスト | E-02 (L143-148) | ○ |
| C-15 | FreeBlocksテスト | E-02 (L234-248) | ○ |

### WAV I/O (UT-LIB-016〜032)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | EncodeAudioAsS16LEWav正常系 | E-03, E-04 (L144-218) | ○ |
| C-17 | audio null検証 | E-04 (L155-157) | ○ |
| C-18 | wav_string null検証 | E-04 (L158-160) | ○ |
| C-19 | sample_rate 0検証 | E-04 (L161-163) | ○ |
| C-20 | num_channels 0検証 | E-04 (L165-168) | ○ |
| C-21 | num_frames 0テスト | E-04 (L155) | ○ |
| C-22 | ファイルサイズオーバーフロー | E-04 (L179-182) | ○ |
| C-23 | DecodeLin16WaveAsFloatVector正常系 | E-04 (L231-361) | ○ |
| C-24 | 不正RIFFヘッダー検証 | E-04 (L237) | ○ |
| C-25 | PCM以外フォーマット検証 | E-04 (L273-276) | ○ |
| C-26 | 16bit以外検証 | E-04 (L297-300) | ○ |
| C-27 | データチャンク不在検証 | E-04 (L357-359) | ○ |
| C-28 | IncrementOffset正常系 | E-04 (L92-117) | ○ |
| C-29 | 負オフセット検証 | E-04 (L94-97) | ○ |
| C-30 | 負インクリメント検証 | E-04 (L98-101) | ○ |
| C-31 | max_size超過検証 | E-04 (L107-109) | ○ |
| C-32 | ReadValue正常系 | E-03 (L83-100) | ○ |

### OrderedCode (UT-LIB-033〜052)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | WriteString正常系 | E-05, E-06 (L195-198) | ○ |
| C-34 | NUL文字エスケープ | E-06 (L177-181) | ○ |
| C-35 | 0xFFエスケープ | E-06 (L183-188) | ○ |
| C-36 | 空文字列テスト | E-06 (L195-198) | ○ |
| C-37 | ReadString正常系 | E-06 (L276-278) | ○ |
| C-38 | 不正エスケープシーケンス | E-06 (L251-253, L267-268) | ○ |
| C-39 | 終端なしテスト | E-06 (L273) | ○ |
| C-40 | WriteNumIncreasing正常系 | E-06 (L200-214) | ○ |
| C-41 | 大きな数値テスト | E-06 (L200-214) | ○ |
| C-42 | 0値テスト | E-06 (L206-211) | ○ |
| C-43 | ReadNumIncreasing正常系 | E-06 (L280-308) | ○ |
| C-44 | 空入力テスト | E-06 (L281-283) | ○ |
| C-45 | 長さ超過テスト | E-06 (L294-296) | ○ |
| C-46 | WriteSignedNumIncreasing正数 | E-06 (L438-458) | ○ |
| C-47 | WriteSignedNumIncreasing負数 | E-06 (L438-458) | ○ |
| C-48 | 0値テスト | E-06 (L440-443) | ○ |
| C-49 | INT64_MAXテスト | E-06 (L438-458) | ○ |
| C-50 | INT64_MINテスト | E-06 (L438-458) | ○ |
| C-51 | ReadSignedNumIncreasing正常系 | E-06 (L460-502) | ○ |
| C-52 | 空入力テスト | E-06 (L462) | ○ |

### SQLite (UT-LIB-053〜070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | Sqlite::Open正常系 | E-07 (L84) | ○ |
| C-54 | Sqlite::Open異常系 | E-07 (L84) | ○ |
| C-55 | Sqlite::Prepare正常系 | E-07 (L94-95) | ○ |
| C-56 | Sqlite::Prepare異常系 | E-07 (L94-95) | ○ |
| C-57 | SqliteStatement::Step正常系 | E-07 (L182-183) | ○ |
| C-58 | SqliteStatement::Step完了検出 | E-07 (L182-183) | ○ |
| C-59 | BindInt | E-07 (L211-217) | ○ |
| C-60 | BindDouble | E-07 (L220-226) | ○ |
| C-61 | BindText | E-07 (L236-244) | ○ |
| C-62 | BindBlob | E-07 (L259-267) | ○ |
| C-63 | ColumnInt | E-07 (L292-294) | ○ |
| C-64 | ColumnDouble | E-07 (L297-299) | ○ |
| C-65 | ColumnString | E-07 (L305-310) | ○ |
| C-66 | ColumnString NULL処理 | E-07 (L307) | ○ |
| C-67 | Reset | E-07 (L208) | ○ |
| C-68 | SqliteTransaction構築 | E-07 (L426) | ○ |
| C-69 | Commit | E-07 (L435) | ○ |
| C-70 | デストラクタロールバック | E-07 (L429) | ○ |

### JPEG (UT-LIB-071〜078)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | Uncompress正常系 | E-08 (L90-93) | ○ |
| C-72 | Uncompress異常系 | E-08 | △ |
| C-73 | スケーリング | E-08 (L40) | ○ |
| C-74 | GetImageInfo正常系 | E-08 (L106-107) | ○ |
| C-75 | GetImageInfo異常系 | E-08 | △ |
| C-76 | Compress正常系 | E-08 (L153-158) | ○ |
| C-77 | 品質0圧縮 | E-08 (L123) | ○ |
| C-78 | 品質100圧縮 | E-08 (L123) | ○ |

### PNG (UT-LIB-079〜086)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | DecodeHeader正常系 | E-09 (L63-65) | ○ |
| C-80 | DecodeHeader異常系 | E-09 | △ |
| C-81 | CommonInitDecode | E-09 (L78-79) | ○ |
| C-82 | CommonFinishDecode | E-09 (L81) | ○ |
| C-83 | CommonFreeDecode | E-09 (L86) | ○ |
| C-84 | WriteImageToBuffer正常系 | E-09 (L99-102) | ○ |
| C-85 | 圧縮レベル-1 | E-09 (L95-96) | ○ |
| C-86 | 圧縮レベル9 | E-09 (L95-96) | ○ |

### GIF (UT-LIB-087〜089)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | Decode正常系 | E-10 (L45-47) | ○ |
| C-88 | Decode異常系 | E-10 (L47) | △ |
| C-89 | アニメーション展開 | E-10 (L47) | ○ |

### GTL (UT-LIB-090〜101)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | LevenshteinDistance同一文字列 | E-11 (L58) | ○ |
| C-91 | LevenshteinDistance異なる文字列 | E-11 (L47-94) | ○ |
| C-92 | 空文字列同士 | E-11 (L57) | ○ |
| C-93 | 一方が空文字列 | E-11 (L57) | ○ |
| C-94 | TopN::push正常系 | E-12 (L117-127) | ○ |
| C-95 | TopN::push置換 | E-12 (L211-253) | ○ |
| C-96 | TopN limit=0 | E-12 (L212-215) | ○ |
| C-97 | peek_bottom正常系 | E-12 (L255-275) | ○ |
| C-98 | peek_bottom空状態 | E-12 (L258) | ○ |
| C-99 | Extract | E-12 (L277-287) | ○ |
| C-100 | ExtractUnsorted | E-12 (L289-294) | ○ |
| C-101 | Reset | E-12 (L327-331) | ○ |

### CRC32C (UT-LIB-102〜105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | Value | E-13 (L33) | △ |
| C-103 | Extend | E-13 (L29) | △ |
| C-104 | Mask | E-13 (L31) | △ |
| C-105 | Unmask | E-13 (L32) | ○ |

## 4) 不足情報（Unknown / Missing）
- **JPEG/PNG/GIF異常系テスト**: ライブラリ内部の詳細なエラーパスが確認できないため、実際の動作確認が推奨される
  - 候補: jpeg_mem.cc / png_io.cc / gif_io.cc の実装確認
- **CRC32C関数**: tsl::crc32cへの委譲のため、TSL側の実装詳細を参照する必要がある
  - 候補: xla/tsl/lib/hash/crc32c.h の確認

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**: JPEG/PNG/GIF関連のテストケースは外部ライブラリ（libjpeg, libpng, giflib）に依存しているため、ライブラリバージョンによる挙動差異に注意
- **リスク0（低）**: Arena, OrderedCode, TopN, LevenshteinDistanceは自己完結した実装であり、テストケースの妥当性が高い
- **リスク0（低）**: SQLite関連は標準的なAPIラッパーであり、テストケースの網羅性は十分

## 6) レビュアーチェックリスト（最小）
- [ ] Arena: メモリリーク検出のためValgrind等での動作確認
- [ ] WAV I/O: 実際のWAVファイルでの往復変換テスト
- [ ] OrderedCode: 複数値のエンコード・デコードの順序保存性確認
- [ ] SQLite: トランザクションのACID特性確認
- [ ] JPEG/PNG/GIF: 各種画像フォーマットの実ファイルでのデコードテスト
- [ ] GTL: 大規模データでのパフォーマンステスト
- [ ] CRC32C: 既知のテストベクターとの照合
