---
generated_at: 2026-02-03 15:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：core-nccl 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **ROCmプラットフォーム固有の動作**：実機テスト環境なしでの検証困難
  2. **NCCLライブラリ呼び出しの実際の挙動**：外部ライブラリ依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/nccl/nccl_manager.h` - NcclManagerクラス定義、Participant構造体、Context構造体
- E-02: `tensorflow/core/nccl/nccl_manager.cc` - NcclManager実装、ToNcclType関数、StringToNcclUniqueId関数、Collective構造体、NcclStream構造体
- E-03: `tensorflow/core/nccl/collective_communicator.h` - MaybeCreateNcclCommunicator関数宣言
- E-04: `tensorflow/core/nccl/collective_communicator.cc` - NcclCommunicatorクラス実装、ReductionOp関数、NcclCollectiveKey関数
- E-05: `tensorflow/core/nccl/nccl_rewrite.cc` - ReplaceReduce関数、ReplaceBroadcast関数、TensorFromShape関数、NcclReplacePassクラス
- E-06: `tensorflow/core/nccl/BUILD` - ビルド設定ファイル

## 3) Claims と根拠の対応（レビューの主戦場）

### NcclManager クラス（nccl_manager.h / nccl_manager.cc）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NcclManagerコンストラクタでインスタンスカウントが増加 | E-02: 223-228行 | ○ |
| C-02 | デストラクタで全NcclStreamがシャットダウン | E-02: 229-244行 | ○ |
| C-03 | instance()でシングルトンが返される | E-02: 245-254行 | ○ |
| C-04 | GenerateCommunicatorKeyでNCCL IDが生成 | E-02: 256-260行 | ○ |
| C-05 | AddToAllReduceがAddParticipantを呼ぶ | E-02: 435-439行 | ○ |
| C-06 | AddToAllGatherがAddParticipantを呼ぶ | E-02: 441-445行 | ○ |
| C-07 | AddToReduceScatterがAddParticipantを呼ぶ | E-02: 447-451行 | ○ |
| C-08 | AddToAllToAllがAddParticipantを呼ぶ | E-02: 453-457行 | ○ |
| C-09 | AddBroadcastSendでroot=trueが設定される | E-02: 459-464行 | ○ |
| C-10 | AddBroadcastRecvでrootはfalseのまま | E-02: 466-470行 | ○ |
| C-11 | AddReduceSendがAddParticipantを呼ぶ | E-02: 472-476行 | ○ |
| C-12 | AddReduceRecvでroot=trueが設定される | E-02: 478-483行 | ○ |
| C-13 | SignalMultiNodeReadyでmulti_node_ready=trueになる | E-02: 485-502行 | ○ |
| C-14 | AddParticipantで整合性チェックが行われる | E-02: 504-613行 | ○ |
| C-15 | CheckReadyで参加者数と準備状態をチェック | E-02: 615-626行 | ○ |
| C-16 | RunCollectiveでカーネルがキューされる | E-02: 628-697行 | ○ |
| C-17 | LoopKernelLaunchesで各タイプのNCCL呼び出し | E-02: 713-919行 | ○ |
| C-18 | StartAbortで中止処理と通知 | E-02: 921-969行 | ○ |
| C-19 | Resetで状態をクリア | E-02: 971-975行 | ○ |
| C-20 | GetCommunicatorでCommunicator取得/作成 | E-02: 262-433行 | ○ |

### データ型変換・ユーティリティ関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | ToNcclTypeでDT_HALFからncclHalfに変換 | E-02: 123-138行 | ○ |
| C-22 | ToNcclTypeでDT_FLOATからncclFloatに変換 | E-02: 123-138行 | ○ |
| C-23 | ToNcclTypeでDT_DOUBLEからncclDoubleに変換 | E-02: 123-138行 | ○ |
| C-24 | ToNcclTypeでDT_INT32からncclIntに変換 | E-02: 123-138行 | ○ |
| C-25 | ToNcclTypeでDT_INT64からncclInt64に変換 | E-02: 123-138行 | ○ |
| C-26 | ToNcclTypeで未知の型はncclFloatを返す | E-02: 136-137行 | ○ |
| C-27 | StringToNcclUniqueIdで文字列からID変換 | E-02: 140-144行 | ○ |
| C-28 | ComputeBufferSizeでバッファサイズ計算 | E-02: 701-710行 | ○ |

### Collective 構造体

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | Collectiveコンストラクタで各フィールドを初期化 | E-02: 157-181行 | ○ |
| C-30 | single_nodeフラグの計算 | E-02: 168行 | ○ |
| C-31 | ROCmでinstance_count > 1の場合エラー | E-02: 176-180行 | △ |

### NcclCommunicator クラス（collective_communicator.cc）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | MaybeCreateNcclCommunicatorでGPU数チェック | E-04: 71-80行 | ○ |
| C-33 | GenerateCommunicatorKeyでNcclManagerに委譲 | E-04: 31-33行 | ○ |
| C-34 | EnqueueでCollectiveTypeに応じた処理分岐 | E-04: 82-221行 | ○ |
| C-35 | REDUCTION_COLLECTIVEでAddToAllReduce | E-04: 141-151行 | ○ |
| C-36 | GATHER_COLLECTIVEでAddToAllGather | E-04: 153-156行 | ○ |
| C-37 | BROADCAST_COLLECTIVEで送受信分岐 | E-04: 157-164行 | ○ |
| C-38 | REDUCE_SCATTER_COLLECTIVEでAddToReduceScatter | E-04: 165-176行 | ○ |
| C-39 | ALL_TO_ALL_COLLECTIVEでAddToAllToAll | E-04: 177-180行 | ○ |
| C-40 | 未知のCollectiveTypeでエラー | E-04: 181-185行 | ○ |
| C-41 | StartAbortでNcclManagerに委譲 | E-04: 223-225行 | ○ |
| C-42 | ReductionOpでmerge_op変換 | E-04: 45-64行 | ○ |
| C-43 | NcclCollectiveKeyで文字列結合 | E-04: 66-68行 | ○ |
| C-44 | キャンセル済み時の即時エラー | E-04: 107-110行 | ○ |

### NcclReplacePass（nccl_rewrite.cc）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | ReplaceReduceでNcclReduceをSend/Recvに置換 | E-05: 31-102行 | ○ |
| C-46 | 同一デバイスの入力がrecv_inputになる | E-05: 66-69行 | ○ |
| C-47 | 同一デバイス入力なしでInvalidArgumentError | E-05: 86-89行 | ○ |
| C-48 | TensorFromShapeでShapeProtoからTensorProto生成 | E-05: 104-112行 | ○ |
| C-49 | ReplaceBroadcastでNcclBroadcastをSend/Recvに置換 | E-05: 117-239行 | ○ |
| C-50 | 参加デバイス1つでNCCLスキップ | E-05: 142-159行 | ○ |
| C-51 | NcclReplacePass::Runでグラフ処理 | E-05: 245-269行 | ○ |
| C-52 | options.graph=nullでOkStatus | E-05: 246-248行 | ○ |
| C-53 | graph->get()=nullでInternal error | E-05: 250-254行 | ○ |
| C-54 | Nccl以外のノードはスキップ | E-05: 258-259行 | ○ |

### NcclStream / CommunicatorMember 構造体

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | NcclStreamのデフォルト初期化 | E-02: 67-92行 | ○ |
| C-56 | CommunicatorMemberデストラクタでncclCommDestroy | E-02: 97-99行 | ○ |
| C-57 | nccl_comm=nullの場合destroyしない | E-02: 98行 | ○ |

### Participant / Context 構造体

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | Participantコンストラクタで各フィールド初期化 | E-01: 73-92行 | ○ |
| C-59 | executorのDCHECK | E-01: 89行 | ○ |
| C-60 | Contextコンストラクタで各フィールド初期化 | E-01: 139-148行 | ○ |

### 実機依存テスト

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | ROCm固有のinstance_count管理 | E-02: 45-46行, 226-227行, 231-233行 | △ |

## 4) 不足情報（Unknown / Missing）

- **ROCmプラットフォーム固有の動作検証**
  - ROCm環境でのinstance_count管理の実際の挙動は実機テストが必要
  - 候補：ROCmテスト環境 / AMD GPU環境 / HIPシミュレータ

- **NCCLライブラリ呼び出しの実挙動**
  - ncclAllReduce、ncclBroadcast等の実際のGPU間通信は外部ライブラリ依存
  - 候補：NCCLモックライブラリ / マルチGPU環境 / NCCLテストスイート

## 5) リスクフラグ（レビュー観点）

- **リスク1**: NCCLエラー処理のカバレッジ（1: 中リスク）
  - NCCLライブラリからのエラー発生パターンが網羅されているか要確認

- **リスク0**: データ型変換のテスト（0: 低リスク）
  - kValidDataTypes（DT_HALF, DT_FLOAT, DT_DOUBLE, DT_INT32, DT_INT64）は網羅済み

- **リスク1**: マルチノード同期テスト（1: 中リスク）
  - SignalMultiNodeReadyのタイミング依存動作は単体テストでの検証に限界あり

- **リスク0**: グラフ書き換えテスト（0: 低リスク）
  - NcclReplacePassのノード置換ロジックは明確に定義されている

## 6) レビュアーチェックリスト（最小）

- [ ] NCCLエラーコード（ncclResult_t）の全パターンがテストされているか
- [ ] ROCm環境固有のコードパス（#if TENSORFLOW_USE_ROCM）の検証方法は妥当か
- [ ] マルチノードCollectiveのデッドロック防止ロジックのテストは十分か
- [ ] グラフ書き換え後のエッジ接続が正しいことの検証方法は適切か
- [ ] キャンセル処理時のリソースリーク可能性は検討されているか
- [ ] 各CollectiveType（AllReduce, Broadcast, Reduce, AllGather, ReduceScatter, AllToAll）が網羅されているか
