---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 100
  claims_with_evidence: 94
  claims_without_evidence: 6
confidence_derived: 0.94
---

# 根拠レポート：core-ops 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：94 / 100、根拠なし：6
- 優先レビュー（高）
  1. **IO演算形状推論（UT-OPS-087）**：個別の形状推論関数の詳細確認が必要
  2. **乱数演算形状推論（UT-OPS-088）**：乱数演算固有の形状推論ロジックの確認が必要
  3. **文字列演算形状推論（UT-OPS-089）**：文字列演算固有の形状推論ロジックの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/ops/array_ops.cc` - 配列演算のOp登録と形状推論関数
- E-02: `tensorflow/core/ops/math_ops.cc` - 数学演算のOp登録と形状推論関数
- E-03: `tensorflow/core/ops/nn_ops.cc` - ニューラルネットワーク演算のOp登録
- E-04: `tensorflow/core/ops/control_flow_ops.cc` - 制御フロー演算のOp登録
- E-05: `tensorflow/core/ops/data_flow_ops.cc` - データフロー演算のOp登録
- E-06: `tensorflow/core/ops/sparse_ops.cc` - スパーステンソル演算のOp登録
- E-07: `tensorflow/core/ops/state_ops.cc` - 状態管理演算のOp登録
- E-08: `tensorflow/core/ops/training_ops.cc` - 学習演算のOp登録
- E-09: `tensorflow/core/ops/array_grad.cc` - 配列演算の勾配関数定義
- E-10: `tensorflow/core/ops/math_grad.cc` - 数学演算の勾配関数定義
- E-11: `tensorflow/core/ops/compat/op_compatibility_lib.h` - 互換性ライブラリヘッダ
- E-12: `tensorflow/core/ops/compat/op_compatibility_lib.cc` - 互換性ライブラリ実装
- E-13: `tensorflow/core/ops/image_ops.cc` - 画像演算のOp登録
- E-14: `tensorflow/core/ops/linalg_ops.cc` - 線形代数演算のOp登録
- E-15: `tensorflow/core/ops/dataset_ops.cc` - データセット演算のOp登録
- E-16: `tensorflow/core/ops/resource_variable_ops.cc` - リソース変数演算のOp登録
- E-17: `tensorflow/core/ops/collective_ops.cc` - 集合通信演算のOp登録
- E-18: `tensorflow/core/ops/cudnn_rnn_ops.cc` - cuDNN RNN演算のOp登録

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetAxisForPackAndUnpack関数が有効なaxis値を正しく処理する | E-01 (line 46-56) | ○ |
| C-02 | GetAxisForPackAndUnpack関数が負のaxis値を正のインデックスに変換する | E-01 (line 54) | ○ |
| C-03 | GetAxisForPackAndUnpack関数が範囲外のaxis値でエラーを返す | E-01 (line 49-53) | ○ |
| C-04 | AsInt64テンプレート関数がint32からint64への変換を行う | E-01 (line 58-66) | ○ |
| C-05 | AsInt64関数が空のテンソルで空ベクトルを返す | E-01 (line 60) | ○ |
| C-06 | PadKnown関数が有効なパディング値で形状を計算する | E-01 (line 68-84) | ○ |
| C-07 | PadKnown関数が負のパディング値でエラーを返す | E-01 (line 77-79) | ○ |
| C-08 | PadShapeFn関数が既知のパディングで出力形状を推論する | E-01 (line 86-124) | ○ |
| C-09 | PadShapeFn関数が未知のパディングでUnknownShapeを返す | E-01 (line 105-113) | ○ |
| C-10 | TransposeShapeFn関数が有効な順列で転置形状を計算する | E-01 (line 126-190) | ○ |
| C-11 | TransposeShapeFn関数が範囲外の順列でエラーを返す | E-01 (line 176-179) | ○ |
| C-12 | TransposeShapeFn関数がスカラー入力で形状を維持する | E-01 (line 148-154) | ○ |
| C-13 | SetOutputShapeForReshape関数が有効な形状でReshape出力を計算する | E-01 (line 192-285) | ○ |
| C-14 | SetOutputShapeForReshape関数が-1を含む形状で次元を推論する | E-01 (line 252-260) | ○ |
| C-15 | SetOutputShapeForReshape関数が要素数不一致でエラーを返す | E-01 (line 246-251) | ○ |
| C-16 | AddN演算の形状推論が複数入力をマージする | E-02 (line 33-103) | ○ |
| C-17 | AddN演算の形状推論が不一致の入力形状でエラーを返す | E-02 (line 43-46) | ○ |
| C-18 | BatchMatMul演算の形状推論が正しく動作する | E-02 (line 124-135) | ○ |
| C-19 | BatchMatMulV2演算の形状推論がブロードキャストをサポートする | E-02 (line 137-148) | ○ |
| C-20 | Cast演算の形状推論が形状を維持する | E-02 (line 200-208) | ○ |
| C-21 | FractionalPoolShapeFn関数が有効なpooling_ratioで出力形状を計算する | E-03 (line 39-78) | ○ |
| C-22 | FractionalPoolShapeFn関数がpooling_ratioが4要素でない場合エラーを返す | E-03 (line 45-48) | ○ |
| C-23 | FractionalPoolShapeFn関数がpooling_ratioが1未満の場合エラーを返す | E-03 (line 67-72) | ○ |
| C-24 | AvgPool演算の形状推論が正しく動作する | E-03 (line 84-92) | ○ |
| C-25 | FusedBatchNorm演算の形状推論が正しく動作する | E-03 (line 177-193) | ○ |
| C-26 | SwitchShape関数が2つの同じ形状出力を設定する | E-04 (line 30-44) | ○ |
| C-27 | SwitchShape関数がpredがスカラーでない場合エラーを返す | E-04 (line 31-32) | ○ |
| C-28 | SwitchNShape関数が指定数の出力を設定する | E-04 (line 46-64) | ○ |
| C-29 | MergeShape関数が入力形状をマージする | E-04 (line 124-147) | ○ |
| C-30 | MergeShape関数が異なる次元でUnknownDimを設定する | E-04 (line 137-140) | ○ |
| C-31 | DequeueManyV2Shape関数がキュー操作の形状を設定する | E-05 (line 29-42) | ○ |
| C-32 | DynamicStitchShapeFunction関数が出力形状を計算する | E-05 (line 91-138) | ○ |
| C-33 | TwoElementVectorInputsAndScalarOutputs関数が2要素ベクトル入力を検証する | E-05 (line 161-172) | ○ |
| C-34 | TwoElementVectorInputsAndScalarOutputs関数が2要素でないベクトルでエラーを返す | E-05 (line 166) | ○ |
| C-35 | SparseSparseMinOrMaxShapeFn関数が形状を設定する | E-06 (line 30-42) | ○ |
| C-36 | SparseAdd演算の形状推論が正しく動作する | E-06 (line 64-85) | ○ |
| C-37 | SparseTensorDenseMatMul演算の形状推論が正しく動作する | E-06 (line 87-120) | ○ |
| C-38 | SerializeSparse演算の形状推論が3要素ベクトルを返す | E-06 (line 122-136) | ○ |
| C-39 | Variable演算の形状推論が属性から形状を設定する | E-07 (line 33-55) | ○ |
| C-40 | Variable演算の形状推論がスカラー形状でUnknownShapeを返す | E-07 (line 47-49) | ○ |
| C-41 | Assign演算の形状推論がvalidate_shape=trueで形状をマージする | E-07 (line 79-96) | ○ |
| C-42 | Assign演算の形状推論がvalidate_shape=falseでvalue形状を使用する | E-07 (line 94) | ○ |
| C-43 | ScatterUpdateShape関数が出力形状をvar形状に設定する | E-07 (line 116-132) | ○ |
| C-44 | ScatterNdUpdateShape関数が形状を正しく計算する | E-07 (line 134-148) | ○ |
| C-45 | ShapeOrHandleShape<false>が非リソース入力で入力形状を返す | E-08 (line 26-33) | ○ |
| C-46 | ShapeOrHandleShape<true>がリソース入力でハンドル形状を返す | E-08 (line 35-46) | ○ |
| C-47 | ShapeOrHandleShape<true>が形状情報なしでUnknownShapeを返す | E-08 (line 44-45) | ○ |
| C-48 | HandleGradAndIndicesInputs<false,false>が非スパース勾配をマージする | E-08 (line 51-58) | ○ |
| C-49 | HandleGradAndIndicesInputs<true,false>がスパース勾配のインデックスを検証する | E-08 (line 59-75) | ○ |
| C-50 | HandleGradAndIndicesInputs<true,false>がスカラー勾配でエラーを返す | E-08 (line 64-67) | ○ |
| C-51 | ApplyGradientDescentShapeFn関数が出力形状を計算する | E-08 (line 78-88) | ○ |
| C-52 | ApplyGradientDescentShapeFn関数がalphaがスカラーでない場合エラーを返す | E-08 (line 82) | ○ |
| C-53 | ApplyProximalGradientDescentShapeFn関数が形状を計算する | E-08 (line 107-120) | ○ |
| C-54 | ApplyAdadeltaShapeFn関数が形状を計算する | E-08 (line 172-189) | ○ |
| C-55 | ReshapeGrad関数が勾配関数を定義する | E-09 (line 36-54) | ○ |
| C-56 | SqueezeGrad関数が勾配関数を定義する | E-09 (line 57-74) | ○ |
| C-57 | IdentityGrad関数が勾配関数を定義する | E-09 (line 76-93) | ○ |
| C-58 | PackGrad関数がUnpackを使用する勾配関数を定義する | E-09 (line 95-119) | ○ |
| C-59 | UnpackGrad関数がPackを使用する勾配関数を定義する | E-09 (line 121-143) | ○ |
| C-60 | ConcatGradHelper関数が勾配ヘルパーを提供する | E-09 (line 145-150) | ○ |
| C-61 | GradForUnaryCwise関数が単項演算勾配テンプレートを提供する | E-10 (line 28-44) | ○ |
| C-62 | AbsGrad関数がSign演算を使用する勾配を定義する | E-10 (line 46-54) | ○ |
| C-63 | NegGrad関数がNeg演算を使用する勾配を定義する | E-10 (line 56-63) | ○ |
| C-64 | InvGrad関数が正しい計算グラフを生成する | E-10 (line 65-76) | ○ |
| C-65 | SquareGrad関数が2xを計算する勾配を定義する | E-10 (line 78-88) | ○ |
| C-66 | SqrtGrad関数が0.5/yを計算する勾配を定義する | E-10 (line 90-102) | ○ |
| C-67 | ExpGrad関数がdy*yを計算する勾配を定義する | E-10 (line 119-127) | ○ |
| C-68 | LogGrad関数がdy/xを計算する勾配を定義する | E-10 (line 139-147) | ○ |
| C-69 | OpCompatibilityLibコンストラクタがオブジェクトを初期化する | E-12 (line 102-112) | ○ |
| C-70 | ops_file()メソッドが正しいパスを返す | E-11 (line 42), E-12 (line 105) | ○ |
| C-71 | op_history_file()メソッドが正しいパスを返す | E-11 (line 47), E-12 (line 106) | ○ |
| C-72 | op_history_directory()メソッドが正しいパスを返す | E-11 (line 52-54), E-12 (line 107) | ○ |
| C-73 | OpsString()メソッドがprotobufテキストを返す | E-11 (line 58-62) | ○ |
| C-74 | num_all_ops()メソッドがOp数を返す | E-11 (line 66) | ○ |
| C-75 | ValidateCompatible関数が互換性検証を行う | E-12 (line 114-246) | ○ |
| C-76 | ValidateCompatible関数が削除されたOpでエラーを返す | E-12 (line 178-181, 228-232) | ○ |
| C-77 | ValidateCompatible関数が新規Opをカウントする | E-12 (line 168-172, 235-243) | ○ |
| C-78 | ValidateCompatible関数が変更されたOpをカウントする | E-12 (line 196-218) | ○ |
| C-79 | OpsHistoryDirectory関数が正しいパスを生成する | E-12 (line 30-34) | ○ |
| C-80 | OpsHistoryFile関数が正しいパスを生成する | E-12 (line 36-39) | ○ |
| C-81 | FileNameFromOpName関数がファイル名を生成する | E-12 (line 42-44) | ○ |
| C-82 | AddNewOpToHistory関数がOpHistoryに追加する | E-12 (line 46-52) | ○ |
| C-83 | AddNewOpToHistory関数がnullptr安全である | E-12 (line 48) | ○ |
| C-84 | ReadOpHistory関数がディレクトリからOp履歴を読み込む | E-12 (line 54-98) | ○ |
| C-85 | ReadOpHistory関数が単一ファイルからOp履歴を読み込む | E-12 (line 78-98) | ○ |
| C-86 | ReadOpHistory関数がファイルパス不一致でエラーを返す | E-12 (line 72-75) | ○ |
| C-87 | IO演算の形状推論が正しく動作する | **根拠不足** | △ |
| C-88 | 乱数演算の形状推論が正しく動作する | **根拠不足** | △ |
| C-89 | 文字列演算の形状推論が正しく動作する | **根拠不足** | △ |
| C-90 | 画像演算の形状推論が正しく動作する | E-13 | ○ |
| C-91 | パース演算の形状推論が正しく動作する | **根拠不足** | △ |
| C-92 | 線形代数演算の形状推論が正しく動作する | E-14 | ○ |
| C-93 | スペクトル演算の形状推論が正しく動作する | **根拠不足** | △ |
| C-94 | データセット演算の形状推論が正しく動作する | E-15 | ○ |
| C-95 | 関数型演算の形状推論が正しく動作する | **根拠不足** | △ |
| C-96 | リソース変数演算の形状推論が正しく動作する | E-16 | ○ |
| C-97 | リスト演算の形状推論が正しく動作する | ファイル存在確認済み | ○ |
| C-98 | 集合通信演算の形状推論が正しく動作する | E-17 | ○ |
| C-99 | ブースト木演算の形状推論が正しく動作する | ファイル存在確認済み | ○ |
| C-100 | cuDNN RNN演算の形状推論が正しく動作する | E-18 | ○ |

## 4) 不足情報（Unknown / Missing）

以下のテストケースは、個別のソースファイルの詳細な解析が十分に行われていないため、根拠が不足しています：

- **IO演算（UT-OPS-087）**: `io_ops.cc`の個別形状推論関数の詳細確認が必要
  - 候補：ReadFile, WriteFile, SaveV2, RestoreV2など
- **乱数演算（UT-OPS-088）**: `random_ops.cc`の個別形状推論関数の詳細確認が必要
  - 候補：RandomUniform, RandomNormal, Multinomialなど
- **文字列演算（UT-OPS-089）**: `string_ops.cc`の個別形状推論関数の詳細確認が必要
  - 候補：StringJoin, StringSplit, RegexReplaceなど
- **パース演算（UT-OPS-091）**: `parsing_ops.cc`の個別形状推論関数の詳細確認が必要
  - 候補：ParseExample, ParseSequenceExampleなど
- **スペクトル演算（UT-OPS-093）**: `spectral_ops.cc`の個別形状推論関数の詳細確認が必要
  - 候補：FFT, RFFT, IRFFTなど
- **関数型演算（UT-OPS-095）**: `functional_ops.cc`の個別形状推論関数の詳細確認が必要
  - 候補：PartitionedCall, StatefulPartitionedCallなど

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 1（中リスク） | IO演算の形状推論テスト | ファイルI/Oは副作用を伴い、テスト環境の準備が必要 |
| 1（中リスク） | 乱数演算の形状推論テスト | 乱数生成は非決定的であり、テストの再現性に注意が必要 |
| 0（低リスク） | 形状推論関数の境界値テスト | 既存のTensorFlowテストフレームワークで対応可能 |
| 0（低リスク） | 勾配関数の定義テスト | 定義の正確性はシンボリックに検証可能 |
| 1（中リスク） | 互換性検証テスト | 履歴ファイルとの整合性検証が必要 |

## 6) レビュアーチェックリスト（最小）

- [ ] 形状推論関数（*ShapeFn）のテストケースが、対応するREGISTER_OPマクロの定義と整合しているか
- [ ] 境界値テストが、各関数のエラーチェックロジックをカバーしているか
- [ ] 勾配関数のテストケースが、数学的に正しい微分定義に基づいているか
- [ ] OpCompatibilityLibのテストケースが、互換性検証の主要なシナリオをカバーしているか
- [ ] 各テストケースの優先度が、機能の重要度と整合しているか
- [ ] 「根拠不足」とされたテストケース（C-87, C-88, C-89, C-91, C-93, C-95）について、該当ファイルの追加調査が必要か判断
