---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 115
  claims_without_evidence: 5
confidence_derived: 0.96
---

# 根拠レポート：core-profiler 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：115 / 120、根拠なし：5
- 優先レビュー（高）
  1. **C-117〜C-118**: math_utils.hの単位変換関数はtsl::profilerへの委譲のため、実装詳細が別ライブラリに依存
  2. **C-119〜C-120**: CallStack::Traceの詳細動作はプロトコルバッファ定義に依存
  3. **C-93**: MemoryTracker::TrackNodeの追跡不可ケースの詳細条件

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/profiler/tfprof_options.h` - Optionsクラス定義
- E-02: `tensorflow/core/profiler/tfprof_options.cc` - Options実装、ParseOutput関数
- E-03: `tensorflow/core/profiler/internal/tfprof_stats.h` - TFStatsクラス定義
- E-04: `tensorflow/core/profiler/internal/tfprof_stats.cc` - TFStats実装
- E-05: `tensorflow/core/profiler/internal/tfprof_node.h` - TFGraphNode、ExecStep、TFMultiGraphNode、CallStackクラス定義
- E-06: `tensorflow/core/profiler/internal/tfprof_node.cc` - ノード関連関数実装
- E-07: `tensorflow/core/profiler/internal/tfprof_utils.h` - ユーティリティ関数宣言
- E-08: `tensorflow/core/profiler/internal/tfprof_utils.cc` - ユーティリティ関数実装
- E-09: `tensorflow/core/profiler/internal/tfprof_timeline.h` - Timeline、ChromeTraceFormatter、MemoryTrackerクラス定義
- E-10: `tensorflow/core/profiler/internal/tfprof_timeline.cc` - タイムライン生成実装
- E-11: `tensorflow/core/profiler/internal/print_model_analysis.h` - Python API向け関数宣言
- E-12: `tensorflow/core/profiler/internal/print_model_analysis.cc` - Python API実装
- E-13: `tensorflow/core/profiler/convert/xplane_to_step_stats.cc` - XSpace変換実装
- E-14: `tensorflow/core/profiler/utils/math_utils.h` - 数学ユーティリティ関数
- E-15: `tensorflow/core/profiler/utils/xplane_schema.h` - XPlaneスキーマ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-04 | Options::FromProtoStr、ToStringの動作 | E-01, E-02 | ○ |
| C-05〜C-08 | ParseOutput関数の各種ケース | E-01, E-02 | ○ |
| C-09〜C-12 | TFStatsコンストラクタの動作 | E-03, E-04 | ○ |
| C-13〜C-17 | TFStats::BuildView、BuildAllViewsの動作 | E-03, E-04 | ○ |
| C-18〜C-21 | TFStats::ShowGraphNode、ShowMultiGraphNodeの動作 | E-03, E-04 | ○ |
| C-22〜C-27 | TFStats::AddGraph、AddRunMeta、AddOpLogProtoの動作 | E-03, E-04 | ○ |
| C-28〜C-30 | TFStats::SerializeToString、WriteProfile、run_coverage | E-03, E-04 | ○ |
| C-31〜C-40 | ExecStep、TFGraphNodeの時間・メモリ統計関数 | E-05, E-06 | ○ |
| C-41〜C-51 | TFGraphNodeのrun_count、exec_micros、parametersなど | E-05, E-06 | ○ |
| C-52〜C-55 | ShapeProtoToVec、VecToShapeProtoの変換 | E-05, E-06 | ○ |
| C-56〜C-61 | デバイス判定関数（IsPlacedOnAccelerator等） | E-06 | ○ |
| C-62〜C-65 | TFMultiGraphNode::SnapshotNodes、AddGraphNode | E-05 | ○ |
| C-66〜C-78 | フォーマット関数（FormatNumber、Time、Memory、Shapes） | E-07, E-08 | ○ |
| C-79〜C-84 | ParseCmdLine、QueryDocの動作 | E-07, E-08 | ○ |
| C-85〜C-91 | ChromeTraceFormatterの各メソッド | E-09, E-10 | ○ |
| C-92〜C-93 | MemoryTracker::TrackNodeの動作 | E-09, E-10 | ○ |
| C-94〜C-98 | Timeline::GenerateXxxTimeline、AllocatePID、AllocateLanes | E-09, E-10 | ○ |
| C-99〜C-107 | print_model_analysis.ccのAPI関数 | E-11, E-12 | ○ |
| C-108〜C-112 | ConvertGpuXSpaceToStepStats、ParseMemcpyName | E-13 | ○ |
| C-113〜C-116 | math_utils.hの時間変換・SafeDivide | E-14 | ○ |
| C-117〜C-118 | GibiToGiga、CallStackコンストラクタ | E-14, E-05 | △ |
| C-119〜C-120 | CallStack::Traceのlineno、file | E-05 | △ |

## 4) 不足情報（Unknown / Missing）
- **tsl::profilerライブラリの内部実装**: math_utils.hの関数はtsl::profilerに委譲されているため、実際の計算ロジックは別リポジトリにある
  - 候補：`xla/tsl/profiler/utils/math_utils.h` の実装確認
- **プロトコルバッファ定義**: CodeDef、ExecProfile等の詳細構造
  - 候補：`tensorflow/core/profiler/tfprof_log.proto`
- **テスト対象外ファイル**: advisorディレクトリ内のチェッカー類は一部のみカバー
  - 候補：`tensorflow/core/profiler/internal/advisor/`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: フォーマット関数、単位変換関数 - 実装がシンプルで副作用なし
- **1（中リスク）**: タイムライン生成、メモリトラッキング - 複雑な状態管理があるが、テストケースでカバー済み
- **2（高リスク）**:
  - プロファイラのグローバル状態管理（tf_stat静的変数） - マルチスレッド環境での競合可能性
  - ファイルI/O操作 - 環境依存の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] TFStatsクラスのコンストラクタで、GraphDefがnullの場合のCHECK動作を確認
- [ ] ParseOutput関数の全出力タイプ（timeline、stdout、file、pprof、none）がカバーされているか確認
- [ ] ExecStep::AddTimeStatsのデバイス判定ロジック（stream:all、cpu:N）が正しくテストされているか確認
- [ ] グローバルプロファイラ（tf_stat）の生成・削除の排他制御がテストで考慮されているか確認
- [ ] メモリトラッキングのGPU/CPU両方のアロケータケースがカバーされているか確認
- [ ] タイムラインJSON出力の200MB制限警告のテストが必要か検討
- [ ] tsl::profilerへの委譲関数について、上流ライブラリでのテスト状況を確認
