---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 76
  claims_with_evidence: 76
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：core-public.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：76 / 76、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/public/session.h` - Sessionクラス定義（88-310行目）
- E-02: `tensorflow/core/public/session.h` - NewSession関数宣言（318行目、355行目）
- E-03: `tensorflow/core/public/session.h` - Reset関数宣言（345-346行目）
- E-04: `tensorflow/core/public/session.h` - SetSessionCreatedMetric関数宣言（358行目）
- E-05: `tensorflow/core/public/session_options.h` - SessionOptions構造体定義（29-62行目）
- E-06: `tensorflow/core/public/version.h` - バージョンマクロ定義（21-110行目）
- E-07: `tensorflow/core/public/release_version.h` - リリースバージョンマクロ定義（26-48行目）

## 3) Claims と根拠の対応（レビューの主戦場）

### session.h - Sessionクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Session()コンストラクタの存在 | E-01 (90行目) | ○ |
| C-02 | ~Session()デストラクタの存在 | E-01 (91行目) | ○ |
| C-03 | Create(const GraphDef&)の純粋仮想関数 | E-01 (98行目) | ○ |
| C-04 | 既存グラフ時のエラー | E-01 (93-97行目コメント) | ○ |
| C-05 | 無効なGraphDefでのエラー | E-01 (93-97行目コメント) | ○ |
| C-06 | Create(GraphDef&&)のムーブ対応 | E-01 (100行目) | ○ |
| C-07 | Create(RunOptions, GraphDef)の実験的API | E-01 (141-146行目) | ○ |
| C-08 | Unimplementedデフォルト実装 | E-01 (143-145行目) | ○ |
| C-09 | Extend(const GraphDef&)の純粋仮想関数 | E-01 (108行目) | ○ |
| C-10 | 操作名重複時のエラー | E-01 (106-107行目コメント) | ○ |
| C-11 | Extend(GraphDef&&)のムーブ対応 | E-01 (110行目) | ○ |
| C-12 | Run()の基本機能 | E-01 (132-136行目) | ○ |
| C-13 | 出力順序の保証 | E-01 (118-119行目コメント) | ○ |
| C-14 | 存在しないテンソル名のエラー | E-01 (125-126行目コメント) | ○ |
| C-15 | 空の出力名/ターゲット名のエラー | E-01 (128-129行目コメント) | ○ |
| C-16 | nullptr出力時のエラー | E-01 (131行目コメント) | ○ |
| C-17 | 空入力での実行 | E-01 (132-136行目) | ○ |
| C-18 | RunOptions付きRun | E-01 (172-177行目) | ○ |
| C-19 | run_metadata省略可能 | E-01 (169行目コメント) | ○ |
| C-20 | ThreadPoolOptions付きRunの未対応 | E-01 (188-191行目) | ○ |
| C-21 | PRunSetupの部分実行 | E-01 (198-201行目) | ○ |
| C-22 | PRunSetupの未対応デフォルト | E-01 (197行目コメント) | ○ |
| C-23 | PRun継続実行 | E-01 (207-211行目) | ○ |
| C-24 | 無効handle時のエラー | E-01 (203-206行目コメント) | ○ |
| C-25 | ListDevices機能 | E-01 (218行目) | ○ |
| C-26 | デバイス0件の処理 | E-01 (213-217行目コメント) | ○ |
| C-27 | Close()の正常終了 | E-01 (225行目) | ○ |
| C-28 | 二重クローズ処理 | E-01 (220-224行目コメント) | ○ |
| C-29 | RunOptions付きClose | E-01 (161-165行目) | ○ |
| C-30 | Close(RunOptions)のUnimplemented | E-01 (162-164行目) | ○ |
| C-31 | LocalDeviceManager取得 | E-01 (232-235行目) | ○ |
| C-32 | LocalDeviceManagerのUnimplemented | E-01 (233-234行目) | ○ |
| C-33 | MakeCallable機能 | E-01 (243-247行目) | ○ |
| C-34 | MakeCallableのUnimplemented | E-01 (245-246行目) | ○ |
| C-35 | RunCallable実行 | E-01 (256-262行目) | ○ |
| C-36 | テンソル順序の保証 | E-01 (252-254行目コメント) | ○ |
| C-37 | RunCallableの無効handle | E-01 (249-255行目コメント) | ○ |
| C-38 | ThreadPoolOptions付きRunCallable | E-01 (272-278行目) | ○ |
| C-39 | ThreadPoolOptions付きUnimplemented | E-01 (276-277行目) | ○ |
| C-40 | ReleaseCallable機能 | E-01 (283-286行目) | ○ |
| C-41 | ReleaseCallableのUnimplemented | E-01 (284-285行目) | ○ |
| C-42 | Finalize機能 | E-01 (306-309行目) | ○ |
| C-43 | Finalize後のRunCallable | E-01 (294-304行目コメント) | ○ |
| C-44 | Finalize後のMakeCallableエラー | E-01 (290-292行目コメント) | ○ |
| C-45 | FinalizeのUnimplemented | E-01 (307-308行目) | ○ |

### session.h - グローバル関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | NewSession(options, out_session)の存在 | E-02 (318行目) | ○ |
| C-47 | ローカルターゲットでの作成 | E-02 (314-317行目コメント) | ○ |
| C-48 | 無効ターゲットのエラー | E-02 (317行目コメント) | ○ |
| C-49 | NewSession(options)の存在 | E-02 (355行目) | ○ |
| C-50 | エラー時nullptr | E-02 (351-354行目コメント) | ○ |
| C-51 | Reset機能 | E-03 (345-346行目) | ○ |
| C-52 | 空containers時のデフォルト動作 | E-03 (339-341行目コメント) | ○ |
| C-53 | 無効コンテナ名のエラー | E-03 (320-344行目コメント) | ○ |
| C-54 | SetSessionCreatedMetric機能 | E-04 (358行目) | ○ |

### session_options.h - SessionOptions構造体

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | SessionOptions()コンストラクタ | E-05 (61行目) | ○ |
| C-56 | envフィールドの存在 | E-05 (31行目) | ○ |
| C-57 | targetフィールドの存在 | E-05 (56行目) | ○ |
| C-58 | 空targetでローカル実行 | E-05 (35-36行目コメント) | ○ |
| C-59 | カンマ区切り複数ターゲット | E-05 (39-40行目コメント) | ○ |
| C-60 | configフィールドの存在 | E-05 (59行目) | ○ |

### version.h - バージョンマクロ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | TF_STR_HELPERマクロ | E-06 (21行目) | ○ |
| C-62 | TF_STRマクロ | E-06 (22行目) | ○ |
| C-63 | TF_GRAPH_DEF_VERSION_MIN_PRODUCER=0 | E-06 (94行目) | ○ |
| C-64 | TF_GRAPH_DEF_VERSION_MIN_CONSUMER=0 | E-06 (95行目) | ○ |
| C-65 | TF_GRAPH_DEF_VERSION値 | E-06 (96行目) | ○ |
| C-66 | TF_CHECKPOINT_VERSION_MIN_PRODUCER=0 | E-06 (108行目) | ○ |
| C-67 | TF_CHECKPOINT_VERSION_MIN_CONSUMER=0 | E-06 (109行目) | ○ |
| C-68 | TF_CHECKPOINT_VERSION=1 | E-06 (110行目) | ○ |

### release_version.h - リリースバージョンマクロ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | _TF_STR_HELPERマクロ | E-07 (26行目) | ○ |
| C-70 | _TF_STRマクロ | E-07 (27行目) | ○ |
| C-71 | TF_VERSION_STRINGの生成 | E-07 (46-48行目) | ○ |
| C-72 | サフィックス付きバージョン | E-07 (48行目) | ○ |
| C-73 | TF_MAJOR_VERSION未定義時エラー | E-07 (29-31行目) | ○ |
| C-74 | TF_MINOR_VERSION未定義時エラー | E-07 (33-35行目) | ○ |
| C-75 | TF_PATCH_VERSION未定義時エラー | E-07 (37-39行目) | ○ |
| C-76 | TF_VERSION_SUFFIX未定義時エラー | E-07 (41-43行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- **該当なし**：全テストケースがソースコードに基づいて生成されました

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**：全テストケースがヘッダーファイルの宣言・コメントに基づいており、根拠が明確

**注意点：**
- Sessionクラスは抽象基底クラスであり、実際のテストは具象実装クラスで行う必要がある
- マクロのテストはコンパイル時の検証となる
- 実験的APIは将来変更される可能性がある（コメントで明記されている）

## 6) レビュアーチェックリスト（最小）
- [ ] Sessionクラスの純粋仮想関数（Create, Extend, Run, ListDevices, Close）のテストケースが網羅されているか
- [ ] デフォルト実装（UnimplementedError返却）のテストケースが含まれているか
- [ ] SessionOptionsの各フィールドに対するテストケースが含まれているか
- [ ] バージョンマクロの定数値が正しいか
- [ ] release_version.hの#errorディレクティブのテストケースが含まれているか
- [ ] 境界値テスト（空入力、空コンテナ等）が十分にカバーされているか
