---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート: core-runtime_fallback.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **C-053 (CopyTfStringTensorToStringHostTensor異常系)**: メモリ不足時の挙動は実装詳細に依存
  2. **C-089 (AddDevices異常系)**: 初期化失敗パターンの具体的条件が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/runtime_fallback/util/attr_util.h`
- E-02: `tensorflow/core/runtime_fallback/util/attr_util.cc`
- E-03: `tensorflow/core/runtime_fallback/util/tensor_util.h`
- E-04: `tensorflow/core/runtime_fallback/util/tensor_util.cc`
- E-05: `tensorflow/core/runtime_fallback/util/type_util.h`
- E-06: `tensorflow/core/runtime_fallback/util/tensor_metadata.h`
- E-07: `tensorflow/core/runtime_fallback/runtime/runtime_fallback_tensor.h`
- E-08: `tensorflow/core/runtime_fallback/runtime/runtime_fallback_tensor.cc`
- E-09: `tensorflow/core/runtime_fallback/runtime/conversion_function.h`
- E-10: `tensorflow/core/runtime_fallback/runtime/conversion_function.cc`
- E-11: `tensorflow/core/runtime_fallback/runtime/kernel_utils.h`
- E-12: `tensorflow/core/runtime_fallback/runtime/runtime_fallback_op_handler.h`
- E-13: `tensorflow/core/runtime_fallback/kernel/kernel_fallback_tensor.h`
- E-14: `tensorflow/core/runtime_fallback/kernel/kernel_fallback_tensor.cc`
- E-15: `tensorflow/core/runtime_fallback/kernel/kernel_fallback_compat_request_state.h`
- E-16: `tensorflow/core/runtime_fallback/kernel/kernel_fallback_compat_request_state.cc`
- E-17: `tensorflow/core/runtime_fallback/kernel/kernel_fallback_execute_compat.h`
- E-18: `tensorflow/core/runtime_fallback/kernel/kernel_fallback_utils.h`
- E-19: `tensorflow/core/runtime_fallback/kernel/tensor_util.h`
- E-20: `tensorflow/core/runtime_fallback/kernel/tfrt_op_kernel.h`
- E-21: `tensorflow/core/runtime_fallback/kernel/attr_util.h`
- E-22: `tensorflow/core/runtime_fallback/conversion/conversion.h`
- E-23: `tensorflow/core/runtime_fallback/conversion/conversion.cc`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | ParseTfDataType - DT_INT8が正しく解析される | E-02 (L270-293) | ○ |
| C-002 | ParseTfDataType - DT_INT32が正しく解析される | E-02 (L270-293) | ○ |
| C-003 | ParseTfDataType - DT_INT64が正しく解析される | E-02 (L270-293) | ○ |
| C-004 | ParseTfDataType - DT_FLOATが正しく解析される | E-02 (L270-293) | ○ |
| C-005 | ParseTfDataType - DT_DOUBLEが正しく解析される | E-02 (L270-293) | ○ |
| C-006 | ParseTfDataType - DT_HALFが正しく解析される | E-02 (L270-293) | ○ |
| C-007 | ParseTfDataType - サポートされていないdtypeでエラー | E-02 (L289-292) | ○ |
| C-008 | ParseTfDataType - 空文字列でエラー | E-02 (L289-292) | ○ |
| C-009 | ConvertToTfDataType - OpAttrType変換 | E-02 (L295-306) | ○ |
| C-010 | ConvertToTfDataType - F32変換 | E-02 (L295-306) | ○ |
| C-011 | ConvertFromTfDataType - DT_INT64変換 | E-02 (L308-319) | ○ |
| C-012 | ConvertFromTfDataType - DT_FLOAT変換 | E-02 (L308-319) | ○ |
| C-013 | ConvertBefAttrTypeToTfDataType - I1変換 | E-02 (L321-375) | ○ |
| C-014 | ConvertBefAttrTypeToTfDataType - I32変換 | E-02 (L321-375) | ○ |
| C-015 | ConvertBefAttrTypeToTfDataType - F32変換 | E-02 (L321-375) | ○ |
| C-016 | ConvertBefAttrTypeToTfDataType - String変換 | E-02 (L321-375) | ○ |
| C-017 | ConvertTfDataTypeToBefAttrType - DT_BOOL変換 | E-02 (L377-430) | ○ |
| C-018 | ConvertTfDataTypeToBefAttrType - DT_INT32変換 | E-02 (L377-430) | ○ |
| C-019 | ParseBoolAttrValue - true解析 | E-02 (L432-443) | ○ |
| C-020 | ParseBoolAttrValue - false解析 | E-02 (L432-443) | ○ |
| C-021 | ParseBoolAttrValue - 不正文字列エラー | E-02 (L432-443) | ○ |
| C-022 | ParseIntAttrValue - 正の整数解析 | E-02 (L445-452) | ○ |
| C-023 | ParseIntAttrValue - 負の整数解析 | E-02 (L445-452) | ○ |
| C-024 | ParseIntAttrValue - ゼロ解析 | E-02 (L445-452) | ○ |
| C-025 | ParseIntAttrValue - 非数値エラー | E-02 (L445-452) | ○ |
| C-026 | ParseTensorShapeAttrValue - 有効形状解析 | E-02 (L479-502) | ○ |
| C-027 | ParseTensorShapeAttrValue - 空形状解析 | E-02 (L479-502) | ○ |
| C-028 | ParseTensorShapeAttrValue - 角括弧なしエラー | E-02 (L481-487) | ○ |
| C-029 | ParseTensorShapeAttrValue - 開始括弧のみエラー | E-02 (L481-487) | ○ |
| C-030 | IsUnusedAttribute - result_segment_sizes判定 | E-02 (L504-513) | ○ |
| C-031 | IsUnusedAttribute - operand_segment_sizes判定 | E-02 (L504-513) | ○ |
| C-032 | IsUnusedAttribute - 通常属性判定 | E-02 (L504-513) | ○ |
| C-033 | FillAttrValueMap - スカラー属性設定 | E-02 (L515-535) | ○ |
| C-034 | FillAttrValueMap - 配列属性設定 | E-02 (L515-535) | ○ |
| C-035 | FillAttrValueMap - 空配列設定 | E-02 (L76-82) | ○ |
| C-036 | SetUpAttrValueMap - 統合属性設定 | E-02 (L672-709) | ○ |
| C-037 | MoveHostBufferToTfTensor - 変換 | E-04 (L44-63) | ○ |
| C-038 | MoveHostBufferToTfTensor - スカラー変換 | E-04 (L44-63) | ○ |
| C-039 | CopyShtToTfTensor - 文字列テンソル変換 | E-04 (L65-84) | ○ |
| C-040 | CopyShtToTfTensor - 空テンソル変換 | E-04 (L65-84) | ○ |
| C-041 | GetTfShape - 形状変換 | E-03 (L49-54) | ○ |
| C-042 | GetTfShape - スカラー形状変換 | E-03 (L49-54) | ○ |
| C-043 | GetTfDataType - 有効DType変換 | E-05 (L27-39) | ○ |
| C-044 | GetTfDataType - Invalid DType処理 | E-05 (L29-33) | ○ |
| C-045 | GetTfrtDtype - 有効DataType変換 | E-05 (L41-54) | ○ |
| C-046 | GetTfrtDtype - DT_INVALID処理 | E-05 (L43-46) | ○ |
| C-047 | RuntimeFallbackTensor - コンストラクタ | E-08 (L65-69) | ○ |
| C-048 | RuntimeFallbackTensor - GetTensorHandle | E-07 (L42) | ○ |
| C-049 | RuntimeFallbackTensor - Print | E-08 (L105-149) | ○ |
| C-050 | GetShape - 形状取得 | E-08 (L71-80) | ○ |
| C-051 | GetShape - 0次元テンソル | E-08 (L71-80) | ○ |
| C-052 | CopyTfStringTensorToStringHostTensor - コピー | E-08 (L82-101) | ○ |
| C-053 | CopyTfStringTensorToStringHostTensor - メモリ不足 | **根拠不足** | △ |
| C-054 | CreateRuntimeFallbackTensorFromTfTensorHandle - 生成 | E-08 (L151-174) | ○ |
| C-055 | CreateRuntimeFallbackTensorFromTfTensorHandle - 無効ハンドル | E-08 (L156-168) | ○ |
| C-056 | MoveDHTToRuntimeFallbackTensor - 変換 | E-08 (L176-189) | ○ |
| C-057 | CopyRefDHTToRuntimeFallbackTensor - 参照付き変換 | E-08 (L191-203) | ○ |
| C-058 | CopySHTToRuntimeFallbackTensor - 変換 | E-08 (L205-213) | ○ |
| C-059 | ConvertRuntimeFallbackTensorToDenseHostTensor - 変換 | E-10 (L45-68) | ○ |
| C-060 | ConvertRuntimeFallbackTensorToDenseHostTensor - エラー | E-10 (L53-55) | ○ |
| C-061 | RegisterTFRuntimeFallbackTensorToHostConversionFn - 登録 | E-10 (L174-193) | ○ |
| C-062 | BaseKernelFallbackTensor - コンストラクタ(Tensor) | E-14 (L47-49) | ○ |
| C-063 | BaseKernelFallbackTensor - コンストラクタ(shape,dtype,tensor) | E-14 (L51-58) | ○ |
| C-064 | BaseKernelFallbackTensor - GetTensor | E-13 (L39) | ○ |
| C-065 | BaseKernelFallbackTensor - Print | E-14 (L60-62) | ○ |
| C-066 | KernelFallbackTensor - Create | E-13 (L56-58) | ○ |
| C-067 | FallbackResourceArray - SetResource | E-16 (L43-62) | ○ |
| C-068 | FallbackResourceArray - SetResource疎インデックス | E-16 (L45-48) | ○ |
| C-069 | FallbackResourceArray - GetResource | E-15 (L51-53) | ○ |
| C-070 | FallbackResourceArray - GetResourceAsFallbackTensor | E-15 (L56-59) | ○ |
| C-071 | KernelFallbackCompatRequestState - コンストラクタ(training) | E-16 (L64-111) | ○ |
| C-072 | KernelFallbackCompatRequestState - コンストラクタ(inference) | E-16 (L113-142) | ○ |
| C-073 | KernelFallbackCompatRequestState - step_id | E-15 (L104) | ○ |
| C-074 | KernelFallbackCompatRequestState - cpu_device | E-15 (L114) | ○ |
| C-075 | KernelFallbackCompatRequestState - device_manager | E-15 (L121-123) | ○ |
| C-076 | KernelFallbackCompatRequestState - custom_device | E-15 (L107-112) | ○ |
| C-077 | KernelFallbackCompatRequestState - custom_device nullptr | E-15 (L109-110) | ○ |
| C-078 | KernelFallbackCompatRequestState - set_cancellation_manager | E-15 (L143-145) | ○ |
| C-079 | SetUpKernelFallbackCompatRequestContext - 設定 | E-16 (L151-183) | ○ |
| C-080 | SetUpKernelFallbackCompatRequestContext - デフォルトrunner | E-16 (L144-149, L172) | ○ |
| C-081 | IsGpuTensorHandle - GPU判定 | E-11 (L63-70) | ○ |
| C-082 | IsGpuTensorHandle - CPU判定 | E-11 (L63-70) | ○ |
| C-083 | IsSupportedByTFRTGpu - DT_FLOAT判定 | E-11 (L75-84) | ○ |
| C-084 | IsSupportedByTFRTGpu - DT_STRING判定 | E-11 (L75-84) | ○ |
| C-085 | EagerContextResource - コンストラクタ(default) | E-11 (L117-122) | ○ |
| C-086 | EagerContextResource - GetTFEagerContext | E-11 (L131-134) | ○ |
| C-087 | EagerContextResource - GetDeviceMgr | E-11 (L136) | ○ |
| C-088 | EagerContextResource - AddDevices | E-11 (L138-147) | ○ |
| C-089 | EagerContextResource - AddDevices異常系 | **根拠不足** | △ |
| C-090 | RegisterRuntimeFallbackTensorToKernelFallbackConversionFn - 登録 | E-23 (L84-90) | ○ |
| C-091 | TFRTOpKernelConstruction - コンストラクタ | E-20 (L65) | ○ |
| C-092 | TFRTOpKernelConstruction - GetAttr<string> | E-20 (L91-92) | ○ |
| C-093 | TFRTOpKernelConstruction - GetAttr<DataType> | E-20 (L94-96) | ○ |
| C-094 | TFRTOpKernelConstruction - GetAttr存在しない属性 | E-20 (L109-117) | ○ |
| C-095 | TFRTOpKernelConstruction - CtxFailure | E-20 (L71) | ○ |
| C-096 | TFRTOpKernelContext - コンストラクタ | E-20 (L123-125) | ○ |
| C-097 | TFRTOpKernelContext - input | E-20 (L131) | ○ |
| C-098 | TFRTOpKernelContext - num_inputs | E-20 (L132) | ○ |
| C-099 | TFRTOpKernelContext - set_output | E-20 (L133) | ○ |
| C-100 | TFRTOpKernelContext - allocate_output | E-20 (L142-143) | ○ |
| C-101 | TFRTOpKernelContext - allocate_temp | E-20 (L140-141) | ○ |
| C-102 | TFRTOpMetaBuilder - Output | E-20 (L207) | ○ |
| C-103 | TFRTOpMetaBuilder - BuildMeta | E-20 (L211) | ○ |
| C-104 | TFRTOpKernelFactories - RegisterFactory | E-20 (L274-275) | ○ |
| C-105 | TFRTOpKernelFactories - CreateKernel | E-20 (L287-289) | ○ |
| C-106 | TFRTOpKernelFactories - CreateKernel未登録 | E-20 (L280-285) | ○ |
| C-107 | ParseValue(bool) | E-21 (L40) | ○ |
| C-108 | ParseValue(int32_t) | E-21 (L41) | ○ |
| C-109 | ParseValue(DataType) | E-21 (L42) | ○ |
| C-110 | ParseValue(vector<int32_t>) | E-21 (L44) | ○ |
| C-111 | ParseValue(Padding) | E-21 (L45) | ○ |
| C-112 | AddOpAttr | E-21 (L47-48) | ○ |
| C-113 | FillOpAttrs | E-21 (L50-51) | ○ |
| C-114 | TransferTensorToDevice - 同一デバイス | E-19 (L41-55) | ○ |
| C-115 | TransferTensorToDevice - CPU間 | E-19 (L47-55) | ○ |
| C-116 | TransferTensorToDevice - CPU-GPU | E-19 (L57-121) | ○ |
| C-117 | TransferTensorToDevice - 空テンソル | E-19 (L69-71) | ○ |
| C-118 | TransferTensorToDevice - memcpy不可型 | E-19 (L57-62) | ○ |
| C-119 | GetTfDevice | E-19 (L127-128) | ○ |
| C-120 | GetTensorMetadata | E-06 (L28-37) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-053 (CopyTfStringTensorToStringHostTensor異常系)**: メモリ不足時の具体的な挙動はStringHostTensor::CreateUninitializedの実装に依存し、runtime_fallback内のコードからは直接確認できない
  - 候補：tfrt/tensor/string_host_tensor.h / tfrt::HostContext実装
- **C-089 (AddDevices異常系)**: 初期化失敗のパターン（ctx_の初期化失敗）の具体的条件は外部依存（DynamicDeviceMgr、EagerContext初期化）による
  - 候補：tensorflow/core/common_runtime/device_mgr.h / EagerContext初期化コード

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: 型変換関数群（C-001〜C-018, C-043〜C-046）- switch文ベースの直接マッピングで実装が明確
- **リスク0（低）**: アクセサ/セッター（C-048, C-064, C-073〜C-078）- 単純なゲッター/セッター
- **リスク1（中）**: 異常系テスト（C-007, C-008, C-021, C-025, C-028, C-029）- エラーパスの網羅性は要確認
- **リスク1（中）**: デバイス転送テスト（C-114〜C-118）- デバイス依存の複雑なロジック
- **リスク2（高）**: メモリ不足テスト（C-053）- 実際のメモリ不足状態の再現が困難
- **リスク2（高）**: 非同期処理テスト（C-116）- タイミング依存の問題が発生する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] 型変換関数（ConvertXxxToYyy）が全ての対応する型をカバーしているか確認
- [ ] 異常系テストケースが実際のエラーパスと一致しているか確認
- [ ] デバイス転送テストで想定するデバイス構成が実環境と一致するか確認
- [ ] FallbackResourceArrayの疎インデックス処理でメモリリークがないか確認
- [ ] テストID（UT-RTF-xxx）の命名が一貫しているか確認
- [ ] 優先度「高」のテストケースが実際のビジネスリスクと一致しているか確認
