---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 81
  claims_with_evidence: 81
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：core-summary.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード上の対応する関数・メソッド・処理が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要な関数・分岐・エラー処理を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で各テストケースの根拠を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：81 / 81、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - 全テストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `tensorflow/core/summary/summary_converter.h` - 変換関数の宣言
- E-02: `tensorflow/core/summary/summary_converter.cc` - 変換関数の実装（AddTensorAsScalarToSummary, AddTensorAsHistogramToSummary, AddTensorAsImageToSummary, AddTensorAsAudioToSummary, TensorValueAt, AddImages, NormalizeFloatImage, NormalizeAndAddImages）
- E-03: `tensorflow/core/summary/summary_file_writer.h` - CreateSummaryFileWriterの宣言
- E-04: `tensorflow/core/summary/summary_file_writer.cc` - SummaryFileWriterクラスの実装（Initialize, Flush, WriteTensor, WriteScalar, WriteHistogram, WriteImage, WriteAudio, WriteGraph, WriteEvent）
- E-05: `tensorflow/core/summary/summary_db_writer.h` - CreateSummaryDbWriterの宣言
- E-06: `tensorflow/core/summary/summary_db_writer.cc` - SummaryDbWriterクラス、IdAllocator、GraphWriter、RunMetadata、SeriesWriter、RunWriterクラスの実装
- E-07: `tensorflow/core/summary/schema.h` - SetupTensorboardSqliteDbの宣言
- E-08: `tensorflow/core/summary/schema.cc` - SQLiteスキーマ作成の実装
- E-09: `tensorflow/core/summary/loader.cc` - AddCommas関数とmain関数の実装
- E-10: `tensorflow/core/summary/vacuum.cc` - Vacuum関数とmain関数の実装

## 3) Claims と根拠の対応（レビューの主戦場）

### summary_converter.cc - スカラー変換

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-SUM-001: float型テンソルをスカラーサマリーに変換 | E-02: L219-227 AddTensorAsScalarToSummary実装 | ○ |
| C-02 | UT-SUM-002: int32型テンソルをスカラー変換 | E-02: L41-75 TensorValueAt テンプレート、TF_CALL_int32マクロ | ○ |
| C-03 | UT-SUM-003: complex64型の実部をスカラー変換 | E-02: L46-49 COMPLEX_CASEマクロで.real()取得 | ○ |
| C-04 | UT-SUM-004: 未サポートデータ型でエラー | E-02: L66-69 default caseでerrors::Unimplemented | ○ |

### summary_converter.cc - ヒストグラム変換

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | UT-SUM-005: テンソルをヒストグラムに変換 | E-02: L229-247 AddTensorAsHistogramToSummary実装 | ○ |
| C-06 | UT-SUM-006: NaN値でエラー | E-02: L237-238 isnan check with InvalidArgument | ○ |
| C-07 | UT-SUM-007: 無限大値でエラー | E-02: L239-241 isinf check with InvalidArgument | ○ |
| C-08 | UT-SUM-008: 空テンソルでヒストグラム生成 | E-02: L234 t.NumElements()によるループ | ○ |

### summary_converter.cc - 画像変換

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | UT-SUM-009: 4次元uint8テンソルを画像変換 | E-02: L271-279 DT_UINT8ケース | ○ |
| C-10 | UT-SUM-010: float型テンソルの正規化 | E-02: L283-286 DT_FLOATケース、NormalizeAndAddImages呼び出し | ○ |
| C-11 | UT-SUM-011: max_images > 1でタグに連番付与 | E-02: L98-102 if (max_images > 1) StrCat(tag, "/image/", i) | ○ |
| C-12 | UT-SUM-012: 4次元以外でエラー | E-02: L252-258 tensor.dims() == 4チェック | ○ |
| C-13 | UT-SUM-013: 最終次元が1,3,4以外でエラー | E-02: L253-254 dim_size(3)チェック | ○ |
| C-14 | UT-SUM-014: サイズ過大でエラー | E-02: L259-264 サイズ制限チェック | ○ |
| C-15 | UT-SUM-015: 未サポート画像型でエラー | E-02: L290-294 default caseでInvalidArgument | ○ |
| C-16 | UT-SUM-016: 非有限値がbad_colorに置換 | E-02: L173-188 NormalizeFloatImageでfiniteチェックとbad_color適用 | ○ |
| C-17 | UT-SUM-017: bad_colorサイズ不足でエラー | E-02: L197-201 bad_color.dim_size(0) < depthチェック | ○ |

### summary_converter.cc - 音声変換

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | UT-SUM-018: テンソルを音声変換 | E-02: L298-337 AddTensorAsAudioToSummary実装 | ○ |
| C-19 | UT-SUM-019: sample_rate <= 0でエラー | E-02: L301-303 sample_rate <= 0.0fチェック | ○ |
| C-20 | UT-SUM-020: max_outputs > 1でタグに連番付与 | E-02: L311-315 if (max_outputs > 1) | ○ |
| C-21 | UT-SUM-021: 極小sample_rateの切り上げ | E-02: L328-331 sample_rate_truncated == 0で1に設定 | ○ |

### summary_file_writer.cc - ファイルライター

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | UT-SUM-022: SummaryFileWriter正常作成 | E-04: L207-221 CreateSummaryFileWriter実装 | ○ |
| C-23 | UT-SUM-023: 存在しないディレクトリ自動作成 | E-04: L53-59 RecursivelyCreateDir呼び出し | ○ |
| C-24 | UT-SUM-024: 無効パスでエラー | E-04: L54-57 is_dir.code()チェックとエラー返却 | ○ |
| C-25 | UT-SUM-025: ファイル名にPIDとカウンタ付与 | E-04: L62-67 pid, file_id_counterによる一意化 | ○ |
| C-26 | UT-SUM-026: Flush成功 | E-04: L79-85 Flush実装 | ○ |
| C-27 | UT-SUM-027: 未初期化Flushでエラー | E-04: L81-83 is_initialized_チェック | ○ |
| C-28 | UT-SUM-028: WriteTensor書き込み | E-04: L91-113 WriteTensor実装 | ○ |
| C-29 | UT-SUM-029: DT_STRINGはAsProtoField形式 | E-04: L99-107 dtype == DT_STRING分岐 | ○ |
| C-30 | UT-SUM-030: WriteScalar書き込み | E-04: L115-123 WriteScalar実装 | ○ |
| C-31 | UT-SUM-031: WriteHistogram書き込み | E-04: L125-133 WriteHistogram実装 | ○ |
| C-32 | UT-SUM-032: WriteImage書き込み | E-04: L135-143 WriteImage実装 | ○ |
| C-33 | UT-SUM-033: WriteAudio書き込み | E-04: L145-153 WriteAudio実装 | ○ |
| C-34 | UT-SUM-034: WriteGraph書き込み | E-04: L155-162 WriteGraph実装 | ○ |
| C-35 | UT-SUM-035: キューサイズ超過で自動フラッシュ | E-04: L167 queue_.size() > max_queue_ | ○ |
| C-36 | UT-SUM-036: 時間経過で自動フラッシュ | E-04: L168 NowMicros() - last_flush_ > 1000 * flush_millis_ | ○ |

### summary_db_writer.cc - DBライター

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | UT-SUM-037: SummaryDbWriter正常作成 | E-06: L1176-1183 CreateSummaryDbWriter実装 | ○ |
| C-38 | UT-SUM-038: WriteTensorでDB書き込み | E-06: L947-956 WriteTensor実装 | ○ |
| C-39 | UT-SUM-039: 未サポート型でエラー | E-06: L950 CheckSupportedType呼び出し | ○ |
| C-40 | UT-SUM-040: 不正メタデータでエラー | E-06: L952-954 ParseFromStringチェック | ○ |
| C-41 | UT-SUM-041: WriteScalarでDB書き込み | E-06: L958-964 WriteScalar実装 | ○ |
| C-42 | UT-SUM-042: WriteGraphでDB書き込み | E-06: L966-970 WriteGraph実装 | ○ |
| C-43 | UT-SUM-043: WriteEventでMigrate | E-06: L972-974 WriteEvent実装 | ○ |
| C-44 | UT-SUM-044: WriteHistogramでDB書き込み | E-06: L976-985 WriteHistogram実装 | ○ |
| C-45 | UT-SUM-045: WriteImageでDB書き込み | E-06: L987-996 WriteImage実装 | ○ |
| C-46 | UT-SUM-046: WriteAudioでDB書き込み | E-06: L998-1007 WriteAudio実装 | ○ |
| C-47 | UT-SUM-047: Flush成功 | E-06: L945 Flush実装(空実装) | ○ |

### summary_db_writer.cc - IdAllocator

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | UT-SUM-048: 一意ID生成 | E-06: L187-218 CreateNewId実装 | ○ |
| C-49 | UT-SUM-049: ID衝突時リトライ | E-06: L201-206 tier昇格ロジック | ○ |
| C-50 | UT-SUM-050: 最高tierで指数バックオフ | E-06: L207-215 スリープロジック | ○ |

### summary_db_writer.cc - RunMetadata

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | UT-SUM-051: 新規タグID作成 | E-06: L443-487 GetTagId実装 | ○ |
| C-52 | UT-SUM-052: タグIDキャッシュ | E-06: L449-452 tag_ids_.find()チェック | ○ |
| C-53 | UT-SUM-053: グラフ保存 | E-06: L427-441 SetGraph実装 | ○ |

### summary_db_writer.cc - GraphWriter

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | UT-SUM-054: グラフノード保存 | E-06: L236-249 GraphWriter::Save実装 | ○ |
| C-55 | UT-SUM-055: 存在しないノード参照でエラー | E-06: L300-303 name_to_node_id_.find()チェック | ○ |
| C-56 | UT-SUM-056: 不正入力形式でエラー | E-06: L290-294 SimpleAtoiチェック | ○ |

### summary_db_writer.cc - SeriesWriter

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | UT-SUM-057: シリーズ追加 | E-06: L660-678 SeriesWriter::Append実装 | ○ |
| C-58 | UT-SUM-058: 文字列テンソル書き込み | E-06: L706-708 DT_STRING && dims()==0ケース | ○ |
| C-59 | UT-SUM-059: 多次元文字列テンソル分割保存 | E-06: L710-715 UpdateNdString呼び出し | ○ |
| C-60 | UT-SUM-060: 未使用予約行削除 | E-06: L680-700 SeriesWriter::Finish実装 | ○ |

### summary_db_writer.cc - RunWriter

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | UT-SUM-061: SeriesWriter委譲 | E-06: L862-867 RunWriter::Append実装 | ○ |
| C-62 | UT-SUM-062: 全SeriesWriter終了 | E-06: L869-880 RunWriter::Finish実装 | ○ |

### schema.cc - スキーマ設定

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | UT-SUM-063: テーブル作成 | E-08: L32-443 SetupTensorboardSqliteDb実装 | ○ |
| C-64 | UT-SUM-064: 冪等性 | E-08: CREATE TABLE IF NOT EXISTS構文 | ○ |
| C-65 | UT-SUM-065: application_id設定 | E-08: L35-38 PRAGMA application_id設定 | ○ |

### loader.cc - ローダーツール

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | UT-SUM-066: 小数値フォーマット | E-09: L37-54 AddCommas実装 | ○ |
| C-67 | UT-SUM-067: 大数値カンマ挿入 | E-09: L41-52 カンマ挿入ロジック | ○ |
| C-68 | UT-SUM-068: ゼロ処理 | E-09: L37-54 AddCommas実装 | ○ |
| C-69 | UT-SUM-069: イベントロード | E-09: L99-126 main関数のロードループ | ○ |
| C-70 | UT-SUM-070: 引数不足でエラー | E-09: L71-79 parse_result || path.empty()チェック | ○ |

### vacuum.cc - バキュームツール

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | UT-SUM-071: 孤立Experiments削除 | E-10: L37-44 DELETE FROM Experiments | ○ |
| C-72 | UT-SUM-072: 孤立Runs削除 | E-10: L46-53 DELETE FROM Runs | ○ |
| C-73 | UT-SUM-073: 孤立Tags削除 | E-10: L55-62 DELETE FROM Tags | ○ |
| C-74 | UT-SUM-074: 孤立Tensors削除 | E-10: L65-72 DELETE FROM Tensors | ○ |
| C-75 | UT-SUM-075: 孤立TensorStrings削除 | E-10: L74-80 DELETE FROM TensorStrings | ○ |
| C-76 | UT-SUM-076: 孤立Graphs削除 | E-10: L82-89 DELETE FROM Graphs | ○ |
| C-77 | UT-SUM-077: 孤立Nodes削除 | E-10: L91-97 DELETE FROM Nodes | ○ |
| C-78 | UT-SUM-078: 孤立NodeInputs削除 | E-10: L99-105 DELETE FROM NodeInputs | ○ |
| C-79 | UT-SUM-079: VACUUM実行 | E-10: L107-108 VACUUM実行 | ○ |
| C-80 | UT-SUM-080: 複数DB処理 | E-10: L130-132 for loop | ○ |
| C-81 | UT-SUM-081: 引数なしでエラー | E-10: L126-129 argc < 2チェック | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全テストケースにソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成されており、根拠が明確

追加の確認推奨事項:
- 実際のテスト実装時にはSQLite DBのモック/スタブが必要
- 画像・音声変換テストには適切なテストデータの準備が必要
- マルチスレッド安全性テストは別途検討が必要（クラスにはmutexが使用されている）

## 6) レビュアーチェックリスト（最小）
- [ ] CSVファイルのエンコーディングがUTF-8 with BOMになっているか
- [ ] テストIDの命名規則（UT-SUM-XXX）が一貫しているか
- [ ] 優先度（高/中/低）の判定基準が適切か
- [ ] 異常系テストケースでエラーメッセージの検証が含まれているか
- [ ] 境界値テストが主要な処理で網羅されているか
