---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 115
  claims_without_evidence: 5
confidence_derived: 0.96
---

# 根拠レポート：core-tfrt 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：115 / 120、根拠なし：5
- 優先レビュー（高）
  1. **UT-TFR-049**: OpKernelRunnerTable::Get 範囲外アクセス時の挙動 - 実装詳細の確認必要
  2. **UT-TFR-098**: IfrtServingExecutable::Execute フリーズ後の挙動 - 実装詳細の確認必要
  3. **UT-TFR-040**: FallbackState::AddFunctionDef 重複登録時のエラー - 実装詳細の確認必要
  4. **UT-TFR-060**: StreamCallbackRegistry::Register 重複ID時のエラー - 実装詳細の確認必要
  5. **UT-TFR-107**: KernelRegistry::Get 未登録時の戻り値 - 実装詳細の確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/tfrt/graph_executor/graph_executor.h` - GraphExecutorクラスの定義
- E-02: `tensorflow/core/tfrt/graph_executor/graph_executor.cc` - GraphExecutorクラスの実装（推定）
- E-03: `tensorflow/core/tfrt/saved_model/saved_model.h` - SavedModel/SavedModelImplクラスの定義
- E-04: `tensorflow/core/tfrt/runtime/runtime.h` - Runtimeクラスの定義
- E-05: `tensorflow/core/tfrt/fallback/fallback_state.h` - FallbackStateクラスの定義
- E-06: `tensorflow/core/tfrt/fallback/op_kernel_runner.h` - OpKernelRunner/OpKernelRunnerTableクラスの定義
- E-07: `tensorflow/core/tfrt/fallback/cost_recorder.h` - CostRecorderクラスの定義
- E-08: `tensorflow/core/tfrt/tfrt_session/tfrt_session.h` - TfrtSessionFactoryクラスの定義
- E-09: `tensorflow/core/tfrt/runtime/stream.h` - StreamCallbackRegistry/ScopedStreamCallbackクラスの定義
- E-10: `tensorflow/core/tfrt/runtime/work_queue_interface.h` - WorkQueueInterfaceクラスの定義
- E-11: `tensorflow/core/tfrt/common/pjrt_state.h` - PjRtStateクラスの定義
- E-12: `tensorflow/core/tfrt/common/async_value_tensor.h` - AsyncValueTensor/AsyncValueAllocatorクラスの定義
- E-13: `tensorflow/core/tfrt/utils/utils.h` - ユーティリティ関数の定義
- E-14: `tensorflow/core/tfrt/utils/tensor_util.h` - テンソル変換関数の定義
- E-15: `tensorflow/core/tfrt/utils/tfrt_graph_execution_state.h` - TfrtGraphExecutionStateクラスの定義
- E-16: `tensorflow/core/tfrt/utils/error_util.h` - エラー変換関数の定義
- E-17: `tensorflow/core/tfrt/ifrt/ifrt_serving_executable.h` - IfrtServingExecutableクラスの定義
- E-18: `tensorflow/core/tfrt/ifrt/sharding_utils.h` - シャーディングユーティリティの定義
- E-19: `tensorflow/core/tfrt/mlrt/interpreter/context.h` - KernelRegistry/ExecutionContextクラスの定義
- E-20: `tensorflow/core/tfrt/mlrt/interpreter/execute.h` - Execute関数の定義
- E-21: `tensorflow/core/tfrt/gpu/kernel/gpu_runner.h` - GpuRunnerクラスの定義
- E-22: `tensorflow/core/tfrt/runtime/step_id.h` - StepIdクラスの定義（推定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-TFR-001) | GraphExecutor::Create 正常系 | E-01, E-02 | ○ |
| C-02 (UT-TFR-002) | GraphExecutor::Create 異常系 | E-01, E-02 | ○ |
| C-03 (UT-TFR-003) | GraphExecutor::Run 正常系 | E-01, E-02 | ○ |
| C-04 (UT-TFR-004) | GraphExecutor::Run 異常系 | E-01, E-02 | ○ |
| C-05 (UT-TFR-005) | GraphExecutor::Run 境界値 | E-01, E-02 | ○ |
| C-06 (UT-TFR-006) | GraphExecutor::RunWithSortedInputsOutputs | E-01 | ○ |
| C-07 (UT-TFR-007) | GraphExecutor::RunWithSyncInterpreter | E-01 | ○ |
| C-08 (UT-TFR-008) | GraphExecutor::Extend | E-01 | ○ |
| C-09 (UT-TFR-009) | GraphExecutor::CompileGraph | E-01 | ○ |
| C-10 (UT-TFR-010) | LoadedClientGraph::MaybeGetCostRecorder | E-01 | ○ |
| C-11 (UT-TFR-011) | LoadedClientGraph::UpdateCost | E-01 | ○ |
| C-12 (UT-TFR-012) | CreateRequestInfo | E-01 | ○ |
| C-13 (UT-TFR-013) | GraphExecutionRunOnFunction | E-01 | ○ |
| C-14 (UT-TFR-014) | RunMlrtFunction | E-01 | ○ |
| C-15 (UT-TFR-015) | CreateSortedNamesAndOriginalIndices | E-01 | ○ |
| C-16 (UT-TFR-016) | SavedModelImpl::LoadSavedModel 正常系 | E-03 | ○ |
| C-17 (UT-TFR-017) | SavedModelImpl::LoadSavedModel 異常系 | E-03 | ○ |
| C-18 (UT-TFR-018) | SavedModelImpl::Run 正常系 | E-03 | ○ |
| C-19 (UT-TFR-019) | SavedModelImpl::Run 異常系 | E-03 | ○ |
| C-20 (UT-TFR-020) | SavedModelImpl::RunMultipleSignatures | E-03 | ○ |
| C-21 (UT-TFR-021) | SavedModelImpl::RunByTensorNames | E-03 | ○ |
| C-22 (UT-TFR-022) | SavedModelImpl::GetFunctionNames | E-03 | ○ |
| C-23 (UT-TFR-023) | SavedModelImpl::GetFunctionMetadata 正常系 | E-03 | ○ |
| C-24 (UT-TFR-024) | SavedModelImpl::GetFunctionMetadata 異常系 | E-03 | ○ |
| C-25 (UT-TFR-025) | FunctionMetadata::GetInputNames | E-03 | ○ |
| C-26 (UT-TFR-026) | FunctionMetadata::GetOutputNames | E-03 | ○ |
| C-27 (UT-TFR-027) | Runtime::Create (スレッド数指定) | E-04 | ○ |
| C-28 (UT-TFR-028) | Runtime::Create (WorkQueue指定) | E-04 | ○ |
| C-29 (UT-TFR-029) | Runtime::Create 境界値 | E-04 | ○ |
| C-30 (UT-TFR-030) | Runtime::CreateRuntimeResources | E-04 | ○ |
| C-31 (UT-TFR-031) | Runtime::CreateRequestQueue | E-04 | ○ |
| C-32 (UT-TFR-032) | Runtime::AddCreateRuntimeResourceFn | E-04 | ○ |
| C-33 (UT-TFR-033) | ModelRuntimeContext::name | E-04 | ○ |
| C-34 (UT-TFR-034) | ModelRuntimeContext::version | E-04 | ○ |
| C-35 (UT-TFR-035) | FallbackState::Create | E-05 | ○ |
| C-36 (UT-TFR-036) | FallbackState::CreateWithCpuDevice | E-05 | ○ |
| C-37 (UT-TFR-037) | FallbackState::CreateWithMockGpuDevice | E-05 | ○ |
| C-38 (UT-TFR-038) | FallbackState::CreateGraphExecutionState | E-05 | ○ |
| C-39 (UT-TFR-039) | FallbackState::AddFunctionDef 正常系 | E-05 | ○ |
| C-40 (UT-TFR-040) | FallbackState::AddFunctionDef 異常系 | **根拠なし** | △ |
| C-41 (UT-TFR-041) | OpKernelRunner::Create 正常系 | E-06 | ○ |
| C-42 (UT-TFR-042) | OpKernelRunner::Create 異常系(op_name) | E-06 | ○ |
| C-43 (UT-TFR-043) | OpKernelRunner::Create 異常系(device) | E-06 | ○ |
| C-44 (UT-TFR-044) | OpKernelRunner::Run | E-06 | ○ |
| C-45 (UT-TFR-045) | OpKernelRunner::RunAsync | E-06 | ○ |
| C-46 (UT-TFR-046) | OpKernelRunnerTable::Insert 正常系 | E-06 | ○ |
| C-47 (UT-TFR-047) | OpKernelRunnerTable::Insert 異常系 | E-06 | ○ |
| C-48 (UT-TFR-048) | OpKernelRunnerTable::Get 正常系 | E-06 | ○ |
| C-49 (UT-TFR-049) | OpKernelRunnerTable::Get 異常系 | E-06 | ○ |
| C-50 (UT-TFR-050) | CostRecorder::RecordCost | E-07 | ○ |
| C-51 (UT-TFR-051) | CostRecorder::GetCost 正常系 | E-07 | ○ |
| C-52 (UT-TFR-052) | CostRecorder::GetCost 異常系 | E-07 | ○ |
| C-53 (UT-TFR-053) | CostRecorder::WriteToFile | E-07 | ○ |
| C-54 (UT-TFR-054) | CostRecorder::size | E-07 | ○ |
| C-55 (UT-TFR-055) | TfrtSessionFactory::NewSession | E-08 | ○ |
| C-56 (UT-TFR-056) | TfrtSessionFactory::AcceptsOptions | E-08 | ○ |
| C-57 (UT-TFR-057) | TfrtSessionFactory::GetRuntime | E-08 | ○ |
| C-58 (UT-TFR-058) | InitializeTfrtSession | E-08 | ○ |
| C-59 (UT-TFR-059) | StreamCallbackRegistry::Register 正常系 | E-09 | ○ |
| C-60 (UT-TFR-060) | StreamCallbackRegistry::Register 異常系 | **根拠なし** | △ |
| C-61 (UT-TFR-061) | StreamCallbackRegistry::Invoke 正常系 | E-09 | ○ |
| C-62 (UT-TFR-062) | StreamCallbackRegistry::Invoke 異常系 | E-09 | ○ |
| C-63 (UT-TFR-063) | ScopedStreamCallback デストラクタ | E-09 | ○ |
| C-64 (UT-TFR-064) | CreateStreamCallbackId | E-09 | ○ |
| C-65 (UT-TFR-065) | WrapDefaultWorkQueue | E-10 | ○ |
| C-66 (UT-TFR-066) | WrapWork | E-10 | ○ |
| C-67 (UT-TFR-067) | PjRtState::Create | E-11 | ○ |
| C-68 (UT-TFR-068) | PjRtState::GetPjRtClient 正常系 | E-11 | ○ |
| C-69 (UT-TFR-069) | PjRtState::GetPjRtClient 異常系 | E-11 | ○ |
| C-70 (UT-TFR-070) | PjRtState::SetPjRtClient | E-11 | ○ |
| C-71 (UT-TFR-071) | PjRtState::GetOrCreatePjRtClient | E-11 | ○ |
| C-72 (UT-TFR-072) | PjRtState::MovePjRtClientToUnused | E-11 | ○ |
| C-73 (UT-TFR-073) | AsyncValueTensor::FromTensor | E-12 | ○ |
| C-74 (UT-TFR-074) | AsyncValueTensor::GetBuffer | E-12 | ○ |
| C-75 (UT-TFR-075) | AsyncValueTensor::SetBuffer | E-12 | ○ |
| C-76 (UT-TFR-076) | AsyncValueAllocator::AllocateRaw | E-12 | ○ |
| C-77 (UT-TFR-077) | AsyncValueAllocator::DeallocateRaw | E-12 | ○ |
| C-78 (UT-TFR-078) | ConvertTfDTypeToTfrtDType | E-13 | ○ |
| C-79 (UT-TFR-079) | RunRuntimeInitializer | E-13 | ○ |
| C-80 (UT-TFR-080) | CreateBefFileFromBefBuffer | E-13 | ○ |
| C-81 (UT-TFR-081) | GetUniqueInt | E-13 | ○ |
| C-82 (UT-TFR-082) | CreateDummyTfDevices | E-13 | ○ |
| C-83 (UT-TFR-083) | TFRTTensorToTFTensor | E-14 | ○ |
| C-84 (UT-TFR-084) | TFTensorToTFRTTensorHandle | E-14 | ○ |
| C-85 (UT-TFR-085) | CreateTensorHandleFromTFTensor | E-14 | ○ |
| C-86 (UT-TFR-086) | CreateTFTensorFromTensorHandle | E-14 | ○ |
| C-87 (UT-TFR-087) | TfrtGraphExecutionState::Create | E-15 | ○ |
| C-88 (UT-TFR-088) | TfrtGraphExecutionState::CreateOptimizedGraph | E-15 | ○ |
| C-89 (UT-TFR-089) | TfrtGraphExecutionState::Extend | E-15 | ○ |
| C-90 (UT-TFR-090) | PruneGraphDef | E-15 | ○ |
| C-91 (UT-TFR-091) | EliminateRefVariablesFromV1ControlFlow | E-15 | ○ |
| C-92 (UT-TFR-092) | ConvertTfErrorCodeToTfrtErrorCode | E-16 | ○ |
| C-93 (UT-TFR-093) | CreateTfErrorStatus | E-16 | ○ |
| C-94 (UT-TFR-094) | ToTfStatus | E-16 | ○ |
| C-95 (UT-TFR-095) | MakeStatusString | E-16 | ○ |
| C-96 (UT-TFR-096) | IfrtServingExecutable::Create | E-17 | ○ |
| C-97 (UT-TFR-097) | IfrtServingExecutable::Execute 正常系 | E-17 | ○ |
| C-98 (UT-TFR-098) | IfrtServingExecutable::Execute 異常系 | **根拠なし** | △ |
| C-99 (UT-TFR-099) | IfrtServingExecutable::Freeze | E-17 | ○ |
| C-100 (UT-TFR-100) | MakeArrayFromTensor | E-18 | ○ |
| C-101 (UT-TFR-101) | MakeTensorFromArray | E-18 | ○ |
| C-102 (UT-TFR-102) | GetByteStrides | E-18 | ○ |
| C-103 (UT-TFR-103) | H2DTransferExecutor::ScheduledH2DTransfer | E-18 | ○ |
| C-104 (UT-TFR-104) | H2DTransferExecutor::RunH2DTransfers | E-18 | ○ |
| C-105 (UT-TFR-105) | KernelRegistry::Register | E-19 | ○ |
| C-106 (UT-TFR-106) | KernelRegistry::Get 正常系 | E-19 | ○ |
| C-107 (UT-TFR-107) | KernelRegistry::Get 異常系 | **根拠なし** | △ |
| C-108 (UT-TFR-108) | LoadedExecutable::GetFunction 正常系 | E-19 | ○ |
| C-109 (UT-TFR-109) | LoadedExecutable::GetFunction 異常系 | E-19 | ○ |
| C-110 (UT-TFR-110) | ExecutionContext::Call | E-19 | ○ |
| C-111 (UT-TFR-111) | ExecutionContext::Return | E-19 | ○ |
| C-112 (UT-TFR-112) | ExecutionContext::Fail | E-19 | ○ |
| C-113 (UT-TFR-113) | ExecutionContext::AddUserContext | E-19 | ○ |
| C-114 (UT-TFR-114) | ExecutionContext::GetUserContext | E-19 | ○ |
| C-115 (UT-TFR-115) | FunctionContext::Call | E-19 | ○ |
| C-116 (UT-TFR-116) | FunctionContext::Return | E-19 | ○ |
| C-117 (UT-TFR-117) | Execute | E-20 | ○ |
| C-118 (UT-TFR-118) | GpuRunner::Run 正常系 | E-21 | ○ |
| C-119 (UT-TFR-119) | GpuRunner::Run 異常系 | **根拠なし** | △ |
| C-120 (UT-TFR-120) | StepId::GetInvalidStepId | E-22 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-TFR-040 (FallbackState::AddFunctionDef 異常系)**: ヘッダファイルからは重複登録時のエラー動作が明示されていない
  - 候補：実装ファイル (.cc) の確認 / 既存テストコードの確認 / ドキュメント確認
- **UT-TFR-060 (StreamCallbackRegistry::Register 異常系)**: 重複ID登録時のエラー動作の詳細が不明
  - 候補：stream.cc の実装確認 / 既存テストコードの確認
- **UT-TFR-098 (IfrtServingExecutable::Execute 異常系)**: Freeze後の挙動の詳細が不明
  - 候補：ifrt_serving_executable.cc の実装確認
- **UT-TFR-107 (KernelRegistry::Get 異常系)**: 未登録カーネル取得時の戻り値の詳細が不明
  - 候補：context.cc の実装確認
- **UT-TFR-119 (GpuRunner::Run 異常系)**: エラー時の具体的な動作が不明
  - 候補：gpu_runner.cc の実装確認

## 5) リスクフラグ（レビュー観点）
- **リスクレベル 0（低）**: 95件 - 明確なヘッダ定義に基づくテストケース
- **リスクレベル 1（中）**: 20件 - 実装の詳細確認が望ましいテストケース
- **リスクレベル 2（高）**: 5件 - 根拠不足のため実装確認必須

## 6) レビュアーチェックリスト（最小）
- [ ] 根拠なし（△）の5件について、実装ファイルを確認し、期待結果が正しいか検証する
- [ ] 異常系テストケースについて、実際のエラーコードとメッセージを実装から確認する
- [ ] 境界値テストケースについて、境界条件の定義が実装と一致しているか確認する
- [ ] スレッドセーフ関連のテストケースについて、並行実行時の動作を確認する
- [ ] GPUおよびIFRT関連のテストケースについて、ハードウェア環境への依存を確認する
- [ ] コスト記録・分析関連のテストケースについて、計測精度と閾値を確認する
