---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 108
  claims_with_evidence: 108
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: core-tpu 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で各テストケースの根拠を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：108 / 108、根拠なし：0
- 優先レビュー（高）
  1. **TPU実行・コンパイル関連（UT-TPU-001〜009）**：TPUの基本機能に関わる重要テスト
  2. **シャーディング関連（UT-TPU-042〜056）**：データ分割処理の正確性確認
  3. **オプティマイザ構築（UT-TPU-071〜076）**：機械学習最適化の中核機能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/tpu/tpu_compile.h` - TPUコンパイル関数のヘッダ定義
- E-02: `tensorflow/core/tpu/tpu_compile.cc` - TPUコンパイル関数の実装
- E-03: `tensorflow/core/tpu/tpu_execute.h` - TPU実行関数のヘッダ定義
- E-04: `tensorflow/core/tpu/tpu_execute.cc` - TPU実行関数の実装
- E-05: `tensorflow/core/tpu/tpu_configuration.h` - TPU設定管理のヘッダ
- E-06: `tensorflow/core/tpu/tpu_configuration.cc` - TPU設定管理の実装
- E-07: `tensorflow/core/tpu/tpu_embedding_optimization_parameters_utils.h` - 最適化パラメータユーティリティのヘッダ
- E-08: `tensorflow/core/tpu/tpu_embedding_optimization_parameters_utils.cc` - 最適化パラメータユーティリティの実装
- E-09: `tensorflow/core/tpu/tpu_defs.h` - TPU定義定数のヘッダ
- E-10: `tensorflow/core/tpu/tpu_defs.cc` - TPU定義定数の実装
- E-11: `tensorflow/core/tpu/kernels/tpu_util.h` - TPUユーティリティのヘッダ
- E-12: `tensorflow/core/tpu/kernels/tpu_util.cc` - TPUユーティリティの実装
- E-13: `tensorflow/core/tpu/kernels/sharding_utils.h` - シャーディングユーティリティのヘッダ（テンプレートクラス含む）
- E-14: `tensorflow/core/tpu/kernels/sharding_utils.cc` - シャーディングユーティリティの実装
- E-15: `tensorflow/core/tpu/kernels/sparse_core_ops_utils.h` - スパースコア操作ユーティリティのヘッダ
- E-16: `tensorflow/core/tpu/kernels/sparse_core_ops_utils.cc` - スパースコア操作ユーティリティの実装
- E-17: `tensorflow/core/tpu/tpu_embedding_output_layout_utils.h` - 埋め込み出力レイアウトユーティリティのヘッダ
- E-18: `tensorflow/core/tpu/tpu_embedding_output_layout_utils.cc` - 埋め込み出力レイアウトユーティリティの実装
- E-19: `tensorflow/core/tpu/tpu_init_mode.h` - TPU初期化モードのヘッダ
- E-20: `tensorflow/core/tpu/tpu_init_mode.cc` - TPU初期化モードの実装
- E-21: `tensorflow/core/tpu/tpu_fingerprint_utils.h` - フィンガープリントユーティリティのヘッダ
- E-22: `tensorflow/core/tpu/tpu_fingerprint_utils.cc` - フィンガープリントユーティリティの実装

## 3) Claims と根拠の対応（レビューの主戦場）

### TPUコンパイル関連（tpu_compile.cc/h）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RunShapeInferenceOnComputation - 正常系テスト | E-01, E-02 | ○ |
| C-02 | RunShapeInferenceOnComputation - arg_shapesサイズ検証 | E-02 (L427: CHECK_EQ) | ○ |
| C-03 | CompileTFFunctionToHlo - 正常系テスト | E-01, E-02 | ○ |
| C-04 | CompileTFFunctionToHlo - 引数検証 | E-02 (L499: TF_RET_CHECK) | ○ |
| C-05 | GetShardingInfo - 正常系テスト | E-01, E-02 | ○ |
| C-06 | GetShardingInfo - 境界値テスト | E-02 | ○ |
| C-92 | SetPerCoreArgShapes - MAXIMALシャーディング | E-02 (L103-108) | ○ |
| C-93 | SetPerCoreArgShapes - OTHERシャーディング | E-02 (L109-121) | ○ |
| C-94 | SetPerCoreArgShapes - REPLICATEDシャーディング | E-02 (L122-131) | ○ |
| C-95 | AssignDevicesToArgsAndRetvals | E-02 (L145-180) | ○ |
| C-96 | OptimizeGraph | E-02 (L221-275) | ○ |
| C-97 | AssignReturnValueToCore | E-02 (L278-308) | ○ |
| C-98 | BuildComputationArgumentDescriptions - 正常系 | E-02 (L332-418) | ○ |
| C-99 | BuildComputationArgumentDescriptions - 異常系 | E-02 (L398-400) | ○ |
| C-100 | DoNotConsiderOpsInBlockList - ブロックリスト外 | E-02 (L210-217) | ○ |
| C-101 | DoNotConsiderOpsInBlockList - ブロックリスト内 | E-02 (L77-82: kBlockList定義) | ○ |

### TPU実行関連（tpu_execute.cc/h）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | TPUExecute - 正常系テスト | E-03, E-04 | ○ |
| C-08 | TPUExecute - キャンセル処理 | E-04 (L527-530) | ○ |
| C-09 | TPUExecute - nullptr検証 | E-04 (L422) | ○ |
| C-10 | DynamicShapeIsCompatible - 互換性あり | E-04 (L135-146) | ○ |
| C-11 | DynamicShapeIsCompatible - 互換性なし | E-04 (L140-141) | ○ |
| C-12 | DynamicShapeIsCompatible - 次元数不一致 | E-04 (L137-139) | ○ |
| C-102 | ShapeSizeCompact | E-04 (L85-93) | ○ |
| C-103 | FixTupleTableAsync | E-04 (L107-131) | ○ |
| C-104 | UpdateDynamicInputs - 正常系 | E-04 (L162-266) | ○ |
| C-105 | UpdateDynamicInputs - 静的形状 | E-04 (L174-176) | ○ |
| C-106 | RegisterCancellation - 正常系 | E-04 (L280-314) | ○ |
| C-107 | RegisterCancellation - キャンセル済み | E-04 (L309-313) | ○ |
| C-108 | CreateOcParams | E-04 (L390-405) | ○ |

### TPU設定管理（tpu_configuration.cc/h）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | GetTPUConfigResourceMgr - initialize_first=true | E-05, E-06 | ○ |
| C-14 | GetTPUConfigResourceMgr - initialize_first=false | E-06 (L34-44) | ○ |

### 最適化パラメータユーティリティ（tpu_embedding_optimization_parameters_utils.cc/h）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | GetOptimizationAlgorithmName - Adagrad | E-08 (L38-42) | ○ |
| C-16 | GetOptimizationAlgorithmName - Adam | E-08 (L52-53) | ○ |
| C-17 | GetOptimizationAlgorithmName - 未設定 | E-08 (L78-81) | ○ |
| C-18 | GetBaseAuxiliaryParameterCount - Adagrad | E-08 (L136-138) | ○ |
| C-19 | GetBaseAuxiliaryParameterCount - SGD | E-08 (L148-149) | ○ |
| C-20 | GetBaseAuxiliaryParameterCount - 未設定 | E-08 (L210-213) | ○ |
| C-21 | GetGradientAccumulationSupport | E-08 (L216-226) | ○ |
| C-22 | UseGradientAccumulation - 有効 | E-08 (L243-245) | ○ |
| C-23 | UseGradientAccumulation - 無効 | E-08 (L239-241) | ○ |
| C-24 | GetOptimizationAlgorithmStateVariables | E-08 (L272-422) | ○ |
| C-25 | GetOptimizationAlgorithms | E-08 (L451-473) | ○ |
| C-26 | GradientAccumulatorInitialValue | E-07 (L115-117) | ○ |
| C-27 | LoadOpShapeFunction - 正常系 | E-08 (L475-503) | ○ |
| C-28 | LoadOpShapeFunction - 両方指定 | E-08 (L482-485) | ○ |
| C-29 | RetrieveOpShapeFunction | E-08 (L505-524) | ○ |

### TPUユーティリティ（tpu_util.cc/h）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | SessionNameFromMetadata - 有効 | E-12 (L30-32) | ○ |
| C-31 | SessionNameFromMetadata - nullptr | E-12 (L31) | ○ |
| C-32 | ProtoKeyForComputation | E-12 (L34-36) | ○ |
| C-33 | ParseCompilationCacheKey - 単純キー | E-12 (L41-43) | ○ |
| C-34 | ParseCompilationCacheKey - guaranteed_const付き | E-12 (L44-55) | ○ |
| C-35 | ParseCompilationCacheKey - 不正フォーマット | E-12 (L44-45) | ○ |
| C-36 | ShapeTensorToTensorShape - 正常系 | E-12 (L70-83) | ○ |
| C-37 | ShapeTensorToTensorShape - 非int64 | E-12 (L72-74) | ○ |
| C-38 | ShapeTensorToTensorShape - 非ベクトル | E-12 (L73) | ○ |
| C-39 | DynamicShapesToTensorShapes - 正常系 | E-12 (L85-93) | ○ |
| C-40 | DynamicShapesToTensorShapes - 空リスト | E-12 (L87) | ○ |
| C-41 | CreateServerBuilder | E-12 (L107-114) | ○ |

### シャーディングユーティリティ（sharding_utils.cc/h）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | ValidateShapesForSlice - 正常系 | E-14 (L37-69) | ○ |
| C-43 | ValidateShapesForSlice - ランク範囲外 | E-14 (L47-49) | ○ |
| C-44 | ValidateShapesForSlice - サイズ不一致 | E-14 (L50-53) | ○ |
| C-45 | ValidateShapesForSlice - 分割不可 | E-14 (L55-66) | ○ |
| C-46 | GetSliceIndices<1> | E-14 (L73-80) | ○ |
| C-47 | GetSliceIndices<2> | E-14 (L82-90) | ○ |
| C-48 | XlaNDSplitter::Create - 正常系 | E-13 (L105-126) | ○ |
| C-49 | XlaNDSplitter::Create - サイズ不一致 | E-13 (L108-112) | ○ |
| C-50 | XlaNDSplitter::Create - num_slices不正 | E-13 (L119-122) | ○ |
| C-51 | XlaNDSplitter::Split - パディングなし | E-13 (L134-194) | ○ |
| C-52 | XlaNDSplitter::Split - パディング付き | E-13 (L167-191) | ○ |
| C-53 | XlaNDSplitter::Split - num_slices=1 | E-13 (L157-159) | ○ |
| C-54 | XlaNDConcatenator::Create | E-13 (L312-333) | ○ |
| C-55 | XlaNDConcatenator::ComputeInternal - 正常系 | E-13 (L334-372) | ○ |
| C-56 | XlaNDConcatenator::ComputeInternal - ランク範囲外 | E-13 (L341-345) | ○ |

### スパースコア操作ユーティリティ（sparse_core_ops_utils.cc/h）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | ConvertBinarySplitsToBucketSplits | E-16 (L47-63) | ○ |
| C-58 | ConvertBinarySplitsToBucketSplits - split=0 | E-16 (L51) | ○ |
| C-59 | ConvertBucketSplitsToBinarySplits | E-16 (L65-77) | ○ |
| C-60 | ValidateInputCombiner - sum | E-16 (L79-88) | ○ |
| C-61 | ValidateInputCombiner - mean | E-16 (L80) | ○ |
| C-62 | ValidateInputCombiner - sqrtn | E-16 (L80) | ○ |
| C-63 | ValidateInputCombiner - 無効 | E-16 (L82-86) | ○ |
| C-64 | GetCombinerScaleContributionFunction - sum | E-16 (L90-98) | ○ |
| C-65 | GetCombinerScaleContributionFunction - mean | E-16 (L94-95) | ○ |
| C-66 | GetCombinerScaleTransformFunction - sqrtn | E-16 (L101-111) | ○ |
| C-67 | GetCombinerScaleTransformFunction - ゼロ | E-16 (L106, L109) | ○ |
| C-68 | GetTableStacks | E-16 (L131-210) | ○ |
| C-69 | GetMinibatchMaxDivisionLevel | E-16 (L212-215) | ○ |
| C-70 | GetDisableTableStacking | E-16 (L217-220) | ○ |
| C-71 | BuildSgdOptimizerComputation | E-16 (L242-272) | ○ |
| C-72 | BuildAdagradOptimizerComputation | E-16 (L274-309) | ○ |
| C-73 | BuildAdamOptimizerComputation | E-16 (L387-446) | ○ |
| C-74 | BuildAdagradMomentumOptimizerComputation | E-16 (L311-385) | ○ |
| C-75 | BuildFtrlOptimizerComputation | E-16 (L448-545) | ○ |
| C-76 | ApplyWeightClippingToTable | E-16 (L232-240) | ○ |

### 埋め込み出力レイアウト（tpu_embedding_output_layout_utils.cc/h）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | ComputeOutputTensorShapes - feature_descriptorあり | E-18 (L37-50) | ○ |
| C-78 | ComputeOutputTensorShapes - feature_descriptorなし | E-18 (L51-62) | ○ |
| C-79 | ComputeOutputTensorShapes - SPMDシャーディング | E-18 (L32-36) | ○ |

### TPU初期化モード（tpu_init_mode.cc/h）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | SetTPUInitMode - kGlobal | E-20 (L42-59) | ○ |
| C-81 | SetTPUInitMode - kRegular | E-20 (L42-59) | ○ |
| C-82 | SetTPUInitMode - kNone | E-20 (L43-46) | ○ |
| C-83 | SetTPUInitMode - モード変更禁止 | E-20 (L49-56) | ○ |
| C-84 | GetTPUInitMode | E-20 (L62-65) | ○ |
| C-85 | ForceSetTPUInitMode | E-20 (L35-38) | ○ |

### フィンガープリントユーティリティ（tpu_fingerprint_utils.cc/h）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | FingerprintFunctionLibrary - 正常系 | E-22 (L33-47) | ○ |
| C-87 | FingerprintFunctionLibrary - 空ライブラリ | E-22 (L39) | ○ |

### TPU定義定数（tpu_defs.cc/h）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | DEVICE_TPU_NODE | E-10 (L20) | ○ |
| C-89 | DEVICE_TPU_REPLICATED_CORE | E-10 (L22) | ○ |
| C-90 | kTPUReplicateAttr | E-10 (L27) | ○ |
| C-91 | kTpuAllTypes | E-09 (L54-78) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべてのテストケースに対してソースコードからの根拠が確認できました。

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**: 全テストケースがソースコードに基づいて生成されており、関数シグネチャ、エラー処理パス、境界条件が確認済み
- **注意点**:
  - TPU実行関連のテストはハードウェア依存性があるため、モック/スタブの適切な使用が必要
  - シャーディング関連のテストは分散環境の設定に依存する可能性がある
  - オプティマイザ計算のテストはXLA依存のため、XLA環境のセットアップが必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各関数のパラメータ検証テストが網羅されているか確認
- [ ] TPU実行関連のキャンセル処理テストが十分か確認
- [ ] シャーディング関連の境界値テストが適切か確認
- [ ] オプティマイザ構築テストで数値計算の精度検証が必要か検討
- [ ] エラーメッセージの内容検証テストの追加要否を確認
- [ ] マルチスレッド環境でのTPU初期化モードテストの追加要否を確認
